/*
 * Decompiled with CFR 0.152.
 */
package system;

import components.OutputListener;
import components.cartridge.Cartridge;
import components.cartridge.MSXCartridge;
import components.cpu.PortMap;
import components.cpu.Z80;
import components.input.FrameInputDevice;
import components.input.InputDevice;
import components.sound.AY38910;
import components.sound.MSXAudioMidiInterface;
import components.sound.MSXAudioMixer;
import components.sound.SCC;
import components.sound.SN76489;
import components.sound.YM2413;
import components.video.TMS9918A;
import components.video.V9938;
import events.AbstractArrayListEventModel;
import events.Event;
import events.EventModel;
import events.EventType;
import events.systems.MSX2EventTypes;
import events.systems.MSXEventType;
import events.systems.MSXEventTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import messages.Z80MessageParser;
import msx.ExpandedSlot;
import msx.MSXDOS2;
import msx.MSXDevice;
import msx.MSXDisk;
import msx.MSXFmPac;
import msx.MSXKeyboard;
import msx.MSXRTC;
import msx.MSXZ80Info;
import output.MSXDisplayWindow;
import output.MSXSoundOutput;
import platform.Emulicious;
import system.DebuggableSystem;
import system.EmulatableSystem;
import system.IntBiMapBasedRamRomMap;
import system.RamRomMap;
import system.SystemEventListener;
import util.io.IOUtilities;
import util.list.AbstractIntList;
import util.list.IntList;
import util.map.HashIntBiMap;
import util.map.HashIntMap;
import util.map.IntBiMap;
import util.map.IntMap;

public class MSX
implements DebuggableSystem,
PortMap {
    public static final int CYCLES_PER_SECOND = 3579545;
    public static final int ERROR_BREAKPOINT = 0;
    public static final int ERROR_INVALID_VDP_ACCESS = 1;
    private static final int[] ERROR_CODES;
    private static final String[] ADDITIONAL_MEMORY_LOCATION_NAMES;
    private static final int[] ADDITIONAL_MEMORY_LOCATION_LENGTHS;
    private static final String[] ADDITIONAL_REGISTER_NAMES;
    private static final MSXCartridge NULL_CARTRIDGE;
    private int CYCLES_PER_SOUND_FRAME;
    private File biosFile;
    private File subRomFile;
    private File fmPacFile;
    private File msxDos2File;
    private DiskRom diskROM;
    private String fmPacRamFilename;
    protected final boolean pal;
    protected final MSXSoundOutput soundOutput;
    protected final int[] ram;
    protected Z80 cpu = new Z80(MSXZ80Info.getInstance(), this, this);
    protected final MSXRTC rtc = new MSXRTC();
    protected MSXCartridge cartridge = NULL_CARTRIDGE;
    protected V9938 vdp;
    protected SN76489 psgSN;
    protected AY38910 psg;
    protected SCC scc;
    protected YM2413 fm;
    protected MSXFmPac fmPac;
    protected MSXKeyboard keyboard;
    protected MSXAudioMidiInterface msxAudio;
    private final int[] prevKeyStates = new int[MSXKeyboard.getNumberOfKeyboardLines()];
    protected int timerSound;
    private boolean sccCartridgeEnabled;
    private int ppiRegisterC;
    private int primarySlotRegister;
    private final RamMapper ramMapper;
    private final MSXDevice[] devices = new MSXDevice[]{ExpandedSlot.EMPTY, ExpandedSlot.EMPTY, ExpandedSlot.EMPTY, ExpandedSlot.EMPTY};
    protected boolean cartridgeEnabled;
    protected int ramSource;
    protected final IntBiMap ramSources = new HashIntBiMap();
    protected final IntMap vramSources = new HashIntMap();
    private final RamRomMap ramRomMap = new IntBiMapBasedRamRomMap(this.ramSources);
    private AbstractArrayListEventModel eventModel;
    private IntList allRAMaddresses;
    private final LinkedList<SystemEventListener> systemEventListenerList = new LinkedList();
    private SystemEventListener[] systemEventListeners = new SystemEventListener[0];
    private final LinkedList<OutputListener> portListenerList = new LinkedList();
    private OutputListener[] portListeners = new OutputListener[0];

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        ERROR_CODES = nArray;
        ADDITIONAL_MEMORY_LOCATION_NAMES = new String[]{"VDP", "PSG", "FM"};
        ADDITIONAL_MEMORY_LOCATION_LENGTHS = new int[]{-1, 11, 64};
        ADDITIONAL_REGISTER_NAMES = new String[]{"R", "I", "VA", "Line"};
        NULL_CARTRIDGE = new MSXCartridge(new int[0]);
    }

    public MSX(boolean bl, MSXDisplayWindow mSXDisplayWindow, MSXSoundOutput mSXSoundOutput, int n, boolean bl2) {
        this.pal = bl;
        this.soundOutput = mSXSoundOutput;
        this.ram = new int[65536 << n];
        this.ramMapper = new RamMapper(this.ram);
        this.vdp = new V9938(bl);
        this.vdp.setV9938mode(bl2);
        this.init(mSXDisplayWindow, mSXSoundOutput);
    }

    protected void init(final MSXDisplayWindow mSXDisplayWindow, final MSXSoundOutput mSXSoundOutput) {
        this.psg = new AY38910(3579545);
        this.psgSN = new SN76489(3579545, 60, 0);
        this.fm = new YM2413(3579545);
        this.scc = new SCC(3579545);
        mSXDisplayWindow.setVDP(this.vdp);
        mSXSoundOutput.setPSGay(this.psg);
        mSXSoundOutput.setSCC(this.scc);
        mSXSoundOutput.setAudioMixer(new MSXAudioMixer(this.psgSN, this.fm));
        this.CYCLES_PER_SOUND_FRAME = this.psgSN.getCyclesPerSecond() / this.psgSN.getFramesPerSecond();
        this.vdp.addOutputListener(new OutputListener(){
            private final TMS9918A.State state;
            {
                this.state = MSX.this.vdp.getState();
            }

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                switch (n) {
                    case 0x110000: {
                        if (n2 == MSX.this.vdp.getScanlines() - 1) {
                            if (MSX.this.keyboard instanceof FrameInputDevice) {
                                ((FrameInputDevice)((Object)MSX.this.keyboard)).frameFinished();
                            }
                            MSX.this.frameFinished();
                        }
                        mSXDisplayWindow.renderLine();
                        break;
                    }
                    case 0x110007: {
                        mSXDisplayWindow.prepareSprites();
                        break;
                    }
                    case 0x110001: {
                        mSXDisplayWindow.setMode(n2);
                        break;
                    }
                    case 0x110008: {
                        mSXDisplayWindow.displayAdjustUpdated();
                        break;
                    }
                    case 0x110003: {
                        mSXDisplayWindow.updateColor(n2 & 0xF, n3, (n2 & 0x10) != 0);
                        break;
                    }
                    case 0x110002: {
                        MSX.this.fireCRAMwrite(n2 & 0x1F, MSX.this.vdp.getCRAM()[n2 & 0xF], n2 >> 8);
                        if (MSX.this.eventModel == null) break;
                        MSX.this.addEvent(MSXEventTypes.CRAM, MSX.this.vdp.getCRAM()[n2 & 0xF], n2 >> 8, n3, n2);
                        break;
                    }
                    case 0x110004: {
                        MSX.this.fireVRAMwrite(n2 & 0x1FFFF, MSX.this.vdp.getVRAM()[n2 & 0x1FFFF], (n2 & 0xFF00000) >> 20);
                        if (MSX.this.eventModel != null) {
                            MSX.this.addEvent(MSXEventTypes.VRAM, MSX.this.vdp.getVRAM()[n2 & 0x1FFFF], (n2 & 0xFF00000) >> 20, n3, n2);
                        }
                        MSX.this.handleVRAMwrite(n2 & 0x1FFFF);
                        break;
                    }
                    case 0x110005: {
                        MSX.this.fireVRAMread(n2 & 0x1FFFF, MSX.this.vdp.getVRAM()[n2 & 0x1FFFF]);
                        if (MSX.this.eventModel == null) break;
                        MSX.this.addEvent(MSXEventTypes.VRAM, MSX.this.vdp.getVRAM()[n2 & 0x1FFFF], -1, n3, n2);
                        break;
                    }
                    case 0x110006: {
                        if (MSX.this.eventModel == null) break;
                        if (n2 > 0) {
                            MSX.this.addEvent(MSX2EventTypes.get(MSX2EventTypes.VDP_STATUS1.ordinal() + n2 - 1), MSX.this.vdp.getRegStatus(n2), -1, n3);
                            break;
                        }
                        MSX.this.addEvent(MSXEventTypes.VDP_STATUS0, MSX.this.vdp.getRegStatus(0), -1, n3);
                        break;
                    }
                    case 0x110010: {
                        MSX.this.fireVRAMaddressWritten();
                        break;
                    }
                    case 1114303: {
                        MSX.this.cpu.setInterruptLine(1, n2 > 0);
                        if (n2 <= 0) break;
                        MSX.this.addEvent(MSXEventTypes.IRQ, 0);
                        break;
                    }
                    case 0x1100FF: {
                        MSX.this.fireErrorOccurred(1, n2);
                        break;
                    }
                    case 0x110011: {
                        MSX.this.fireVdpRegisterWrite(n2 & 0xFF, this.state.getReg(n2 & 0xFF), n2 >> 8);
                        break;
                    }
                    case 0x110012: {
                        MSX.this.handleVdpRegisterEvent(n2 & 0xFF, n2 >> 8 & 0xFF, n2 >> 16, n3);
                    }
                }
            }
        });
        this.psg.addOutputListener(new OutputListener(){
            private final AY38910.State state;
            {
                this.state = MSX.this.psg.getState();
            }

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                switch (n) {
                    case 4456575: {
                        mSXSoundOutput.updateBuffer(MSX.this.CYCLES_PER_SOUND_FRAME - (MSX.this.timerSound - n2));
                        break;
                    }
                    case 0x440000: {
                        int n4 = n2 & 0xF;
                        MSX.this.firePsgRegisterWrite(n4, this.state.getReg(n4), n2 >> 8);
                    }
                }
            }
        });
        this.psgSN.addOutputListener(new OutputListener(){
            private final SN76489.State state;
            {
                this.state = MSX.this.psgSN.getState();
            }

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                switch (n) {
                    case 2228351: {
                        mSXSoundOutput.updateBuffer(MSX.this.CYCLES_PER_SOUND_FRAME - (MSX.this.timerSound - n2));
                        break;
                    }
                    case 0x220000: {
                        int n4 = (n2 & 0x7F) >> 1;
                        int n5 = (n2 & 1) != 0 ? 2 : (n2 & 0x80) >> 7 ^ 1;
                        int n6 = n4 == 3 && (n2 & 1) != 0 ? n4 * 3 + 1 : n4 * 3 + n5;
                        MSX.this.firePsgSnRegisterWrite(n6, this.getOldValue(n6), n2 >> 8);
                    }
                }
            }

            private int getOldValue(int n) {
                int n2 = n / 3;
                if (n2 == 3) {
                    if (n % 3 == 0) {
                        return this.state.getRegNoise();
                    }
                    return this.state.getRegVolume(n2);
                }
                if (n % 3 == 2) {
                    return this.state.getRegVolume(n2);
                }
                return this.state.getRegTone(n2) >> 8 * (n % 3);
            }
        });
        this.scc.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                switch (n) {
                    case 5570687: {
                        mSXSoundOutput.updateBuffer(MSX.this.CYCLES_PER_SOUND_FRAME - (MSX.this.timerSound - n2));
                        break;
                    }
                }
            }
        });
        this.fm.addOutputListener(new OutputListener(){
            private final YM2413.State state;
            {
                this.state = MSX.this.fm.getState();
            }

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                switch (n) {
                    case 3342463: {
                        mSXSoundOutput.updateBuffer(MSX.this.CYCLES_PER_SOUND_FRAME - (MSX.this.timerSound - n2));
                        break;
                    }
                    case 0x330000: {
                        MSX.this.fireFmRegisterWrite(n2 & 0x3F, this.state.getReg(n2 & 0x3F), n2 >> 6);
                    }
                }
            }
        });
    }

    @Override
    public int readPort(int n, int n2) {
        int n3 = this.doReadPort(n, n2);
        this.firePortRead(n, n3, n2);
        return n3;
    }

    private int doReadPort(int n, int n2) {
        switch (n) {
            case 152: 
            case 153: {
                return this.vdp.readByte(n & 1, n2);
            }
            case 162: {
                return this.psg.readByte(n2);
            }
            case 168: {
                return this.primarySlotRegister;
            }
            case 169: {
                int n3 = this.keyboard.readData(n2);
                int n4 = ~n3 & 0xFF;
                int n5 = this.keyboard.getSelectedLine();
                if (n4 != this.prevKeyStates[n5]) {
                    this.fireInputStateChanged(n5 << 16 | n4);
                    this.prevKeyStates[n5] = n4;
                }
                return n3;
            }
            case 170: {
                return 255;
            }
            case 180: 
            case 181: {
                return this.rtc.readByte(n & 1);
            }
            case 186: {
                break;
            }
            case 192: 
            case 193: {
                if (this.msxAudio != null) {
                    return this.msxAudio.readByte(n & 1);
                }
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return this.ramMapper.readMemoryMapperRegister(n - 252);
            }
            default: {
                System.out.println(String.valueOf(Integer.toHexString(n)) + " --> " + Integer.toHexString(255));
            }
        }
        return 255;
    }

    @Override
    public void writePort(int n, int n2, int n3) {
        if (n >= 256) {
            if (n == 256) {
                this.fireErrorOccurred(0, n2);
            } else if (n == 338) {
                this.handleMessage();
            } else if (n == 374) {
                this.addEvent(MSXEventTypes.HALT, n2 ^ 1, n2, (228 - (this.vdp.getTimer() - n3)) * 3 / 2);
            }
            return;
        }
        this.firePortWritten(n, n2, n3);
        switch (n) {
            case 6: {
                if (!(this.devices[2] instanceof MSXDOS2)) break;
                this.psgSN.processInput(6, n2, n3);
                break;
            }
            case 60: 
            case 63: {
                this.psgSN.processInput(n & 1, n2, n3);
                break;
            }
            case 124: 
            case 125: {
                if (this.fmPac == null) break;
                this.fm.processInput(n & 1, n2, n3);
                break;
            }
            case 144: {
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                this.vdp.processInput(n & 3, n2, n3);
                break;
            }
            case 160: 
            case 161: {
                this.psg.processInput(n & 1, n2, n3);
                break;
            }
            case 168: {
                this.primarySlotRegister = n2;
                break;
            }
            case 170: {
                this.keyboard.setSelectedLine(n2 & 0xF);
                this.ppiRegisterC = n2;
                break;
            }
            case 171: {
                this.setRegisterCbitValue(n2 >> 1 & 7, n2 & 1, n3);
                break;
            }
            case 180: 
            case 181: {
                this.rtc.writeByte(n & 1, n2);
                break;
            }
            case 192: 
            case 193: {
                if (this.msxAudio != null) {
                    this.msxAudio.processInput(n & 1, n2, n3);
                    break;
                }
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                this.ramMapper.writeMemoryMapperRegister(n - 252, n2);
                break;
            }
            default: {
                System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
            }
        }
    }

    private void setRegisterCbitValue(int n, int n2, int n3) {
        int n4 = ~(1 << n);
        this.writePort(170, this.ppiRegisterC & n4 | n2 << n, n3);
    }

    public void setBIOS(String string) {
        if (string == null) {
            string = new File(new File(Emulicious.getHomeDirectory(), "MSX"), this.vdp.isV9938mode() ? "cbios_msx2.rom" : "cbios_msx1.rom").getAbsolutePath();
        }
        this.biosFile = new File(string);
    }

    public void setSubROM(String string) {
        if (string == null) {
            string = new File(new File(Emulicious.getHomeDirectory(), "MSX"), "cbios_sub.rom").getAbsolutePath();
        }
        this.subRomFile = new File(string);
    }

    public void setFmPacROM(String string) {
        this.fmPacFile = string != null ? new File(string) : null;
    }

    public void setFmPacRamFilename(String string) {
        this.fmPacRamFilename = string;
    }

    public void setMSXDOS2ROM(String string) {
        this.msxDos2File = string != null ? new File(string) : null;
    }

    public void setDiskROM(String string) {
        try {
            this.diskROM = string != null ? new DiskRom(new File(string), null) : null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public int getMemoryLength() {
        return 65536;
    }

    @Override
    public int readByte(int n, int n2) {
        int n3;
        MSXDevice mSXDevice = this.getDevice(n);
        if (!this.cartridgeEnabled && this.getEffectiveDevice(n) instanceof MSXCartridge && n == this.getPrevPC()) {
            n3 = this.peekByte(n);
            if (n3 == 243) {
                this.cpu.setRegValue(7, this.cpu.getPC() - 1);
            } else if (n3 == 49) {
                this.cpu.setRegValue(7, this.cpu.getPC() - 3);
            } else if (n3 == 62) {
                this.cpu.setRegValue(7, this.cpu.getPC() - 2);
            }
            this.cartridgeEnabled = true;
        }
        n3 = mSXDevice.readByte(n, n2);
        if (this.isSRAMaddress(n)) {
            this.addEvent(MSXEventTypes.SRAM, n3, -1, (228 - this.vdp.getTimer() + n2) * 3 / 2, n & 0x3FFF);
        }
        return n3;
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        if (this.eventModel != null && this.isSRAMaddress(n)) {
            this.addEvent(MSXEventTypes.SRAM, this.getDevice(n).readByte(n, 0), n2, (228 - this.vdp.getTimer() + n3) * 3 / 2, n & 0x3FFF);
        }
        this.getDevice(n).writeByte(n, n2, n3);
    }

    private int getSlot(int n) {
        return this.primarySlotRegister >> n * 2 & 3;
    }

    private int getSecondarySlot(int n) {
        MSXDevice mSXDevice = this.devices[this.getSlot(n)];
        return mSXDevice instanceof ExpandedSlot ? ((ExpandedSlot)mSXDevice).getSlot(n) : 0;
    }

    private MSXDevice getDevice(int n) {
        return this.devices[this.getSlot(n >> 14)];
    }

    private MSXDevice getEffectiveDevice(int n) {
        MSXDevice mSXDevice = this.getDevice(n);
        return mSXDevice instanceof ExpandedSlot ? ((ExpandedSlot)mSXDevice).getDevice(n) : mSXDevice;
    }

    public String getDeviceName(int n) {
        String string;
        String string2;
        MSXDevice mSXDevice = this.getDevice(n * 16384);
        if (mSXDevice instanceof ExpandedSlot) {
            String string3;
            String string4;
            ExpandedSlot expandedSlot = (ExpandedSlot)mSXDevice;
            MSXDevice mSXDevice2 = expandedSlot.getDevice(n * 16384);
            if (mSXDevice2 instanceof RamMapper) {
                RamMapper ramMapper = (RamMapper)mSXDevice2;
                string4 = mSXDevice2.getClass().getSimpleName();
                string3 = String.format(":%02X", ramMapper.readMemoryMapperRegister(n));
            } else if (mSXDevice2 != null && mSXDevice2.getClass() == MSXCartridge.class) {
                string4 = "Cartridge";
                string3 = String.format(":%02X", this.cartridge.getBank(n * 16384));
            } else {
                string4 = mSXDevice2 != null ? mSXDevice2.getClass().getSimpleName() : "Empty";
                string3 = "   ";
            }
            return String.valueOf(this.getSlot(n)) + "-" + expandedSlot.getSlot(n) + string3 + " " + string4;
        }
        if (mSXDevice.getClass() == MSXCartridge.class) {
            string2 = "Cartridge";
            string = String.format(":%02X   ", this.cartridge.getBank(n * 16384));
        } else {
            string2 = mSXDevice.getClass().getSimpleName();
            string = "      ";
        }
        return String.valueOf(this.getSlot(n)) + string + string2;
    }

    public void setMSXAudio(MSXAudioMidiInterface mSXAudioMidiInterface) {
        this.msxAudio = mSXAudioMidiInterface;
    }

    public void setSccCartridgeEnabled(boolean bl) {
        this.sccCartridgeEnabled = bl;
    }

    @Override
    public void plugInInputDevice(int n, InputDevice inputDevice) {
        if (!(inputDevice instanceof MSXKeyboard)) {
            throw new IllegalArgumentException(inputDevice + " is not compatible with " + this.getClass().getSimpleName());
        }
        this.keyboard = (MSXKeyboard)inputDevice;
    }

    public String getMapperName() {
        return this.cartridge != NULL_CARTRIDGE ? this.cartridge.getMapperName() : "None";
    }

    public boolean isDisk() {
        return this.cartridge instanceof MSXDisk;
    }

    @Override
    public void insertCartridge(Cartridge cartridge) {
        block14: {
            if (this.biosFile == null || !this.biosFile.exists() || this.vdp.isV9938mode() && (this.subRomFile == null || !this.subRomFile.exists())) {
                this.biosFile = new File(new File(Emulicious.getHomeDirectory(), "MSX"), this.vdp.isV9938mode() ? "cbios_msx2.rom" : "cbios_msx1.rom");
                this.subRomFile = new File(new File(Emulicious.getHomeDirectory(), "MSX"), "cbios_sub.rom");
            }
            this.cartridge = (MSXCartridge)cartridge;
            if (cartridge instanceof MSXDisk) {
                if (this.diskROM != null) {
                    this.diskROM.insertDisk(0, (MSXDisk)cartridge);
                }
                try {
                    MSXDisk mSXDisk = (MSXDisk)cartridge;
                    File file = mSXDisk.getMSX2parent();
                    if (file != null && new File(file, "MSXDOS2.ROM").exists()) {
                        this.setupMSX2(file, new File(file, "MSXDOS2.ROM").exists());
                        break block14;
                    }
                    if (this.vdp.isV9938mode()) {
                        this.setupMSX2(null, false);
                        break block14;
                    }
                    this.setupMSX1();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                this.cartridge.setSCC(this.scc);
                if (this.vdp.isV9938mode()) {
                    try {
                        this.setupMSX2(null, false);
                        this.devices[1] = this.cartridge;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    try {
                        this.setupMSX1();
                        this.devices[1] = this.cartridge;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        this.reset();
    }

    public void insertDisk(int n, String string) {
        if (this.diskROM != null) {
            try {
                this.diskROM.insertDisk(n, string != null ? new MSXDisk(new File(string)) : null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setupMSX1() throws IOException {
        this.devices[0] = new Bios(this.biosFile);
        MSXDevice mSXDevice = this.sccCartridgeEnabled ? new MSXDevice(){

            @Override
            public int readByte(int n, int n2) {
                return MSX.this.scc.readByte(n, n2);
            }

            @Override
            public void writeByte(int n, int n2, int n3) {
                MSX.this.scc.writeByte(n, n2, n3);
            }

            @Override
            public int getByte(int n) {
                return this.readByte(n, 0);
            }

            @Override
            public void reset() {
            }
        } : null;
        this.fmPac = this.fmPacFile != null && this.fmPacFile.exists() ? new MSXFmPac(this.fmPacFile, this.fm, this.fmPacRamFilename) : null;
        this.devices[3] = new ExpandedSlot(mSXDevice, this.diskROM, this.ramMapper, this.fmPac);
    }

    private void setupMSX2(File file, boolean bl) throws IOException {
        Bios bios;
        Bios bios2;
        this.vdp.setV9938mode(true);
        if (bl && file != null) {
            bios2 = new Bios(this, new File(file, "MSX2.ROM")){

                @Override
                public int readByte(int n, int n2) {
                    cartridgeEnabled = true;
                    if ((n == 3438 || n == 3439 || n == 3440) && super.readByte(3438, n2) == 205) {
                        if (n == 3438) {
                            return 118;
                        }
                        int n3 = this.peekByte(64687);
                        int n4 = cpu.getRegisterValue(3);
                        cpu.setRegValue(3, n3 << 8 | n4 & 0xFF);
                        return super.readByte(2897 + n - 3439, n2);
                    }
                    if ((n == 31684 || n == 31685) && super.readByte(31684, n2) == 32) {
                        return 0;
                    }
                    if ((n == 32760 || n == 32761) && super.readByte(32760, n2) == 48) {
                        return 0;
                    }
                    return super.readByte(n, n2);
                }
            };
            bios = new Bios(this, new File(file, "MSX2EXT.ROM"), 0, 16384){

                @Override
                public int readByte(int n, int n2) {
                    if ((n == 10942 || n == 10943) && super.readByte(10942, n2) == 32) {
                        return 0;
                    }
                    if (n == 2423 && super.readByte(2424, n2) == 205 && super.readByte(2425, n2) == 227 && super.readByte(2426, n2) == 8) {
                        int n3 = cpu.getRegisterValue(2);
                        int n4 = cpu.getRegisterValue(0);
                        int n5 = cpu.getRegisterValue(3) >> 8;
                        Arrays.fill(this.getVRAM(), n3, n3 + n4, n5);
                        return 201;
                    }
                    if ((n == 1053 || n == 1054 || n == 1055 || n == 1056) && super.readByte(1053, n2) == 32) {
                        return 0;
                    }
                    if (super.readByte(4150, n2) == 205 && super.readByte(4151, n2) == 139 && super.readByte(4152, n2) == 41) {
                        if (n == 4153) {
                            n = n + 1 - 1;
                        }
                        if (n == 4155 || n == 4156) {
                            if (n == 4155 && !this.isFlagSet(6)) {
                                vdp.update((313 - vdp.getLine()) * 228);
                            }
                            return 0;
                        }
                        if (n == 4164 || n == 4165) {
                            if (n == 4164 && this.isFlagSet(6)) {
                                vdp.update((192 - vdp.getLine()) * 228);
                            }
                            return 0;
                        }
                    }
                    return super.readByte(n, n2);
                }
            };
        } else {
            bios2 = new Bios(this.biosFile);
            bios = new Bios(this.subRomFile, this.subRomFile.length() >= 49152L ? 32768 : 0, 16384);
        }
        if (bl) {
            this.cpu = new Z80(new MSXZ80Info(){

                @Override
                public int getMinCycles(int n, int n2) {
                    if (n2 == 0) {
                        if (n == 118) {
                            return 100 * super.getMinCycles(n, n2);
                        }
                        if ((n & 0xC7) == 194) {
                            return super.getMinCycles(n, n2);
                        }
                        if (n == 255) {
                            return super.getMinCycles(n, n2);
                        }
                    }
                    return 0;
                }
            }, this, this);
        }
        this.devices[0] = bios2;
        MSXDevice mSXDevice = bl || this.sccCartridgeEnabled ? new MSXDevice(){

            @Override
            public int readByte(int n, int n2) {
                return MSX.this.scc.readByte(n, n2);
            }

            @Override
            public void writeByte(int n, int n2, int n3) {
                MSX.this.scc.writeByte(n, n2, n3);
            }

            @Override
            public int getByte(int n) {
                return this.readByte(n, 0);
            }

            @Override
            public void reset() {
            }
        } : null;
        File file2 = this.msxDos2File != null && this.msxDos2File.exists() ? this.msxDos2File : new File(file, "MSXDOS2.ROM");
        MSXDOS2 mSXDOS2 = file2.exists() && (this.cartridge.getRom().length < 5 || this.cartridge.getRom()[3] != 77 || this.cartridge.getRom()[4] != 66) ? new MSXDOS2(file2) : null;
        if (mSXDevice != null && mSXDOS2 != null) {
            this.devices[2] = new ExpandedSlot(mSXDevice, mSXDOS2);
        } else if (mSXDevice != null) {
            this.devices[2] = mSXDevice;
        } else if (mSXDOS2 != null) {
            this.devices[2] = mSXDOS2;
        }
        File file3 = this.fmPacFile != null && this.fmPacFile.exists() ? this.fmPacFile : new File(file, "FMPAC.ROM");
        this.fmPac = file3.exists() ? new MSXFmPac(file3, this.fm, this.fmPacRamFilename) : null;
        this.devices[3] = new ExpandedSlot(bios, this.diskROM, this.ramMapper, this.fmPac);
    }

    public int[] getDiskMemory() {
        if (this.diskROM == null || !(this.cartridge instanceof MSXDisk)) {
            return null;
        }
        return this.diskROM.getDiskMemory();
    }

    @Override
    public void ejectCartridge() {
        this.cartridge.eject();
        if (this.fmPac != null) {
            this.fmPac.shutdown();
        }
        this.cartridge = NULL_CARTRIDGE;
    }

    @Override
    public void shutdown() {
        this.ejectCartridge();
        Arrays.fill(this.devices, ExpandedSlot.EMPTY);
        this.diskROM = null;
    }

    @Override
    public boolean isCartridgeEnabled() {
        return this.cartridgeEnabled;
    }

    @Override
    public boolean isBiosEnabled() {
        return true;
    }

    @Override
    public void reset() {
        this.ppiRegisterC = 0;
        Arrays.fill(this.prevKeyStates, 0);
        this.cpu.reset();
        this.vdp.reset();
        this.psg.reset();
        this.psgSN.reset();
        this.fm.reset();
        this.cartridgeEnabled = false;
        this.cartridge.reset();
        MSXDevice[] mSXDeviceArray = this.devices;
        int n = this.devices.length;
        int n2 = 0;
        while (n2 < n) {
            MSXDevice mSXDevice = mSXDeviceArray[n2];
            mSXDevice.reset();
            ++n2;
        }
        this.ramSource = -1;
        this.ramSources.clear();
        this.vramSources.clear();
        this.primarySlotRegister = 0;
    }

    @Override
    public int execute(int n) {
        while ((n = this.executeOnce(n)) > 0) {
        }
        return n;
    }

    @Override
    public int executeOnce(int n) {
        int n2 = this.cpu.execute(Math.min(Math.max(5, n), this.vdp.getTimer()));
        n -= n2;
        this.vdp.update(n2);
        this.timerSound -= n2;
        while (this.timerSound <= 0) {
            this.timerSound += this.CYCLES_PER_SOUND_FRAME;
            this.soundOutput.updateBuffer(this.CYCLES_PER_SOUND_FRAME);
            this.soundOutput.finishFrame();
        }
        return n;
    }

    @Override
    public int getCyclesPerSecond() {
        return 3579545;
    }

    @Override
    public int getCyclesPerFrame() {
        return this.vdp.getCyclesPerFrame();
    }

    @Override
    public void uninitializeMemory(int n) {
        int[] nArray = this.vdp.getVRAM();
        if (n < 0 || n >= 256) {
            Random random = new Random();
            int n2 = 0;
            while (n2 < this.ram.length) {
                this.ram[n2] = random.nextInt(256);
                ++n2;
            }
            n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = random.nextInt(256);
                ++n2;
            }
        } else {
            Arrays.fill(this.ram, n);
            Arrays.fill(nArray, n);
        }
    }

    @Override
    public int[] getRAM() {
        return this.ram;
    }

    @Override
    public int[] getSRAM() {
        return this.cartridge.hasSRAM() ? this.cartridge.getSRAM() : (this.fmPac != null ? this.fmPac.getRAM() : new int[]{});
    }

    @Override
    public int[] getVRAM() {
        return this.vdp.getVRAM();
    }

    public int getNumberOfVdpRegisters() {
        return this.vdp.isV9938mode() ? 47 : 8;
    }

    private int calcNumberOfBytesPerPaletteEntry() {
        int n = this.vdp.getColorMaxIntensity() + 1;
        return n * n * n >= 256 ? 2 : 1;
    }

    @Override
    public int getNumberOfPaletteBytes() {
        return this.getNumberOfPaletteEntries() * this.calcNumberOfBytesPerPaletteEntry();
    }

    @Override
    public int getNumberOfPaletteEntries() {
        return this.vdp.getCRAM().length;
    }

    @Override
    public int getPaletteByte(int n) {
        int n2 = this.calcNumberOfBytesPerPaletteEntry();
        return this.vdp.getCRAM()[n / n2] >> n % n2 * 8 & 0xFF;
    }

    @Override
    public void setPaletteByte(int n, int n2) {
        int n3 = this.calcNumberOfBytesPerPaletteEntry();
        int n4 = 255 << n % n3 * 8;
        this.vdp.getCRAM()[n / n3] = this.vdp.getCRAM()[n / n3] & ~n4 | n2 << n % n3 * 8;
    }

    @Override
    public String getPaletteName(int n) {
        return null;
    }

    @Override
    public void setAddress(int n, int n2) {
        if (this.cartridge instanceof MSXDisk) {
            this.setRegValue(7, this.getRamRomMap().toRamAddress(n) ^ 0xC000);
        } else if (n2 == 3) {
            this.setRegValue(7, n);
        } else if (n2 == 2) {
            this.cartridge.setBank2(n / 16384);
            this.setRegValue(7, 0x8000 | n & 0x3FFF);
        } else if (n2 == 1) {
            this.cartridge.setBank1(n / 16384);
            this.setRegValue(7, 0x4000 | n & 0x3FFF);
        } else if (n2 == 0) {
            this.setRegValue(7, n & 0x3FFF);
        }
    }

    @Override
    public int getPrevPC() {
        return this.cpu.getPrevPC();
    }

    @Override
    public int getPC() {
        return this.cpu.getPC();
    }

    @Override
    public int getSP() {
        return this.cpu.getSP();
    }

    @Override
    public int getStackPointer() {
        int n = this.getSP();
        if (!this.isROMaddress(n - 1) || this.isROMaddress(this.cpu.getPrevSP() - 1)) {
            return n;
        }
        return this.cpu.getPrevSP();
    }

    @Override
    public int getVirtualAddress() {
        return this.toVirtualAddress(this.getPC());
    }

    @Override
    public int toVirtualAddress(int n) {
        int n2 = n >> 14;
        int n3 = this.getSlot(n2);
        int n4 = this.getSecondarySlot(n2);
        return this.getBank(n) << 20 | n4 << 18 | n3 << 16 | n;
    }

    @Override
    public int getROMsize() {
        if (this.diskROM != null && this.cartridge instanceof MSXDisk) {
            return this.diskROM.getDisksSize();
        }
        return this.cartridge.getRom().length;
    }

    @Override
    public int getByte(int n) {
        return this.getByte(n & 0xFFFF, n >> 20);
    }

    @Override
    public int getByte(int n, int n2) {
        if (n2 < 0) {
            n2 = this.getBank(n);
        }
        if (this.isROMaddress(n)) {
            return this.cartridge.getRom()[this.mapAddress(n, n2)];
        }
        if (this.isRAMaddress(n)) {
            return this.ram[this.mapAddress(n, n2)];
        }
        if (this.isSRAMaddress(n)) {
            return this.cartridge.getSRAM()[this.mapAddress(n, n2)];
        }
        return 255;
    }

    @Override
    public int peekByte(int n) {
        return this.getDevice(n).getByte(n);
    }

    @Override
    public void pokeByte(int n, int n2) {
        this.getDevice(n).writeByte(n, n2, 0);
    }

    @Override
    public void setByte(int n, int n2, int n3) {
        if (this.isROMaddress(n)) {
            this.cartridge.getRom()[this.mapAddress((int)n, (int)n2)] = n3;
        }
        if (this.isSRAMaddress(n)) {
            this.cartridge.getSRAM()[this.mapAddress((int)n, (int)n2)] = n3;
        }
        if (this.isRAMaddress(n)) {
            int n4 = this.mapAddress(n, n2);
            this.ram[n4] = n3;
            ((RamMapper)this.ramMapper).ramInitialized[n4] = true;
        }
    }

    @Override
    public String getMemoryName(int n) {
        if ((n & 0xF) == 0) {
            return "Slot " + (n >> 14);
        }
        return null;
    }

    @Override
    public void setMemoryAt(int n, int[] nArray) {
        System.arraycopy(nArray, 0, this.ram, n & this.ram.length - 1, Math.min(this.ram.length - (n & this.ram.length - 1), nArray.length));
    }

    @Override
    public String[] getRegisterNames() {
        return this.cpu.getRegisterNames();
    }

    @Override
    public int indexOfPC() {
        return this.cpu.indexOfPC();
    }

    @Override
    public int getRegisterValue(int n) {
        return this.cpu.getRegisterValue(n);
    }

    @Override
    public int getVRAMaddress() {
        return this.vdp.getAddress();
    }

    @Override
    public boolean isAdditionalRegister(int n) {
        return this.cpu.isAdditionalRegister(n);
    }

    @Override
    public String getAdditionalRegisterName(int n) {
        if (n < 4) {
            return this.cpu.getRegisterNames()[8 + n];
        }
        return (n -= 4) < ADDITIONAL_REGISTER_NAMES.length ? ADDITIONAL_REGISTER_NAMES[n] : null;
    }

    @Override
    public int getAdditionalRegisterValue(int n) {
        if (n < 4) {
            return this.cpu.getRegisterValue(8 + n);
        }
        switch (n -= 4) {
            case 0: {
                return this.cpu.getRegisterValue(12);
            }
            case 1: {
                return this.cpu.getRegisterValue(13);
            }
            case 2: {
                return this.getVRAMaddress();
            }
            case 3: {
                return this.vdp.getLine();
            }
        }
        return 0;
    }

    @Override
    public int getAdditionalRegisterSize(int n) {
        if (n < 4) {
            return 2;
        }
        switch (n -= 4) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public boolean hasSRAM() {
        return this.cartridge.hasSRAM() || this.fmPac != null;
    }

    @Override
    public boolean isROMaddress(int n) {
        return this.isROMaddress(n, false);
    }

    @Override
    public boolean isROMaddress(int n, boolean bl) {
        if (this.cartridge instanceof MSXDisk) {
            return false;
        }
        return this.getEffectiveDevice(n) == this.cartridge && this.cartridge.isROMaddress(n) || bl && n < 49152;
    }

    @Override
    public boolean isRAMaddress(int n) {
        return MSX.isRAMaddress(this.getDevice(n), n);
    }

    @Override
    public boolean isRAMaddress(int n, boolean bl) {
        return n >= 49152;
    }

    private static boolean isRAMaddress(MSXDevice mSXDevice, int n) {
        if (mSXDevice instanceof ExpandedSlot) {
            return ((ExpandedSlot)mSXDevice).isRAMaddress(n);
        }
        return mSXDevice instanceof RamMapper;
    }

    @Override
    public boolean isSRAMaddress(int n) {
        if (this.cartridge instanceof MSXDisk) {
            return false;
        }
        return this.getEffectiveDevice(n) == this.cartridge && this.cartridge.isSRAMaddress(n);
    }

    @Override
    public boolean isVRAMaddress(int n) {
        return false;
    }

    @Override
    public int mapAddress(int n) {
        if (this.isRAMaddress(n)) {
            return this.ramMapper.mapAddress(n);
        }
        if (this.isROMaddress(n)) {
            return this.cartridge.mapAddress(n);
        }
        return n;
    }

    @Override
    public int mapAddress(int n, int n2) {
        if (this.isRAMaddress(n)) {
            return this.ramMapper.mapAddress(n, n2);
        }
        if (this.isROMaddress(n)) {
            return this.cartridge.mapAddress(n, n2);
        }
        return n;
    }

    @Override
    public int mapAddress(int n, int n2, boolean bl) {
        if (this.isRAMaddress(n, bl)) {
            return this.ramMapper.mapAddress(n, n2);
        }
        if (this.isROMaddress(n, bl)) {
            return this.cartridge.mapAddress(n, n2);
        }
        return n;
    }

    @Override
    public int mapVirtualAddress(int n) {
        return this.mapAddress(n & 0xFFFF, n >> 20);
    }

    @Override
    public void setRegValue(int n, int n2) {
        this.cpu.setRegValue(n, n2);
    }

    @Override
    public void setAdditionalRegValue(int n, int n2) {
        if (n < 4) {
            this.cpu.setRegValue(8 + n, n2);
        } else {
            switch (n -= 4) {
                case 0: {
                    this.cpu.setRegValue(12, n2);
                    break;
                }
                case 1: {
                    this.cpu.setRegValue(13, n2);
                }
            }
        }
    }

    @Override
    public String getAdditionalRegisterDescription(int n) {
        return null;
    }

    @Override
    public String[] getFlagNames() {
        return this.cpu.getFlagNames();
    }

    @Override
    public boolean isFlagSet(int n) {
        return this.cpu.isFlagSet(n);
    }

    @Override
    public void setFlagSet(int n, boolean bl) {
        int n2 = this.cpu.getRegisterValue(3);
        n2 = !bl ? (n2 &= ~(1 << n)) : (n2 |= 1 << n);
        this.cpu.setRegValue(3, n2);
    }

    @Override
    public int getNumberOfPorts() {
        return 256;
    }

    @Override
    public int getPortExtension() {
        return 0;
    }

    @Override
    public int getRAMlength() {
        return this.ram.length;
    }

    @Override
    public IntList getAllRAMaddresses() {
        final int n = this.getRAMlength();
        if (this.allRAMaddresses == null || this.allRAMaddresses.size() != n) {
            this.allRAMaddresses = new AbstractIntList(){

                @Override
                public int get(int n2) {
                    return 0xC000 | n2 / 16384 << 20 | n2 & 0x3FFF;
                }

                @Override
                public int size() {
                    return n;
                }
            };
        }
        return this.allRAMaddresses;
    }

    @Override
    public int getStackStart() {
        return this.getStackPointer() - 1 & ~(this.getStackLength() - 1) & this.getMemoryLength() - 1;
    }

    @Override
    public int getStackLength() {
        return 16384;
    }

    @Override
    public int getRAMvalue(int n) {
        return this.ram[n & this.ram.length - 1];
    }

    @Override
    public int getBank0() {
        return this.cartridge.getBank0();
    }

    @Override
    public int getBank1() {
        return this.cartridge.getBank1();
    }

    @Override
    public int getBank2() {
        return this.cartridge.getBank2();
    }

    @Override
    public int getBank3() {
        return this.cartridge.getBank3();
    }

    @Override
    public int getBank(int n) {
        MSXDevice mSXDevice = this.getEffectiveDevice(n &= 0xFFFF);
        if (mSXDevice instanceof MSXCartridge) {
            return ((MSXCartridge)mSXDevice).getBank(n);
        }
        if (mSXDevice instanceof RamMapper) {
            return ((RamMapper)mSXDevice).getBank(n);
        }
        return 0;
    }

    @Override
    public void setBank(int n, int n2) {
        if (this.getDevice(n &= 0xFFFF) instanceof MSXCartridge) {
            ((MSXCartridge)this.getDevice(n)).setBank(n, n2);
        }
    }

    @Override
    public int getRomBankSize() {
        return this.cartridge.getBankSize();
    }

    @Override
    public boolean isSRAMenabled() {
        return this.cartridge.isSRAMenabled();
    }

    @Override
    public void setSRAMenabled(boolean bl) {
        this.cartridge.setSRAMenabled(bl);
    }

    @Override
    public int getSRAMbank() {
        return this.cartridge.getSRAMbank();
    }

    @Override
    public int getScanline() {
        return this.vdp.getLine();
    }

    @Override
    public boolean isHalted() {
        return this.cpu.isHalted();
    }

    @Override
    public boolean isVBlank() {
        return this.vdp.getLine() >= this.vdp.getScreenHeight();
    }

    @Override
    public boolean isInterruptsEnabled() {
        return this.cpu.isInterruptsEnabled();
    }

    @Override
    public void setInterruptsEnabled(boolean bl) {
        this.cpu.setInterruptsEnabled(bl);
    }

    @Override
    public void syncLazyState() {
    }

    @Override
    public boolean isInterruptAddress(int n) {
        return n == 56;
    }

    @Override
    public boolean isConditionMet(int n) {
        int n2 = this.cpu.getRegisterValue(3);
        switch (n) {
            case 0: {
                return (n2 & 0x40) == 0;
            }
            case 1: {
                return (n2 & 0x40) != 0;
            }
            case 2: {
                return (n2 & 1) == 0;
            }
            case 3: {
                return (n2 & 1) != 0;
            }
            case 4: {
                return (n2 & 4) == 0;
            }
            case 5: {
                return (n2 & 4) != 0;
            }
            case 6: {
                return (n2 & 0x80) == 0;
            }
            case 7: {
                return (n2 & 0x80) != 0;
            }
            case 8: {
                return this.cpu.getRegisterValue(0) >> 8 > 1;
            }
        }
        return false;
    }

    @Override
    public boolean canStepOver() {
        int n = this.peekByte(this.getPC());
        return n != 24 && n != 195 && n != 201 && n != 233 && (n != 237 || (this.peekByte(this.getPC() + 1) & 0xC7) != 69);
    }

    @Override
    public RamRomMap getRamRomMap() {
        return this.ramRomMap;
    }

    @Override
    public int[] getErrorCodes() {
        return ERROR_CODES;
    }

    @Override
    public int getNumberOfAdditionalMemoryLocations() {
        return ADDITIONAL_MEMORY_LOCATION_NAMES.length;
    }

    @Override
    public String getAdditionalMemoryLocationName(int n) {
        return ADDITIONAL_MEMORY_LOCATION_NAMES[n];
    }

    @Override
    public int getAdditionalMemoryLocationLength(int n) {
        if (n == 0) {
            return this.getNumberOfVdpRegisters();
        }
        return ADDITIONAL_MEMORY_LOCATION_LENGTHS[n];
    }

    @Override
    public String getAdditionalMemoryLocationAt(int n) {
        return null;
    }

    @Override
    public boolean isAdditionalMemoryLocationMemoryMapped(String string) {
        return false;
    }

    @Override
    public String cpuAddressToString(int n) {
        return this.virtualAddressToString(this.toVirtualAddress(n));
    }

    @Override
    public String virtualAddressToString(int n) {
        int n2 = n >> 16 & 3;
        int n3 = n >> 18 & 3;
        int n4 = n >> 20;
        int n5 = n & 0xFFFF;
        if (this.devices[n2] instanceof ExpandedSlot) {
            return String.format("%X-%X:%02X:%04X", n2, n3, n4, n5);
        }
        return String.format("%X:%02X:%04X", n2, n4, n5);
    }

    @Override
    public String romAddressToString(int n) {
        int n2;
        int n3;
        int n4 = 0;
        while (n4 < 4) {
            n3 = n4 * 16384 | n & 0x3FFF;
            if (this.getEffectiveDevice(n3) == this.cartridge && this.mapAddress(n3, n2 = this.getBank(n3)) == n) {
                return String.format("%X:%02X:%04X", n4, n2, n3);
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < 4) {
            n3 = n4 * 16384 | n & 0x3FFF;
            if (this.getEffectiveDevice(n3) == this.cartridge && this.mapAddress(n3, n2 = n / this.cartridge.getBankSize()) == n) {
                return String.format("%X:%02X:%04X", n4, n2, n3);
            }
            ++n4;
        }
        return String.format(this.cartridge.getRom().length > 65536 ? "%05X" : "%04X", n);
    }

    @Override
    public String ramAddressToString(int n) {
        int n2 = n / 16384;
        int n3 = 0;
        while (n3 < 3 && this.ramMapper.readMemoryMapperRegister(n3) != n2) {
            ++n3;
        }
        return String.format("%02X:%04X", n2, n3 * 16384 | n & 0x3FFF);
    }

    @Override
    public String vramAddressToString(int n) {
        return String.format(this.vdp.getVRAM().length >= 65536 ? "%05X" : "%04X", n);
    }

    @Override
    public String sramAddressToString(int n) {
        if (this.getSRAM().length <= 16384) {
            return String.format("%04X", n);
        }
        return String.format("%X:%04X", n / 16384, n & 0x3FFF);
    }

    @Override
    public String palAddressToString(int n) {
        return "PAL" + n;
    }

    @Override
    public boolean isRamInitialized(int n) {
        return this.ramMapper.isInitialized(n);
    }

    @Override
    public boolean isVramInitialized(int n) {
        return true;
    }

    @Override
    public boolean isSramInitialized(int n) {
        return true;
    }

    @Override
    public boolean isCpuMemoryInitialized(int n) {
        if (this.isRAMaddress(n)) {
            return this.isRamInitialized(this.mapAddress(n));
        }
        if (this.isVRAMaddress(n)) {
            return this.isVramInitialized(this.mapAddress(n));
        }
        if (this.isSRAMaddress(n)) {
            return this.isSramInitialized(this.mapAddress(n));
        }
        return true;
    }

    @Override
    public boolean isPaletteInitialized(int n) {
        return true;
    }

    @Override
    public EventModel createEventModel() {
        if (this.eventModel == null) {
            Enum[] enumArray = this.vdp.isV9938mode() ? MSX2EventTypes.values() : MSXEventTypes.values();
            String[][] stringArray = new String[][]{{"External video input", "Mode M3", "Mode M4", "Mode M5", "H-Blank Interrupt Enable", "Light pen/mouse on", "DiGitize mode"}, {"Sprite zoom", "Sprite size", "Unused", "Mode M2", "Mode M1", "V-Blank Interrupt Enable", "Screen output control", "VRAM size control"}};
            String[][] stringArray2 = new String[][]{{"BW", "Disable OBJ Sprites", "VRAM Size and Speed", "Color Bus Direction", "Transparent From Palette", "Lightpen Select", "Mouse Select"}, {"Dot Clock Direction", "NTSC", "Even Odd Display", "Interlace", "Simultaneous Mode", "Unused", "Overscan"}};
            if (!this.isMSX2()) {
                stringArray[0] = Arrays.copyOf(stringArray[0], 2);
                stringArray[1] = Arrays.copyOf(stringArray[1], 7);
            }
            this.eventModel = new AbstractArrayListEventModel((EventType[])enumArray, (MSXEventType[])enumArray, stringArray, stringArray2){
                private final /* synthetic */ MSXEventType[] val$eventTypes;
                private final /* synthetic */ String[][] val$bitLabels;
                private final /* synthetic */ String[][] val$bitLabels2;
                {
                    this.val$eventTypes = mSXEventTypeArray;
                    this.val$bitLabels = stringArray;
                    this.val$bitLabels2 = stringArray2;
                    super(eventTypeArray);
                }

                @Override
                protected String pcToString(int n) {
                    return MSX.this.virtualAddressToString(n).trim();
                }

                @Override
                protected String getDetails(Event event) {
                    if (event.getType() >= this.val$eventTypes.length) {
                        return null;
                    }
                    switch (MSX2EventTypes.get(event.getType())) {
                        case VDP0: {
                            int n = event.getNewValue() ^ event.getOldValue();
                            boolean bl = (n & (MSX.this.vdp.isV9938mode() ? 14 : 2)) != 0;
                            n &= ~(MSX.this.vdp.isV9938mode() ? 14 : 2);
                            StringBuilder stringBuilder = new StringBuilder();
                            if (bl) {
                                stringBuilder.append("Mode: " + MSX.this.vdp.getModeName(event.getDetailsData()));
                            }
                            int n2 = 1;
                            int n3 = 0;
                            while (n3 < this.val$bitLabels[0].length) {
                                if ((n & n2) != 0) {
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(", ");
                                    }
                                    stringBuilder.append(this.val$bitLabels[0][n3]).append(' ').append((event.getNewValue() & n2) != 0 ? "Enabled" : "Disabled");
                                }
                                n2 <<= 1;
                                ++n3;
                            }
                            return stringBuilder.toString();
                        }
                        case VDP1: {
                            int n = event.getNewValue() ^ event.getOldValue();
                            boolean bl = (n & 0x18) != 0;
                            n &= 0xFFFFFFE7;
                            StringBuilder stringBuilder = new StringBuilder();
                            if (bl) {
                                stringBuilder.append("Mode: " + MSX.this.vdp.getModeName(event.getDetailsData()));
                            }
                            int n4 = 1;
                            int n5 = 0;
                            while (n5 < this.val$bitLabels[1].length) {
                                if ((n & n4) != 0) {
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(", ");
                                    }
                                    stringBuilder.append(this.val$bitLabels[1][n5]).append(' ').append((event.getNewValue() & n4) != 0 ? "Enabled" : "Disabled");
                                }
                                n4 <<= 1;
                                ++n5;
                            }
                            return stringBuilder.toString();
                        }
                        case VDP2: {
                            return "Name Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP3: 
                        case VDP10: {
                            return "Color Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP4: {
                            return "Pattern Generator Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP5: 
                        case VDP11: {
                            return "Sprite Attribute Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP6: {
                            return "Sprite Pattern Generator Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP7: {
                            return "Foreground Color: " + (event.getNewValue() >> 4) + ", Backdrop Color: " + (event.getNewValue() & 0xF);
                        }
                        case VDP8: {
                            int n = event.getNewValue() ^ event.getOldValue();
                            StringBuilder stringBuilder = new StringBuilder();
                            int n6 = 1;
                            int n7 = 0;
                            while (n7 < this.val$bitLabels2[0].length) {
                                if ((n & n6) != 0) {
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(", ");
                                    }
                                    stringBuilder.append(this.val$bitLabels2[0][n7]).append(' ').append((event.getNewValue() & n6) != 0 ? "Enabled" : "Disabled");
                                }
                                n6 <<= 1;
                                ++n7;
                            }
                            return stringBuilder.toString();
                        }
                        case VDP9: {
                            int n = event.getNewValue() ^ event.getOldValue();
                            StringBuilder stringBuilder = new StringBuilder();
                            int n8 = 1;
                            int n9 = 0;
                            while (n9 < this.val$bitLabels2[1].length) {
                                if ((n & n8) != 0) {
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(", ");
                                    }
                                    stringBuilder.append(this.val$bitLabels2[1][n9]).append(' ').append((event.getNewValue() & n8) != 0 ? "Enabled" : "Disabled");
                                }
                                n8 <<= 1;
                                ++n9;
                            }
                            return stringBuilder.toString();
                        }
                        case VDP14: {
                            return "VDP Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP15: {
                            return "Status Register Index: " + event.getNewValue();
                        }
                        case VDP16: {
                            return "Palette Index: " + String.format("%01X", event.getNewValue());
                        }
                        case VDP17: {
                            return "Register Pointer: " + (event.getNewValue() & 0x3F) + ((event.getNewValue() & 0x80) != 0 ? " (Auto Increment)" : "");
                        }
                        case VDP18: {
                            return "Horizontal Display Adjust: " + (-(event.getNewValue() & 8) | event.getNewValue() & 7) + ", " + "Vertical Display Adjust: " + (-(event.getNewValue() >> 4 & 8) | event.getNewValue() >> 4 & 7);
                        }
                        case VDP19: {
                            return "Interrupt Line: " + event.getNewValue();
                        }
                        case VDP23: {
                            return "Display Offset: " + event.getNewValue();
                        }
                        case VDP32: {
                            return "Source X Low: " + event.getNewValue();
                        }
                        case VDP33: {
                            return "Source X High: " + (event.getNewValue() & 1);
                        }
                        case VDP34: {
                            return "Source Y Low: " + event.getNewValue();
                        }
                        case VDP35: {
                            return "Source Y High: " + (event.getNewValue() & 3);
                        }
                        case VDP36: {
                            return "Destination X Low: " + event.getNewValue();
                        }
                        case VDP37: {
                            return "Destination X High: " + (event.getNewValue() & 1);
                        }
                        case VDP38: {
                            return "Destination Y Low: " + event.getNewValue();
                        }
                        case VDP39: {
                            return "Destination Y High: " + (event.getNewValue() & 3);
                        }
                        case VDP40: {
                            return "Number of X dots Low: " + event.getNewValue();
                        }
                        case VDP41: {
                            return "Number of X dots High: " + (event.getNewValue() & 3);
                        }
                        case VDP42: {
                            return "Number of Y dots Low: " + event.getNewValue();
                        }
                        case VDP43: {
                            return "Number of Y dots High: " + (event.getNewValue() & 3);
                        }
                        case VDP44: {
                            return "Data: " + String.format("%02X", event.getNewValue());
                        }
                        case VDP45: {
                            return "Argument: " + String.format("%02X", event.getNewValue());
                        }
                        case VDP46: {
                            return "Command: " + String.format("%02X", event.getNewValue());
                        }
                        case RAM: {
                            if (event.getNewValue() >= 0) {
                                return "RAM write to " + MSX.this.ramAddressToString(event.getDetailsData());
                            }
                            return "RAM read from " + MSX.this.ramAddressToString(event.getDetailsData());
                        }
                        case SRAM: {
                            if (event.getNewValue() >= 0) {
                                return "SRAM write to " + MSX.this.sramAddressToString(event.getDetailsData());
                            }
                            return "SRAM read from " + MSX.this.sramAddressToString(event.getDetailsData());
                        }
                        case CRAM: {
                            return "CRAM write to " + String.format("%X", event.getDetailsData() & 0xF);
                        }
                        case VRAM: {
                            if (event.getNewValue() >= 0) {
                                return "VRAM write to " + String.format("%04X", event.getDetailsData() & 0x1FFFF);
                            }
                            return "VRAM read from " + String.format("%04X", event.getDetailsData() & 0x1FFFF);
                        }
                        case HALT: {
                            return event.getNewValue() != 0 ? "Halted" : "Unhalted";
                        }
                    }
                    return null;
                }

                @Override
                protected int getCurrentScanline() {
                    return MSX.this.getScanline();
                }

                @Override
                protected int getCurrentDot() {
                    return (228 - MSX.this.vdp.getTimer()) * 3 / 2;
                }

                @Override
                protected int getCurrentPC() {
                    return MSX.this.getVirtualAddress();
                }

                @Override
                public int getBreakpointEventId() {
                    return MSXEventTypes.BREAKPOINT.ordinal();
                }

                @Override
                public int getExceptionEventId() {
                    return MSXEventTypes.EXCEPTION.ordinal();
                }

                @Override
                protected boolean isRead(Event event) {
                    return event.getOldValue() >= 0 && event.getNewValue() < 0;
                }
            };
        }
        return this.eventModel;
    }

    protected void handleVdpRegisterEvent(int n, int n2, int n3, int n4) {
        MSX2EventTypes mSX2EventTypes;
        if (this.eventModel != null && (mSX2EventTypes = MSX2EventTypes.get(n > MSX2EventTypes.VDP_STATUS0.ordinal() ? n + MSX2EventTypes.VDP8.ordinal() - MSX2EventTypes.VDP_STATUS0.ordinal() : n)) != null) {
            switch (mSX2EventTypes) {
                case VDP0: 
                case VDP1: {
                    this.addEvent(mSX2EventTypes, n2, n3, n4, this.vdp.getModeBits());
                    break;
                }
                case VDP2: {
                    this.addEvent(mSX2EventTypes, n2, n3, n4, this.getScreenMapBaseAddress());
                    break;
                }
                case VDP3: 
                case VDP10: {
                    this.addEvent(mSX2EventTypes, n2, n3, n4, this.getColorTableAddress());
                    break;
                }
                case VDP4: {
                    this.addEvent(mSX2EventTypes, n2, n3, n4, this.getPatternGeneratorTableAddress());
                    break;
                }
                case VDP5: 
                case VDP11: {
                    this.addEvent(mSX2EventTypes, n2, n3, n4, this.getSpriteAttributeTableAddress());
                    break;
                }
                case VDP6: {
                    this.addEvent(mSX2EventTypes, n2, n3, n4, this.getSpritePatternAddress());
                    break;
                }
                case VDP14: {
                    this.addEvent(mSX2EventTypes, n2, n3, n4, this.vdp.getAddress());
                    break;
                }
                default: {
                    this.addEvent(mSX2EventTypes, n2, n3, n4);
                }
            }
        }
    }

    protected void addEvent(MSXEventType mSXEventType, int n) {
        this.addEvent(mSXEventType, -1, -1, n);
    }

    protected void addEvent(MSXEventType mSXEventType, int n, int n2, int n3) {
        this.addEvent(mSXEventType, n, n2, n3, -1);
    }

    protected void addEvent(MSXEventType mSXEventType, int n, int n2, int n3, int n4) {
        this.addEvent(mSXEventType, n, n2, n3, n4, null);
    }

    protected void addEvent(MSXEventType mSXEventType, int n, int n2, int n3, int n4, String string) {
        if (this.eventModel != null) {
            this.eventModel.addEvent(mSXEventType, this.getScanline(), n3, n, n2, this.getVirtualAddress(), n4, string);
        }
    }

    @Override
    public void addDebugEvent(DebuggableSystem.DebugEvent debugEvent, String string) {
        switch (debugEvent) {
            case BREAKPOINT: {
                this.addEvent(MSXEventTypes.BREAKPOINT, -1, -1, (228 - this.vdp.getTimer()) * 3 / 2, -1, string);
                break;
            }
            case EXCEPTION: {
                this.addEvent(MSXEventTypes.EXCEPTION, -1, -1, (228 - this.vdp.getTimer()) * 3 / 2, -1, string);
            }
        }
    }

    protected void frameFinished() {
        if (this.eventModel != null) {
            this.eventModel.finishFrame();
        }
    }

    @Override
    public void setInputState(long l) {
        this.keyboard.setState(l);
    }

    @Override
    public void setDebugger(DebuggableSystem debuggableSystem) {
        if (debuggableSystem == null) {
            debuggableSystem = this;
        }
        this.cpu.setMemoryMap(debuggableSystem);
    }

    public void setVdpReg(int n, int n2) {
        this.vdp.setReg(n, n2);
    }

    public void setPsgSnReg(int n, int n2) {
        this.psgSN.setReg(n, n2);
    }

    public void setFmReg(int n, int n2) {
        this.fm.writeReg(n, n2);
    }

    protected void handleVRAMwrite(int n) {
        int n2;
        if (this.peekByte(this.cpu.getPrevPC()) == 237 && this.peekByte(this.cpu.getPrevPC() + 1) == 179 && (n2 = this.ramSources.get(this.mapAddress(this.cpu.getRegisterValue(2)))) > 0) {
            this.vramSources.put(this.vdp.getAddress(), n2);
        }
    }

    public boolean isMSX2() {
        return this.vdp.isV9938mode();
    }

    public int getScreenMapBaseAddress() {
        return this.vdp.getScreenMapBaseAddress();
    }

    public int getColorTableAddress() {
        return this.vdp.getColorTableAddress();
    }

    public int getPatternGeneratorTableAddress() {
        return this.vdp.getPatternGeneratorTableAddress();
    }

    public int getSpriteAttributeTableAddress() {
        return this.vdp.getSpriteAttributeTableAddress();
    }

    public int getSpritePatternAddress() {
        return this.vdp.getSpritePatternAddress();
    }

    private void handleMessage() {
        this.fireMessageSent(Z80MessageParser.parseMessage(this));
    }

    protected void fireMessageSent(String string) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n = this.systemEventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemEventListener systemEventListener = systemEventListenerArray[n2];
            systemEventListener.messageSent(string);
            ++n2;
        }
    }

    protected void fireInputStateChanged(int n) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n2 = this.systemEventListeners.length;
        int n3 = 0;
        while (n3 < n2) {
            SystemEventListener systemEventListener = systemEventListenerArray[n3];
            systemEventListener.inputStateChanged(n);
            ++n3;
        }
    }

    protected void fireMemoryChanged(int n) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n2 = this.systemEventListeners.length;
        int n3 = 0;
        while (n3 < n2) {
            SystemEventListener systemEventListener = systemEventListenerArray[n3];
            systemEventListener.memoryChanged(n);
            ++n3;
        }
    }

    protected void fireErrorOccurred(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.errorOccurred(n, n2);
            ++n4;
        }
    }

    protected void fireVRAMread(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.vramRead(n, n2);
            ++n4;
        }
    }

    protected void fireVRAMwrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.vramWrite(n, n2, n3);
            ++n5;
        }
    }

    protected void fireCRAMwrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("palettes", n, n2, n3);
            ++n5;
        }
    }

    protected void fireVRAMaddressWritten() {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n = this.systemEventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemEventListener systemEventListener = systemEventListenerArray[n2];
            systemEventListener.vramAddressWritten();
            ++n2;
        }
    }

    protected void fireVdpRegisterWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("vdp", n, n2, n3);
            ++n5;
        }
    }

    protected void firePsgRegisterWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("psg", n, n2, n3);
            ++n5;
        }
    }

    protected void firePsgSnRegisterWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("sn", n, n2, n3);
            ++n5;
        }
    }

    protected void fireFmRegisterWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("fm", n, n2, n3);
            ++n5;
        }
    }

    @Override
    public void addSystemEventListener(SystemEventListener systemEventListener) {
        if (!this.systemEventListenerList.contains(systemEventListener)) {
            this.systemEventListenerList.addFirst(systemEventListener);
            this.systemEventListeners = this.systemEventListenerList.toArray(new SystemEventListener[this.systemEventListenerList.size()]);
        }
    }

    @Override
    public void removeSystemEventListener(SystemEventListener systemEventListener) {
        if (this.systemEventListenerList.remove(systemEventListener)) {
            this.systemEventListeners = this.systemEventListenerList.toArray(new SystemEventListener[this.systemEventListenerList.size()]);
        }
    }

    protected void firePortWritten(int n, int n2, int n3) {
        OutputListener[] outputListenerArray = this.portListeners;
        int n4 = this.portListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            OutputListener outputListener = outputListenerArray[n5];
            outputListener.outputAvailable(n, n2, n3);
            ++n5;
        }
    }

    protected void firePortRead(int n, int n2, int n3) {
        OutputListener[] outputListenerArray = this.portListeners;
        int n4 = this.portListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            OutputListener outputListener = outputListenerArray[n5];
            outputListener.outputAvailable(n, Integer.MIN_VALUE | n2, n3);
            ++n5;
        }
    }

    @Override
    public void addPortListener(OutputListener outputListener) {
        if (!this.portListenerList.contains(outputListener)) {
            this.portListenerList.addFirst(outputListener);
            this.portListeners = this.portListenerList.toArray(new OutputListener[this.portListenerList.size()]);
        }
    }

    @Override
    public void removePortListener(OutputListener outputListener) {
        if (this.portListenerList.remove(outputListener)) {
            this.portListeners = this.portListenerList.toArray(new OutputListener[this.portListenerList.size()]);
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        this.vdp.addOutputListener(outputListener);
        this.psg.addOutputListener(outputListener);
        this.psgSN.addOutputListener(outputListener);
        this.fm.addOutputListener(outputListener);
    }

    public void removeOutputListener(OutputListener outputListener) {
        this.vdp.removeOutputListener(outputListener);
        this.psg.removeOutputListener(outputListener);
        this.psgSN.removeOutputListener(outputListener);
        this.fm.removeOutputListener(outputListener);
    }

    @Override
    public EmulatableSystem.State createMutableState() {
        return this.getState().clone();
    }

    @Override
    public State getState() {
        final Z80.State state = this.cpu.getState();
        final TMS9918A.State state2 = this.vdp.getState();
        final MSXCartridge.State state3 = this.cartridge.getState();
        final AY38910.State state4 = this.psg.getState();
        final SN76489.State state5 = this.psgSN.getState();
        final YM2413.State state6 = this.fm.getState();
        final int[] nArray = this.ram;
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getPrimarySlotRegister() {
                return MSX.this.primarySlotRegister;
            }

            @Override
            public int getKeyboardLine() {
                return MSX.this.keyboard.getSelectedLine();
            }

            @Override
            public int[] getRam() {
                return nArray;
            }

            @Override
            public MSXCartridge.State getCartridgeState() {
                return state3;
            }

            @Override
            public Z80.State getCPUstate() {
                return state;
            }

            @Override
            public TMS9918A.State getVDPstate() {
                return state2;
            }

            @Override
            public AY38910.State getPSGstate() {
                return state4;
            }

            @Override
            public SN76489.State getPSGSNstate() {
                return state5;
            }

            @Override
            public YM2413.State getFMstate() {
                return state6;
            }
        };
    }

    @Override
    public void setState(EmulatableSystem.State state, boolean bl, boolean bl2) {
        if (state instanceof State) {
            State state2 = (State)state;
            System.arraycopy(state2.getRam(), 0, this.ram, 0, Math.min(this.ram.length, state2.getRam().length));
            this.primarySlotRegister = state2.getPrimarySlotRegister();
            this.keyboard.setSelectedLine(state2.getKeyboardLine());
            this.cartridge.setState(state2.getCartridgeState(), bl);
            this.cpu.setState(state2.getCPUstate());
            this.vdp.setState(state2.getVDPstate(), bl2);
            this.psg.setState(state2.getPSGstate());
            this.psgSN.setState(state2.getPSGSNstate());
            this.fm.setState(state2.getFMstate());
        }
    }

    @Override
    public void loadSAV(File file) {
        this.cartridge.readRAMfromFile(file);
    }

    private class Bios
    implements MSXDevice {
        private final byte[] rom;
        private final int offset;
        private final int mask;

        public Bios(File file) throws IOException {
            this(file, 0, 0);
        }

        public Bios(File file, int n, int n2) throws IOException {
            this.rom = IOUtilities.toByteArray(new FileInputStream(file));
            if (n2 <= 0) {
                n2 = this.rom.length;
            }
            if (!MSX.this.vdp.isV9938mode() || "cbios_msx2.rom".equals(file.getName())) {
                this.rom[43] = (byte)((MSX.this.pal ? 128 : 0) | this.rom[43] & 0xFFFFFF7F);
            }
            if ("cbios_msx2.rom".equals(file.getName())) {
                this.rom[4013] = (byte)(MSX.this.pal ? 2 : 0);
                this.rom[9652] = (byte)(MSX.this.pal ? 53 : 54);
            }
            this.offset = n;
            this.mask = n2 - 1;
        }

        @Override
        public int readByte(int n, int n2) {
            return this.rom[this.offset + (n & this.mask)] & 0xFF;
        }

        @Override
        public int getByte(int n) {
            return this.readByte(n, 0);
        }

        @Override
        public void writeByte(int n, int n2, int n3) {
        }

        @Override
        public void reset() {
        }
    }

    private class DiskRom
    implements MSXDevice {
        private final boolean DEBUG = false;
        private final byte[] rom;
        private final MSXDisk[] disks = new MSXDisk[2];

        public DiskRom(File file, MSXDisk mSXDisk) throws IOException {
            this.rom = IOUtilities.toByteArray(new FileInputStream(file));
        }

        public void insertDisk(int n, MSXDisk mSXDisk) {
            this.disks[n] = mSXDisk;
        }

        @Override
        public int readByte(int n, int n2) {
            if (n >= 16400 && n < 16418 && MSX.this.cpu.getPrevPC() == n) {
                MSX.this.cartridgeEnabled = true;
                int n3 = 0;
                switch (n) {
                    case 16400: {
                        n3 = this.handlePHYDIO(this.getA(), this.isCarrySet(), this.getB(), this.getC(), this.getDE(), this.getHL(), n2);
                        MSX.this.cpu.setRegValue(3, (n3 & 0x7F) << 8 | (n3 & 0x80) >> 7);
                        MSX.this.cpu.setRegValue(0, n3 & 0xFF00);
                        return 201;
                    }
                    case 16403: {
                        n3 = this.handleDSKCHG(this.getA(), this.getB(), this.getC(), this.getHL(), n2);
                        MSX.this.cpu.setRegValue(3, (n3 & 0x7F) << 8 | (n3 & 0x80) >> 7);
                        MSX.this.cpu.setRegValue(0, n3 & 0xFF00);
                        return 201;
                    }
                    case 16406: {
                        n3 = this.handleGETDBP(this.getA(), this.getB(), this.getC(), this.getHL(), n2);
                        MSX.this.cpu.setRegValue(3, (n3 & 0x7F) << 8 | (n3 & 0x80) >> 7);
                        MSX.this.cpu.setRegValue(0, n3 & 0xFF00);
                        return 201;
                    }
                    case 16409: {
                        return 201;
                    }
                    case 16412: {
                        return 201;
                    }
                    case 16415: {
                        return 201;
                    }
                }
            }
            if ((n & 0x3FFF) == 16376) {
                return 0;
            }
            if (n < 16384 || n >= 32768) {
                return 255;
            }
            return this.rom[n - 16384] & 0xFF;
        }

        @Override
        public void writeByte(int n, int n2, int n3) {
            if (n != 48896 && n != 65024) {
                System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
            }
        }

        private int handlePHYDIO(int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
            if (n >= this.disks.length || this.disks[n] == null) {
                return n2 << 8 | 0x82;
            }
            int n7 = n2;
            int n8 = this.disks[n].getBytesPerLogicalSector();
            if (n5 + n7 * n8 > 65536) {
                n7 = (65536 - n5) / n8;
            }
            int n9 = this.getSlt();
            this.enaSlt(MSX.this.peekByte(62274), 16384);
            if (bl) {
                try {
                    int n10 = n4;
                    while (n7 > 0) {
                        int n11 = 0;
                        while (n11 < n8) {
                            this.disks[n].writeFilesystem(n10 * n8 + n11, MSX.this.peekByte(n5++));
                            if (n == 0) {
                                MSX.this.ramSources.removeValue(n5 - 1);
                                MSX.this.fireMemoryChanged(n5 - 1);
                            }
                            ++n11;
                        }
                        --n2;
                        --n7;
                        ++n10;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.enaSlt(n9, 16384);
                    return n2 << 8 | 0x8A;
                }
            }
            try {
                int n12 = n4;
                while (n7 > 0) {
                    int n13 = 0;
                    while (n13 < n8) {
                        MSX.this.ramSource = n == 0 ? n12 * n8 + n13 : (n == 1 ? this.disks[0].getRom().length + n12 * n8 + n13 : -1);
                        this.setByte(n5++, this.disks[n].readFilesystem(n12 * n8 + n13));
                        MSX.this.ramSource = -1;
                        ++n13;
                    }
                    --n2;
                    --n7;
                    ++n12;
                }
            }
            catch (Exception exception) {
                MSX.this.ramSource = -1;
                exception.printStackTrace();
                this.enaSlt(n9, 16384);
                return n2 << 8 | 0x84;
            }
            this.enaSlt(n9, 16384);
            return n2 << 8;
        }

        private int handleDSKCHG(int n, int n2, int n3, int n4, int n5) {
            if (n >= this.disks.length || this.disks[n] == null) {
                return 130;
            }
            int n6 = this.disks[n].handleDSKCHG(n, n2, n3, n4, n5);
            if (n > 0 && n6 < 0) {
                int n7 = 0;
                while (n7 < this.disks[0].getRom().length) {
                    MSX.this.fireMemoryChanged(this.disks[0].getRom().length + n7);
                    ++n7;
                }
            }
            return n6 << 8;
        }

        private int handleGETDBP(int n, int n2, int n3, int n4, int n5) {
            if (n >= this.disks.length || this.disks[n] == null) {
                return 130;
            }
            try {
                this.disks[n].handleGETDBP(MSX.this, n, n2, n3, n4, n5);
            }
            catch (Exception exception) {
                return 132;
            }
            return 0;
        }

        public int[] getDiskMemory() {
            if (this.disks.length <= 0) {
                return null;
            }
            if (this.disks.length <= 1 || this.disks[1] == null) {
                return this.disks[0].getRom();
            }
            int[] nArray = new int[this.disks[0].getRom().length * 2];
            System.arraycopy(this.disks[0].getRom(), 0, nArray, 0, this.disks[0].getRom().length);
            int n = 0;
            while (n < this.disks[0].getRom().length) {
                nArray[this.disks[0].getRom().length + n] = this.disks[1].readByte(n, 0);
                ++n;
            }
            return nArray;
        }

        public int getDisksSize() {
            if (this.disks.length <= 0) {
                return 0;
            }
            if (this.disks.length <= 1 || this.disks[1] == null) {
                return this.disks[0].getRom().length;
            }
            return this.disks[0].getRom().length * 2;
        }

        @Override
        public int getByte(int n) {
            if ((n & 0x3FFF) == 16376) {
                return 0;
            }
            if (n < 16384 || n >= 32768) {
                return 255;
            }
            return this.rom[n - 16384] & 0xFF;
        }

        private void setByte(int n, int n2) {
            MSX.this.pokeByte(n, n2 & 0xFF);
        }

        private int getA() {
            return MSX.this.cpu.getRegisterValue(3) >> 8;
        }

        private boolean isCarrySet() {
            return MSX.this.cpu.isFlagSet(0);
        }

        private int getB() {
            return MSX.this.cpu.getRegisterValue(0) >> 8;
        }

        private int getC() {
            return MSX.this.cpu.getRegisterValue(0) & 0xFF;
        }

        private int getDE() {
            return MSX.this.cpu.getRegisterValue(1);
        }

        private int getHL() {
            return MSX.this.cpu.getRegisterValue(2);
        }

        private void setA(int n) {
            MSX.this.cpu.setRegValue(3, (n & 0xFF) << 8 | MSX.this.cpu.getRegisterValue(3) & 0xFF);
        }

        private void setHL(int n) {
            MSX.this.cpu.setRegValue(2, n);
        }

        private int getSP() {
            return MSX.this.cpu.getRegisterValue(6);
        }

        private void decSP() {
            MSX.this.cpu.setRegValue(6, this.getSP() - 1);
        }

        private int getSlt() {
            this.call(16429);
            return this.getA();
        }

        private void enaSlt(int n, int n2) {
            this.setA(n);
            this.setHL(n2);
            this.call(36);
        }

        private void call(int n) {
            int n2 = this.getSP();
            this.decSP();
            this.decSP();
            int n3 = MSX.this.cpu.getPC();
            MSX.this.cpu.setRegValue(7, n);
            while (MSX.this.cpu.getSP() < n2) {
                MSX.this.cpu.execute(0);
            }
            MSX.this.cpu.setRegValue(7, n3);
        }

        @Override
        public void reset() {
        }
    }

    public class RamMapper
    implements MSXDevice {
        private final int[] ram;
        private final boolean[] ramInitialized;
        private final int[] memoryMapperRegisters;

        public RamMapper(int[] nArray) {
            int[] nArray2 = new int[4];
            nArray2[0] = 3;
            nArray2[1] = 2;
            nArray2[2] = 1;
            this.memoryMapperRegisters = nArray2;
            this.ram = nArray;
            this.ramInitialized = new boolean[nArray.length];
        }

        @Override
        public int readByte(int n, int n2) {
            int n3;
            int n4;
            int n5 = this.mapAddress(n);
            if (n5 < 0) {
                return 255;
            }
            if (!(this.ramInitialized[n5] || (n4 = MSX.this.peekByte(n3 = MSX.this.getPrevPC())) == 237 && MSX.this.peekByte(n3 + 1) == 103 && (MSX.this.peekByte(n3 + 2) & 0xF8) == 120 || n4 == 42 && (n - 1 & 0x1FFF) == ((MSX.this.peekByte(n3 + 2) << 8 | MSX.this.peekByte(n3 + 1)) & 0x1FFF) && MSX.this.peekByte(n3 + 3) == 38)) {
                MSX.this.fireErrorOccurred(-1, n);
            }
            MSX.this.addEvent(MSXEventTypes.RAM, this.ram[n5], -1, (228 - MSX.this.vdp.getTimer() + n2) * 3 / 2, n5);
            return this.ram[n5];
        }

        @Override
        public int getByte(int n) {
            int n2 = this.mapAddress(n);
            if (n2 < 0) {
                return 255;
            }
            return this.ram[n2];
        }

        public void printMemoryRegisters() {
            System.out.println("RAM mapper registers: " + this.memoryMapperRegisters[0] + " " + this.memoryMapperRegisters[1] + " " + this.memoryMapperRegisters[2] + " " + this.memoryMapperRegisters[3]);
        }

        @Override
        public void writeByte(int n, int n2, int n3) {
            int n4 = this.mapAddress(n);
            if (n4 >= 0) {
                if (MSX.this.isCartridgeEnabled()) {
                    this.ramInitialized[n4] = true;
                } else if (MSX.this.getPC() < 32768 && MSX.this.peekByte(MSX.this.getPC()) != 190 && this.ram[n4] != (n2 ^ 0xFF)) {
                    this.ramInitialized[n4] = true;
                }
                MSX.this.addEvent(MSXEventTypes.RAM, this.ram[n4], n2, (228 - MSX.this.vdp.getTimer() + n3) * 3 / 2, n4);
                this.ram[n4] = n2;
                if (n3 > 0 && MSX.this.peekByte(MSX.this.cpu.getPrevPC()) == 237) {
                    if (MSX.this.peekByte(MSX.this.cpu.getPrevPC() + 1) == 176 && MSX.this.isRAMaddress(MSX.this.cpu.getRegisterValue(2))) {
                        MSX.this.ramSource = MSX.this.ramSources.get(this.mapAddress(MSX.this.cpu.getRegisterValue(2)));
                    } else if (MSX.this.peekByte(MSX.this.cpu.getPrevPC() + 1) == 178) {
                        MSX.this.ramSource = MSX.this.vramSources.get(MSX.this.vdp.getAddress() - 1);
                    }
                }
                if (MSX.this.ramSource >= 0) {
                    MSX.this.ramSources.put(n4, MSX.this.ramSource);
                } else {
                    MSX.this.ramSources.remove(n4);
                }
                MSX.this.ramSource = -1;
            }
        }

        public int getBank(int n) {
            return this.memoryMapperRegisters[n >> 14];
        }

        public int mapAddress(int n) {
            return this.mapAddress(n, this.memoryMapperRegisters[n >> 14]);
        }

        public int mapAddress(int n, int n2) {
            return n2 * 16384 | n & 0x3FFF;
        }

        public void writeMemoryMapperRegister(int n, int n2) {
            this.memoryMapperRegisters[n & 3] = Math.min((this.ram.length - 1) / 16384, n2);
        }

        public int readMemoryMapperRegister(int n) {
            return this.memoryMapperRegisters[n & 3];
        }

        public boolean isInitialized(int n) {
            return this.ramInitialized[n];
        }

        @Override
        public void reset() {
            Arrays.fill(this.ramInitialized, false);
            int n = 0;
            while (n < this.memoryMapperRegisters.length) {
                this.memoryMapperRegisters[n] = 3 - n;
                ++n;
            }
        }
    }

    public static interface State
    extends EmulatableSystem.State {
        public int getPrimarySlotRegister();

        public int getKeyboardLine();

        public int[] getRam();

        public MSXCartridge.State getCartridgeState();

        public Z80.State getCPUstate();

        public TMS9918A.State getVDPstate();

        public AY38910.State getPSGstate();

        public SN76489.State getPSGSNstate();

        public YM2413.State getFMstate();
    }

    private static class StateClone
    implements State {
        private int primarySlotRegister;
        private int keyboardLine;
        private final int[] ram;
        private final MSXCartridge.State cartridge;
        private final Z80.State cpu;
        private final TMS9918A.State vdp;
        private final AY38910.State psg;
        private final SN76489.State psgSN;
        private final YM2413.State fm;

        public StateClone(State state) {
            this.primarySlotRegister = state.getPrimarySlotRegister();
            this.keyboardLine = state.getKeyboardLine();
            this.ram = new int[state.getRam().length];
            System.arraycopy(state.getRam(), 0, this.ram, 0, Math.min(this.ram.length, state.getRam().length));
            this.cartridge = state.getCartridgeState().clone();
            this.cpu = state.getCPUstate().clone();
            this.vdp = state.getVDPstate().clone();
            this.psg = state.getPSGstate().clone();
            this.psgSN = state.getPSGSNstate().clone();
            this.fm = state.getFMstate().clone();
        }

        @Override
        public void setState(EmulatableSystem.State state) throws UnmodifiableClassException {
            State state2 = (State)state;
            this.primarySlotRegister = state2.getPrimarySlotRegister();
            this.keyboardLine = state2.getKeyboardLine();
            System.arraycopy(state2.getRam(), 0, this.ram, 0, Math.min(this.ram.length, state2.getRam().length));
            this.cartridge.setState(state2.getCartridgeState());
            this.cpu.setState(state2.getCPUstate());
            this.vdp.setState(state2.getVDPstate());
            this.psg.setState(state2.getPSGstate());
            this.psgSN.setState(state2.getPSGSNstate());
            this.fm.setState(state2.getFMstate());
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getPrimarySlotRegister() {
            return this.primarySlotRegister;
        }

        @Override
        public int getKeyboardLine() {
            return this.keyboardLine;
        }

        @Override
        public int[] getRam() {
            return this.ram;
        }

        @Override
        public MSXCartridge.State getCartridgeState() {
            return this.cartridge;
        }

        @Override
        public Z80.State getCPUstate() {
            return this.cpu;
        }

        @Override
        public TMS9918A.State getVDPstate() {
            return this.vdp;
        }

        @Override
        public AY38910.State getPSGstate() {
            return this.psg;
        }

        @Override
        public SN76489.State getPSGSNstate() {
            return this.psgSN;
        }

        @Override
        public YM2413.State getFMstate() {
            return this.fm;
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(EmulatableSystem.State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

