/*
 * Decompiled with CFR 0.152.
 */
package util.map;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import util.map.IntMap;

public class HashIntMap
implements IntMap {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int KEY_FREE = 0;
    public static final int NO_VALUE = Integer.MIN_VALUE;
    int[] table;
    boolean hasFreeKey;
    int freeValue = Integer.MIN_VALUE;
    int size;
    private int threshold;
    private int mask;
    private final float loadFactor;
    private Set<IntMap.Entry> entrySet;

    public HashIntMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.mask = (n2 << 1) - 1;
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new int[n2 << 1];
        Arrays.fill(this.table, 0);
    }

    public HashIntMap(int n) {
        this(n, 0.75f);
    }

    public HashIntMap() {
        this(16, 0.75f);
    }

    private static final int hash(int n) {
        int n2 = n * -1640531527;
        return n2 ^ n2 >> 16;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(int n) {
        return this.get(n) != Integer.MIN_VALUE;
    }

    @Override
    public boolean containsValue(int n) {
        if (this.hasFreeKey && n == this.freeValue) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.table.length) {
            if (this.table[n2] != 0 && this.table[n2 | 1] == n) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    @Override
    public int get(int n) {
        if (n == 0) {
            return this.hasFreeKey ? this.freeValue : Integer.MIN_VALUE;
        }
        int n2 = HashIntMap.hash(n) << 1 & this.mask;
        int n3 = this.table[n2];
        while (n3 != 0) {
            if (n3 == n) {
                return this.table[n2 | 1];
            }
            n2 = n2 + 2 & this.mask;
            n3 = this.table[n2];
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int put(int n, int n2) {
        if (n == 0) {
            return this.putFreeKey(n2);
        }
        int n3 = HashIntMap.hash(n) << 1 & this.mask;
        int n4 = this.table[n3];
        while (n4 != 0) {
            if (n4 == n) {
                int n5 = this.table[n3 | 1];
                this.table[n3 | 1] = n2;
                return n5;
            }
            n3 = n3 + 2 & this.mask;
            n4 = this.table[n3];
        }
        this.addEntry(n, n2, n3);
        return Integer.MIN_VALUE;
    }

    private final void addEntry(int n, int n2, int n3) {
        this.table[n3] = n;
        this.table[n3 | 1] = n2;
        if (this.size++ >= this.threshold) {
            this.resize(this.table.length << 1);
        }
    }

    private final int putFreeKey(int n) {
        int n2 = this.freeValue;
        if (!this.hasFreeKey) {
            ++this.size;
        }
        this.hasFreeKey = true;
        this.freeValue = n;
        return n2;
    }

    private final void resize(int n) {
        if (this.table.length == 0x40000000) {
            return;
        }
        int[] nArray = this.table;
        this.table = new int[n];
        this.threshold = (int)((float)(n >> 1) * this.loadFactor);
        this.mask = n - 1;
        this.size = this.hasFreeKey ? 1 : 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (n3 != 0) {
                this.put(n3, nArray[n2 | 1]);
            }
            n2 += 2;
        }
    }

    @Override
    public int remove(int n) {
        if (n == 0) {
            return this.removeFreeKey();
        }
        int n2 = HashIntMap.hash(n) << 1 & this.mask;
        int n3 = this.table[n2];
        while (n3 != 0) {
            if (n3 == n) {
                int n4 = this.table[n2 | 1];
                int n5 = n2 + 2 & this.mask;
                int n6 = this.table[n5];
                while (n3 != 0 && n6 != 0) {
                    int n7 = HashIntMap.hash(n6) << 1 & this.mask;
                    if (n5 != n7 && (n2 - n7 & this.mask) < this.mask >> 1) {
                        this.table[n2] = n6;
                        this.table[n2 | 1] = this.table[n5 | 1];
                        n2 = n5;
                        n3 = n6;
                    }
                    n5 = n5 + 2 & this.mask;
                    n6 = this.table[n5];
                }
                this.table[n2] = 0;
                --this.size;
                return n4;
            }
            n2 = n2 + 2 & this.mask;
            n3 = this.table[n2];
        }
        return Integer.MIN_VALUE;
    }

    private final int removeFreeKey() {
        if (!this.hasFreeKey) {
            return Integer.MIN_VALUE;
        }
        this.hasFreeKey = false;
        --this.size;
        return this.freeValue;
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, 0);
        this.hasFreeKey = false;
        this.size = 0;
    }

    @Override
    public Set<IntMap.Entry> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public BitSet keyBitSet() {
        BitSet bitSet = new BitSet();
        if (this.hasFreeKey) {
            bitSet.set(0);
        }
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != 0) {
                bitSet.set(this.table[n]);
            }
            n += 2;
        }
        return bitSet;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    final class EntryIterator
    implements Iterator<IntMap.Entry> {
        private int knownSize;
        private int cursor;
        private int counter;

        EntryIterator() {
            this.knownSize = HashIntMap.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.counter < HashIntMap.this.size;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public IntMap.Entry next() {
            if (HashIntMap.this.size != this.knownSize) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!HashIntMap.this.hasFreeKey || this.counter != 0) ** GOTO lbl9
            ++this.counter;
            return new IntHashMapEntry(0, HashIntMap.this.freeValue);
lbl-1000:
            // 1 sources

            {
                this.cursor += 2;
lbl9:
                // 2 sources

                ** while (HashIntMap.this.table[this.cursor] == 0)
            }
lbl10:
            // 1 sources

            ++this.counter;
            var1_1 = new IntHashMapEntry(HashIntMap.this.table[this.cursor], HashIntMap.this.table[this.cursor | 1]);
            this.cursor += 2;
            return var1_1;
        }

        @Override
        public void remove() {
            if (HashIntMap.this.size != this.knownSize) {
                throw new ConcurrentModificationException();
            }
            if (this.counter >= HashIntMap.this.table.length || HashIntMap.this.table[this.cursor] == 0) {
                throw new IllegalStateException();
            }
            HashIntMap.this.table[this.cursor] = 0;
            --HashIntMap.this.size;
        }
    }

    final class EntrySet
    extends AbstractSet<IntMap.Entry> {
        EntrySet() {
        }

        @Override
        public Iterator<IntMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return HashIntMap.this.size;
        }

        @Override
        public void clear() {
            HashIntMap.this.clear();
        }
    }

    public static class IntHashMapEntry
    implements IntMap.Entry {
        private final int key;
        private final int value;

        public IntHashMapEntry(int n, int n2) {
            this.key = n;
            this.value = n2;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(Integer.toHexString(this.key)) + "=" + Integer.toHexString(this.value);
        }
    }
}

