/*
 * Decompiled with CFR 0.152.
 */
package assembler;

import assembler.Z80SourceLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import util.string.StringUtilities;

public class Macro {
    private final CharSequence name;
    private final CharSequence[] params;
    private final List<Z80SourceLine> lines = new ArrayList<Z80SourceLine>();

    public Macro(CharSequence charSequence, CharSequence[] charSequenceArray) {
        if (charSequence == null) {
            throw new IllegalArgumentException("name of Macro must not be null");
        }
        if ((charSequence = StringUtilities.trim(charSequence)).length() == 0) {
            throw new IllegalArgumentException("name of Macro must not be empty");
        }
        this.name = charSequence;
        if (charSequenceArray == null) {
            this.params = new CharSequence[0];
        } else {
            this.params = new CharSequence[charSequenceArray.length];
            int n = 0;
            while (n < charSequenceArray.length) {
                this.params[n] = StringUtilities.trim(charSequenceArray[n]);
                ++n;
            }
        }
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence[] getParams() {
        return this.params;
    }

    public void addLine(Z80SourceLine z80SourceLine) {
        this.lines.add(z80SourceLine);
    }

    public List<Z80SourceLine> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public String toString() {
        return this.getName() + Arrays.toString(this.params);
    }
}

