/*
 * Decompiled with CFR 0.152.
 */
package assembler;

import assembler.HexStrings;

public class Z80Instruction {
    protected static final int NO_ARG = -1073741824;
    private static final String[] CONDITIONS = new String[]{"nz", "z", "nc", "c", "po", "pe", "p", "m"};
    private static final String[] ALU_OPERATIONS = new String[]{"add a, ", "adc a, ", "sub ", "sbc a, ", "and ", "xor ", "or ", "cp "};
    private static final String[] BIT_OPERATIONS = new String[]{"rlc", "rrc", "rl", "rr", "sla", "sra", "sll", "srl"};
    protected final int opCode;
    protected final int arg;
    protected final int prefix;
    protected final int displacement;
    protected final int size;
    private static final Z80Instruction[] instructions = new Z80Instruction[256];
    private static final Z80Instruction[] instructionsCB = new Z80Instruction[256];
    private static final Z80Instruction[] instructionsED = new Z80Instruction[256];
    private String string;

    protected Z80Instruction(int n, int n2, int n3, int n4, int n5) {
        if (n2 == 203) {
            n |= 0xCB00;
            n2 = 0;
        } else if (n2 == 237) {
            n |= 0xED00;
            n2 = 0;
        }
        if (n2 == 0) {
            n3 = 256;
        }
        this.opCode = n;
        this.prefix = n2;
        this.displacement = n3;
        this.arg = n4;
        int n6 = 1;
        if (n >= 256) {
            ++n6;
        }
        if (n2 != 0) {
            ++n6;
        }
        if (n3 != 256) {
            ++n6;
        }
        this.size = n6 += n5;
    }

    protected Z80Instruction(int n, int n2) {
        this(n, n2, 256, -1073741824, 0);
    }

    public static Z80Instruction getInstance(int n, int n2, int n3, int n4, int n5) {
        if (n5 == 0) {
            if (n2 == 203) {
                if (instructionsCB[n] == null) {
                    Z80Instruction.instructionsCB[n] = new Z80Instruction(n, 203, n3, n4, 0);
                }
                return instructionsCB[n];
            }
            if (n2 == 237) {
                if (instructionsED[n] == null) {
                    Z80Instruction.instructionsED[n] = new Z80Instruction(n, 237, n3, n4, 0);
                }
                return instructionsED[n];
            }
            if (n2 == 0) {
                return Z80Instruction.getInstance(n);
            }
        }
        return new Z80Instruction(n, n2, n3, n4, n5);
    }

    public static Z80Instruction getInstance(int n, int n2, int n3) {
        return Z80Instruction.getInstance(n, n2, n3, -1073741824, 0);
    }

    public static Z80Instruction getInstance(int n, int n2) {
        return Z80Instruction.getInstance(n, n2, 256);
    }

    public static Z80Instruction getInstance(int n) {
        if (instructions[n] == null) {
            Z80Instruction.instructions[n] = new Z80Instruction(n, 0, 0, -1073741824, 0);
        }
        return instructions[n];
    }

    public static Z80Instruction parse(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        block58: {
            block57: {
                n5 = -1073741824;
                n4 = 256;
                if (((n3 = nArray[n++]) & 0xDF) != 221) break block57;
                n2 = n3;
                n3 = nArray[n++];
                switch (n3 >> 6) {
                    case 0: {
                        switch (n3 & 0x3F) {
                            case 52: 
                            case 53: 
                            case 54: {
                                n4 = (byte)nArray[n++];
                            }
                        }
                        break;
                    }
                    case 1: {
                        if ((n3 >> 3 & 7) == 6) {
                            n4 = (byte)nArray[n++];
                            break;
                        }
                    }
                    case 2: {
                        if ((n3 & 7) == 6) {
                            n4 = (byte)nArray[n++];
                            break;
                        }
                        break block58;
                    }
                    case 3: {
                        if ((n3 & 0xFF) != 203) break block58;
                        n4 = (byte)nArray[n++];
                        n3 = n3 << 8 | nArray[n++];
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block58;
            }
            n2 = 0;
        }
        int n6 = n;
        block9 : switch (n3 >> 6) {
            case 0: {
                block13 : switch (n3 & 0xF) {
                    case 0: 
                    case 8: {
                        switch (n3) {
                            case 0: 
                            case 8: {
                                break block13;
                            }
                        }
                        n5 = (byte)nArray[n++];
                        break;
                    }
                    case 1: {
                        n5 = nArray[n++] | nArray[n++] << 8;
                        break;
                    }
                    case 2: {
                        switch (n3) {
                            case 2: 
                            case 18: {
                                break block13;
                            }
                        }
                        n5 = nArray[n++] | nArray[n++] << 8;
                        break;
                    }
                    case 6: 
                    case 14: {
                        n5 = nArray[n++];
                        break;
                    }
                    case 10: {
                        switch (n3) {
                            case 10: 
                            case 26: {
                                break block13;
                            }
                        }
                        n5 = nArray[n++] | nArray[n++] << 8;
                    }
                }
                break;
            }
            case 3: {
                switch (n3 & 0xF) {
                    case 2: 
                    case 10: {
                        n5 = nArray[n++] | nArray[n++] << 8;
                        break block9;
                    }
                    case 3: {
                        switch (n3) {
                            case 195: {
                                n5 = nArray[n++] | nArray[n++] << 8;
                                break block9;
                            }
                            case 211: {
                                n5 = nArray[n++];
                            }
                        }
                        break block9;
                    }
                    case 4: 
                    case 12: {
                        n5 = nArray[n++] | nArray[n++] << 8;
                        break block9;
                    }
                    case 6: 
                    case 14: {
                        n5 = nArray[n++];
                        break block9;
                    }
                    case 11: {
                        switch (n3) {
                            case 203: {
                                n3 = nArray[n];
                                if (instructionsCB[n3] == null) {
                                    Z80Instruction.instructionsCB[n3] = new Z80Instruction(n3, 203, n4, n5, n - n6);
                                }
                                return instructionsCB[n3];
                            }
                            case 219: {
                                n5 = nArray[n++];
                            }
                        }
                    }
                    case 13: {
                        switch (n3) {
                            case 205: {
                                n5 = nArray[n++] | nArray[n++] << 8;
                                break block9;
                            }
                            case 237: {
                                n3 = nArray[n++];
                                if ((n3 & 0xC7) != 67) {
                                    if (instructionsED[n3] == null) {
                                        Z80Instruction.instructionsED[n3] = new Z80Instruction(n3, 237, n4, n5, n - n6 - 1);
                                    }
                                    return instructionsED[n3];
                                }
                                n5 = nArray[n++] | nArray[n++] << 8;
                                return new Z80Instruction(n3, 237, n4, n5, n - n6 - 1);
                            }
                        }
                    }
                }
            }
        }
        return n == n6 && n2 == 0 ? Z80Instruction.getInstance(n3) : new Z80Instruction(n3, n2, n4, n5, n - n6);
    }

    private final String registerPairToString(int n) {
        if ((n & 6) == 4) {
            if (this.prefix == 221) {
                return "ix";
            }
            if (this.prefix == 253) {
                return "iy";
            }
        } else if ((n & 6) == 6) {
            return "sp";
        }
        return String.valueOf(this.registerToString(n & 0xFE)) + this.registerToString(n | 1);
    }

    protected final String registerToString(int n) {
        switch (n & 7) {
            case 0: {
                return "b";
            }
            case 1: {
                return "c";
            }
            case 2: {
                return "d";
            }
            case 3: {
                return "e";
            }
            case 4: {
                if (this.prefix > 0 && this.opCode >> 8 != 203 && (this.opCode == 38 || (this.opCode & 7) != 6 && ((this.opCode & 0xC0) != 64 || (this.opCode >> 3 & 7) != 6))) {
                    if (this.prefix == 221) {
                        return "ixh";
                    }
                    return "iyh";
                }
                return "h";
            }
            case 5: {
                if (this.prefix > 0 && this.opCode >> 8 != 203 && (this.opCode == 46 || (this.opCode & 7) != 6 && ((this.opCode & 0xC0) != 64 || (this.opCode >> 3 & 7) != 6))) {
                    if (this.prefix == 221) {
                        return "ixl";
                    }
                    return "iyl";
                }
                return "l";
            }
            case 6: {
                if (this.prefix == 221) {
                    if (this.displacement < 0) {
                        return "(ix" + this.displacement + ")";
                    }
                    return "(ix+" + this.displacement + ")";
                }
                if (this.prefix == 253) {
                    if (this.displacement < 0) {
                        return "(iy" + this.displacement + ")";
                    }
                    return "(iy+" + this.displacement + ")";
                }
                return "(hl)";
            }
            case 7: {
                return "a";
            }
        }
        return null;
    }

    protected static final String toHexString(int n, int n2) {
        if (n2 == 2) {
            return String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n >> 8 & 0xFF].substring(1)) + HexStrings.HEX_STRINGS[n & 0xFF];
        }
        return HexStrings.PREFIXED_HEX_STRINGS[n & 0xFF].substring(1);
    }

    private final String instructionEDToString() {
        int n = this.opCode & 0xFF;
        if (n >> 6 == 1) {
            switch (n & 7) {
                case 0: {
                    if (n == 112) {
                        return "in (c)";
                    }
                    return "in " + this.registerToString(n >> 3) + ", (c)";
                }
                case 1: {
                    if (n == 113) {
                        return "out (c), 0";
                    }
                    return "out (c), " + this.registerToString(n >> 3);
                }
                case 2: {
                    return String.valueOf((n & 8) != 0 ? "adc" : "sbc") + " hl, " + this.registerPairToString(n >> 3);
                }
                case 3: {
                    if ((n & 8) != 0) {
                        return "ld " + this.registerPairToString(n >> 3) + ", (" + Z80Instruction.toHexString(this.arg, 2) + ")";
                    }
                    return "ld (" + Z80Instruction.toHexString(this.arg, 2) + "), " + this.registerPairToString(n >> 3);
                }
                case 4: {
                    return "neg";
                }
                case 5: {
                    return n == 77 ? "reti" : "retn";
                }
                case 6: {
                    return "im " + ((n >> 4 & 1) + (n >> 3 & 1));
                }
                case 7: {
                    switch (n) {
                        case 71: {
                            return "ld i, a";
                        }
                        case 79: {
                            return "ld r, a";
                        }
                        case 87: {
                            return "ld a, i";
                        }
                        case 95: {
                            return "ld a, r";
                        }
                        case 103: {
                            return "rrd";
                        }
                        case 111: {
                            return "rld";
                        }
                    }
                }
            }
        } else if (n >> 5 == 5) {
            switch (n & 7) {
                case 0: {
                    return "ld" + ((n & 8) != 0 ? "d" : "i") + ((n & 0x10) != 0 ? "r" : "");
                }
                case 1: {
                    return "cp" + ((n & 8) != 0 ? "d" : "i") + ((n & 0x10) != 0 ? "r" : "");
                }
                case 2: {
                    return "in" + ((n & 8) != 0 ? "d" : "i") + ((n & 0x10) != 0 ? "r" : "");
                }
                case 3: {
                    if ((n & 0x10) != 0) {
                        return "ot" + ((n & 8) != 0 ? "d" : "i") + "r";
                    }
                    return "out" + ((n & 8) != 0 ? "d" : "i");
                }
            }
        }
        return Integer.toHexString(0xED00 | n);
    }

    public boolean isCall() {
        return (this.opCode & 0xFFFF) == 205 || (this.opCode & 0xFFC7) == 196 || (this.opCode & 0xFFC7) == 199;
    }

    public boolean isRet() {
        return (this.opCode & 0xFFFF) == 201 || (this.opCode & 0xFFC7) == 192 || (this.opCode & 0xFFC7) == 60741;
    }

    public boolean isJump() {
        return (this.opCode & 0xFFFF) == 195 || (this.opCode & 0xFFFF) == 233 || (this.opCode & 0xFFC7) == 194 || (this.opCode & 0xFFF7) == 16 || (this.opCode & 0xFFE7) == 32;
    }

    public boolean isRelative() {
        return this.isJump() && this.getArgSize() == 1;
    }

    public boolean isBranch() {
        return this.isCall() || this.isJump();
    }

    public boolean isMemoryRead() {
        return this.opCode == 52 || this.opCode == 53 || this.opCode == 227 || (this.opCode & 0xFFCF) == 10 || (this.opCode - 64 & 0xFF87) == 6 && this.opCode != 118 || (this.opCode & 0xFFCF) == 60747 || (this.opCode & 0xFF07) == 51974;
    }

    public boolean isMemoryWrite() {
        return this.opCode == 52 || this.opCode == 53 || this.opCode == 54 || this.opCode == 227 || (this.opCode & 0xFFCF) == 2 || (this.opCode & 0xFFF8) == 112 && this.opCode != 118 || (this.opCode & 0xFFCF) == 60739 || (this.opCode & 0xFF07) == 51974 && (this.opCode & 0xC0) != 64;
    }

    public boolean isMemoryAccess() {
        return this.isMemoryRead() || this.isMemoryWrite();
    }

    public int getMemoryAccessRegister() {
        if (this.opCode == 227) {
            return 6;
        }
        if (this.prefix == 221) {
            return 4;
        }
        if (this.prefix == 253) {
            return 5;
        }
        if (this.getArgSize() == 2) {
            return -1;
        }
        if ((this.opCode & 0xFFE7) == 2) {
            return this.opCode >> 4;
        }
        return 2;
    }

    public int getMemoryAccessSize() {
        if ((this.opCode & 0xFFF7) == 34 || (this.opCode & 0xFFC7) == 60739) {
            return 2;
        }
        if (this.isMemoryAccess()) {
            return 1;
        }
        return 0;
    }

    public boolean isPortRead() {
        return (this.opCode & 0xFFFF) == 219 || (this.opCode & 0xFFC7) == 60736 || (this.opCode & 0xFFE7) == 60834;
    }

    public boolean isPortWrite() {
        return (this.opCode & 0xFFFF) == 211 || (this.opCode & 0xFFC7) == 60737 || (this.opCode & 0xFFE7) == 60835;
    }

    public boolean isPortAccess() {
        return this.isPortRead() || this.isPortWrite();
    }

    public int getDestination(int n, int n2) {
        if ((this.opCode & 0xFFC7) == 199) {
            return this.opCode - 199;
        }
        if (this.opCode == 205 || this.opCode == 195 || (this.opCode & 0xFFC7) == 196 || (this.opCode & 0xFFC7) == 194) {
            return this.arg;
        }
        if ((this.opCode & 0xFFE7) == 32 || (this.opCode & 0xFFF7) == 16) {
            return n2 * 16384 + (n & 0x3FFF) + this.size + this.arg & 0xFFFF;
        }
        return this.arg;
    }

    public boolean isConditional() {
        return (this.opCode & 0xFFE7) == 32 || (this.opCode & 0xFFC3) == 192 || (this.opCode & 0xFFC7) == 194 || (this.opCode & 0xFFFF) == 16;
    }

    public int getCondition() {
        if (this.opCode == 16) {
            return 8;
        }
        int n = 7;
        if ((this.opCode & 0xFFE7) == 32) {
            n = 3;
        }
        return this.opCode >> 3 & n;
    }

    public boolean isValid() {
        if (this.prefix > 0) {
            switch (this.opCode >> 4) {
                case 0: 
                case 1: {
                    return (this.opCode & 0xF) == 9;
                }
                case 2: {
                    return ((this.opCode & 7) - 1 & 7) < 6;
                }
                case 3: {
                    return (this.opCode & 0xF) == 9 || ((this.opCode & 0xF) - 4 & 0xF) < 3;
                }
                case 6: {
                    return true;
                }
                case 7: {
                    if ((this.opCode & 0xF) < 8) {
                        return ((this.opCode & 7) + 1 & 7) <= 6;
                    }
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return ((this.opCode & 7) + 1 & 7) > 4;
                }
            }
            return this.opCode >> 8 == 203 || this.opCode == 225 || this.opCode == 227 || this.opCode == 229 || this.opCode == 233 || this.opCode == 249;
        }
        if (this.opCode >> 8 != 237) {
            return true;
        }
        int n = this.opCode & 0xFF;
        if (n >> 6 == 1) {
            switch (n & 7) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return true;
                }
                case 7: {
                    switch (n) {
                        case 71: 
                        case 79: 
                        case 87: 
                        case 95: 
                        case 103: 
                        case 111: {
                            return true;
                        }
                    }
                }
            }
        } else if (n >> 5 == 5) {
            switch (n & 7) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
        }
        return false;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public boolean hasArg() {
        return this.arg != -1073741824;
    }

    public boolean hasDestination() {
        return this.hasArg() || this.isCall();
    }

    public int getArg() {
        if (!this.hasArg()) {
            return 0;
        }
        return this.arg;
    }

    public int getArgSize() {
        if (!this.hasArg()) {
            return 0;
        }
        int n = this.getSize() - 1;
        if (this.getOpCode() >= 256) {
            --n;
        }
        if (this.getPrefix() != 0) {
            --n;
        }
        if (this.hasDisplacement()) {
            --n;
        }
        return n;
    }

    public int getPrefix() {
        return this.prefix;
    }

    public boolean hasDisplacement() {
        return this.displacement < 256;
    }

    public int getDisplacement() {
        if (!this.hasDisplacement()) {
            return 0;
        }
        return this.displacement;
    }

    public int getSize() {
        return this.size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Z80Instruction)) {
            return false;
        }
        Z80Instruction z80Instruction = (Z80Instruction)object;
        if (this.size != z80Instruction.size) {
            return false;
        }
        if (this.arg != z80Instruction.arg) {
            return false;
        }
        if (this.displacement != z80Instruction.displacement) {
            return false;
        }
        if (this.opCode != z80Instruction.opCode) {
            return false;
        }
        return this.prefix == z80Instruction.prefix;
    }

    /*
     * Unable to fully structure code
     */
    protected String buildString() {
        var1_1 = this.opCode;
        if ((var1_1 & 65280) != 0) {
            var1_1 >>= 8;
        }
        switch (var1_1 >> 6) {
            case 0: {
                switch (var1_1 & 15) {
                    case 0: 
                    case 8: {
                        switch (var1_1) {
                            case 0: {
                                return "nop";
                            }
                            case 8: {
                                return "ex af, af'";
                            }
                            case 16: {
                                return "djnz " + this.arg;
                            }
                            case 24: {
                                return "jr " + this.arg;
                            }
                        }
                        return "jr " + Z80Instruction.CONDITIONS[var1_1 >> 3 & 3] + ", " + this.arg;
                    }
                    case 1: {
                        return "ld " + this.registerPairToString(var1_1 >> 3) + ", " + Z80Instruction.toHexString(this.arg, 2);
                    }
                    case 2: {
                        switch (var1_1) {
                            case 2: {
                                return "ld (bc), a";
                            }
                            case 18: {
                                return "ld (de), a";
                            }
                            case 34: {
                                return "ld (" + Z80Instruction.toHexString(this.arg, 2) + "), " + this.registerPairToString(4);
                            }
                            case 50: {
                                return "ld (" + Z80Instruction.toHexString(this.arg, 2) + "), a";
                            }
                        }
                    }
                    case 3: {
                        return "inc " + this.registerPairToString(var1_1 >> 3);
                    }
                    case 4: 
                    case 12: {
                        return "inc " + this.registerToString(var1_1 >> 3);
                    }
                    case 5: 
                    case 13: {
                        return "dec " + this.registerToString(var1_1 >> 3);
                    }
                    case 6: 
                    case 14: {
                        return "ld " + this.registerToString(var1_1 >> 3) + ", " + Z80Instruction.toHexString(this.arg, 1);
                    }
                    case 7: {
                        switch (var1_1) {
                            case 7: {
                                return "rlca";
                            }
                            case 23: {
                                return "rla";
                            }
                            case 39: {
                                return "daa";
                            }
                            case 55: {
                                return "scf";
                            }
                        }
                    }
                    case 9: {
                        return "add " + this.registerPairToString(4) + ", " + this.registerPairToString(var1_1 >> 3);
                    }
                    case 10: {
                        switch (var1_1) {
                            case 10: {
                                return "ld a, (bc)";
                            }
                            case 26: {
                                return "ld a, (de)";
                            }
                            case 42: {
                                return "ld " + this.registerPairToString(4) + ", (" + Z80Instruction.toHexString(this.arg, 2) + ")";
                            }
                            case 58: {
                                return "ld a, (" + Z80Instruction.toHexString(this.arg, 2) + ")";
                            }
                        }
                    }
                    case 11: {
                        return "dec " + this.registerPairToString(var1_1 >> 3);
                    }
                    case 15: {
                        switch (var1_1) {
                            case 15: {
                                return "rrca";
                            }
                            case 31: {
                                return "rra";
                            }
                            case 47: {
                                return "cpl";
                            }
                            case 63: {
                                return "ccf";
                            }
                        }
                    }
                }
                break;
            }
            case 1: {
                if (var1_1 == 118) {
                    return "halt";
                }
                return "ld " + this.registerToString(var1_1 >> 3) + ", " + this.registerToString(var1_1);
            }
            case 2: {
                if (this.prefix > 0 && ((var1_1 & 7) == 4 || (var1_1 & 7) == 5) && (var1_1 >> 3 & 7) == 2) {
                    return String.valueOf(Z80Instruction.ALU_OPERATIONS[var1_1 >> 3 & 7]) + "a, " + this.registerToString(var1_1);
                }
                return String.valueOf(Z80Instruction.ALU_OPERATIONS[var1_1 >> 3 & 7]) + this.registerToString(var1_1);
            }
            case 3: {
                switch (var1_1 & 15) {
                    case 0: 
                    case 8: {
                        return "ret " + Z80Instruction.CONDITIONS[var1_1 >> 3 & 7];
                    }
                    case 1: 
                    case 5: {
                        if ((var1_1 & 240) == 240) {
                            return String.valueOf((var1_1 & 4) != 0 ? "push " : "pop ") + "af";
                        }
                        return String.valueOf((var1_1 & 4) != 0 ? "push " : "pop ") + this.registerPairToString(var1_1 >> 3);
                    }
                    case 2: 
                    case 10: {
                        return "jp " + Z80Instruction.CONDITIONS[var1_1 >> 3 & 7] + ", " + Z80Instruction.toHexString(this.arg, 2);
                    }
                    case 3: {
                        switch (var1_1) {
                            case 195: {
                                return "jp " + Z80Instruction.toHexString(this.arg, 2);
                            }
                            case 211: {
                                return "out (" + Z80Instruction.toHexString(this.arg, 1) + "), a";
                            }
                            case 227: {
                                return "ex (sp), " + this.registerPairToString(4);
                            }
                            case 243: {
                                return "di";
                            }
                        }
                    }
                    case 4: 
                    case 12: {
                        return "call " + Z80Instruction.CONDITIONS[var1_1 >> 3 & 7] + ", " + Z80Instruction.toHexString(this.arg, 2);
                    }
                    case 6: 
                    case 14: {
                        return String.valueOf(Z80Instruction.ALU_OPERATIONS[var1_1 >> 3 & 7]) + Z80Instruction.toHexString(this.arg, 1);
                    }
                    case 7: 
                    case 15: {
                        return "rst " + Z80Instruction.toHexString(var1_1 - 199, 1);
                    }
                    case 9: {
                        switch (var1_1) {
                            case 201: {
                                return "ret";
                            }
                            case 217: {
                                return "exx";
                            }
                            case 233: {
                                return "jp (" + this.registerPairToString(4) + ")";
                            }
                            case 249: {
                                return "ld sp, " + this.registerPairToString(4);
                            }
                        }
                    }
                    case 11: {
                        switch (var1_1) {
                            case 203: {
                                var1_1 = this.opCode & 255;
                                if (this.prefix <= 0) ** GOTO lbl132
                                switch (var1_1 >> 6) {
                                    case 0: {
                                        return String.valueOf(Z80Instruction.BIT_OPERATIONS[var1_1 >> 3 & 7]) + " " + this.registerToString(6) + ((var1_1 & 7) != 6 ? ", " + this.registerToString(var1_1) : "");
                                    }
                                    case 1: {
                                        return "bit " + (var1_1 >> 3 & 7) + ", " + this.registerToString(6);
                                    }
                                    case 2: {
                                        return "res " + (var1_1 >> 3 & 7) + ", " + this.registerToString(6) + ((var1_1 & 7) != 6 ? ", " + this.registerToString(var1_1) : "");
                                    }
                                    case 3: {
                                        return "set " + (var1_1 >> 3 & 7) + ", " + this.registerToString(6) + ((var1_1 & 7) != 6 ? ", " + this.registerToString(var1_1) : "");
                                    }
                                }
                                ** GOTO lbl141
lbl132:
                                // 1 sources

                                switch (var1_1 >> 6) {
                                    case 0: {
                                        return String.valueOf(Z80Instruction.BIT_OPERATIONS[var1_1 >> 3 & 7]) + " " + this.registerToString(var1_1);
                                    }
                                    case 1: {
                                        return "bit " + (var1_1 >> 3 & 7) + ", " + this.registerToString(var1_1);
                                    }
                                    case 2: {
                                        return "res " + (var1_1 >> 3 & 7) + ", " + this.registerToString(var1_1);
                                    }
                                    case 3: {
                                        return "set " + (var1_1 >> 3 & 7) + ", " + this.registerToString(var1_1);
                                    }
                                }
                            }
lbl141:
                            // 3 sources

                            case 219: {
                                return "in a, (" + Z80Instruction.toHexString(this.arg, 1) + ")";
                            }
                            case 235: {
                                return "ex de, hl";
                            }
                            case 251: {
                                return "ei";
                            }
                        }
                    }
                    case 13: {
                        switch (var1_1) {
                            case 205: {
                                return "call " + Z80Instruction.toHexString(this.arg, 2);
                            }
                            case 237: {
                                return this.instructionEDToString();
                            }
                        }
                    }
                }
            }
        }
        return String.valueOf(String.format("%02x", new Object[]{var1_1})) + (this.hasArg() != false ? String.format(" %02x", new Object[]{this.arg & 255}) : "");
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        this.string = this.buildString();
        return this.string;
    }
}

