/*
 * Decompiled with CFR 0.152.
 */
package assembler.rgbds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RGBDSMapFile {
    private final List<Bank> banks = new ArrayList<Bank>();

    private RGBDSMapFile(BufferedReader bufferedReader) throws IOException {
        int n = "SECTION: $".length();
        int n2 = "SLACK: $".length();
        int n3 = "EMPTY: $".length();
        int n4 = "TOTAL EMPTY: $".length();
        int n5 = " = ".length();
        Bank bank = null;
        Section section = null;
        String string = bufferedReader.readLine();
        while (string != null) {
            int n6 = string.length();
            if (n6 > 0) {
                int n7;
                int n8;
                int n9;
                int n10 = 0;
                while (n10 < n6 && string.charAt(n10) <= ' ') {
                    ++n10;
                }
                int n11 = n6 - n10;
                if (n10 <= 0) {
                    bank = null;
                    String[] stringArray = string.split(" ");
                    if (stringArray.length == 3) {
                        try {
                            bank = new Bank(stringArray[0], Integer.parseInt(stringArray[2].substring(1, stringArray[2].length() - 1)));
                            this.banks.add(bank);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (bank != null && n11 > n && string.charAt(n10 + 1) == 'E') {
                    section = null;
                    try {
                        int n12 = string.indexOf("[\"") + 2;
                        if (n12 - 2 >= 0 && (n9 = string.indexOf("\"]", n12 + 2)) >= 0 && (n8 = string.indexOf(" ($", n10 + n + 4) + 3) - 3 >= 0 && string.length() > n8 + 4) {
                            int n13 = Integer.parseInt(string.substring(n10 + n, n10 + n + 4), 16);
                            int n14 = Integer.parseInt(string.substring(n8, n8 + 4), 16);
                            section = new Section(string.substring(n12, n9), n13, n14);
                            bank.addSection(section);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (bank != null && n11 > n2 && string.charAt(n10 + 1) == 'L') {
                    try {
                        bank.setSlack(Integer.parseInt(string.substring(n10 + n2, n10 + n2 + 4), 16));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (bank != null && n11 > n4 && string.charAt(n10) == 'T') {
                    try {
                        bank.setSlack(Integer.parseInt(string.substring(n10 + n4, n10 + n4 + 4), 16));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (bank != null && n11 > n3 && string.charAt(n10) == 'E') {
                    int n15 = string.indexOf(" ($", n10 + n3 + 4) + 3;
                    if (n15 - 3 >= 0 && string.length() > n15 + 4) {
                        n9 = Integer.parseInt(string.substring(n10 + n3, n10 + n3 + 4), 16);
                        n8 = Integer.parseInt(string.substring(n15, n15 + 4), 16);
                    } else {
                        List<Section> list = bank.getSections();
                        Section section2 = !list.isEmpty() ? list.get(list.size() - 1) : null;
                        n9 = section2 != null ? section2.getOrg() + section2.getSize() : 0;
                        n8 = Integer.parseInt(string.substring(n10 + n2, n10 + n2 + 4), 16);
                    }
                    section = new Section(null, n9, n8);
                    bank.addSection(section);
                } else if (section != null && (n7 = string.indexOf(" = ")) >= 0) {
                    String string2 = string.substring(n10 + 1, n7);
                    String string3 = string.substring(n7 + n5);
                    try {
                        section.addSymbol(new Symbol(string3, Integer.parseInt(string2, 16)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public static RGBDSMapFile parse(File file) throws IOException {
        return new RGBDSMapFile(new BufferedReader(new FileReader(file)));
    }

    public List<Bank> getBanks() {
        return Collections.unmodifiableList(this.banks);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Bank bank : this.banks) {
            stringBuilder.append(bank).append('\n');
        }
        return stringBuilder.toString();
    }

    public static class Bank {
        private final String type;
        private final int bankNumber;
        private final List<Section> sections = new ArrayList<Section>();
        private int slack;

        public Bank(String string, int n) {
            this.type = string;
            this.bankNumber = n;
        }

        public String getType() {
            return this.type;
        }

        public int getBankNumber() {
            return this.bankNumber;
        }

        public List<Section> getSections() {
            return Collections.unmodifiableList(this.sections);
        }

        public void setSlack(int n) {
            this.slack = n;
        }

        public int getSlack() {
            return this.slack;
        }

        void addSection(Section section) {
            this.sections.add(section);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.type) + " bank #" + this.bankNumber + ":\n");
            for (Section section : this.sections) {
                stringBuilder.append(section);
            }
            stringBuilder.append("    SLACK: $" + String.format("%04x", this.slack) + " bytes\n");
            return stringBuilder.toString();
        }
    }

    public static class Section {
        private final String name;
        private final int org;
        private final int size;
        private final List<Symbol> symbols = new ArrayList<Symbol>();

        public Section(String string, int n, int n2) {
            this.name = string;
            this.org = n;
            this.size = n2;
        }

        public String getName() {
            return this.name;
        }

        public int getOrg() {
            return this.org;
        }

        public int getSize() {
            return this.size;
        }

        public List<Symbol> getSymbols() {
            return Collections.unmodifiableList(this.symbols);
        }

        void addSymbol(Symbol symbol) {
            this.symbols.add(symbol);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.name != null ? "  SECTION: $" : "    EMPTY: $") + String.format("%04x", this.org) + "-$" + String.format("%04x", this.org + this.size - 1) + " ($" + String.format("%04x", this.size) + " bytes)" + (this.name != null ? " [\"" + this.name + "\"]" : "") + "\n");
            for (Symbol symbol : this.symbols) {
                stringBuilder.append(symbol).append('\n');
            }
            return stringBuilder.toString();
        }
    }

    public static class Symbol {
        private final String name;
        private final int offset;

        public Symbol(String string, int n) {
            this.name = string;
            this.offset = n;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return "           $" + String.format("%04x", this.offset) + " = " + this.name;
        }
    }
}

