/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.PixelBuffer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;

public class CompatiblePixelBuffer
implements PixelBuffer {
    private final BufferedImage image;

    public CompatiblePixelBuffer(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    @Override
    public void fill(int n) {
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setColor(new Color(n));
        graphics2D.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        graphics2D.dispose();
    }

    @Override
    public int[] getPixels() {
        int[] nArray = new int[this.image.getHeight() * this.image.getWidth()];
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = dataBuffer.getElem(n);
            ++n;
        }
        return nArray;
    }

    @Override
    public int getPixel(int n) {
        int n2 = n / this.image.getWidth();
        int n3 = n % this.image.getWidth();
        return this.image.getRGB(n3, n2);
    }

    @Override
    public void setPixel(int n, int n2) {
        int n3 = n / this.image.getWidth();
        int n4 = n % this.image.getWidth();
        this.image.setRGB(n4, n3, n2);
    }

    @Override
    public void fill(int n, int n2, int n3) {
        int n4 = n / this.image.getWidth();
        int n5 = n % this.image.getWidth();
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setColor(new Color(n3));
        graphics2D.fillRect(n5, n4, n5 + (n2 - n), 1);
        graphics2D.dispose();
    }
}

