/*
 * Decompiled with CFR 0.152.
 */
package components.cartridge;

import components.cartridge.SMSCartridge;
import filesystem.FAT1632;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import patching.IPS;
import util.io.IOUtilities;

public class MasterEverdrive
extends SMSCartridge {
    private static final int CFG_REG = 65528;
    private static final int KEY_REG = 65529;
    private static final int BANK_CFG0_REG = 65530;
    private static final int BANK_CFG1_REG = 65531;
    private static final int BANK_CFG2_REG = 65532;
    private static final int SPI_PORT = 32512;
    private static final int STATE_PORT = 32513;
    private static final int FIFO_PORT = 32514;
    private static final int FIRM_VERSION = 32515;
    private static final int _BCFG_ROM_BANK = 1;
    private static final int _BCFG_RAM_BANK = 2;
    private static final int _BCFG_RAM_NROM = 3;
    private static final int _CFG_ROM_REGS_ON = 0;
    private static final int _CFG_SPI_SS = 1;
    private static final int _CFG_SPI_FULL_SPEED = 2;
    private static final int _CFG_CDM_MAP = 3;
    private static final int _CFG_AUTO_BUSY = 4;
    private static final int _CFG_ROM_WE_OFF = 5;
    private static final int _CFG_SMS_MODE = 6;
    private static final int _ST_SPI_BUSY = 7;
    private static final int _ST_ROM_BUSY = 6;
    private static final int _ST_FIFO_RD_BUSY = 5;
    private static final int _ST_FIFO_WR_BUSY = 4;
    private static final int _ST_DEV_GG = 3;
    private int regCFG;
    private int regBankCFG0;
    private int regBankCFG1;
    private int regBankCFG2;
    private int ramRegsMagicSequence;
    private int rom2eraseMagicSequence;
    private boolean rom2writeEnabled;
    private int writeCounter;
    private boolean romErased;
    private int[] font;
    private int[] about;
    private int spiCmd;
    private int spiArg;
    private int spiCrc;
    private int spiCounter;
    private int[] spiResponse = new int[0];
    private int spiResponseCounter;
    private int spiContinuousRead;
    private int spiWriteAddress;
    private boolean spiSingleBlockWrite;
    private int spiBytesToWrite;
    private int[] rom;
    private int[] flashedROM = new int[0];
    private int[] ram;
    private boolean ramWriteProtect;
    private boolean ramEnabled;
    private boolean romChanged;
    private boolean ramChanged;
    private HashSet<String> ramFileChanged = new HashSet();
    private final int MASK_BANK = 63;
    private int frame2ROMPageNumber;
    private int frame1ROMPageNumber;
    private int frame0ROMPageNumber;
    private int ramPageNumber;
    private boolean debug;
    private final boolean noSdCard;
    private final boolean deviceGG;
    private boolean spiBusy;
    private boolean fifoRdBusy;
    private boolean fifoWrBusy;
    private int fifoPort;
    private boolean romBusy;
    private int firmVersion = 58;
    private final Iterable<File> selectableFiles;
    private final Random random = new Random();
    private final FAT1632 fat = new FAT1632();
    private boolean fat32;

    public MasterEverdrive(String string, String string2, String string3, Iterable<File> iterable, IPS iPS, boolean bl, boolean bl2) throws IOException {
        super(string3, iPS);
        Object object;
        Object object2;
        this.noSdCard = bl;
        this.deviceGG = bl2;
        this.selectableFiles = iterable;
        this.fat.addFile(this.createFile(string3));
        ArrayList<FAT1632.File> arrayList = new ArrayList<FAT1632.File>();
        ArrayList<FAT1632.File> arrayList2 = new ArrayList<FAT1632.File>();
        int n = ((SMSCartridge)this).rom.length;
        boolean bl3 = true;
        if (new File(this.ramFilename).exists()) {
            FAT1632.File object32 = this.createRAMfile(this.ramFilename);
            arrayList2.add(object32);
            n += object32.getSize();
        }
        for (File file : iterable) {
            FAT1632.File file2;
            if (bl3) {
                bl3 = false;
                continue;
            }
            if (!file.exists() || n + (file2 = this.createFile(file.getAbsolutePath())).getSize() >= 0x500000) continue;
            object2 = MasterEverdrive.makeRamFilename(file.getAbsolutePath());
            if (new File((String)object2).exists()) {
                object = this.createRAMfile((String)object2);
                arrayList2.add((FAT1632.File)object);
                n += object.getSize();
            }
            arrayList.add(file2);
            n += file2.getSize();
        }
        if (!arrayList.isEmpty()) {
            this.fat.addFile(this.createDirectory("RECENT", arrayList.toArray(new FAT1632.File[arrayList.size()])));
        }
        if (!arrayList2.isEmpty()) {
            this.fat.addFile(this.createDirectory("SAVE", arrayList2.toArray(new FAT1632.File[arrayList2.size()])));
        }
        this.readROMfromFile();
        byte[] byArray = IOUtilities.toByteArray(new FileInputStream(string));
        this.rom = new int[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            this.rom[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        this.about = new int[256];
        n2 = 0;
        while (n2 < "11.05.2013".length()) {
            this.about[16 + n2] = "11.05.2013".charAt(n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < "Calindro".length()) {
            this.about[32 + n2] = "Calindro".charAt(n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < "https://www.emulicious.net".length()) {
            this.about[64 + n2] = "https://www.emulicious.net".charAt(n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < "TMR SEGA  ".length()) {
            this.rom[32752 + n2] = "TMR SEGA  ".charAt(n2);
            ++n2;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < 32752) {
            n2 += this.rom[n3];
            ++n3;
        }
        this.rom[32762] = n2 & 0xFF;
        this.rom[32763] = n2 >> 8 & 0xFF;
        n3 = 32764;
        while (n3 < 32768) {
            this.rom[n3] = 0;
            ++n3;
        }
        this.rom[Short.MAX_VALUE] = 76;
        if (string2 != null) {
            byte[] byArray2 = IOUtilities.toByteArray(new FileInputStream(string2));
            this.font = new int[byArray2.length];
            n3 = 0;
            while (n3 < byArray2.length) {
                this.font[n3] = byArray2[n3] & 0xFF;
                ++n3;
            }
        } else {
            this.font = new int[1024];
            n3 = 0;
            object2 = new BufferedImage(8, 8, 2);
            object = ((BufferedImage)object2).createGraphics();
            ((Graphics)object).setFont(((Graphics)object).getFont().deriveFont(9.0f));
            int n4 = 0;
            while (n4 < 128) {
                String string4 = Character.toString((char)(32 + n4 >= 97 ? 32 + n4 & 0x5F : 32 + n4));
                Composite composite = ((Graphics2D)object).getComposite();
                ((Graphics2D)object).setComposite(AlphaComposite.Clear);
                ((Graphics)object).fillRect(0, 0, ((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight());
                ((Graphics2D)object).setComposite(composite);
                FontMetrics fontMetrics = ((Graphics)object).getFontMetrics();
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string4, (Graphics)object);
                ((Graphics2D)object).drawString(string4, (8.0f - (float)rectangle2D.getWidth()) / 2.0f, 7.0f);
                int n5 = 0;
                while (n5 < 8) {
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < 8) {
                        n6 <<= 1;
                        if (((BufferedImage)object2).getRGB(n7, n5) < 0) {
                            n6 |= 1;
                        }
                        ++n7;
                    }
                    this.font[n3++] = n6;
                    ++n5;
                }
                ++n4;
            }
            ((Graphics)object).dispose();
        }
        if (this.ram == null) {
            this.ram = new int[32768];
        }
        this.enableShutdownHook();
    }

    private FAT1632.File createFile(final String string) throws IOException {
        final int n = string.toLowerCase().indexOf(".zip");
        final int n2 = string.lastIndexOf(File.separatorChar, Math.min(string.length() - 1, n & Integer.MAX_VALUE)) + 1;
        if (n >= 0) {
            FAT1632 fAT1632 = this.fat;
            fAT1632.getClass();
            return new FAT1632.AbstractDirectory(fAT1632){
                private final FAT1632.File[] files;
                {
                    super(fAT1632);
                    ZipFile zipFile = new ZipFile(string2.substring(0, n3 + 4));
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    HashMap<String, ArrayList<FAT1632.File>> hashMap = new HashMap<String, ArrayList<FAT1632.File>>();
                    ArrayList<FAT1632.File> arrayList = new ArrayList<FAT1632.File>();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry object = enumeration.nextElement();
                        if (object.isDirectory()) continue;
                        File file = new File(object.getName());
                        if (file.getParent() != null) {
                            ArrayList<FAT1632.File> arrayList2 = (ArrayList<FAT1632.File>)hashMap.get(file.getParent());
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<FAT1632.File>();
                                hashMap.put(file.getParent(), arrayList2);
                            }
                            arrayList2.add(MasterEverdrive.this.createFile(file.getName(), zipFile.getInputStream(object)));
                            continue;
                        }
                        arrayList.add(MasterEverdrive.this.createFile(object.getName(), zipFile.getInputStream(object)));
                    }
                    zipFile.close();
                    for (Map.Entry entry : hashMap.entrySet()) {
                        arrayList.add(MasterEverdrive.this.createDirectory((String)entry.getKey(), ((List)entry.getValue()).toArray(new FAT1632.File[((List)entry.getValue()).size()])));
                    }
                    this.files = arrayList.toArray(new FAT1632.File[arrayList.size()]);
                }

                @Override
                public String getName() {
                    return string.substring(n2, n);
                }

                @Override
                public FAT1632.File[] listFiles() {
                    return this.files;
                }
            };
        }
        return this.createFile(new File(string).getName(), new FileInputStream(string));
    }

    private FAT1632.File createFile(final String string, InputStream inputStream) throws IOException {
        FAT1632 fAT1632 = this.fat;
        fAT1632.getClass();
        return new FAT1632.AbstractFile(fAT1632, inputStream){
            private final int[] bytes;
            {
                super(fAT1632);
                byte[] byArray = IOUtilities.toByteArray(inputStream);
                this.bytes = new int[byArray.length];
                int n = 0;
                while (n < this.bytes.length) {
                    this.bytes[n] = byArray[n] & 0xFF;
                    ++n;
                }
            }

            @Override
            public String getName() {
                return string;
            }

            @Override
            public int getSize() {
                return this.bytes.length;
            }

            @Override
            public int readByte(int n) {
                return n < this.bytes.length ? this.bytes[n] : 255;
            }

            @Override
            public void writeByte(int n, int n2) {
            }
        };
    }

    private FAT1632.File createRAMfile(final String string) {
        int n = string.lastIndexOf(File.separatorChar) + 1;
        FAT1632 fAT1632 = this.fat;
        fAT1632.getClass();
        return new FAT1632.AbstractFile(fAT1632, n){
            private final String name;
            private final int[] bytes;
            {
                super(fAT1632);
                this.name = string2.substring(n).replace(".sav", ".srm");
                int[] nArray = new int[32768];
                try {
                    byte[] byArray = IOUtilities.toByteArray(new FileInputStream(string2));
                    nArray = new int[byArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length && n2 < byArray.length) {
                        nArray[n2] = byArray[n2] & 0xFF;
                        ++n2;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.bytes = nArray;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public int getSize() {
                return this.bytes.length;
            }

            @Override
            public int readByte(int n) {
                return this.bytes[n];
            }

            @Override
            public void writeByte(int n, int n2) {
                this.bytes[n] = n2;
                MasterEverdrive.this.ramFileChanged.add(string);
            }
        };
    }

    private FAT1632.File createDirectory(final String string, FAT1632.File[] fileArray) {
        FAT1632 fAT1632 = this.fat;
        fAT1632.getClass();
        FAT1632.AbstractDirectory abstractDirectory = new FAT1632.AbstractDirectory(fAT1632){

            @Override
            public String getName() {
                return string;
            }
        };
        FAT1632.File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            FAT1632.File file = fileArray2[n2];
            abstractDirectory.addFile(file);
            ++n2;
        }
        return abstractDirectory;
    }

    @Override
    public String getMapperName() {
        if (!(this.isBank0rom() || this.isBank1rom() || this.isBank2rom() || this.isBank0nrom() || this.isBank1nrom() || this.isBank2nrom())) {
            return "Everdrive";
        }
        return this.isCDMmap() ? "ED Codemasters" : "ED SEGA";
    }

    @Override
    public boolean hasSRAM() {
        return this.ram != null && this.ram.length > 0;
    }

    @Override
    public int[] getSRAM() {
        return this.ram;
    }

    @Override
    public void reset() {
        this.writeROMtoFile();
        this.writeRAMtoFile();
        this.ramEnabled = false;
        this.ramWriteProtect = false;
        this.ramPageNumber = 0;
        this.regBankCFG0 = 0;
        this.regBankCFG1 = 0;
        this.regBankCFG2 = 0;
        this.ramRegsMagicSequence = 0;
        this.spiResponse = new int[0];
        this.spiContinuousRead = -1;
        this.spiWriteAddress = -1;
        this.fat32 = false;
        if (this.fat != null) {
            this.fat.setFAT16(false);
        }
    }

    @Override
    public int readByte(int n, int n2) {
        if (this.ramRegsMagicSequence >= 3 && n2 != 0) {
            switch (n) {
                case 32512: {
                    return this.readSPIport();
                }
                case 32513: {
                    return this.readStatePort();
                }
                case 32514: {
                    return this.readFifoPort();
                }
                case 32515: {
                    return this.readFirmVersion();
                }
            }
        }
        if (n < 16384) {
            if (this.isBank0rom()) {
                if (n >= 1024 && !this.isCDMmap()) {
                    return this.flashedROM[n];
                }
                if ((this.frame0ROMPageNumber * 16384 | n) >= this.flashedROM.length) {
                    return this.random.nextInt(256);
                }
                return this.flashedROM[this.frame0ROMPageNumber * 16384 | n];
            }
            if (this.isBank0nrom()) {
                if (this.isBank0ram()) {
                    return this.ram[0x4000 | n];
                }
                return this.ram[n];
            }
        } else if (n < 32768) {
            if (this.isBank1rom()) {
                if ((this.frame1ROMPageNumber * 16384 | n & 0x3FFF) >= this.flashedROM.length) {
                    return this.random.nextInt(256);
                }
                return this.flashedROM[this.frame1ROMPageNumber * 16384 | n & 0x3FFF];
            }
            if (this.isBank1nrom()) {
                if (this.isBank1ram()) {
                    return this.ram[0x4000 | n & 0x3FFF];
                }
                return this.ram[n & 0x3FFF];
            }
        } else if (n < 49152) {
            if (this.isBank2rom()) {
                if (this.ramEnabled) {
                    return this.ram[16384 * this.ramPageNumber | n & 0x3FFF];
                }
                if ((this.frame2ROMPageNumber * 16384 | n & 0x3FFF) >= this.flashedROM.length) {
                    return this.random.nextInt(256);
                }
                return this.flashedROM[this.frame2ROMPageNumber * 16384 | n & 0x3FFF];
            }
            if (this.isBank2nrom()) {
                if (this.isBank2ram()) {
                    return this.ram[0x4000 | n & 0x3FFF];
                }
                return this.ram[n & 0x3FFF];
            }
        }
        if (n >= 48128) {
            if (this.frame2ROMPageNumber == 0) {
                return this.font[n & 0x3FF];
            }
            if (this.frame2ROMPageNumber == 3) {
                return this.about[n & 0xFF];
            }
        }
        if (this.ramRegsMagicSequence < 3) {
            return n < this.rom.length ? this.rom[n] : 255;
        }
        if (n < this.rom.length) {
            return this.rom[n];
        }
        if (this.debug) {
            System.out.println("Read from: " + Integer.toHexString(n));
        }
        return 255;
    }

    private void writeSPIport(int n) {
        if (n == 255) {
            if (this.spiResponseCounter < this.spiResponse.length) {
                ++this.spiResponseCounter;
            } else if (this.spiContinuousRead >= 0) {
                this.spiContinuousRead += 512;
                this.spiResponse = this.readDataBlock(0, this.spiContinuousRead, 512);
                this.spiResponseCounter = 1;
            }
        }
        if (this.spiWriteAddress >= 0) {
            switch (this.spiBytesToWrite--) {
                case 0: {
                    this.spiResponse = MasterEverdrive.createDataResponse(2);
                    this.spiResponseCounter = 0;
                    if (this.spiSingleBlockWrite) {
                        this.spiWriteAddress = -1;
                        break;
                    }
                    this.spiBytesToWrite = 515;
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 515: {
                    if ((n & 0xFC) != 252) {
                        System.out.println("WARNING: Invalid data token received.");
                    }
                    switch (n & 3) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.spiWriteAddress = -1;
                            this.spiResponse = MasterEverdrive.createDataResponse(2);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            ++this.spiBytesToWrite;
                        }
                    }
                    break;
                }
                default: {
                    this.writeFAT(this.spiWriteAddress++, n);
                }
            }
            return;
        }
        if (this.debug && (n != 255 || this.spiCounter > 0)) {
            System.out.println("writeSPI: " + Integer.toHexString(n));
        }
        if (this.spiCounter > 1) {
            this.spiArg <<= 8;
            this.spiArg |= n;
        }
        if (--this.spiCounter <= 0) {
            if (this.spiCounter == -2) {
                this.handleSPIcommand();
                this.spiArg = 0;
            } else if (this.spiCounter == 0) {
                this.spiCrc = n;
            } else if ((n & 0xC0) == 64) {
                this.spiCmd = n & 0x3F;
                this.spiArg = 0;
                this.spiCounter = 5;
            }
        }
    }

    private void handleSPIcommand() {
        if (this.debug) {
            System.out.println("HANDLING SPI CMD" + this.spiCmd + " with ARG " + Integer.toHexString(this.spiArg));
        }
        if (this.noSdCard) {
            this.spiResponse = new int[0];
            return;
        }
        switch (this.spiCmd) {
            case 0: {
                this.spiResponse = MasterEverdrive.createResponseR1(this.spiCrc == 149 ? 1 : 8);
                break;
            }
            case 8: {
                this.spiResponse = MasterEverdrive.createResponseR7(1);
                break;
            }
            case 12: {
                this.spiContinuousRead = -1;
                this.spiResponse = MasterEverdrive.createResponseR1(1);
                break;
            }
            case 17: {
                this.spiContinuousRead = -1;
                if (!this.fat32) {
                    this.fat.setFAT16(true);
                }
                this.spiResponse = this.readDataBlock(0, this.spiArg, 512);
                break;
            }
            case 18: {
                this.fat32 = true;
                this.spiContinuousRead = this.spiArg;
                this.spiResponse = this.readDataBlock(0, this.spiContinuousRead, 512);
                break;
            }
            case 24: {
                this.spiWriteAddress = this.spiArg;
                this.spiResponse = MasterEverdrive.createResponseR1(0);
                this.spiBytesToWrite = 515;
                this.spiSingleBlockWrite = true;
                break;
            }
            case 25: {
                this.spiWriteAddress = this.spiArg;
                this.spiResponse = MasterEverdrive.createResponseR1(0);
                this.spiBytesToWrite = 515;
                this.spiSingleBlockWrite = false;
                break;
            }
            case 55: {
                this.spiResponse = MasterEverdrive.createResponseR1(1);
                break;
            }
            case 58: {
                this.spiResponse = MasterEverdrive.createResponseR3(0);
                break;
            }
            default: {
                this.spiResponse = MasterEverdrive.createResponseR1(0);
            }
        }
        this.spiResponseCounter = 0;
    }

    private static int[] createResponseR1(int n) {
        return new int[]{n};
    }

    private static int[] createResponseR3(int n) {
        int[] nArray = new int[5];
        nArray[0] = n;
        nArray[1] = 128;
        nArray[2] = 255;
        nArray[3] = 128;
        return nArray;
    }

    private static int[] createResponseR7(int n) {
        int[] nArray = new int[5];
        nArray[0] = n;
        nArray[3] = 1;
        nArray[4] = 170;
        return nArray;
    }

    private static int[] createDataResponse(int n) {
        return new int[]{0xE0 | (n & 7) << 1 | 1, 255};
    }

    private int[] readDataBlock(int n, int n2, int n3) {
        int[] nArray = new int[2 + n3 + 2];
        nArray[0] = n;
        nArray[1] = 254;
        int n4 = 0;
        while (n4 < n3) {
            nArray[2 + n4] = this.readFAT(n2 + n4);
            ++n4;
        }
        return nArray;
    }

    private void writeFAT(int n, int n2) {
        this.fat.writeByte(n, n2);
    }

    private int readFAT(int n) {
        return this.fat.readByte(n);
    }

    private int readSPIport() {
        int n;
        int n2 = n = this.spiResponseCounter < this.spiResponse.length ? this.spiResponse[this.spiResponseCounter] : 255;
        if (this.debug && n > 0) {
            System.out.println("readSPI: " + Integer.toHexString(n));
        }
        return n;
    }

    private boolean isSPIbusy() {
        return this.spiBusy;
    }

    private boolean isROMbusy() {
        return this.romBusy;
    }

    private boolean isFifoRdBusy() {
        return this.fifoRdBusy;
    }

    private boolean isFifoWrBusy() {
        return this.fifoWrBusy;
    }

    private boolean isDeviceGG() {
        return this.deviceGG;
    }

    private int readStatePort() {
        int n = 0;
        if (this.isSPIbusy()) {
            n |= 0x80;
        }
        if (this.isROMbusy()) {
            n |= 0x40;
        }
        if (this.isFifoRdBusy()) {
            n |= 0x20;
        }
        if (this.isFifoWrBusy()) {
            n |= 0x10;
        }
        if (this.isDeviceGG()) {
            n |= 8;
        }
        return n;
    }

    private int readFifoPort() {
        return this.fifoPort;
    }

    private int readFirmVersion() {
        return this.firmVersion;
    }

    private boolean isCDMmap() {
        return (this.regCFG & 8) != 0;
    }

    private boolean isROMregsOn() {
        return (this.regCFG & 1) != 0;
    }

    private boolean isROMwriteEnableOff() {
        return (this.regCFG & 0x20) != 0;
    }

    @Override
    public boolean isSmsMode() {
        return (this.regCFG & 0x40) != 0;
    }

    private boolean isBank0rom() {
        return (this.regBankCFG0 & 2) != 0;
    }

    private boolean isBank1rom() {
        return (this.regBankCFG1 & 2) != 0;
    }

    private boolean isBank2rom() {
        return (this.regBankCFG2 & 2) != 0;
    }

    private boolean isBank0ram() {
        return (this.regBankCFG0 & 4) != 0;
    }

    private boolean isBank1ram() {
        return (this.regBankCFG1 & 4) != 0;
    }

    private boolean isBank2ram() {
        return (this.regBankCFG2 & 4) != 0;
    }

    private boolean isBank0nrom() {
        return (this.regBankCFG0 & 8) != 0;
    }

    private boolean isBank1nrom() {
        return (this.regBankCFG1 & 8) != 0;
    }

    private boolean isBank2nrom() {
        return (this.regBankCFG2 & 8) != 0;
    }

    @Override
    public void processWrite(int n, int n2, int n3) {
        block0 : switch (n) {
            case 32512: {
                this.writeSPIport(n2);
                break;
            }
            case 65528: {
                this.regCFG = n2;
                if (this.debug) {
                    System.out.print("CFG:");
                    if (this.isROMregsOn()) {
                        System.out.print(" ROM_REGS_ON");
                    }
                    if ((n2 & 2) != 0) {
                        System.out.print(" SPI_SLAVE_SELECT");
                    }
                    if ((n2 & 4) != 0) {
                        System.out.print(" SPI_FULL_SPEED");
                    }
                    if (this.isCDMmap()) {
                        System.out.print(" CDM_MAP");
                    }
                    if ((n2 & 0x10) != 0) {
                        System.out.print(" AUTO_BUSY");
                    }
                    if ((n2 & 0x20) != 0) {
                        System.out.print(" ROM_WE_OFF");
                    }
                    if (this.isSmsMode()) {
                        System.out.print(" SMS_MODE");
                    }
                    System.out.println();
                }
                if (!this.isCDMmap()) break;
                System.out.println("Codemasters mapper enabled");
                break;
            }
            case 65529: {
                switch (this.ramRegsMagicSequence) {
                    case 0: {
                        if (n2 == 82) {
                            ++this.ramRegsMagicSequence;
                            break;
                        }
                        if (this.debug) {
                            System.out.println("Magic sequence for RAM_REGS_ON interrupted at " + this.ramRegsMagicSequence + " with " + Integer.toHexString(n2));
                        }
                        this.ramRegsMagicSequence = 0;
                        break;
                    }
                    case 1: {
                        if (n2 == 69) {
                            ++this.ramRegsMagicSequence;
                            break;
                        }
                        if (this.debug) {
                            System.out.println("Magic sequence for RAM_REGS_ON interrupted at " + this.ramRegsMagicSequence + " with " + Integer.toHexString(n2));
                        }
                        this.ramRegsMagicSequence = 0;
                        break;
                    }
                    case 2: {
                        if (n2 == 78) {
                            ++this.ramRegsMagicSequence;
                            if (!this.debug) break;
                            System.out.println("RAM_REGS_ON (magic sequence)");
                            break;
                        }
                        if (this.debug) {
                            System.out.println("Magic sequence for RAM_REGS_ON interrupted at " + this.ramRegsMagicSequence + " with " + Integer.toHexString(n2));
                        }
                        this.ramRegsMagicSequence = 0;
                        break;
                    }
                    case 3: {
                        this.ramRegsMagicSequence = 0;
                    }
                }
                if (this.ramRegsMagicSequence > 0) break;
                this.spiResponse = new int[0];
                this.spiContinuousRead = -1;
                this.spiWriteAddress = -1;
                break;
            }
            case 65530: {
                if (this.ramRegsMagicSequence >= 3) {
                    this.regBankCFG0 = n2;
                    if (!this.debug) break;
                    System.out.print("BANK_CFG0_REG:");
                    if (this.isBank0rom()) {
                        System.out.print(" ROM");
                    }
                    if (this.isBank0ram()) {
                        System.out.print(" RAM");
                    }
                    if (this.isBank0nrom()) {
                        System.out.print(" NROM");
                    }
                    System.out.println();
                    break;
                }
            }
            case 65531: {
                if (this.ramRegsMagicSequence >= 3) {
                    this.regBankCFG1 = n2;
                    if (!this.debug) break;
                    System.out.print("BANK_CFG1_REG:");
                    if (this.isBank1rom()) {
                        System.out.print(" ROM");
                    }
                    if (this.isBank1ram()) {
                        System.out.print(" RAM");
                    }
                    if (this.isBank1nrom()) {
                        System.out.print(" NROM");
                    }
                    System.out.println();
                    break;
                }
            }
            case 65532: {
                if (this.ramRegsMagicSequence >= 3) {
                    this.regBankCFG2 = n2;
                    if (!this.debug) break;
                    System.out.print("BANK_CFG2_REG:");
                    if (this.isBank2rom()) {
                        System.out.print(" ROM");
                    }
                    if (this.isBank2ram()) {
                        System.out.print(" RAM");
                    }
                    if (this.isBank2nrom()) {
                        System.out.print(" NROM");
                    }
                    System.out.println();
                    break;
                }
            }
            default: {
                if (!this.isROMwriteEnableOff()) {
                    block14 : switch (n / 16384) {
                        case 2: {
                            if (this.rom2writeEnabled && (this.frame2ROMPageNumber * 16384 | n & 0x3FFF) < this.flashedROM.length) {
                                if ((this.writeCounter++ & 0x1FF) == 0 && n == 32768 && n2 == 144) {
                                    this.rom2writeEnabled = false;
                                } else {
                                    if (this.flashedROM[this.frame2ROMPageNumber * 16384 | n & 0x3FFF] != n2) {
                                        this.romChanged = true;
                                    }
                                    this.flashedROM[this.frame2ROMPageNumber * 16384 | n & 0x3FFF] = n2;
                                }
                            }
                            switch (n & 0x3FFF) {
                                case 0: {
                                    if (this.rom2eraseMagicSequence == 5 && n2 == 48) {
                                        ++this.rom2eraseMagicSequence;
                                        break block14;
                                    }
                                    if (this.debug && this.rom2eraseMagicSequence > 0) {
                                        System.out.println("Magic sequence for erase of slot 2 interrupted at " + this.rom2eraseMagicSequence + " with " + Integer.toHexString(n2));
                                    }
                                    this.rom2eraseMagicSequence = 0;
                                    break block14;
                                }
                                case 1365: {
                                    if (n2 == 85 && (this.rom2eraseMagicSequence == 1 || this.rom2eraseMagicSequence == 4)) {
                                        ++this.rom2eraseMagicSequence;
                                        break block14;
                                    }
                                    if (this.debug && this.rom2eraseMagicSequence > 0) {
                                        System.out.println("Magic sequence for erase of slot 2 interrupted at " + this.rom2eraseMagicSequence + " with " + Integer.toHexString(n2));
                                    }
                                    this.rom2eraseMagicSequence = 0;
                                    break block14;
                                }
                                case 2730: {
                                    if (n2 == 170 && (this.rom2eraseMagicSequence == 0 || this.rom2eraseMagicSequence == 3) || n2 == 128 && this.rom2eraseMagicSequence == 2) {
                                        ++this.rom2eraseMagicSequence;
                                        break block14;
                                    }
                                    if (n2 == 32 && this.rom2eraseMagicSequence == 2) {
                                        this.rom2writeEnabled = true;
                                        this.writeCounter = 0;
                                    } else if (this.debug && this.rom2eraseMagicSequence > 0) {
                                        System.out.println("Magic sequence for erase of slot 2 interrupted at " + this.rom2eraseMagicSequence + " with " + Integer.toHexString(n2));
                                    }
                                    if (n2 == 170) {
                                        this.rom2eraseMagicSequence = 1;
                                        break block14;
                                    }
                                    this.rom2eraseMagicSequence = 0;
                                    break block14;
                                }
                                case 8192: {
                                    if (this.rom2eraseMagicSequence == 6 && n2 == 48) {
                                        --this.rom2eraseMagicSequence;
                                        if (this.debug) {
                                            System.out.println("Erasing bank " + this.frame2ROMPageNumber);
                                        }
                                        if (!this.romErased) {
                                            Arrays.fill(this.flashedROM, 0);
                                            this.romChanged = true;
                                            this.romErased = true;
                                        }
                                        if (this.frame2ROMPageNumber < this.flashedROM.length / 16384) {
                                            Arrays.fill(this.flashedROM, this.frame2ROMPageNumber * 16384, (this.frame2ROMPageNumber + 1) * 16384, 0);
                                            break block14;
                                        }
                                    } else {
                                        if (this.debug && this.rom2eraseMagicSequence > 0) {
                                            System.out.println("Magic sequence for erase of slot 2 interrupted at " + this.rom2eraseMagicSequence + " with " + Integer.toHexString(n2));
                                        }
                                        this.rom2eraseMagicSequence = 0;
                                    }
                                }
                            }
                        }
                    }
                }
                if (n < 16384) {
                    if (this.isBank0nrom()) {
                        if (this.isBank0ram()) {
                            if (this.ram[0x4000 | n] != n2) {
                                this.ramChanged = true;
                            }
                            this.ram[0x4000 | n] = n2;
                        } else {
                            if (this.ram[n] != n2) {
                                this.ramChanged = true;
                            }
                            this.ram[n] = n2;
                        }
                    }
                } else if (n < 32768) {
                    if (this.isBank1nrom()) {
                        if (this.isBank1ram()) {
                            if (this.ram[0x4000 | n & 0x3FFF] != n2) {
                                this.ramChanged = true;
                            }
                            this.ram[0x4000 | n & 0x3FFF] = n2;
                        } else {
                            if (this.ram[n & 0x3FFF] != n2) {
                                this.ramChanged = true;
                            }
                            this.ram[n & 0x3FFF] = n2;
                        }
                    }
                } else if (n < 49152 && this.isBank2nrom()) {
                    if (this.isBank2ram()) {
                        if (this.ram[0x4000 | n & 0x3FFF] != n2) {
                            this.ramChanged = true;
                        }
                        this.ram[0x4000 | n & 0x3FFF] = n2;
                    } else {
                        if (this.ram[n & 0x3FFF] != n2) {
                            this.ramChanged = true;
                        }
                        this.ram[n & 0x3FFF] = n2;
                    }
                }
                if (this.ramEnabled && !this.ramWriteProtect && n >= 32768 && n < 49152) {
                    if (this.ram[this.ramPageNumber * 16384 | n & 0x3FFF] != n2) {
                        this.ramChanged = true;
                    }
                    this.ram[this.ramPageNumber * 16384 | n & 0x3FFF] = n2;
                }
                if (this.isCDMmap()) {
                    if (n > 32768 || (n & 0x3FFF) != 0) break;
                    switch (n) {
                        case 0: {
                            this.frame0ROMPageNumber = n2 & 0x3F;
                            break;
                        }
                        case 16384: {
                            if (this.frame1ROMPageNumber == n2) {
                                return;
                            }
                            if ((n2 & 0x80) != 0) {
                                System.out.println("Map external RAM to upper 8k of frame 2");
                            }
                            this.frame1ROMPageNumber = n2 & 0x3F;
                            break;
                        }
                        case 32768: {
                            if (this.frame2ROMPageNumber == (n2 & 0x3F)) {
                                return;
                            }
                            this.frame2ROMPageNumber = n2 & 0x3F;
                        }
                    }
                    break;
                }
                if (n < 65532) break;
                switch (n & 3) {
                    case 0: {
                        long l;
                        if (this.ramEnabled && (n2 & 8) == 0 && this.lastWriteMillis - (l = System.currentTimeMillis()) >= 5000L) {
                            this.writeRAMtoFile();
                            this.lastWriteMillis = l;
                        }
                        this.ramWriteProtect = (n2 & 0x10) != 0;
                        boolean bl = this.ramEnabled = (n2 & 8) != 0;
                        if (this.ramEnabled) {
                            this.enableShutdownHook();
                        }
                        this.ramPageNumber = (n2 & 4) >> 2;
                        if ((n2 & 0xFFFFFF73) == 0) break block0;
                        System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
                        break block0;
                    }
                    case 1: {
                        this.frame0ROMPageNumber = n2 & 0x3F;
                        break block0;
                    }
                    case 2: {
                        this.frame1ROMPageNumber = n2 & 0x3F;
                        break block0;
                    }
                    case 3: {
                        this.frame2ROMPageNumber = n2 & 0x3F;
                        break block0;
                    }
                    default: {
                        System.out.println(String.valueOf(Integer.toHexString(n)) + " <-- " + Integer.toHexString(n2));
                    }
                }
            }
        }
    }

    @Override
    public boolean isROMaddress(int n) {
        if (n < 16384) {
            return this.isBank0rom();
        }
        if (n < 32768) {
            return this.isBank1rom();
        }
        if (n < 49152) {
            return this.isBank2rom() && !this.ramEnabled;
        }
        return false;
    }

    @Override
    public int mapAddress(int n) {
        if (n < 16384) {
            if (this.isBank0rom()) {
                if (n >= 1024 && !this.isCDMmap()) {
                    return n;
                }
                return this.frame0ROMPageNumber * 16384 | n;
            }
        } else if (n < 32768) {
            if (this.isBank1rom()) {
                return this.frame1ROMPageNumber * 16384 | n & 0x3FFF;
            }
        } else if (n < 49152 && this.isBank2rom()) {
            if (this.ramEnabled) {
                return 16384 * this.ramPageNumber | n & 0x3FFF;
            }
            return this.frame2ROMPageNumber * 16384 | n & 0x3FFF;
        }
        return -2;
    }

    @Override
    public void setBank0(int n) {
        this.frame0ROMPageNumber = n;
    }

    @Override
    public void setBank1(int n) {
        this.frame1ROMPageNumber = n;
    }

    @Override
    public void setBank2(int n) {
        this.frame2ROMPageNumber = n;
    }

    @Override
    public int getBank0() {
        return this.frame0ROMPageNumber;
    }

    @Override
    public int getBank1() {
        return this.frame1ROMPageNumber;
    }

    @Override
    public int getBank2() {
        return this.frame2ROMPageNumber;
    }

    @Override
    public void shutdown() {
        this.writeRAMtoFile();
        this.writeROMtoFile();
        FAT1632.File file = this.fat.findFile("SAVE");
        if (file != null) {
            FAT1632.File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                FAT1632.File file2 = fileArray[n2];
                String string = file2.getName();
                for (File file3 : this.selectableFiles) {
                    if (!file3.getName().startsWith(string.substring(0, string.length() - 4))) continue;
                    string = MasterEverdrive.makeRamFilename(file3.getAbsolutePath());
                    break;
                }
                this.writeSavedRAMtoFile(string, file2);
                ++n2;
            }
        }
    }

    private void writeSavedRAMtoFile(String string, FAT1632.File file) {
        if (file instanceof FAT1632.AbstractFile && !this.ramFileChanged.contains(string)) {
            return;
        }
        int[] nArray = new int[file.getSize()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = file.readByte(n);
            ++n;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = new byte[nArray.length];
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = (byte)nArray[n2];
                ++n2;
            }
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.ramFileChanged.remove(string);
    }

    @Override
    protected boolean readRAMfromFile() {
        try {
            byte[] byArray = IOUtilities.toByteArray(new FileInputStream(this.deviceGG ? "EverdriveRAM.gg" : "EverdriveRAM.sms"));
            this.ram = new int[32768];
            int n = 0;
            while (n < this.ram.length && n < byArray.length) {
                this.ram[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    @Override
    protected void writeRAMtoFile() {
        if (!this.ramChanged) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.deviceGG ? "EverdriveRAM.gg" : "EverdriveRAM.sms");
            byte[] byArray = new byte[this.ram.length];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)this.ram[n];
                ++n;
            }
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.ramChanged = false;
    }

    @Override
    public boolean applyPatch(IPS iPS, boolean bl) {
        super.applyPatch(iPS, bl);
        return false;
    }

    private boolean readROMfromFile() {
        try {
            byte[] byArray = IOUtilities.toByteArray(new FileInputStream(this.deviceGG ? "EverdriveROM.gg" : "EverdriveROM.sms"));
            if (byArray.length > this.flashedROM.length) {
                this.flashedROM = new int[byArray.length];
            }
            int n = 0;
            while (n < this.flashedROM.length && n < byArray.length) {
                this.flashedROM[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
        catch (IOException iOException) {
            if (!(iOException instanceof FileNotFoundException)) {
                iOException.printStackTrace();
            }
            this.flashedROM = new int[((SMSCartridge)this).rom.length];
            System.arraycopy(((SMSCartridge)this).rom, 0, this.flashedROM, 0, ((SMSCartridge)this).rom.length);
            return false;
        }
        return true;
    }

    private void writeROMtoFile() {
        if (!this.romChanged) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.deviceGG ? "EverdriveROM.gg" : "EverdriveROM.sms");
            byte[] byArray = new byte[this.flashedROM.length];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)this.flashedROM[n];
                ++n;
            }
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.romChanged = false;
    }
}

