/*
 * Decompiled with CFR 0.152.
 */
package components.video;

import components.cpu.LR35902;
import components.video.GBLCDController;
import java.util.Random;
import system.GameBoyColor;

public class GBCLCDController
extends GBLCDController {
    public static final int PALETTE_WRITE = 0x110008;
    public static final int PALETTE_WRITTEN = 0x110009;
    private int regBGPI;
    private int regOBPI;
    private final long[] bgp = new long[8];
    private final long[] obp = new long[8];
    private int regVBK;
    private int regOPRI;
    private int regHDMA1;
    private int regHDMA2;
    private int regHDMA3;
    private int regHDMA4;
    private int regHDMA5 = 255;
    private int mode;
    private boolean inaccessibleVRAMduringDMAsent;

    public GBCLCDController() {
        this.vram = new int[16384];
    }

    @Override
    public void reset() {
        super.reset();
        this.fireOutputAvailable(81, 255);
        this.fireOutputAvailable(82, 255);
        this.fireOutputAvailable(83, 255);
        this.fireOutputAvailable(84, 255);
        this.regHDMA5 = 255;
        this.fireOutputAvailable(108, 254);
        this.regOPRI = 0;
        this.mode = 0;
        this.fireOutputAvailable(79, 254);
        this.regVBK = 0;
        int n = 0;
        while (n < this.bgp.length) {
            this.setBGP(n, -1L);
            ++n;
        }
        Random random = new Random();
        int n2 = 0;
        while (n2 < this.obp.length) {
            this.setOBP(n2, random.nextLong());
            ++n2;
        }
    }

    @Override
    public boolean isBGDisplayEnabled(int n) {
        return super.isBGDisplayEnabled(n) || (this.mode & 4) == 0;
    }

    @Override
    public boolean isOBJxBasedPriority() {
        return (this.regOPRI & 1) != 0;
    }

    public int getRegOPRI() {
        return this.regOPRI;
    }

    public int getRegBGPI() {
        return this.regBGPI;
    }

    public int getRegOBPI() {
        return this.regOBPI;
    }

    public int getRegVBK() {
        return this.regVBK;
    }

    public int getRegHDMA1() {
        return this.regHDMA1;
    }

    public int getRegHDMA2() {
        return this.regHDMA2;
    }

    public int getRegHDMA3() {
        return this.regHDMA3;
    }

    public int getRegHDMA4() {
        return this.regHDMA4;
    }

    public int getRegHDMA5() {
        return this.regHDMA5;
    }

    @Override
    public long getBGP(int n, int n2) {
        return this.bgp[n2];
    }

    @Override
    public long getOBP(int n) {
        return this.obp[n];
    }

    @Override
    public int getSCY(int n, int n2) {
        return super.getSCY(n, 0);
    }

    @Override
    public int mixWithTileSelReset(int n, int n2, int n3) {
        if ((this.lcdc[n + 2] & 0x10) < (this.lcdc[n + 1] & 0x10)) {
            return n2 << 1 | n3 & 1;
        }
        return n3;
    }

    @Override
    public void setBGP(int n, long l) {
        this.bgp[n] = l;
        int n2 = 0;
        while (n2 < 4) {
            this.fireOutputAvailable(0x110009, n << 3 | n2 << 1);
            ++n2;
        }
    }

    @Override
    public void setOBP(int n, long l) {
        this.obp[n] = l;
        int n2 = 0;
        while (n2 < 4) {
            this.fireOutputAvailable(0x110009, 0x40 | n << 3 | n2 << 1);
            ++n2;
        }
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    private boolean isDMGmode() {
        return (this.mode & 0xC) != 0;
    }

    public boolean initiateHDMA(int[] nArray, GameBoyColor gameBoyColor) {
        if (this.isDMGmode()) {
            return false;
        }
        if ((this.regHDMA5 & 0x80) == 0 && (nArray[85] & 0x80) == 0) {
            this.regHDMA5 = nArray[85] = nArray[85] | 0x80;
            return false;
        }
        this.regHDMA5 = nArray[85];
        int n = this.regHDMA1 << 8 | this.regHDMA2;
        int n2 = 0x8000 | this.regHDMA3 << 8 | this.regHDMA4;
        int n3 = 4;
        if ((this.regHDMA5 & 0x80) == 0) {
            int n4 = this.regHDMA5;
            while (n4 >= 0) {
                gameBoyColor.doHDMA(n & 0xFFF0, n2 & 0xFFF0, n3);
                if ((n += 16) == 32768) {
                    n = 40960;
                }
                if ((n2 += 16) == 40960) {
                    n2 = 32768;
                }
                n3 += 32;
                --n4;
            }
            this.regHDMA1 = n >> 8;
            this.regHDMA2 = n & 0xFF;
            this.regHDMA3 = n2 >> 8;
            this.regHDMA4 = n2 & 0xFF;
            this.regHDMA5 = 255;
            nArray[85] = 255;
            return true;
        }
        nArray[85] = this.regHDMA5 &= 0x7F;
        if ((this.getRegSTAT() & 3) == 0 && !this.lineLastCycle || this.isOddMode0()) {
            return this.continueHDMA(nArray, gameBoyColor, true);
        }
        return false;
    }

    public boolean continueHDMA(int[] nArray, GameBoyColor gameBoyColor) {
        return this.continueHDMA(nArray, gameBoyColor, false);
    }

    private boolean continueHDMA(int[] nArray, GameBoyColor gameBoyColor, boolean bl) {
        if (!this.isDMGmode() && (bl || this.isHDMAready()) && (this.regHDMA5 & 0x80) == 0) {
            this.hdmaReady = false;
            int n = this.regHDMA1 << 8 | this.regHDMA2;
            int n2 = this.regHDMA3 << 8 | this.regHDMA4;
            int n3 = this.regHDMA5;
            gameBoyColor.doHDMA(n & 0xFFF0, n2 & 0xFFF0, 4);
            if ((n += 16) == 32768) {
                n = 40960;
            }
            this.regHDMA1 = n >> 8;
            this.regHDMA2 = n & 0xFF;
            if ((n2 += 16) == 40960) {
                n2 = 32768;
            }
            this.regHDMA3 = n2 >> 8;
            this.regHDMA4 = n2 & 0xFF;
            nArray[85] = this.regHDMA5 = --n3 & 0xFF;
            return true;
        }
        return false;
    }

    private boolean isHDMAready() {
        return this.hdmaReady;
    }

    @Override
    public int readPort(int n, int n2) {
        if (n == 105 || n == 107) {
            int n3;
            this.update(n2);
            if ((this.getRegSTAT() & 3) == 3) {
                n3 = 255;
                this.fireInaccessiblePalette();
            } else {
                n3 = n == 105 ? (int)(this.bgp[(this.regBGPI & 0x3F) >> 3] >> ((this.regBGPI & 7) << 3) & 0xFFL) : (int)(this.obp[(this.regOBPI & 0x3F) >> 3] >> ((this.regOBPI & 7) << 3) & 0xFFL);
            }
            this.fireOutputAvailable(n, n3, n2);
            this.timerMode += n2;
            this.cyclesSinceLastFrame -= n2;
            return 255;
        }
        return super.readPort(n, n2);
    }

    @Override
    public void processInput(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = n3 != this.timerMode || n != 67 && n != 75;
        if (bl) {
            this.update(n3);
        }
        switch (n) {
            case 79: {
                if (this.isDMGmode()) {
                    this.fireOutputAvailable(n, 255);
                    break;
                }
                this.regVBK = n2 & 1;
                this.fireOutputAvailable(n, 0xFE | this.regVBK, n3);
                break;
            }
            case 81: {
                this.fireOutputAvailable(n, 255);
                if (this.isDMGmode()) break;
                this.regHDMA1 = n2;
                break;
            }
            case 82: {
                this.fireOutputAvailable(n, 255);
                if (this.isDMGmode()) break;
                this.regHDMA2 = n2;
                break;
            }
            case 83: {
                this.fireOutputAvailable(n, 255);
                if (this.isDMGmode()) break;
                this.regHDMA3 = n2;
                break;
            }
            case 84: {
                this.fireOutputAvailable(n, 255);
                if (this.isDMGmode()) break;
                this.regHDMA4 = n2;
                break;
            }
            case 85: {
                if (this.isDMGmode()) {
                    this.fireOutputAvailable(n, 255);
                    break;
                }
                this.fireOutputAvailable(n, n2);
                break;
            }
            case 104: {
                this.regBGPI = n2;
                this.fireOutputAvailable(n, 0x40 | n2, n3);
                if (this.isDMGmode()) {
                    this.fireInaccessiblePalette();
                    break;
                }
                this.fireOutputAvailable(105, (int)(this.bgp[(this.regBGPI & 0x3F) >> 3] >> ((this.regBGPI & 7) << 3) & 0xFFL), n3);
                break;
            }
            case 105: {
                if (this.isDMGmode()) {
                    this.fireOutputAvailable(n, 255);
                    this.fireInaccessiblePalette();
                    break;
                }
                if ((this.getRegSTAT() & 3) == 3) {
                    this.regBGPI = 0x80 | this.regBGPI + 1 & 0x3F;
                    this.fireOutputAvailable(104, 0x40 | this.regBGPI, n3);
                    this.fireInaccessiblePalette();
                    break;
                }
                this.fireOutputAvailable(0x110008, (int)(this.bgp[(this.regBGPI & 0x3F) >> 3] >> ((this.regBGPI & 7) << 3) & 0xFFL) << 16 | n2 << 8 | this.regBGPI & 0x3F);
                this.bgp[(this.regBGPI & 0x3F) >> 3] = this.bgp[(this.regBGPI & 0x3F) >> 3] & (255L << ((this.regBGPI & 7) << 3) ^ 0xFFFFFFFFFFFFFFFFL) | (long)n2 << ((this.regBGPI & 7) << 3);
                this.fireOutputAvailable(0x110009, n2 << 8 | this.regBGPI & 0x3F);
                if ((this.regBGPI & 0x80) == 0) break;
                this.regBGPI = 0x80 | this.regBGPI + 1 & 0x3F;
                this.fireOutputAvailable(104, 0x40 | this.regBGPI, n3);
                this.fireOutputAvailable(105, (int)(this.bgp[(this.regBGPI & 0x3F) >> 3] >> ((this.regBGPI & 7) << 3) & 0xFFL), n3);
                break;
            }
            case 106: {
                this.regOBPI = n2;
                this.fireOutputAvailable(n, 0x40 | n2, n3);
                if (this.isDMGmode()) {
                    this.fireInaccessiblePalette();
                    break;
                }
                this.fireOutputAvailable(107, (int)(this.obp[(this.regOBPI & 0x3F) >> 3] >> ((this.regOBPI & 7) << 3) & 0xFFL), n3);
                break;
            }
            case 107: {
                if (this.isDMGmode()) {
                    this.fireOutputAvailable(n, 255);
                    this.fireInaccessiblePalette();
                    break;
                }
                if ((this.getRegSTAT() & 3) == 3) {
                    this.regOBPI = 0x80 | this.regOBPI + 1 & 0x3F;
                    this.fireOutputAvailable(106, 0x40 | this.regOBPI, n3);
                    this.fireInaccessiblePalette();
                    break;
                }
                this.fireOutputAvailable(0x110008, (int)(this.obp[(this.regOBPI & 0x3F) >> 3] >> ((this.regOBPI & 7) << 3) & 0xFFL) << 16 | n2 << 8 | 0x40 | this.regOBPI & 0x3F);
                this.obp[(this.regOBPI & 0x3F) >> 3] = this.obp[(this.regOBPI & 0x3F) >> 3] & (255L << ((this.regOBPI & 7) << 3) ^ 0xFFFFFFFFFFFFFFFFL) | (long)n2 << ((this.regOBPI & 7) << 3);
                this.fireOutputAvailable(0x110009, n2 << 8 | 0x40 | this.regOBPI & 0x3F);
                if ((this.regOBPI & 0x80) == 0) break;
                this.regOBPI = 0x80 | this.regOBPI + 1 & 0x3F;
                this.fireOutputAvailable(106, 0x40 | this.regOBPI, n3);
                this.fireOutputAvailable(107, (int)(this.obp[(this.regOBPI & 0x3F) >> 3] >> ((this.regOBPI & 7) << 3) & 0xFFL), n3);
                break;
            }
            case 108: {
                if (this.isDMGmode()) {
                    this.fireOutputAvailable(n, 255);
                    break;
                }
                this.regOPRI = n2;
                this.fireOutputAvailable(108, 0xFE | n2 & 1, n3);
                break;
            }
            default: {
                super.processInput(n, n2, 0);
            }
        }
        if (bl) {
            this.timerMode += n3;
            this.cyclesSinceLastFrame -= n3;
        }
    }

    public void setMode(int n) {
        this.mode = n;
        if (this.isDMGmode()) {
            this.fireOutputAvailable(79, 254);
            this.fireOutputAvailable(85, 255);
            this.fireOutputAvailable(105, 255);
            this.fireOutputAvailable(107, 255);
            this.fireOutputAvailable(108, 255);
        }
    }

    @Override
    protected int readOAM(int n) {
        if (n >= this.oam.length) {
            return n & 0xF0 | n >> 4 & 0xF;
        }
        return super.readOAM(n);
    }

    @Override
    protected int readVRAM(int n) {
        return super.readVRAM(this.regVBK << 13 | n & 0x1FFF);
    }

    @Override
    protected int peekVRAM(int n) {
        return super.peekVRAM(this.regVBK << 13 | n & 0x1FFF);
    }

    @Override
    protected void writeVRAM(int n, int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl && this.isVramWriteInaccessible();
        if (bl2) {
            int n3 = this.getRegLY();
            int n4 = this.toScreenDot(n3, this.calcCurrentDot() - 80) & Integer.MAX_VALUE;
            if (n4 < 160) {
                if (!this.inaccessibleVRAMduringDMAsent) {
                    this.fireInaccessibleVram(n & 0x1FFF);
                }
                this.inaccessibleVRAMduringDMAsent = true;
                int n5 = n4 + this.getSCXlow();
                int n6 = n5 / 8;
                int n7 = n3 + this.getSCY(n5);
                int n8 = n7 / 8;
                int n9 = this.getBGTileMapDisplayAddress(n6) | (n8 & 0x1F) << 5;
                int n10 = n9 | n6 + (this.getSCX(n6) >> 3) & 0x1F;
                n &= n10;
            }
            super.writeVRAM((this.regVBK ^ 1) << 13 | n & 0x1FFF, n2, bl);
        } else {
            this.inaccessibleVRAMduringDMAsent = false;
        }
        super.writeVRAM(this.regVBK << 13 | n & 0x1FFF, n2, bl);
    }

    @Override
    protected void pokeVRAM(int n, int n2) {
        super.pokeVRAM(this.regVBK << 13 | n & 0x1FFF, n2);
    }

    @Override
    protected void clearCoincidenceFlagOnLineLastCycles() {
    }

    @Override
    protected boolean isCoincidenceFlag() {
        if (!this.isLCDDisplayEnabled()) {
            return (this.getRegSTAT() & 4) != 0;
        }
        int n = this.getRegLY();
        if (n == 153 && this.line153cycles > 4) {
            n = 0;
        }
        return n == this.getRegLYC();
    }

    @Override
    public LR35902.OamBugHandler createOamBugHandler() {
        return null;
    }

    @Override
    protected void handleOamReadBug(int n) {
    }

    @Override
    protected void handleOamWriteBug(int n) {
    }

    private void fireInaccessiblePalette() {
        this.fireOutputAvailable(0x110101, 0);
    }

    @Override
    public GBLCDController.State getState() {
        final GBLCDController.State state = super.getState();
        return new GBLCDController.UnmodifiableState(){

            @Override
            public GBLCDController.State clone() {
                return new StateClone(this);
            }

            @Override
            public int getTimer() {
                return state.getTimer();
            }

            @Override
            public int[] getVram() {
                return state.getVram();
            }

            @Override
            public int[] getOam() {
                return state.getOam();
            }

            @Override
            public int getRegLCDC() {
                return state.getRegLCDC();
            }

            @Override
            public int getRegSTAT() {
                return state.getRegSTAT();
            }

            @Override
            public int getRegSCY() {
                return state.getRegSCY();
            }

            @Override
            public int getRegSCX() {
                return state.getRegSCX();
            }

            @Override
            public int getRegLY() {
                return state.getRegLY();
            }

            @Override
            public int getRegLYC() {
                return state.getRegLYC();
            }

            @Override
            public int getRegWY() {
                return state.getRegWY();
            }

            @Override
            public int getRegWX() {
                return state.getRegWX();
            }

            @Override
            public int getRegBGP() {
                return state.getRegBGP();
            }

            @Override
            public int getRegOBP0() {
                return state.getRegOBP0();
            }

            @Override
            public int getRegOBP1() {
                return state.getRegOBP1();
            }

            @Override
            public int getRegDMA() {
                return state.getRegDMA();
            }

            @Override
            public int getMode3additionalTime() {
                return state.getMode3additionalTime();
            }

            @Override
            public int getLine153cycles() {
                return state.getLine153cycles();
            }

            @Override
            public boolean isFirstFrame() {
                return state.isFirstFrame();
            }

            @Override
            public boolean isLineMainPart() {
                return state.isLineMainPart();
            }

            @Override
            public boolean isLineLastCycle() {
                return state.isLineLastCycle();
            }

            @Override
            public boolean isMode3lastCycles() {
                return state.isMode3lastCycles();
            }

            @Override
            public boolean isHdmaReady() {
                return state.isHdmaReady();
            }

            @Override
            public boolean isWySatisfied() {
                return state.isWySatisfied();
            }

            @Override
            public int getWindowLine() {
                return state.getWindowLine();
            }

            @Override
            public int getRegBGPI() {
                return GBCLCDController.this.regBGPI;
            }

            @Override
            public int getRegOBPI() {
                return GBCLCDController.this.regOBPI;
            }

            @Override
            public int getRegOPRI() {
                return GBCLCDController.this.regOPRI;
            }

            @Override
            public boolean hasCGBpalettes() {
                return true;
            }

            @Override
            public long getBGP(int n) {
                return GBCLCDController.this.bgp[n];
            }

            @Override
            public long getOBP(int n) {
                return GBCLCDController.this.obp[n];
            }

            @Override
            public int getRegVBK() {
                return GBCLCDController.this.regVBK;
            }

            @Override
            public int getRegHDMA1() {
                return GBCLCDController.this.regHDMA1;
            }

            @Override
            public int getRegHDMA2() {
                return GBCLCDController.this.regHDMA2;
            }

            @Override
            public int getRegHDMA3() {
                return GBCLCDController.this.regHDMA3;
            }

            @Override
            public int getRegHDMA4() {
                return GBCLCDController.this.regHDMA4;
            }

            @Override
            public int getRegHDMA5() {
                return GBCLCDController.this.regHDMA5;
            }

            @Override
            public int getMode() {
                return GBCLCDController.this.mode;
            }
        };
    }

    @Override
    public void setState(GBLCDController.State state, boolean bl) {
        super.setState(state, true);
        this.regBGPI = state.getRegBGPI();
        this.regOBPI = state.getRegOBPI();
        this.regOPRI = state.getRegOPRI();
        if (state.hasCGBpalettes()) {
            int n = 0;
            while (n < this.bgp.length) {
                this.setBGP(n, state.getBGP(n));
                ++n;
            }
            n = 0;
            while (n < this.obp.length) {
                this.setOBP(n, state.getOBP(n));
                ++n;
            }
        }
        this.regVBK = state.getRegVBK() & 1;
        this.regHDMA1 = state.getRegHDMA1();
        this.regHDMA2 = state.getRegHDMA2();
        this.regHDMA3 = state.getRegHDMA3();
        this.regHDMA4 = state.getRegHDMA4();
        this.regHDMA5 = state.getRegHDMA5();
        this.mode = state.getMode();
        if (!bl) {
            this.fireOutputAvailable(0x110010, 0);
        }
    }

    private static class StateClone
    extends GBLCDController.StateClone {
        private final int regBGPI;
        private final int regOBPI;
        private final int regOPRI;
        private final boolean hasCGBpalettes;
        private final long[] bgp = new long[8];
        private final long[] obp = new long[8];
        private final int regVBK;
        private final int regHDMA1;
        private final int regHDMA2;
        private final int regHDMA3;
        private final int regHDMA4;
        private final int regHDMA5;
        private final int mode;

        public StateClone(GBLCDController.State state) {
            super(state);
            this.regBGPI = state.getRegBGPI();
            this.regOBPI = state.getRegOBPI();
            this.regOPRI = state.getRegOPRI();
            this.hasCGBpalettes = state.hasCGBpalettes();
            if (this.hasCGBpalettes) {
                int n = 0;
                while (n < this.bgp.length) {
                    this.bgp[n] = state.getBGP(n);
                    ++n;
                }
                n = 0;
                while (n < this.obp.length) {
                    this.obp[n] = state.getOBP(n);
                    ++n;
                }
            }
            this.regVBK = state.getRegVBK();
            this.regHDMA1 = state.getRegHDMA1();
            this.regHDMA2 = state.getRegHDMA2();
            this.regHDMA3 = state.getRegHDMA3();
            this.regHDMA4 = state.getRegHDMA4();
            this.regHDMA5 = state.getRegHDMA5();
            this.mode = state.getMode();
        }

        @Override
        public GBLCDController.State clone() {
            return new StateClone(this);
        }

        @Override
        public int getRegBGPI() {
            return this.regBGPI;
        }

        @Override
        public int getRegOBPI() {
            return this.regOBPI;
        }

        @Override
        public int getRegOPRI() {
            return this.regOPRI;
        }

        @Override
        public long getBGP(int n) {
            return this.bgp[n];
        }

        @Override
        public long getOBP(int n) {
            return this.obp[n];
        }

        @Override
        public int getRegVBK() {
            return this.regVBK;
        }

        @Override
        public int getRegHDMA1() {
            return this.regHDMA1;
        }

        @Override
        public int getRegHDMA2() {
            return this.regHDMA2;
        }

        @Override
        public int getRegHDMA3() {
            return this.regHDMA3;
        }

        @Override
        public int getRegHDMA4() {
            return this.regHDMA4;
        }

        @Override
        public int getRegHDMA5() {
            return this.regHDMA5;
        }

        @Override
        public int getMode() {
            return this.mode;
        }
    }
}

