/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import util.map.HashMap;
import util.map.Map;
import util.set.IntHashSet;

public class HashMapStack<T>
implements Map<T> {
    private List<Map<T>> stack;
    private int height;

    public HashMapStack() {
        this.stack = new ArrayList<Map<T>>();
        this.stack.add(new HashMap());
    }

    public HashMapStack(HashMapStack<T> hashMapStack) {
        this.stack = hashMapStack.stack;
        this.height = hashMapStack.height;
        this.push();
    }

    @Override
    public int size() {
        int n = 0;
        for (Map<T> map : this.stack) {
            if (map.size() <= n) continue;
            n = map.size();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public boolean containsKey(int n) {
        int n2 = this.height;
        while (n2 >= 0) {
            if (this.stack.get(n2).containsKey(n)) {
                return true;
            }
            --n2;
        }
        return false;
    }

    @Override
    public boolean containsValue(T t) {
        int n = this.height;
        while (n >= 0) {
            if (this.stack.get(n).containsValue(t)) {
                return true;
            }
            --n;
        }
        return false;
    }

    @Override
    public T get(int n) {
        int n2 = this.height;
        while (n2 >= 0) {
            T t = this.stack.get(n2).get(n);
            if (t != null) {
                return t;
            }
            --n2;
        }
        return null;
    }

    @Override
    public T put(int n, T t) {
        return this.stack.get(this.height).put(n, t);
    }

    @Override
    public T remove(int n) {
        int n2 = this.height;
        while (n2 >= 0) {
            T t = this.stack.get(n2).remove(n);
            if (t != null) {
                return t;
            }
            --n2;
        }
        return null;
    }

    @Override
    public void clear() {
        this.height = 0;
    }

    @Override
    public int[] keySet() {
        IntHashSet intHashSet = new IntHashSet();
        int n = this.height;
        while (n >= 0) {
            int[] nArray = this.stack.get(n).keySet();
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n3];
                intHashSet.add(n4);
                ++n3;
            }
            --n;
        }
        return intHashSet.keys();
    }

    @Override
    public BitSet keyBitSet() {
        BitSet bitSet = new BitSet();
        int n = this.height;
        while (n >= 0) {
            bitSet.or(this.stack.get(n).keyBitSet());
            --n;
        }
        return bitSet;
    }

    @Override
    public Collection<T> values() {
        return new AbstractCollection<T>(){
            final Set<Map.Entry<T>> entrySet;
            {
                this.entrySet = HashMapStack.this.entrySet();
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<Map.Entry<T>> it;
                    {
                        this.it = entrySet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        return this.it.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.entrySet.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<T>> entrySet() {
        HashSet<Map.Entry<T>> hashSet = new HashSet<Map.Entry<T>>();
        int[] nArray = this.keySet();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            hashSet.add(new HashMap.HashMapEntry<T>(n3, this.get(n3)));
            ++n2;
        }
        return hashSet;
    }

    public Set<Map.Entry<T>> topEntrySet() {
        return this.stack.get(this.height).entrySet();
    }

    private void push() {
        ++this.height;
        if (this.height < this.stack.size()) {
            this.stack = new ArrayList<Map<T>>(this.stack.subList(0, this.height));
        }
        this.stack.add(new HashMap());
    }
}

