/*
 * Decompiled with CFR 0.152.
 */
package platform;

import assembler.Z80Instruction;
import components.OutputListener;
import components.cartridge.MSXCartridge;
import disassembler.Z80Disassembler;
import java.util.LinkedList;
import platform.MemoryTracer;
import system.MSX;

public class MSXMemoryTracer
extends MemoryTracer {
    private final OutputListener outputListener = new OutputListener(){

        @Override
        public void outputAvailable(int n, int n2, int n3) {
            try {
                if (!MSXMemoryTracer.this.isCartridgeEnabled()) {
                    return;
                }
                if (n != 0x110004 && n != 0x110002 && n != 0x220000 && n != 0x110011 && n != 0x330000) {
                    return;
                }
                int n4 = MSXMemoryTracer.this.getPrevOpcode();
                if (n4 < 0) {
                    return;
                }
                int[] nArray = new int[2];
                nArray[0] = MSXMemoryTracer.this.getPrevMappedPC();
                int[] nArray2 = nArray;
                switch (n4) {
                    case 211: 
                    case 60793: {
                        nArray2 = MSXMemoryTracer.this.traceReg(7);
                        break;
                    }
                    case 60737: {
                        nArray2 = MSXMemoryTracer.this.traceReg(0);
                        break;
                    }
                    case 60745: {
                        nArray2 = MSXMemoryTracer.this.traceReg(1);
                        break;
                    }
                    case 60753: {
                        nArray2 = MSXMemoryTracer.this.traceReg(2);
                        break;
                    }
                    case 60761: {
                        nArray2 = MSXMemoryTracer.this.traceReg(3);
                        break;
                    }
                    case 60769: {
                        nArray2 = MSXMemoryTracer.this.traceReg(4);
                        break;
                    }
                    case 60777: {
                        nArray2 = MSXMemoryTracer.this.traceReg(5);
                        break;
                    }
                    case 60785: {
                        nArray2 = new int[]{MSXMemoryTracer.this.getPrevMappedPC(), -1};
                        break;
                    }
                    case 60835: 
                    case 60843: 
                    case 60851: 
                    case 60859: {
                        nArray2 = new int[]{MSXMemoryTracer.this.getPrevMappedPC(), MSXMemoryTracer.this.toMappedAddress(MSXMemoryTracer.this.getRegisterValue(2))};
                    }
                }
                if (nArray2[1] < 0) {
                    nArray2[1] = -nArray2[1];
                }
                int n5 = nArray2[0];
                if (n == 0x110004) {
                    if (MSXMemoryTracer.this.vramSources[n2 & 0x3FFF] != ((long)n5 << 32 | (long)nArray2[1])) {
                        MSXMemoryTracer.this.vramSources[n2 & 0x3FFF] = (long)n5 << 32 | (long)nArray2[1];
                        MSXMemoryTracer.fireOutputAvailable(n, n2 & 0x3FFF);
                    }
                    int n6 = (n2 & 0x3FFF) < 14336 ? 2 : ((n2 & 0x3FFF) < 16128 ? 3 : 4);
                    MSXMemoryTracer.this.updateDataTypes(nArray2, n6);
                } else if (n == 0x110002) {
                    if (MSXMemoryTracer.this.colorSources[n2 & 0xF] != ((long)n5 << 32 | (long)nArray2[1])) {
                        MSXMemoryTracer.this.colorSources[n2 & 0xF] = (long)n5 << 32 | (long)nArray2[1];
                        MSXMemoryTracer.fireOutputAvailable(n, n2 & 0x1F);
                    }
                    MSXMemoryTracer.this.updateDataTypes(nArray2, 1);
                } else if (n == 0x220000) {
                    int n7;
                    int n8 = (n2 & 0x7F) >> 1;
                    int n9 = (n2 & 1) != 0 ? 2 : (n2 & 0x80) >> 7 ^ 1;
                    int n10 = n7 = n8 == 3 && (n2 & 1) != 0 ? n8 * 3 + 1 : n8 * 3 + n9;
                    if (MSXMemoryTracer.this.psgSources[n7] != ((long)n5 << 32 | (long)nArray2[1])) {
                        MSXMemoryTracer.this.psgSources[n7] = (long)n5 << 32 | (long)nArray2[1];
                        MSXMemoryTracer.fireOutputAvailable(n, n7);
                    }
                    MSXMemoryTracer.this.updateDataTypes(nArray2, 16);
                } else if (n == 0x110011) {
                    if (MSXMemoryTracer.this.vdpSources[n2 & 0x3F] != ((long)n5 << 32 | (long)nArray2[1])) {
                        MSXMemoryTracer.this.vdpSources[n2 & 0x3F] = (long)n5 << 32 | (long)nArray2[1];
                        MSXMemoryTracer.fireOutputAvailable(n, n2 & 0x3F);
                    }
                } else if (n == 0x330000 && MSXMemoryTracer.this.fmSources[n2 & 0x3F] != ((long)n5 << 32 | (long)nArray2[1])) {
                    MSXMemoryTracer.this.fmSources[n2 & 0x3F] = (long)n5 << 32 | (long)nArray2[1];
                    MSXMemoryTracer.fireOutputAvailable(n, n2 & 0x3F);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MSXMemoryTracer.this.clearTrace();
            }
        }
    };
    final long[] psgSources = new long[11];
    final long[] vdpSources = new long[64];
    final long[] fmSources = new long[64];

    protected MSXMemoryTracer(MSX mSX, MSXCartridge mSXCartridge) {
        super(mSX, mSXCartridge);
    }

    @Override
    protected int getIndexOfPC() {
        return 7;
    }

    @Override
    protected void updateTrace(int n, Z80Instruction z80Instruction) {
        int n2;
        super.updateTrace(n, z80Instruction);
        int n3 = z80Instruction.getOpCode();
        if (n3 == 8) {
            this.regSources[7] = null;
            return;
        }
        if (n3 == 217) {
            int n4 = 0;
            while (n4 < this.regSources.length) {
                if (n4 != 7) {
                    this.regSources[n4] = null;
                }
                ++n4;
            }
            return;
        }
        int n5 = z80Instruction.getPrefix();
        int n6 = n2 = n5 != 0 ? n5 >> 5 & 5 : 2;
        if (n3 >> 6 == 0 && ((n3 & 0xF) == 1 || (n3 & 7) == 6)) {
            if ((n3 & 0xF) == 1) {
                int n7 = n3 >> 4;
                if (n7 < 3) {
                    if (n7 == 2) {
                        n7 = n2;
                    }
                    if (n7 < 3) {
                        this.regSources[n7 << 1] = new int[]{n, n + 2};
                        this.regSources[n7 << 1 | 1] = new int[]{n, n + 1};
                    }
                }
            } else if ((n3 & 7) == 6) {
                this.regSources[n3 >> 3 & 7] = new int[]{n, n + 1};
            }
        } else if (n3 >> 6 == 1) {
            int n8 = n3 >> 3 & 7;
            int n9 = n3 & 7;
            if (n9 == 6) {
                if (n8 != 6) {
                    this.regSources[n8] = null;
                }
            } else if (n8 != 6) {
                this.regSources[n8] = this.regSources[n9];
            }
        } else {
            switch (n3) {
                case 10: 
                case 26: {
                    this.regSources[7] = null;
                    break;
                }
                case 42: {
                    this.regSources[n2 << 1] = new int[]{n, this.toMappedAddress(z80Instruction.getArg() + 1)};
                    this.regSources[n2 << 1 | 1] = new int[]{n, this.toMappedAddress(z80Instruction.getArg())};
                    break;
                }
                case 58: {
                    this.regSources[7] = new int[]{n, this.toMappedAddress(z80Instruction.getArg())};
                    break;
                }
                case 175: {
                    this.regSources[7] = new int[]{n, -1};
                    break;
                }
                case 235: {
                    int[] nArray = this.regSources[2];
                    this.regSources[2] = this.regSources[4];
                    this.regSources[4] = nArray;
                    nArray = this.regSources[3];
                    this.regSources[3] = this.regSources[5];
                    this.regSources[5] = nArray;
                    break;
                }
                case 60763: {
                    this.regSources[2] = new int[]{n, this.toMappedAddress(z80Instruction.getArg() + 1)};
                    this.regSources[3] = new int[]{n, this.toMappedAddress(z80Instruction.getArg())};
                    break;
                }
                case 219: {
                    this.regSources[7] = new int[]{n, -2};
                    break;
                }
                case 193: {
                    this.regSources[0] = null;
                    this.regSources[1] = null;
                    break;
                }
                case 209: {
                    this.regSources[2] = null;
                    this.regSources[3] = null;
                    break;
                }
                case 225: {
                    this.regSources[4] = null;
                    this.regSources[5] = null;
                    break;
                }
                case 241: {
                    this.regSources[7] = null;
                }
            }
        }
    }

    @Override
    protected boolean shouldTrace(Z80Instruction z80Instruction) {
        if (z80Instruction == null) {
            return false;
        }
        if (!z80Instruction.isValid()) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xCF) == 9) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xC7) == 198) {
            return false;
        }
        if (z80Instruction.getOpCode() == 7) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xFF00) == 51968) {
            return (z80Instruction.getOpCode() & 0xFFC0) == 51968;
        }
        if ((z80Instruction.getOpCode() & 0xFFF7) == 243) {
            return false;
        }
        if (z80Instruction.getOpCode() == 233) {
            return false;
        }
        if (z80Instruction.isJump() || z80Instruction.isCall() || z80Instruction.isRet()) {
            return false;
        }
        if (z80Instruction.getOpCode() == 211 || (z80Instruction.getOpCode() & 0xFFC7) == 60737 || (z80Instruction.getOpCode() & 0xFFE7) == 60835) {
            return false;
        }
        if (z80Instruction.getOpCode() == 52 || z80Instruction.getOpCode() == 53 || (z80Instruction.getOpCode() & 0xFFC7) == 3 || (z80Instruction.getOpCode() & 0xFFC7) == 4 || (z80Instruction.getOpCode() & 0xFFC7) == 5) {
            return false;
        }
        if (z80Instruction.getOpCode() == 54 || (z80Instruction.getOpCode() & 0xFFF8) == 112 || (z80Instruction.getOpCode() & 0xFFCF) == 2 || (z80Instruction.getOpCode() & 0xFFE7) == 60832) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xFFE7) == 39) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xFFF8) == 184 || z80Instruction.getOpCode() == 254) {
            return false;
        }
        if (z80Instruction.getOpCode() == 183) {
            return false;
        }
        return z80Instruction.getOpCode() > 0;
    }

    @Override
    protected void setListenersEnabled(boolean bl) {
        if (bl) {
            ((MSX)this.getDecoratedSystem()).addOutputListener(this.outputListener);
        } else {
            ((MSX)this.getDecoratedSystem()).removeOutputListener(this.outputListener);
        }
    }

    int[] traceReg(int n) {
        int[] nArray = this.regSources[n];
        if (nArray != null) {
            return nArray;
        }
        int n2 = n;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = -1;
        for (int[] nArray2 : this.trace) {
            int n4;
            if (nArray2 == null) break;
            int n5 = nArray2[this.getIndexOfPC()];
            Z80Instruction z80Instruction = this.disassemble(n5);
            int n6 = z80Instruction.getOpCode();
            if (n6 == 8 || bl2) {
                if (n6 != 8) continue;
                bl2 = !bl2 && n == 7;
                continue;
            }
            if (n6 == 217 || bl) {
                if (n6 != 217) continue;
                bl = !bl && n >= 0 && n != 7;
                continue;
            }
            int n7 = z80Instruction.getPrefix();
            int n8 = n7 != 0 ? n7 >> 5 & 5 : 2;
            int n9 = z80Instruction.getDisplacement();
            if (n6 >> 6 == 0 && ((n6 & 0xF) == 1 || (n6 & 7) == 6)) {
                if ((n6 & 0xF) == 1) {
                    n4 = n6 >> 4;
                    if (n4 >= 3) continue;
                    if (n4 == 2) {
                        n4 = n8;
                    }
                    if (n >> 1 != n4) continue;
                    this.regSources[n] = new int[]{n5, n5 + 2 - (n & 1)};
                    return this.regSources[n];
                }
                if ((n6 & 7) != 6 || (n4 = n6 >> 3 & 7) == 6 || n != n4) continue;
                this.regSources[n] = new int[]{n5, n5 + 1};
                return this.regSources[n];
            }
            if (n6 >> 6 == 1) {
                n4 = n6 >> 3 & 7;
                if (n != n4) continue;
                int n10 = n6 & 7;
                if (n10 == 6) {
                    if (n4 == 6) continue;
                    this.regSources[n] = new int[]{n5, nArray2[n8] + n9};
                    return this.regSources[n];
                }
                if (n4 == 6 || this.regSources[n = n10] == null) continue;
                this.regSources[n2] = this.regSources[n];
                return this.regSources[n2];
            }
            switch (n6) {
                case 10: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, nArray2[0]};
                    return this.regSources[n];
                }
                case 26: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, nArray2[1]};
                    return this.regSources[n];
                }
                case 42: {
                    if (n >> 1 != n8) break;
                    this.regSources[n] = new int[]{n5, this.toMappedAddress(z80Instruction.getArg() + (~n & 1))};
                    return this.regSources[n];
                }
                case 58: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, this.toMappedAddress(z80Instruction.getArg())};
                    return this.regSources[n];
                }
                case 175: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, -1};
                    return this.regSources[n];
                }
                case 235: {
                    if (n >> 1 == 1) {
                        n += 2;
                    }
                    if (n >> 1 == 2) {
                        n -= 2;
                    }
                    if (n < 0 || this.regSources[n] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 51993: 
                case 52002: {
                    if (n != 7) break;
                    if (n6 == 52002 && n3 == 31) {
                        n = 2;
                        if (this.regSources[n] == null) break;
                        this.regSources[n2] = this.regSources[n];
                        return this.regSources[n2];
                    }
                    if (n6 != 51993 || n3 != 23 || this.regSources[n = 1] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 60763: {
                    if (n >> 1 != 1) break;
                    this.regSources[n] = new int[]{n5, this.toMappedAddress(z80Instruction.getArg() + (~n & 1))};
                    return this.regSources[n];
                }
                case 219: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, -2};
                    return this.regSources[n];
                }
                case 193: {
                    if (n >> 1 != 0) break;
                    linkedList.push(n);
                    n = -1;
                    break;
                }
                case 209: {
                    if (n >> 1 != 1) break;
                    linkedList.push(n);
                    n = -1;
                    break;
                }
                case 225: {
                    if (n >> 1 != n8) break;
                    linkedList.push(n);
                    n = -1;
                    break;
                }
                case 241: {
                    if (n >> 1 != 3) break;
                    linkedList.push(n);
                    n = -1;
                    break;
                }
                case 197: {
                    if (linkedList.isEmpty() || (Integer)linkedList.peek() >> 1 != 0 || this.regSources[n = ((Integer)linkedList.pop()).intValue()] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 213: {
                    if (linkedList.isEmpty() || (Integer)linkedList.peek() >> 1 != 1 || this.regSources[n = ((Integer)linkedList.pop()).intValue()] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 229: {
                    if (linkedList.isEmpty() || (Integer)linkedList.peek() >> 1 != 2 || this.regSources[n = ((Integer)linkedList.pop()).intValue()] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 245: {
                    if (linkedList.isEmpty() || (Integer)linkedList.peek() >> 1 != 3 || this.regSources[n = ((Integer)linkedList.pop()).intValue()] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
            }
            n3 = n6;
        }
        int[] nArray3 = new int[2];
        nArray3[0] = this.getPrevMappedPC();
        this.regSources[n2] = nArray3;
        return nArray3;
    }

    @Override
    protected long traceMemory() {
        long l;
        int n = this.getPrevMappedPC();
        int n2 = this.getPrevOpcode();
        int[] nArray = new int[2];
        nArray[0] = n;
        int[] nArray2 = nArray;
        switch (n2) {
            case 2: 
            case 18: 
            case 50: {
                nArray2 = this.traceReg(7);
                break;
            }
            case 34: {
                nArray2 = this.traceReg(4);
                break;
            }
            case 52: 
            case 53: {
                return -1L;
            }
            case 54: {
                nArray2 = new int[]{n, n + 1};
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: {
                nArray2 = this.traceReg(n2 & 7);
                break;
            }
            case 60832: 
            case 60840: 
            case 60848: 
            case 60856: {
                nArray2 = new int[]{n, this.toMappedAddress(this.getRegisterValue(2))};
            }
        }
        if (nArray2[1] <= 0) {
            nArray2[1] = -nArray2[1];
        } else if ((nArray2[1] & 0x8000000) != 0) {
            long l2;
            long l3 = l2 = (nArray2[1] & 0xFFFFFF) < this.sramSources.length ? this.sramSources[nArray2[1] & 0xFFFFFF] : 0L;
            if ((int)l2 != 0 && (int)l2 != 1 && (int)l2 != 2) {
                nArray2[0] = (int)(l2 >> 32);
                nArray2[1] = (int)l2;
            }
        } else if ((nArray2[1] & 0x1000000) != 0 && (int)(l = this.ramSources[nArray2[1] & 0xFFFFFF]) != 0 && (int)l != 1 && (int)l != 2) {
            nArray2[0] = (int)(l >> 32);
            nArray2[1] = (int)l;
        }
        return (long)nArray2[0] << 32 | (long)nArray2[1];
    }

    @Override
    protected Z80Instruction disassemble(int n) {
        if ((n & 0x2000000) != 0) {
            return Z80Disassembler.disassemble(this.cartridge.getRom(), n & 0xFFFFFF);
        }
        if ((n & 0x1000000) != 0) {
            return Z80Disassembler.disassemble(this.getRAM(), n & 0xFFFFFF);
        }
        if ((n & 0x8000000) != 0) {
            return Z80Disassembler.disassemble(this.getSRAM(), n & 0xFFFFFF);
        }
        return null;
    }

    @Override
    protected long[] getInstanceSpriteSources(long[] lArray) {
        return MSXMemoryTracer.getVRAMSources(lArray);
    }

    public static long getPSGsource(int n) {
        if (!(instance instanceof MSXMemoryTracer) || !enabled) {
            return 0L;
        }
        return ((MSXMemoryTracer)MSXMemoryTracer.instance).psgSources[n];
    }

    public static long getVDPsource(int n) {
        if (!(instance instanceof MSXMemoryTracer) || !enabled) {
            return 0L;
        }
        return ((MSXMemoryTracer)MSXMemoryTracer.instance).vdpSources[n];
    }

    public static long getFMsource(int n) {
        if (!(instance instanceof MSXMemoryTracer) || !enabled) {
            return 0L;
        }
        return ((MSXMemoryTracer)MSXMemoryTracer.instance).fmSources[n];
    }
}

