/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import common.MenuItem;
import common.ScreenUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import platform.Emulicious;
import platform.GoToDialog;
import platform.debugger.Debugger;
import platform.debugger.RAMWatchWindow;

class CoverageWindow {
    private static CoverageWindow coverageWindow;
    final Window window;
    final Window owner;
    final Debugger debugger;
    int romSize;
    private final AbstractTableModel[] tableModels = new AbstractTableModel[2];
    private final JTable[] tables = new JTable[2];
    private final CoverageOverview[] overviews = new CoverageOverview[2];
    private final CoverageBoard[] boards = new CoverageBoard[2];
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final RowSorter<? extends TableModel>[] sorters = new RowSorter[2];

    private CoverageWindow(Window window, final Debugger debugger, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        final JButton jButton = new JButton();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Coverage");
        this.window.setIconImage(window.getIconImages().get(0));
        this.debugger = debugger;
        this.owner = window;
        this.romSize = debugger.getROMsize();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.window.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                debugger.setRecordCoverage(!debugger.isRecordCoverage());
                jButton.setText(debugger.isRecordCoverage() ? "Stop recording accesses" : "Start recording accesses");
                CoverageWindow.update();
            }
        });
        jButton.setText(debugger.isRecordCoverage() ? "Stop recording accesses" : "Start recording accesses");
        JButton jButton2 = new JButton("Clear collected data");
        jPanel2.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                debugger.clearCoverageData();
                CoverageWindow.update();
            }
        });
        this.tabbedPane.add("ROM", this.createROMcoveragePanel());
        this.tabbedPane.add("RAM", this.createRAMcoveragePanel());
        this.window.add((Component)this.tabbedPane, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuNavigate());
        debugger.installRunActions(this.getRootPane());
        if (coverageWindow == null || !coverageWindow.isVisible()) {
            block6: {
                try {
                    this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
                }
                catch (NumberFormatException numberFormatException) {
                    this.window.pack();
                    Rectangle rectangle = this.window.getBounds();
                    Rectangle rectangle2 = ScreenUtilities.getScreen(this.window).getDefaultConfiguration().getBounds();
                    int n = rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
                    if (n <= 0) break block6;
                    this.window.setSize(this.getWidth() - n, this.getHeight());
                }
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private JRootPane getRootPane() {
        if (this.window instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.window)).getRootPane();
        }
        return null;
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private JMenu makeMenuNavigate() {
        final Debugger debugger = this.debugger;
        final JTabbedPane jTabbedPane = this.tabbedPane;
        final JTable[] jTableArray = this.tables;
        JMenu jMenu = new JMenu("Navigate");
        jMenu.setMnemonic('n');
        MenuItem menuItem = new MenuItem("Go To", 103);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final int n = jTabbedPane.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                final JTable jTable = jTableArray[n];
                if (n == 0) {
                    int n2 = jTable.getSelectedRow();
                    String string = GoToDialog.open(CoverageWindow.this.window, "Enter ROM Address (HEX) or label:", debugger.getAllLabels(), new DocumentListener(){
                        private String prevText;

                        @Override
                        public void removeUpdate(DocumentEvent documentEvent) {
                        }

                        @Override
                        public void insertUpdate(DocumentEvent documentEvent) {
                            Document document = documentEvent.getDocument();
                            try {
                                String string = document.getText(0, document.getLength());
                                if (!string.equals(this.prevText)) {
                                    int n3;
                                    int n2;
                                    block6: {
                                        n2 = -1;
                                        try {
                                            n2 = Integer.parseInt(string, 16);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            if (n != 0) break block6;
                                            n3 = debugger.getLabelAddress(string);
                                            n2 = 16384 * (n3 >> 16) | n3 & 0x3FFF;
                                        }
                                    }
                                    if (n2 >= 0) {
                                        n3 = jTable.convertRowIndexToView(n2);
                                        jTable.getSelectionModel().setSelectionInterval(n3, n3);
                                        CoverageWindow.scrollRowToVisible(jTable, n3);
                                    }
                                }
                                this.prevText = string;
                            }
                            catch (BadLocationException badLocationException) {}
                        }

                        @Override
                        public void changedUpdate(DocumentEvent documentEvent) {
                        }
                    });
                    if (string == null) {
                        jTable.getSelectionModel().setSelectionInterval(n2, n2);
                        CoverageWindow.scrollRowToVisible(jTable, n2);
                    }
                } else {
                    String string = JOptionPane.showInputDialog(CoverageWindow.this, (Object)"Enter RAM Address (HEX):");
                    if (string != null) {
                        int n3 = -1;
                        try {
                            n3 = Integer.parseInt(string, 16);
                            int n4 = jTable.convertRowIndexToView(n3);
                            jTable.getSelectionModel().setSelectionInterval(n4, n4);
                            CoverageWindow.scrollRowToVisible(jTable, n4);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return jMenu;
    }

    static boolean scrollRowToVisible(JTable jTable, int n) {
        Rectangle rectangle = jTable.getCellRect(n, 0, true);
        Rectangle rectangle2 = jTable.getVisibleRect();
        rectangle.x = 0;
        rectangle.width = rectangle2.width;
        rectangle.height = rectangle2.height / 2;
        rectangle.y -= rectangle.height / 2;
        jTable.scrollRectToVisible(rectangle);
        return jTable.getVisibleRect().y != rectangle2.y;
    }

    private JPanel createROMcoveragePanel() {
        final Debugger debugger = this.debugger;
        final JTable[] jTableArray = this.tables;
        JPanel jPanel = new JPanel(new BorderLayout());
        jTableArray[0] = this.createROMcoverageTable();
        jTableArray[0].addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0) {
                    debugger.setSelectedAddress(jTableArray[0].convertRowIndexToModel(jTableArray[0].getSelectedRow()));
                }
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 16));
        this.boards[0] = new CoverageBoard(debugger, jTableArray[0], false);
        this.overviews[0] = new CoverageOverview(debugger, jTableArray[0], this.boards[0], false);
        jPanel2.add(this.overviews[0]);
        jPanel2.add(this.boards[0]);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(jTableArray[0]), "Center");
        return jPanel;
    }

    private JTable createROMcoverageTable() {
        final Debugger debugger = this.debugger;
        this.tableModels[0] = new AbstractTableModel(){
            private final String[] COLUMN_NAMES = new String[]{"Address", "Accesses"};

            @Override
            public Object getValueAt(int n, int n2) {
                if (n < 0) {
                    return "0";
                }
                if (n2 == 0) {
                    if (debugger.isROMcoverageExcluded(n)) {
                        return "(excluded)" + debugger.romAddressToString(n);
                    }
                    return debugger.romAddressToString(n);
                }
                return debugger.getCoverage(n);
            }

            @Override
            public int getRowCount() {
                return CoverageWindow.this.romSize;
            }

            @Override
            public int getColumnCount() {
                return this.COLUMN_NAMES.length;
            }

            @Override
            public String getColumnName(int n) {
                return this.COLUMN_NAMES[n];
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 1) {
                    return Long.class;
                }
                return super.getColumnClass(n);
            }
        };
        return this.createCoverageTable(this.tableModels[0]);
    }

    private JPanel createRAMcoveragePanel() {
        final Debugger debugger = this.debugger;
        final JTable[] jTableArray = this.tables;
        JPanel jPanel = new JPanel(new BorderLayout());
        jTableArray[1] = this.createRAMcoverageTable();
        jTableArray[1].addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0) {
                    debugger.setSelectedRAMaddress(jTableArray[1].convertRowIndexToModel(jTableArray[1].getSelectedRow()));
                }
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 16));
        this.boards[1] = new CoverageBoard(debugger, jTableArray[1], true);
        this.overviews[1] = new CoverageOverview(debugger, jTableArray[1], this.boards[1], true);
        jPanel2.add(this.overviews[1]);
        jPanel2.add(this.boards[1]);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(jTableArray[1]), "Center");
        return jPanel;
    }

    private JTable createRAMcoverageTable() {
        final Debugger debugger = this.debugger;
        this.tableModels[1] = new AbstractTableModel(){
            private final String[] COLUMN_NAMES = new String[]{"Address", "Accesses"};

            @Override
            public Object getValueAt(int n, int n2) {
                if (n < 0) {
                    return "0";
                }
                if (n2 == 0) {
                    if (debugger.isRAMcoverageExcluded(n)) {
                        return "(excluded)" + debugger.ramAddressToString(n);
                    }
                    return debugger.ramAddressToString(n);
                }
                return debugger.getRamCoverage(n);
            }

            @Override
            public int getRowCount() {
                return debugger.getRAMlength();
            }

            @Override
            public int getColumnCount() {
                return this.COLUMN_NAMES.length;
            }

            @Override
            public String getColumnName(int n) {
                return this.COLUMN_NAMES[n];
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 1) {
                    return Long.class;
                }
                return super.getColumnClass(n);
            }
        };
        return this.createCoverageTable(this.tableModels[1]);
    }

    static boolean isRowSelected(JTable jTable, int n) {
        int[] nArray = jTable.getSelectedRows();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            if (n4 == n) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private JTable createCoverageTable(AbstractTableModel abstractTableModel) {
        final JTable jTable = new JTable(abstractTableModel){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setRowHeight(this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
            }

            @Override
            public Color getForeground() {
                return CoverageWindow.this.debugger.getTableForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return CoverageWindow.this.debugger.getTableSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return CoverageWindow.this.debugger.getTableBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return CoverageWindow.this.debugger.getTableSelectionBackground();
            }

            @Override
            public Color getGridColor() {
                Color color = super.getGridColor();
                if (color != null && color.equals(Color.WHITE)) {
                    return Color.GRAY;
                }
                return color;
            }

            @Override
            public Font getFont() {
                return CoverageWindow.this.debugger.getFont();
            }
        };
        jTable.setAutoCreateRowSorter(true);
        jTable.setFillsViewportHeight(true);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = jTable.rowAtPoint(mouseEvent.getPoint());
                    if (!CoverageWindow.isRowSelected(jTable, n)) {
                        jTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    CoverageWindow.this.showPopupMenu(mouseEvent.getPoint(), jTable);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0) {
                    CoverageWindow.this.selectSelectedAddressInDebugger(jTable);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = jTable.rowAtPoint(mouseEvent.getPoint());
                    if (!CoverageWindow.isRowSelected(jTable, n)) {
                        jTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    CoverageWindow.this.showPopupMenu(mouseEvent.getPoint(), jTable);
                }
            }
        });
        Dimension dimension = jTable.getCellRenderer(0, 0).getTableCellRendererComponent(jTable, jTable.getValueAt(0, 0), false, false, 0, 0).getPreferredSize();
        int n = dimension.width + jTable.getIntercellSpacing().width;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n + jTable.getIntercellSpacing().width);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(n + jTable.getIntercellSpacing().width);
        return jTable;
    }

    public static void update() {
        CoverageWindow.update(true);
    }

    public static void update(boolean bl) {
        if (coverageWindow != null && coverageWindow.isVisible()) {
            JTable jTable;
            int n;
            CoverageWindow.coverageWindow.romSize = CoverageWindow.coverageWindow.debugger.getROMsize();
            if (bl) {
                n = 0;
                while (n < CoverageWindow.coverageWindow.tables.length) {
                    jTable = CoverageWindow.coverageWindow.tables[n];
                    if (jTable.getRowSorter() == null) {
                        jTable.setRowSorter(CoverageWindow.coverageWindow.sorters[n]);
                        CoverageWindow.coverageWindow.sorters[n].allRowsChanged();
                        jTable.getTableHeader().repaint();
                    }
                    jTable.repaint();
                    ++n;
                }
            } else {
                n = 0;
                while (n < CoverageWindow.coverageWindow.tables.length) {
                    jTable = CoverageWindow.coverageWindow.tables[n];
                    if (jTable.getRowSorter() != null) {
                        CoverageWindow.coverageWindow.sorters[n] = jTable.getRowSorter();
                        jTable.setRowSorter(null);
                        jTable.getTableHeader().repaint();
                    }
                    jTable.repaint();
                    ++n;
                }
            }
            JPanel[] jPanelArray = CoverageWindow.coverageWindow.overviews;
            int n2 = CoverageWindow.coverageWindow.overviews.length;
            int n3 = 0;
            while (n3 < n2) {
                CoverageOverview coverageOverview = jPanelArray[n3];
                coverageOverview.repaint();
                ++n3;
            }
            jPanelArray = CoverageWindow.coverageWindow.boards;
            n2 = CoverageWindow.coverageWindow.boards.length;
            n3 = 0;
            while (n3 < n2) {
                JPanel jPanel = jPanelArray[n3];
                jPanel.repaint();
                ++n3;
            }
        }
    }

    void showPopupMenu(Point point, final JTable jTable) {
        try {
            final int n = jTable.convertRowIndexToModel(jTable.getSelectedRow());
            final Debugger debugger = this.debugger;
            final JTable[] jTableArray = this.tables;
            final CoverageOverview[] coverageOverviewArray = this.overviews;
            final CoverageBoard[] coverageBoardArray = this.boards;
            JPopupMenu jPopupMenu = new JPopupMenu();
            MenuItem menuItem = new MenuItem("Select in Debugger");
            jPopupMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTable == jTableArray[0]) {
                        debugger.setSelectedAddress(n);
                    } else {
                        debugger.setSelectedRAMaddress(n);
                    }
                }
            });
            menuItem = new MenuItem("Select in Memory Editor");
            jPopupMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTable == jTableArray[0]) {
                        debugger.openROMaddressInMemoryEditor(n, n);
                    } else {
                        debugger.openRAMaddressInMemoryEditor(n, n);
                    }
                }
            });
            menuItem = new MenuItem("Reset");
            jPopupMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTable == jTableArray[0]) {
                        int[] nArray = CoverageWindow.getSelectedAddresses(jTable);
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int n3 = nArray[n2];
                            debugger.resetROMcoverage(n3);
                            ++n2;
                        }
                        coverageOverviewArray[0].repaint();
                        coverageBoardArray[0].repaint();
                    } else {
                        int[] nArray = CoverageWindow.getSelectedAddresses(jTable);
                        int n = nArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            int n5 = nArray[n4];
                            debugger.resetRAMcoverage(n5);
                            ++n4;
                        }
                        coverageOverviewArray[1].repaint();
                        coverageBoardArray[1].repaint();
                    }
                    jTable.repaint();
                }
            });
            final boolean bl = jTable == jTableArray[0] && debugger.isROMcoverageExcluded(n) || jTable == jTableArray[1] && debugger.isRAMcoverageExcluded(n);
            menuItem = new MenuItem(bl ? "Include" : "Exclude");
            jPopupMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTable == jTableArray[0]) {
                        int[] nArray = CoverageWindow.getSelectedAddresses(jTable);
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int n3 = nArray[n2];
                            debugger.setExcludedFromROMcoverage(n3, !bl);
                            ++n2;
                        }
                    } else {
                        int[] nArray = CoverageWindow.getSelectedAddresses(jTable);
                        int n = nArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            int n5 = nArray[n4];
                            debugger.setExcludedFromRAMcoverage(n5, !bl);
                            ++n4;
                        }
                    }
                    jTable.repaint();
                }
            });
            if (jTable == jTableArray[1]) {
                menuItem = new MenuItem("Watch");
                jPopupMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RAMWatchWindow.open(CoverageWindow.this.owner, debugger, debugger.asExpression(n).wrapInRead(), false);
                    }
                });
            }
            jPopupMenu.show(jTable, point.x, point.y);
        }
        catch (Exception exception) {}
    }

    void selectSelectedAddressInDebugger(JTable jTable) {
        int n = jTable.convertRowIndexToModel(jTable.getSelectedRow());
        Debugger debugger = this.debugger;
        JTable[] jTableArray = this.tables;
        if (jTable == jTableArray[0]) {
            debugger.setSelectedAddress(n);
        } else {
            debugger.setSelectedRAMaddress(n);
        }
    }

    static int[] getSelectedAddresses(JTable jTable) {
        int[] nArray = jTable.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = jTable.convertRowIndexToModel(nArray[n]);
            ++n;
        }
        return nArray;
    }

    public static void open(Window window, Debugger debugger, boolean bl) {
        if (coverageWindow == null) {
            coverageWindow = new CoverageWindow(window, debugger, Emulicious.isUseFrames());
        }
        if (!bl || !coverageWindow.isVisible()) {
            coverageWindow.setVisible(true);
        }
    }

    public static void close() {
        if (coverageWindow != null) {
            Emulicious.getProperties().setProperty("Window" + coverageWindow.getClass().getSimpleName() + "Open", "" + coverageWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + coverageWindow.getClass().getSimpleName() + "X", "" + coverageWindow.getX());
            Emulicious.getProperties().setProperty("Window" + coverageWindow.getClass().getSimpleName() + "Y", "" + coverageWindow.getY());
            Emulicious.getProperties().setProperty("Window" + coverageWindow.getClass().getSimpleName() + "Width", "" + coverageWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + coverageWindow.getClass().getSimpleName() + "Height", "" + coverageWindow.getHeight());
            coverageWindow.dispose();
            coverageWindow = null;
        }
    }

    private class CoverageBoard
    extends JPanel {
        private final Debugger debugger;
        private final JTable table;
        private final boolean ram;
        private CoverageOverview overview;
        private int start;

        public CoverageBoard(Debugger debugger, final JTable jTable, boolean bl) {
            this.debugger = debugger;
            this.table = jTable;
            this.ram = bl;
            final boolean[] blArray = new boolean[1];
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.handleMouseEvent(mouseEvent);
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    this.handleMouseEvent(mouseEvent);
                }

                private void handleMouseEvent(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        int n = CoverageBoard.this.columnAt(mouseEvent.getX());
                        if (n < 0) {
                            return;
                        }
                        int n2 = jTable.convertRowIndexToView(CoverageBoard.this.toRow(n));
                        blArray[0] = true;
                        jTable.getSelectionModel().setSelectionInterval(n2, n2);
                        blArray[0] = false;
                        jTable.scrollRectToVisible(jTable.getCellRect(n2, 0, true));
                    }
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (jTable.getSelectedRow() < 0) {
                        return;
                    }
                    if (!blArray[0]) {
                        CoverageBoard.this.setStart(jTable.convertRowIndexToModel(jTable.getSelectedRow()) - CoverageBoard.this.getWidth() / 2);
                    } else {
                        CoverageBoard.this.repaint();
                    }
                }
            });
        }

        public void setOverview(CoverageOverview coverageOverview) {
            this.overview = coverageOverview;
        }

        public void setStart(int n) {
            if (n < 0) {
                n = 0;
            }
            if (n + this.getWidth() > this.table.getRowCount()) {
                n = this.table.getRowCount() - this.getWidth();
            }
            this.start = n;
            this.repaint();
        }

        public int getStart() {
            return this.start;
        }

        public int getColumnCount() {
            return this.getWidth();
        }

        public int columnAt(int n) {
            return n;
        }

        public int toRow(int n) {
            if (n < 0) {
                return -1;
            }
            return this.start + n;
        }

        private void paintColumn(Graphics graphics, int n, Color color) {
            if (color == null) {
                color = Color.BLACK;
            }
            graphics.setColor(color);
            graphics.fillRect(n, 0, 1, this.getHeight());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            super.paintComponent(graphics);
            if (this.start + this.getWidth() > this.table.getRowCount()) {
                this.start = this.table.getRowCount() - this.getWidth();
                if (this.overview != null) {
                    this.overview.repaint();
                }
            }
            int n2 = this.getColumnCount();
            int n3 = 0;
            while (n3 < n2) {
                n = this.toRow(n3 + 1);
                long l = 0L;
                int n4 = -1;
                int n5 = this.toRow(n3);
                while (n5 < n) {
                    long l2 = (Long)this.table.getValueAt(this.table.convertRowIndexToView(n5), 1);
                    if (l2 > l) {
                        l = l2;
                        n4 = n5;
                    }
                    ++n5;
                }
                this.paintColumn(graphics, n3, this.debugger.getCoverageColor(n4, this.ram));
                ++n3;
            }
            n3 = this.table.getSelectedRow();
            if (n3 >= 0 && (n = this.table.convertRowIndexToModel(n3) - this.start) >= 0 && n < this.getWidth()) {
                graphics.setColor(new Color(-1056964609, true));
                graphics.fillRect(n, 0, 1, this.getHeight());
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(Math.min(this.table.getRowCount(), 16384), 48);
        }
    }

    private class CoverageOverview
    extends JPanel {
        private final Debugger debugger;
        private final JTable table;
        private final CoverageBoard board;
        private final boolean ram;
        private float factor;

        public CoverageOverview(Debugger debugger, JTable jTable, final CoverageBoard coverageBoard, boolean bl) {
            this.debugger = debugger;
            this.table = jTable;
            this.board = coverageBoard;
            this.ram = bl;
            coverageBoard.setOverview(this);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.handleMouseEvent(mouseEvent);
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    this.handleMouseEvent(mouseEvent);
                }

                private void handleMouseEvent(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        int n = CoverageOverview.this.columnAt(mouseEvent.getX());
                        if (n < 0) {
                            return;
                        }
                        coverageBoard.setStart(CoverageOverview.this.toRow(n));
                        CoverageOverview.this.repaint();
                    }
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
        }

        private int getColumnCount() {
            return this.getWidth();
        }

        public int columnAt(int n) {
            return n;
        }

        public int toRow(int n) {
            if (n < 0) {
                return -1;
            }
            return (int)((float)n * this.factor);
        }

        private int toColumn(int n) {
            if (n < 0) {
                return -1;
            }
            return (int)((float)n / this.factor);
        }

        private void paintColumn(Graphics graphics, int n, Color color) {
            if (color == null) {
                color = Color.BLACK;
            }
            graphics.setColor(color);
            graphics.fillRect(n, 0, 1, this.getHeight());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getColumnCount();
            this.factor = (float)this.table.getRowCount() / (float)n;
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.toRow(n2 + 1);
                long l = 0L;
                int n4 = -1;
                int n5 = this.toRow(n2);
                while (n5 < n3) {
                    long l2 = (Long)this.table.getValueAt(this.table.convertRowIndexToView(n5), 1);
                    if (l2 > l) {
                        l = l2;
                        n4 = n5;
                    }
                    ++n5;
                }
                this.paintColumn(graphics, n2, this.debugger.getCoverageColor(n4, this.ram));
                ++n2;
            }
            graphics.setColor(new Color(-2130706433, true));
            graphics.fillRect(this.toColumn(this.board.getStart()), 1, this.toColumn(this.board.getStart() + this.board.getWidth()) - this.toColumn(this.board.getStart()), this.getHeight() - 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(Math.min(this.table.getRowCount(), 16384), 48);
        }
    }
}

