/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import common.FileChooser;
import common.ScreenUtilities;
import expressions.ParseException;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.BadLocationException;
import platform.Emulicious;
import platform.debugger.Debugger;
import platform.debugger.IsConstantException;
import platform.debugger.SystemDebugger;
import system.EmulatableSystem;
import util.map.IntMap;
import util.queue.CyclicIntStack;

class TracerWindow {
    private static TracerWindow tracerWindow;
    Debugger debugger;
    final Window window;
    private JTextArea console = new JTextArea(10, 80);
    private ArrayDeque<TracerEntry> entries;
    private CyclicIntStack addresses;
    private int count = 0;
    private boolean shouldTrace;
    private boolean tracing;
    private boolean hideInterruptCode;
    private boolean showInterruptCodeOnly;
    private boolean traceBranchesOnly;
    String format = "";
    private JButton startButton = new JButton("Start Tracing");
    private final JButton buttonFile;
    private final JCheckBox checkBoxWriteToFile = new JCheckBox("Write Trace Log to File");
    private final JCheckBox checkBoxCompress = new JCheckBox("Compressed");
    final JCheckBox checkBoxAddress = new JCheckBox("Address");
    final JCheckBox checkBoxInstructions = new JCheckBox("Instructions");
    private final JCheckBox checkBoxLabels = new JCheckBox("Labels");
    private final JCheckBox checkBoxEmptyLines = new JCheckBox("Empty lines after branches");
    private final JCheckBox checkBoxInterrupts = new JCheckBox("Interrupt Messages");
    private final JCheckBox checkBoxBreakpoints = new JCheckBox("Breakpoint Messages");
    final JCheckBox checkBoxIncludeExpression = new JCheckBox("Include Expression in log");
    private final JPanel checkBoxesRegisters = new JPanel();
    JCheckBox[] registers;
    private JTextField textFieldFile = new JTextField("", 25);
    private JTextField textFieldStart = new JTextField("", 15);
    private JTextField textFieldEnd = new JTextField("", 15);
    private JTextField textFieldCondition = new JTextField("", 15);
    private JTextField textFieldMaxLines = new JTextField("", 8);
    JTextField textFieldAdditionalExpression = new JTextField("", 25);
    private JRadioButton radioButtonShowAllCode = new JRadioButton("Show all code");
    private JRadioButton radioButtonHideInterruptCode = new JRadioButton("Hide interrupt code");
    private JRadioButton radioButtonShowInterruptCodeOnly = new JRadioButton("Show interrupt code only");
    private int maxLines;
    private Debugger.Expression startCondition;
    private Debugger.Expression traceCondition;
    private Debugger.Expression endCondition;
    Debugger.Expression additionalExpression;
    private Set<String> additionalExpressionVariables;
    private Set<Debugger.Expression> additionalExpressionReadLocations;
    private JRadioButton radioButtonTraceAllInstructions = new JRadioButton("Trace all code");
    private JRadioButton radioButtonTraceBranchesOnly = new JRadioButton("Trace branches only");
    private boolean isBranch;
    private boolean wasBranch;
    private PrintStream out;
    private File outFile;
    private ActionListener actionListener;
    private static TracerEntry prevEntry;

    private TracerWindow(Window window, Debugger debugger, SystemDebugger systemDebugger, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Trace Logger");
        this.window.setIconImages(window.getIconImages());
        this.debugger = debugger;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.window.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TracerWindow.this.toggleTracing();
            }
        });
        JButton jButton = new JButton("Clear Trace");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TracerWindow.this.clearTrace();
                    }
                });
            }
        });
        jPanel3.add(jButton);
        jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, "Center");
        this.checkBoxWriteToFile.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceWriteToFile")));
        jPanel3.add(this.checkBoxWriteToFile);
        this.checkBoxCompress.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceCompress")));
        jPanel3.add(this.checkBoxCompress);
        this.textFieldFile.setText(Emulicious.getProperties().getProperty("TraceFilePath"));
        jPanel3.add(this.textFieldFile);
        this.buttonFile = new JButton(FileSystemView.getFileSystemView().getSystemIcon(this.getTraceLogFile(false).getParentFile()));
        this.buttonFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TracerWindow.this.showWriteTraceLogFileChooser(TracerWindow.this.window);
            }
        });
        jPanel3.add(this.buttonFile);
        jPanel3 = new JPanel();
        jPanel.add((Component)jPanel3, "Center");
        this.textFieldMaxLines.setText(Emulicious.getProperties().getProperty("TraceMaxLines"));
        jPanel3.add(new JLabel("Max Lines:"));
        jPanel3.add(this.textFieldMaxLines);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioButtonHideInterruptCode);
        buttonGroup.add(this.radioButtonShowAllCode);
        buttonGroup.add(this.radioButtonShowInterruptCodeOnly);
        int n = Emulicious.getProperties().getInt("TraceFilterCode");
        this.radioButtonShowAllCode.setSelected(n == 0);
        jPanel3.add(this.radioButtonShowAllCode);
        this.radioButtonHideInterruptCode.setSelected(n == 1);
        jPanel3.add(this.radioButtonHideInterruptCode);
        this.radioButtonShowInterruptCodeOnly.setSelected(n == 2);
        jPanel3.add(this.radioButtonShowInterruptCodeOnly);
        jPanel3 = new JPanel();
        jPanel.add((Component)jPanel3, "South");
        jPanel3.add(new JLabel("Conditions:"));
        this.textFieldStart.setText(Emulicious.getProperties().getProperty("TraceStartCondition"));
        jPanel3.add(new JLabel("Start:"));
        jPanel3.add(this.textFieldStart);
        this.textFieldEnd.setText(Emulicious.getProperties().getProperty("TraceEndCondition"));
        jPanel3.add(new JLabel("End:"));
        jPanel3.add(this.textFieldEnd);
        this.textFieldCondition.setText(Emulicious.getProperties().getProperty("TraceCondition"));
        jPanel3.add(new JLabel("Trace:"));
        jPanel3.add(this.textFieldCondition);
        this.console.setEditable(false);
        this.console.setFont(new Font("Monospaced", this.console.getFont().getStyle(), this.textFieldMaxLines.getFont().getSize()));
        this.window.add((Component)new JScrollPane(this.console), "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.window.add((Component)jPanel4, "South");
        jPanel3 = new JPanel();
        jPanel4.add((Component)jPanel3, "North");
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioButtonTraceAllInstructions);
        buttonGroup.add(this.radioButtonTraceBranchesOnly);
        int n2 = Emulicious.getProperties().getInt("TraceFilterTrace");
        this.radioButtonTraceAllInstructions.setSelected(n2 == 0);
        jPanel3.add(this.radioButtonTraceAllInstructions);
        this.radioButtonTraceBranchesOnly.setSelected(n2 == 1);
        jPanel3.add(this.radioButtonTraceBranchesOnly);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel5.add((Component)jPanel6, "North");
        this.checkBoxAddress.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceAddress")));
        this.checkBoxInstructions.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceInstructions")));
        this.checkBoxLabels.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceLabels")));
        this.checkBoxEmptyLines.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceEmptyLines")));
        this.checkBoxInterrupts.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceInterrupts")));
        this.checkBoxBreakpoints.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceBreakpoints")));
        jPanel6.add(this.checkBoxAddress);
        jPanel6.add(this.checkBoxInstructions);
        jPanel6.add(this.checkBoxLabels);
        jPanel6.add(this.checkBoxEmptyLines);
        jPanel6.add(this.checkBoxInterrupts);
        jPanel6.add(this.checkBoxBreakpoints);
        jPanel5.add((Component)this.checkBoxesRegisters, "Center");
        jPanel4.add((Component)jPanel5, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel4.add((Component)jPanel7, "South");
        this.textFieldAdditionalExpression.setText(Emulicious.getProperties().getProperty("TraceAdditionalExpression"));
        this.textFieldAdditionalExpression.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TracerWindow.this.additionalExpression = null;
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TracerWindow.this.additionalExpression = null;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TracerWindow.this.additionalExpression = null;
            }
        });
        this.checkBoxIncludeExpression.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceIncludeExpression")));
        jPanel7.add(new JLabel("Additional Expression:"));
        jPanel7.add(this.textFieldAdditionalExpression);
        jPanel7.add(this.checkBoxIncludeExpression);
        this.updateSystem(systemDebugger);
        debugger.installRunActions(this.getRootPane());
        if (tracerWindow == null || !tracerWindow.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private JRootPane getRootPane() {
        if (this.window instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.window)).getRootPane();
        }
        return null;
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    public static CyclicIntStack getAddresses() {
        if (tracerWindow == null) {
            return null;
        }
        return TracerWindow.tracerWindow.addresses;
    }

    private void updateSystem(final EmulatableSystem emulatableSystem) {
        boolean bl;
        this.checkBoxesRegisters.removeAll();
        this.checkBoxesRegisters.add(new JLabel("Registers: "));
        if (this.actionListener != null) {
            JCheckBox[] jCheckBoxArray = this.registers;
            boolean bl2 = this.registers.length;
            bl = false;
            while (bl < bl2) {
                JCheckBox jCheckBox = jCheckBoxArray[bl];
                jCheckBox.removeActionListener(this.actionListener);
                bl += 1;
            }
            this.checkBoxAddress.removeActionListener(this.actionListener);
            this.checkBoxInstructions.removeActionListener(this.actionListener);
        }
        this.registers = new JCheckBox[emulatableSystem.getRegisterNames().length];
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TracerWindow.this.updateFormat(emulatableSystem);
            }
        };
        int n = 0;
        while (n < this.registers.length) {
            bl = false;
            if (Emulicious.getProperties().getProperty("TraceRegister" + n) != null) {
                bl = Boolean.parseBoolean(Emulicious.getProperties().getProperty("TraceRegister" + n));
            }
            this.registers[n] = new JCheckBox(emulatableSystem.getRegisterNames()[n], bl);
            this.registers[n].addActionListener(this.actionListener);
            this.checkBoxesRegisters.add(this.registers[n]);
            ++n;
        }
        this.checkBoxesRegisters.revalidate();
        this.checkBoxesRegisters.repaint();
        this.checkBoxAddress.addActionListener(this.actionListener);
        this.checkBoxInstructions.addActionListener(this.actionListener);
        this.updateFormat(emulatableSystem);
    }

    void updateFormat(EmulatableSystem emulatableSystem) {
        this.format = "";
        int n = 0;
        while (n < this.registers.length) {
            if (this.registers[n].isSelected()) {
                this.format = String.valueOf(this.format) + (!this.format.isEmpty() ? " " : "") + emulatableSystem.getRegisterNames()[n] + "=%04X";
            }
            ++n;
        }
        if (this.checkBoxInstructions.isSelected()) {
            this.format = this.format.isEmpty() ? "%s" : "%-32s " + this.format;
        }
    }

    void clearTrace() {
        this.console.setText("");
        this.count = 0;
        prevEntry = null;
        this.clearAddresses();
        this.debugger.updateAnnotations();
    }

    void clearAddresses() {
        this.addresses.fill(Integer.MIN_VALUE);
    }

    void toggleTracing() {
        if (!this.shouldTrace) {
            this.maxLines = -1;
            try {
                this.maxLines = Integer.parseInt(this.textFieldMaxLines.getText());
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.maxLines < 0) {
                this.maxLines = 10000;
                this.textFieldMaxLines.setText("10000");
            }
            if (this.addresses == null || this.maxLines > this.addresses.size() || this.maxLines < this.addresses.size() / 2) {
                this.addresses = new CyclicIntStack(this.maxLines);
                this.clearAddresses();
            }
            this.entries = new ArrayDeque(this.maxLines);
            this.startCondition = null;
            this.traceCondition = null;
            this.endCondition = null;
            this.shouldTrace = true;
            if (!this.textFieldStart.getText().trim().isEmpty()) {
                try {
                    this.startCondition = this.debugger.parseExpression(this.textFieldStart.getText());
                    if (this.startCondition.isConstant()) {
                        throw new IsConstantException(this.startCondition.getValueString());
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.window, "Failed to parse start condition:\n" + exception.getMessage() + "\nThe condition will be ignored.", "Error parsing start condition", 0);
                    this.startCondition = null;
                }
            }
            if (!this.textFieldCondition.getText().trim().isEmpty()) {
                try {
                    this.traceCondition = this.debugger.parseExpression(this.textFieldCondition.getText());
                    if (this.traceCondition.isConstant()) {
                        throw new IsConstantException(this.traceCondition.getValueString());
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.window, "Failed to parse trace condition:\n" + exception.getMessage() + "\nThe condition will be ignored.", "Error parsing trace condition", 0);
                    this.traceCondition = null;
                }
            }
            if (!this.textFieldEnd.getText().trim().isEmpty()) {
                try {
                    this.endCondition = this.debugger.parseExpression(this.textFieldEnd.getText());
                    if (this.endCondition.isConstant()) {
                        throw new IsConstantException(this.endCondition.getValueString());
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.window, "Failed to parse end condition:\n" + exception.getMessage() + "\nThe condition will be ignored.", "Error parsing end condition", 0);
                    this.endCondition = null;
                }
            }
            if (this.additionalExpression == null) {
                this.additionalExpressionVariables = null;
                this.additionalExpressionReadLocations = null;
                if (!this.textFieldAdditionalExpression.getText().trim().isEmpty()) {
                    try {
                        this.additionalExpression = this.debugger.parseConcatenatedExpression(this.textFieldAdditionalExpression.getText());
                        this.additionalExpressionVariables = this.additionalExpression.getVariableNames();
                        this.additionalExpressionReadLocations = this.additionalExpression.getReadLocations();
                    }
                    catch (ParseException parseException) {
                        JOptionPane.showMessageDialog(this.window, "Failed to parse additional expression:\n" + parseException.getMessage(), "Error parsing additional expression", 0);
                        this.debugger.suspend();
                        this.shouldTrace = false;
                    }
                    catch (UnknownVariableException unknownVariableException) {
                        JOptionPane.showMessageDialog(this.window, unknownVariableException.getMessage(), "Unknown variable in additional expression", 0);
                        this.debugger.suspend();
                        this.additionalExpression = null;
                        this.shouldTrace = false;
                    }
                }
            }
            this.hideInterruptCode = this.radioButtonHideInterruptCode.isSelected();
            this.showInterruptCodeOnly = this.radioButtonShowInterruptCodeOnly.isSelected();
            this.traceBranchesOnly = this.radioButtonTraceBranchesOnly.isSelected();
            if (this.checkBoxWriteToFile.isSelected()) {
                File file = this.getTraceLogFile(this.checkBoxCompress.isSelected());
                try {
                    if (this.out != null) {
                        if (!this.outFile.equals(file)) {
                            this.out.close();
                            this.out = null;
                        } else {
                            this.out.flush();
                        }
                    }
                    if (this.out == null) {
                        this.out = this.checkBoxCompress.isSelected() ? new PrintStream(new GZIPOutputStream(new FileOutputStream(file))) : new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                        this.outFile = file;
                        this.textFieldFile.setText(this.getTraceLogFile(false).getPath());
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.window, "Failed to create log file:\n" + iOException.getMessage(), "Error Creating Log File", 0);
                    this.debugger.suspend();
                    this.shouldTrace = false;
                }
            }
        } else {
            this.shouldTrace = false;
            this.tracing = false;
            TracerWindow.update();
        }
        if (this.shouldTrace) {
            this.startButton.setText("Stop Tracing");
        } else {
            this.startButton.setText("Start Tracing");
        }
        this.checkBoxWriteToFile.setEnabled(!this.shouldTrace);
        this.checkBoxCompress.setEnabled(!this.shouldTrace);
        this.textFieldFile.setEnabled(!this.shouldTrace);
        this.buttonFile.setEnabled(!this.shouldTrace);
        this.textFieldMaxLines.setEnabled(!this.shouldTrace);
        this.textFieldStart.setEnabled(!this.shouldTrace);
        this.textFieldEnd.setEnabled(!this.shouldTrace);
        this.textFieldCondition.setEnabled(!this.shouldTrace);
        this.textFieldAdditionalExpression.setEnabled(!this.shouldTrace);
        this.radioButtonHideInterruptCode.setEnabled(!this.shouldTrace);
        this.radioButtonShowAllCode.setEnabled(!this.shouldTrace);
        this.radioButtonShowInterruptCodeOnly.setEnabled(!this.shouldTrace);
        this.radioButtonTraceAllInstructions.setEnabled(!this.shouldTrace);
        this.radioButtonTraceBranchesOnly.setEnabled(!this.shouldTrace);
    }

    private void appendEntry(int n, int n2, String string, boolean bl, int[] nArray) {
        if (!this.tracing && this.isStartConditionMet()) {
            this.tracing = true;
        }
        this.wasBranch = this.isBranch;
        this.isBranch = bl;
        if (this.shouldTrace()) {
            TracerEntry tracerEntry;
            TracerEntry tracerEntry2 = null;
            if (!this.entries.isEmpty()) {
                tracerEntry2 = this.entries.getLast();
            }
            try {
                tracerEntry = new TracerEntry(n, n2, string, nArray, this.additionalExpression, this.debugger.getVariableValues(this.additionalExpressionVariables), this.debugger.readValues(this.additionalExpressionReadLocations));
            }
            catch (UnknownVariableException unknownVariableException) {
                tracerEntry = new TracerEntry(n, n2, string, nArray);
            }
            if (!tracerEntry.equals(tracerEntry2)) {
                this.entries.add(tracerEntry);
                if (this.out != null && this.checkBoxWriteToFile.isSelected()) {
                    String string2;
                    int n3;
                    if (TracerWindow.tracerWindow.checkBoxEmptyLines.isSelected() && tracerEntry2 != null && ((n3 = tracerEntry.address - tracerEntry2.address) < 0 || n3 > 4)) {
                        this.out.println();
                    }
                    if (TracerWindow.tracerWindow.checkBoxLabels.isSelected() && (tracerEntry2 == null || tracerEntry.address != tracerEntry2.address) && (string2 = TracerWindow.tracerWindow.debugger.getLabel(tracerEntry.traceAddress)) != null) {
                        this.out.println(String.valueOf(string2) + ":");
                    }
                    this.out.println(tracerEntry);
                }
                if (n2 != -1) {
                    this.addresses.add(n2);
                }
                if (this.count < this.maxLines) {
                    ++this.count;
                } else {
                    this.entries.removeFirst();
                }
            }
        }
        if (this.tracing && this.isEndConditionMet()) {
            this.tracing = false;
        }
    }

    private void appendInterruptEntry(boolean bl) {
        if (bl) {
            this.appendMessageEntry("==== Interrupt Exited ====");
        } else {
            this.appendMessageEntry("==== Interrupt Taken ====");
        }
    }

    private void appendMessageEntry(String string) {
        this.appendEntry(new MessageTracerEntry(string));
    }

    private void appendMessageEntry(int n, int n2, String string) {
        this.appendEntry(new MessageTracerEntry(n, n2, string));
    }

    private void appendEntry(TracerEntry tracerEntry) {
        if (this.shouldTrace()) {
            this.entries.add(tracerEntry);
            if (this.out != null && this.checkBoxWriteToFile.isSelected()) {
                this.out.println(tracerEntry);
            }
            if (this.count < this.maxLines) {
                ++this.count;
            } else {
                this.entries.removeFirst();
            }
        }
    }

    private boolean shouldTrace() {
        if (!this.tracing) {
            return false;
        }
        if (this.hideInterruptCode && this.debugger.isExecutingInterrupt()) {
            return false;
        }
        if (this.showInterruptCodeOnly && !this.debugger.isExecutingInterrupt()) {
            return false;
        }
        if (this.traceBranchesOnly && !this.isBranch && !this.wasBranch) {
            return false;
        }
        return this.isTraceConditionMet();
    }

    private boolean isStartConditionMet() {
        if (this.startCondition != null) {
            try {
                return this.startCondition.isTrue();
            }
            catch (UnknownVariableException unknownVariableException) {}
        }
        return true;
    }

    private boolean isTraceConditionMet() {
        if (this.traceCondition != null) {
            try {
                return this.traceCondition.isTrue();
            }
            catch (UnknownVariableException unknownVariableException) {}
        }
        return true;
    }

    private boolean isEndConditionMet() {
        if (this.endCondition != null) {
            try {
                return this.endCondition.isTrue();
            }
            catch (UnknownVariableException unknownVariableException) {}
        }
        return false;
    }

    void showWriteTraceLogFileChooser(Component component) {
        File file = this.getTraceLogFile(false);
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(".");
        }
        FileChooser fileChooser = new FileChooser(file2);
        fileChooser.setDialogTitle("Save Trace Log To...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Text files (*.txt)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".txt") || file.isDirectory();
            }
        });
        fileChooser.setSelectedFile(file);
        if (fileChooser.showSaveDialog(component) == 0) {
            this.textFieldFile.setText(fileChooser.getSelectedFile().getPath());
        }
    }

    private File getTraceLogFile(boolean bl) {
        File file = new File(!this.textFieldFile.getText().isEmpty() ? this.textFieldFile.getText() : "log.txt");
        if (file.getParentFile() == null) {
            file = new File(".", file.getPath());
        }
        if (bl) {
            file = new File(file.getParentFile(), String.valueOf(file.getName()) + ".gz");
        }
        return file;
    }

    public static void append(boolean bl) {
        if (tracerWindow != null && TracerWindow.tracerWindow.checkBoxInterrupts.isSelected()) {
            tracerWindow.appendInterruptEntry(bl);
        }
    }

    public static void append(int n, int n2, String string) {
        if (tracerWindow != null) {
            tracerWindow.appendMessageEntry(n, n2, string);
        }
    }

    public static void appendBreakpointMessage(int n, int n2, String string) {
        if (tracerWindow != null && TracerWindow.tracerWindow.checkBoxBreakpoints.isSelected()) {
            TracerWindow.append(n, n2, string);
        }
    }

    public static void append(int n, int n2, String string, boolean bl, int[] nArray) {
        if (tracerWindow != null) {
            tracerWindow.appendEntry(n, n2, string, bl, nArray);
        }
    }

    public static void update() {
        if (tracerWindow != null && TracerWindow.tracerWindow.entries != null && tracerWindow.isVisible()) {
            while (!TracerWindow.tracerWindow.entries.isEmpty()) {
                String string;
                int n;
                TracerEntry tracerEntry = TracerWindow.tracerWindow.entries.removeFirst();
                if (TracerWindow.tracerWindow.checkBoxEmptyLines.isSelected() && prevEntry != null && ((n = tracerEntry.address - TracerWindow.prevEntry.address) < 0 || n > 4)) {
                    TracerWindow.tracerWindow.console.append("\n");
                }
                if (TracerWindow.tracerWindow.checkBoxLabels.isSelected() && (prevEntry == null || tracerEntry.address != TracerWindow.prevEntry.address) && (string = TracerWindow.tracerWindow.debugger.getLabel(tracerEntry.traceAddress)) != null) {
                    TracerWindow.tracerWindow.console.append(String.valueOf(string) + ":\n");
                }
                TracerWindow.tracerWindow.console.append(tracerEntry + "\n");
                prevEntry = tracerEntry;
            }
            int n = TracerWindow.tracerWindow.console.getLineCount();
            if (n > TracerWindow.tracerWindow.maxLines) {
                try {
                    TracerWindow.tracerWindow.console.replaceRange("", 0, TracerWindow.tracerWindow.console.getLineStartOffset(n - TracerWindow.tracerWindow.maxLines - 1));
                }
                catch (BadLocationException badLocationException) {}
            }
            TracerWindow.tracerWindow.console.setCaretPosition(TracerWindow.tracerWindow.console.getDocument().getLength());
            TracerWindow.tracerWindow.count = 0;
            if (TracerWindow.tracerWindow.out != null && TracerWindow.tracerWindow.checkBoxWriteToFile.isSelected()) {
                TracerWindow.tracerWindow.out.flush();
            }
        }
    }

    public static boolean isTracing() {
        return tracerWindow != null && TracerWindow.tracerWindow.shouldTrace;
    }

    public static void startTracing(Window window, Debugger debugger, SystemDebugger systemDebugger, String string) {
        TracerWindow.open(window, debugger, systemDebugger, false);
        TracerWindow.tracerWindow.shouldTrace = false;
        TracerWindow.tracerWindow.textFieldStart.setText("address = " + string);
        tracerWindow.toggleTracing();
    }

    public static void open(Window window, Debugger debugger, SystemDebugger systemDebugger, boolean bl) {
        if (tracerWindow == null) {
            tracerWindow = new TracerWindow(window, debugger, systemDebugger, Emulicious.isUseFrames());
            tracerWindow.setVisible(true);
        } else if (!bl) {
            tracerWindow.setVisible(true);
        }
        if (systemDebugger.isSuspended()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TracerWindow.update();
                }
            });
        }
    }

    public static void updateModel(EmulatableSystem emulatableSystem) {
        if (tracerWindow != null) {
            tracerWindow.updateSystem(emulatableSystem);
        }
    }

    public static void close() {
        if (tracerWindow != null) {
            Emulicious.getProperties().setProperty("TraceWriteToFile", "" + TracerWindow.tracerWindow.checkBoxWriteToFile.isSelected());
            Emulicious.getProperties().setProperty("TraceCompress", "" + TracerWindow.tracerWindow.checkBoxCompress.isSelected());
            Emulicious.getProperties().setProperty("TraceFilePath", TracerWindow.tracerWindow.textFieldFile.getText());
            if (TracerWindow.tracerWindow.checkBoxAddress.isSelected()) {
                Emulicious.getProperties().remove("TraceAddress");
            } else {
                Emulicious.getProperties().setProperty("TraceAddress", "false");
            }
            if (TracerWindow.tracerWindow.checkBoxInstructions.isSelected()) {
                Emulicious.getProperties().remove("TraceInstructions");
            } else {
                Emulicious.getProperties().setProperty("TraceInstructions", "false");
            }
            if (TracerWindow.tracerWindow.checkBoxLabels.isSelected()) {
                Emulicious.getProperties().remove("TraceLabels");
            } else {
                Emulicious.getProperties().setProperty("TraceLabels", "false");
            }
            if (TracerWindow.tracerWindow.checkBoxEmptyLines.isSelected()) {
                Emulicious.getProperties().remove("TraceEmptyLines");
            } else {
                Emulicious.getProperties().setProperty("TraceEmptyLines", "false");
            }
            if (TracerWindow.tracerWindow.checkBoxInterrupts.isSelected()) {
                Emulicious.getProperties().remove("TraceInterrups");
            } else {
                Emulicious.getProperties().setProperty("TraceInterrupts", "false");
            }
            if (TracerWindow.tracerWindow.checkBoxBreakpoints.isSelected()) {
                Emulicious.getProperties().remove("TraceBreakpoints");
            } else {
                Emulicious.getProperties().setProperty("TraceBreakpoints", "false");
            }
            if (TracerWindow.tracerWindow.checkBoxIncludeExpression.isSelected()) {
                Emulicious.getProperties().setProperty("TraceIncludeExpression", "true");
            } else {
                Emulicious.getProperties().remove("TraceIncludeExpression");
            }
            int n = 0;
            while (n < TracerWindow.tracerWindow.registers.length) {
                if (TracerWindow.tracerWindow.registers[n].isSelected()) {
                    Emulicious.getProperties().setProperty("TraceRegister" + n, "true");
                } else {
                    Emulicious.getProperties().remove("TraceRegister" + n);
                }
                ++n;
            }
            Emulicious.getProperties().setProperty("TraceMaxLines", TracerWindow.tracerWindow.textFieldMaxLines.getText());
            Emulicious.getProperties().setProperty("TraceStartCondition", TracerWindow.tracerWindow.textFieldStart.getText());
            Emulicious.getProperties().setProperty("TraceCondition", TracerWindow.tracerWindow.textFieldCondition.getText());
            Emulicious.getProperties().setProperty("TraceEndCondition", TracerWindow.tracerWindow.textFieldEnd.getText());
            Emulicious.getProperties().setProperty("TraceAdditionalExpression", TracerWindow.tracerWindow.textFieldAdditionalExpression.getText());
            n = 0;
            if (TracerWindow.tracerWindow.radioButtonHideInterruptCode.isSelected()) {
                n = 1;
            }
            if (TracerWindow.tracerWindow.radioButtonShowInterruptCodeOnly.isSelected()) {
                n = 2;
            }
            Emulicious.getProperties().setProperty("TraceFilterCode", "" + n);
            int n2 = 0;
            if (TracerWindow.tracerWindow.radioButtonTraceBranchesOnly.isSelected()) {
                n2 = 1;
            }
            Emulicious.getProperties().setProperty("TraceFilterTrace", "" + n2);
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "Open", "" + tracerWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "X", "" + tracerWindow.getX());
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "Y", "" + tracerWindow.getY());
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "Width", "" + tracerWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "Height", "" + tracerWindow.getHeight());
            if (TracerWindow.tracerWindow.out != null) {
                TracerWindow.tracerWindow.out.close();
            }
            tracerWindow.dispose();
            tracerWindow = null;
        }
    }

    private class MessageTracerEntry
    extends TracerEntry {
        private final String message;

        public MessageTracerEntry(int n, int n2, String string) {
            super(n, n2, null, null);
            this.message = string;
        }

        public MessageTracerEntry(String string) {
            this(-1, -1, string);
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }

        @Override
        public String toString() {
            if (this.address >= 0) {
                return String.valueOf(this.addressToString()) + ": " + this.message;
            }
            return this.message;
        }
    }

    private class TracerEntry {
        protected final int address;
        private final int traceAddress;
        private final String instruction;
        private final int[] regValues;
        private final Debugger.Expression expression;
        private final HashMap<String, Integer> expressionVariables;
        private final VariableProvider variables;

        public TracerEntry(int n, int n2, String string, int[] nArray, Debugger.Expression expression, final HashMap<String, Integer> hashMap, final IntMap intMap) {
            this.address = n;
            this.traceAddress = n2;
            this.instruction = string;
            this.regValues = nArray;
            this.expression = expression;
            this.expressionVariables = hashMap;
            this.variables = new VariableProvider(){

                @Override
                public int readValue(int n, boolean bl, boolean bl2) {
                    return intMap.get(n);
                }

                @Override
                public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
                    return intMap.get(n);
                }

                @Override
                public int getBankAt(int n) {
                    return 0;
                }

                @Override
                public long getValue(String string, boolean bl) throws UnknownVariableException {
                    return ((Integer)hashMap.get(string)).intValue();
                }

                @Override
                public long mapBank(int n, int n2) {
                    return ((TracerEntry)TracerEntry.this).TracerWindow.this.debugger.mapAddress(n, n2);
                }

                @Override
                public boolean isConstant(String string) throws UnknownVariableException {
                    return true;
                }

                @Override
                public boolean isConstantRead(int n) {
                    return true;
                }
            };
        }

        public TracerEntry(int n, int n2, String string, int[] nArray) {
            this(n, n2, string, nArray, null, null, null);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.address;
            n = 31 * n + Arrays.hashCode(this.regValues);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TracerEntry tracerEntry = (TracerEntry)object;
            if (this.address != tracerEntry.address) {
                return false;
            }
            return Arrays.equals(this.regValues, tracerEntry.regValues);
        }

        protected String addressToString() {
            return TracerWindow.this.debugger.virtualAddressToString(this.address);
        }

        public String toString() {
            String string;
            ArrayList<Object> arrayList = new ArrayList<Object>(TracerWindow.this.registers.length);
            String string2 = string = TracerWindow.this.checkBoxAddress.isSelected() ? String.valueOf(this.addressToString()) + TracerWindow.this.format : TracerWindow.this.format;
            if (TracerWindow.this.checkBoxInstructions.isSelected()) {
                arrayList.add(this.instruction);
            }
            int n = 0;
            while (n < TracerWindow.this.registers.length) {
                if (TracerWindow.this.registers[n].isSelected()) {
                    arrayList.add(this.regValues[n]);
                }
                ++n;
            }
            if (this.expressionVariables != null) {
                return String.format(String.valueOf(string) + (TracerWindow.this.checkBoxIncludeExpression.isSelected() ? "   " + TracerWindow.this.textFieldAdditionalExpression.getText() + " = " : "   ") + this.expression.getValueString(this.variables), arrayList.toArray());
            }
            return String.format(string, arrayList.toArray());
        }
    }
}

