/*
 * Decompiled with CFR 0.152.
 */
package platform.viewers;

import common.CheckBoxMenuItem;
import common.ClickableJLabel;
import common.MacUtilities;
import common.ScreenUtilities;
import common.WindowsUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import output.TilesetRenderer;
import output.ViewerCache;
import platform.DisplayWindow;
import platform.Emulicious;
import platform.MemoryTracer;
import platform.MemoryTracerWindow;
import platform.viewers.PaletteViewer;
import platform.viewers.VideoViewer;
import platform.viewers.ViewerWindow;

public class TileViewer {
    static TilesetRenderer tilesetRenderer;
    static final Cursor HAND_CURSOR;
    static final Cursor DEFAULT_CURSOR;
    final Window owner;
    final Window window;
    final ViewerWindow viewerWindow = new ViewerWindow();
    private final ViewerWindow tileWindow = new ViewerWindow();
    final JCheckBox autoRefresh = new JCheckBox("Auto Refresh");
    private final ClickableJLabel index = new ClickableJLabel("0 ($0)"){

        @Override
        protected boolean canClick(int n) {
            return true;
        }

        @Override
        protected void indexClicked(int n) {
            Emulicious.openMemoryEditorVRAM(tilesetRenderer.getTileVRAMaddress(TileViewer.this.getIndex()));
        }
    };
    private final JComboBox<String> paletteSelection;
    private final JRadioButton[] buttons8x16 = new JRadioButton[2];
    private final MemoryTracerWindow.SourceLabel source = MemoryTracerWindow.createSourceLabel();
    int selectedTile;
    private long[] sources;
    private final ViewerCache viewerCache = new ViewerCache();
    int highlightedPixel = -1;
    int selectedPixel = -1;
    static TileViewer viewer;
    private final Timer refreshTimer = new Timer(50, new ActionListener(){
        private int exceptionCounter;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TileViewer.refresh();
                this.exceptionCounter = 0;
            }
            catch (RuntimeException runtimeException) {
                if (++this.exceptionCounter >= 2) {
                    TileViewer.this.autoRefresh.setSelected(false);
                    throw runtimeException;
                }
                runtimeException.printStackTrace();
            }
        }
    });

    static {
        HAND_CURSOR = Cursor.getPredefinedCursor(12);
        DEFAULT_CURSOR = Cursor.getDefaultCursor();
    }

    private TileViewer(Window window, boolean bl) {
        Component component;
        this.window = bl ? new JFrame() : new JDialog();
        this.owner = window;
        final ViewerWindow viewerWindow = this.viewerWindow;
        final ViewerWindow viewerWindow2 = this.tileWindow;
        final Timer timer = this.refreshTimer;
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Tile Viewer");
        this.window.setIconImages(window.getIconImages());
        ButtonGroup buttonGroup = new ButtonGroup();
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TileViewer.refresh();
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.paletteSelection = new JComboBox<String>(tilesetRenderer.getPaletteNames()){
            private final JList<String> DUMMY_LIST;
            {
                this.DUMMY_LIST = new JList();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (!MacUtilities.isMacOS() && !WindowsUtilities.isWindows()) {
                    dimension.height = this.getRenderer().getListCellRendererComponent(this.DUMMY_LIST, this.getSelectedItem().toString(), (int)0, (boolean)false, (boolean)false).getPreferredSize().height;
                }
                return dimension;
            }
        };
        if (this.paletteSelection.getComponentCount() > 0 && (component = this.paletteSelection.getComponent(0)) instanceof JComponent) {
            ((JComponent)component).setBorder(null);
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).setMargin(new Insets(0, 0, 0, 0));
            }
        }
        this.paletteSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        component = new JPanel(new GridLayout(1, 2));
        this.buttons8x16[0] = new JRadioButton("8x8", true);
        this.buttons8x16[1] = new JRadioButton("8x16", false);
        buttonGroup.add(this.buttons8x16[0]);
        buttonGroup.add(this.buttons8x16[1]);
        ((Container)component).add(this.buttons8x16[0]);
        ((Container)component).add(this.buttons8x16[1]);
        this.window.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)viewerWindow, "Center");
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout()){
            private Dimension maxWidthDimension;
            {
                this.maxWidthDimension = new Dimension();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width > this.maxWidthDimension.width) {
                    this.maxWidthDimension = new Dimension(dimension.width, dimension.height);
                }
                return this.maxWidthDimension;
            }
        };
        jPanel3.add((Component)jPanel, "Center");
        this.window.add((Component)jPanel2, "Center");
        this.window.add((Component)jPanel3, "East");
        viewerWindow2.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)viewerWindow2, "Center");
        jPanel4.setBorder(BorderFactory.createTitledBorder("Tile:"));
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        jPanel4.add((Component)jPanel5, "South");
        this.index.setBorder(BorderFactory.createTitledBorder("Tile Index:"));
        jPanel5.add(this.index);
        this.source.setBorder(BorderFactory.createTitledBorder("Pixel Source:"));
        jPanel5.add(this.source);
        ((JComponent)component).setBorder(BorderFactory.createTitledBorder("Arrangement:"));
        jPanel.add(component);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.paletteSelection);
        jPanel6.setBorder(BorderFactory.createTitledBorder("Palette:"));
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel3.add((Component)jPanel7, "South");
        jPanel7.add(this.autoRefresh);
        jPanel7.add(TileViewer.createRefreshButton());
        viewerWindow.setBackground(this.window.getBackground());
        viewerWindow.setIntegerScaling(Boolean.parseBoolean(Emulicious.getProperties().getProperty("TileViewerIntegerScaling")));
        viewerWindow.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Dimension dimension = tilesetRenderer.getTilesetDimension(TileViewer.getNumberOfColumns(), TileViewer.this.is8x16(), TileViewer.isShowGrid());
                int n = TileViewer.getNumberOfColumns();
                boolean bl = TileViewer.this.is8x16();
                int n2 = viewerWindow.toScreenX(mouseEvent.getX());
                int n3 = viewerWindow.toScreenY(mouseEvent.getY());
                int n4 = bl ? 16 : 8;
                int n5 = tilesetRenderer.getTileAt(n2, n3, n, bl, TileViewer.isShowGrid());
                if (n2 >= 0 && n2 < dimension.width && n3 >= 0 && n3 < dimension.height && tilesetRenderer.isTileValid(n5)) {
                    viewerWindow.setHighlightCursor(tilesetRenderer.getTileX(n5, n, bl, TileViewer.isShowGrid()), tilesetRenderer.getTileY(n5, n, bl, TileViewer.isShowGrid()), tilesetRenderer.getTileWidth(bl), n4);
                    TileViewer.this.updateLabels(n5);
                    viewerWindow.setCursor(HAND_CURSOR);
                    PaletteViewer.setHighlightedColor(tilesetRenderer.getTilePixelColor(n5, TileViewer.this.selectedPixel, viewer.getSelectedPalette(), TileViewer.this.viewerCache));
                } else {
                    viewerWindow.setCursor(DEFAULT_CURSOR);
                    viewerWindow.hideHighlightCursor();
                    TileViewer.this.updateLabels(TileViewer.this.selectedTile);
                }
            }
        });
        viewerWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = tilesetRenderer.getTilesetDimension(TileViewer.getNumberOfColumns(), TileViewer.this.is8x16(), TileViewer.isShowGrid());
                int n = TileViewer.getNumberOfColumns();
                boolean bl = TileViewer.this.is8x16();
                int n2 = viewerWindow.toScreenX(mouseEvent.getX());
                int n3 = viewerWindow.toScreenY(mouseEvent.getY());
                int n4 = bl ? 16 : 8;
                int n5 = tilesetRenderer.getTileAt(n2, n3, n, bl, TileViewer.isShowGrid());
                if (n2 >= 0 && n2 < dimension.width && n3 >= 0 && n3 < dimension.height && tilesetRenderer.isTileValid(n5)) {
                    viewerWindow.setSelectionCursor(tilesetRenderer.getTileX(n5, n, bl, TileViewer.isShowGrid()), tilesetRenderer.getTileY(n5, n, bl, TileViewer.isShowGrid()), tilesetRenderer.getTileWidth(bl), n4);
                    TileViewer.this.updateLabels(n5);
                    viewerWindow.setCursor(HAND_CURSOR);
                    TileViewer.this.selectedTile = n5;
                    PaletteViewer.setSelectedColor(tilesetRenderer.getTilePixelColor(n5, TileViewer.this.selectedPixel, viewer.getSelectedPalette(), TileViewer.this.viewerCache));
                } else {
                    viewerWindow.setCursor(DEFAULT_CURSOR);
                    TileViewer.this.updateLabels(TileViewer.this.selectedTile);
                    viewerWindow.hideHighlightCursor();
                    PaletteViewer.setSelectedColor(tilesetRenderer.getTilePixelColor(TileViewer.this.selectedTile, TileViewer.this.selectedPixel, viewer.getSelectedPalette(), TileViewer.this.viewerCache));
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                viewerWindow.setCursor(DEFAULT_CURSOR);
                TileViewer.this.updateLabels(TileViewer.this.selectedTile);
                viewerWindow.hideHighlightCursor();
                PaletteViewer.setHighlightedColor(tilesetRenderer.getTilePixelColor(TileViewer.this.selectedTile, TileViewer.this.selectedPixel, viewer.getSelectedPalette(), TileViewer.this.viewerCache));
            }
        });
        viewerWindow2.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = viewerWindow2.toScreenX(mouseEvent.getX());
                int n2 = viewerWindow2.toScreenY(mouseEvent.getY());
                int n3 = TileViewer.this.getIndex();
                if (n >= 0 && n2 >= 0 && n < 8 && (n2 < 8 || TileViewer.this.is8x16() && n2 < 16)) {
                    TileViewer.this.highlightedPixel = n2 * 8 + n;
                    TileViewer.this.updateLabels(n3);
                    viewerWindow2.setCursor(HAND_CURSOR);
                    PaletteViewer.setHighlightedColor(tilesetRenderer.getTilePixelColor(n3, TileViewer.this.highlightedPixel, viewer.getSelectedPalette(), TileViewer.this.viewerCache));
                } else {
                    viewerWindow2.setCursor(DEFAULT_CURSOR);
                    TileViewer.this.highlightedPixel = -1;
                    TileViewer.this.updateLabels(n3);
                    PaletteViewer.setHighlightedColor(-1);
                }
            }
        });
        viewerWindow2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = viewerWindow2.toScreenX(mouseEvent.getX());
                int n2 = viewerWindow2.toScreenY(mouseEvent.getY());
                int n3 = TileViewer.this.getIndex();
                if (n >= 0 && n2 >= 0 && n < 8 && (n2 < 8 || TileViewer.this.is8x16() && n2 < 16)) {
                    TileViewer.this.selectedPixel = n2 * 8 + n;
                    TileViewer.this.updateLabels(n3);
                    viewerWindow2.setCursor(HAND_CURSOR);
                    PaletteViewer.setSelectedColor(tilesetRenderer.getTilePixelColor(n3, TileViewer.this.selectedPixel, viewer.getSelectedPalette(), TileViewer.this.viewerCache));
                } else {
                    viewerWindow2.setCursor(DEFAULT_CURSOR);
                    TileViewer.this.highlightedPixel = -1;
                    TileViewer.this.updateLabels(n3);
                    PaletteViewer.setSelectedColor(-1);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                int n = TileViewer.this.getIndex();
                viewerWindow2.setCursor(DEFAULT_CURSOR);
                TileViewer.this.highlightedPixel = -1;
                TileViewer.this.updateLabels(n);
                PaletteViewer.setHighlightedColor(-1);
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                timer.stop();
            }
        });
        this.autoRefresh.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                if (jCheckBox.isSelected()) {
                    timer.restart();
                } else {
                    timer.stop();
                }
            }
        });
        this.autoRefresh.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("AutoRefresh" + this.getClass().getSimpleName())));
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = this.makeMenuView();
        jMenuBar.add(jMenu);
        if (tilesetRenderer != null) {
            int n = TileViewer.getNumberOfColumns();
            viewerWindow.setDimensions(tilesetRenderer.getTilesetDimension(n, this.is8x16(), TileViewer.isShowGrid()));
            viewerWindow2.setDimensions(new Dimension(tilesetRenderer.getTileWidth(this.is8x16()), this.is8x16() ? 16 : 8));
            viewerWindow2.setScale(10.0f);
        }
        viewerWindow.setScale(1.0f);
        this.window.pack();
        this.window.setMinimumSize(this.window.getSize());
        if (viewer == null || !viewer.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                viewerWindow.setScale(2.0f);
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private Container getContentPane() {
        return this.window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)this.window)).getContentPane() : null;
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private JMenu makeMenuView() {
        final JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('v');
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                JMenuItem jMenuItem;
                jMenu.removeAll();
                int n = Emulicious.getProperties().getInt("TileViewerColumns", 32);
                int n2 = 0;
                while (n2 <= 24) {
                    final int n3 = n2 + 8;
                    if (tilesetRenderer.isLayoutSupported(n3)) {
                        jMenuItem = new JRadioButtonMenuItem(String.valueOf(n3) + " column layout", n3 == n);
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                Emulicious.getProperties().setProperty("TileViewerColumns", Integer.toString(n3));
                                TileViewer.refresh();
                            }
                        });
                        jMenu.add(jMenuItem);
                    }
                    ++n2;
                }
                jMenu.addSeparator();
                final CheckBoxMenuItem checkBoxMenuItem = new CheckBoxMenuItem("Always Scale to Integer Multiples", TileViewer.this.viewerWindow.isIntegerScaling());
                checkBoxMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TileViewer.setIntegerScaling(checkBoxMenuItem.isSelected());
                    }
                });
                jMenu.add(checkBoxMenuItem);
                final CheckBoxMenuItem checkBoxMenuItem2 = new CheckBoxMenuItem("Show Grid", TileViewer.isShowGrid());
                checkBoxMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Emulicious.getProperties().setProperty("TileViewerShowGrid", Boolean.toString(checkBoxMenuItem2.isSelected()));
                    }
                });
                jMenu.add(checkBoxMenuItem2);
                jMenu.addSeparator();
                jMenuItem = new JMenuItem("Combine Video Viewers");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        VideoViewer.open((this).TileViewer.this.owner, "Tiles", false);
                    }
                });
                jMenu.add(jMenuItem);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    static JMenu makeLayoutMenu() {
        final JMenu jMenu = new JMenu("Tile Viewer Layout");
        jMenu.setMnemonic('v');
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jMenu.removeAll();
                int n = Emulicious.getProperties().getInt("TileViewerColumns", 32);
                int n2 = 0;
                while (n2 <= 24) {
                    final int n3 = n2 + 8;
                    if (tilesetRenderer.isLayoutSupported(n3)) {
                        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(String.valueOf(n3) + " column layout", n3 == n);
                        jRadioButtonMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                Emulicious.getProperties().setProperty("TileViewerColumns", Integer.toString(n3));
                                TileViewer.refresh();
                            }
                        });
                        jMenu.add(jRadioButtonMenuItem);
                    }
                    ++n2;
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    void updateLabels(int n) {
        String string;
        int n2 = tilesetRenderer.getTileWidth(this.is8x16());
        String string2 = tilesetRenderer.getTileWidth(true) == 8 ? "8x16" : (string = tilesetRenderer.getTileWidth(true) == 12 ? "12x16" : "8x16");
        if (!this.buttons8x16[1].getText().equals(string)) {
            this.buttons8x16[1].setText(string);
        }
        this.tileWindow.setDimensions(new Dimension(n2, this.is8x16() ? 16 : 8));
        this.tileWindow.fill(this.tileWindow.getBackgroundRGB());
        tilesetRenderer.renderTile(this.tileWindow, n, this.getSelectedPalette(), this.is8x16(), TileViewer.isShowGrid(), this.viewerCache);
        this.tileWindow.repaint();
        if (this.highlightedPixel >= 0) {
            this.tileWindow.setHighlightCursor(this.highlightedPixel % n2, this.highlightedPixel / n2, 1, 1);
        } else {
            this.tileWindow.hideHighlightCursor();
        }
        if (this.selectedPixel >= 0) {
            this.tileWindow.setSelectionCursor(this.selectedPixel % n2, this.selectedPixel / n2, 1, 1);
        }
        int n3 = tilesetRenderer.getTileVRAMaddress(n);
        String string3 = tilesetRenderer.getTileCPUaddress(n);
        if (string3 != null) {
            this.index.setText(String.format("%d ($%X) @ VRAM %s", n, n & 0xFF, string3));
        } else {
            this.index.setText(String.format("%d ($%X) @ VRAM %04X", n, n & 0xFF, n3));
        }
        if (this.sources != null && n3 < this.sources.length) {
            long l = this.sources[n3 + tilesetRenderer.getTilePixelOffset(this.highlightedPixel >= 0 ? this.highlightedPixel : this.selectedPixel)];
            this.source.setSource(l);
        } else {
            this.source.setSource(0L);
        }
    }

    private void updatePaletteNames() {
        int n = this.paletteSelection.getSelectedIndex();
        this.paletteSelection.setModel(new DefaultComboBoxModel<String>(tilesetRenderer.getPaletteNames()));
        if (n < this.paletteSelection.getItemCount()) {
            this.paletteSelection.setSelectedIndex(n);
        }
    }

    private static JButton createRefreshButton() {
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileViewer.refresh();
            }
        });
        return jButton;
    }

    int getSelectedPalette() {
        return this.paletteSelection.getSelectedIndex();
    }

    static int getNumberOfColumns() {
        int n = Emulicious.getProperties().getInt("TileViewerColumns", 16);
        if (tilesetRenderer.isLayoutSupported(n)) {
            return n;
        }
        return 16;
    }

    boolean is8x16() {
        return tilesetRenderer.is8x16supported() && this.buttons8x16[1].isSelected();
    }

    int getIndex() {
        return Integer.parseInt(this.index.getText().substring(0, this.index.getText().indexOf(32)));
    }

    static void setShowGrid(boolean bl) {
        Emulicious.getProperties().setProperty("TileViewerShowGrid", Boolean.toString(bl));
    }

    static boolean isShowGrid() {
        return Boolean.parseBoolean(Emulicious.getProperties().getProperty("TileViewerShowGrid"));
    }

    static void setIntegerScaling(boolean bl) {
        if (viewer != null) {
            TileViewer.viewer.viewerWindow.setIntegerScaling(bl);
            Emulicious.getProperties().setProperty("TileViewerIntegerScaling", Boolean.toString(bl));
        }
    }

    static boolean isIntegerScaling() {
        return Boolean.parseBoolean(Emulicious.getProperties().getProperty("TileViewerIntegerScaling"));
    }

    static void setHighlightedTile(int n) {
        if (viewer != null && tilesetRenderer != null) {
            if (n < 0) {
                n = TileViewer.viewer.selectedTile;
            }
            if (tilesetRenderer.isTileValid(n)) {
                int n2 = TileViewer.getNumberOfColumns();
                boolean bl = viewer.is8x16();
                int n3 = bl ? 16 : 8;
                TileViewer.viewer.viewerWindow.setHighlightCursor(tilesetRenderer.getTileX(n, n2, bl, TileViewer.isShowGrid()), tilesetRenderer.getTileY(n, n2, bl, TileViewer.isShowGrid()), 8, n3);
                viewer.updateLabels(n);
                PaletteViewer.setHighlightedColor(tilesetRenderer.getTilePixelColor(n, TileViewer.viewer.selectedPixel, viewer.getSelectedPalette(), TileViewer.viewer.viewerCache));
            } else {
                TileViewer.viewer.viewerWindow.hideHighlightCursor();
            }
        }
    }

    static void setSelectedTile(int n) {
        if (viewer != null && tilesetRenderer != null && tilesetRenderer.isTileValid(n)) {
            int n2 = TileViewer.getNumberOfColumns();
            boolean bl = viewer.is8x16();
            int n3 = bl ? 16 : 8;
            TileViewer.viewer.selectedTile = n;
            TileViewer.viewer.viewerWindow.setSelectionCursor(tilesetRenderer.getTileX(n, n2, bl, TileViewer.isShowGrid()), tilesetRenderer.getTileY(n, n2, bl, TileViewer.isShowGrid()), 8, n3);
            viewer.updateLabels(n);
            PaletteViewer.setSelectedColor(tilesetRenderer.getTilePixelColor(n, TileViewer.viewer.selectedPixel, viewer.getSelectedPalette(), TileViewer.viewer.viewerCache));
        }
    }

    public static boolean isOpen() {
        return viewer != null && viewer.isVisible();
    }

    public static void open(Window window, boolean bl) {
        if (VideoViewer.isCombined()) {
            VideoViewer.open(window, "Tiles", bl);
        } else {
            if (viewer == null) {
                viewer = new TileViewer(window, Emulicious.isUseFrames());
                viewer.setVisible(true);
            } else if (!bl) {
                viewer.setVisible(true);
            }
            if (viewer.isShowing() && TileViewer.viewer.autoRefresh.isSelected()) {
                TileViewer.viewer.refreshTimer.restart();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TileViewer.refresh();
                }
            });
        }
    }

    static Container stealContentPane(Window window) {
        if (viewer == null) {
            viewer = new TileViewer(window, false);
        }
        if (TileViewer.viewer.autoRefresh.isSelected()) {
            TileViewer.viewer.refreshTimer.restart();
        }
        Container container = viewer.getContentPane();
        viewer.dispose();
        return container;
    }

    static void stopRefreshTimer() {
        if (viewer != null) {
            TileViewer.viewer.refreshTimer.stop();
        }
    }

    static void restartRefreshTimer() {
        if (viewer != null && TileViewer.viewer.autoRefresh.isSelected()) {
            TileViewer.viewer.refreshTimer.restart();
        }
    }

    public static void setTilesetRenderer(TilesetRenderer tilesetRenderer) {
        TileViewer.tilesetRenderer = tilesetRenderer;
        if (tilesetRenderer != null && viewer != null) {
            viewer.updatePaletteNames();
        }
    }

    public static void close() {
        if (viewer != null) {
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Open", "" + viewer.isVisible());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "X", "" + viewer.getX());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Y", "" + viewer.getY());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Width", "" + viewer.getWidth());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Height", "" + viewer.getHeight());
            if (TileViewer.viewer.autoRefresh.isSelected()) {
                Emulicious.getProperties().remove("AutoRefresh" + viewer.getClass().getSimpleName());
            } else {
                Emulicious.getProperties().setProperty("AutoRefresh" + viewer.getClass().getSimpleName(), "false");
            }
            TileViewer.viewer.refreshTimer.stop();
            TileViewer.viewer.autoRefresh.setSelected(false);
            viewer.dispose();
            viewer = null;
        }
    }

    static void refresh() {
        if (viewer != null && TileViewer.viewer.viewerWindow.isShowing()) {
            TileViewer.viewer.sources = MemoryTracer.getVRAMSources(TileViewer.viewer.sources);
            int n = TileViewer.getNumberOfColumns();
            TileViewer.viewer.viewerWindow.setDimensions(tilesetRenderer.getTilesetDimension(n, viewer.is8x16(), TileViewer.isShowGrid()));
            TileViewer.viewer.viewerWindow.fill(DisplayWindow.COLOR_GRAY);
            tilesetRenderer.renderTileset(TileViewer.viewer.viewerWindow, viewer.getSelectedPalette(), TileViewer.getNumberOfColumns(), viewer.is8x16(), TileViewer.isShowGrid(), TileViewer.viewer.viewerCache);
            TileViewer.viewer.viewerWindow.repaint();
            viewer.updateLabels(viewer.getIndex());
        }
    }
}

