/*
 * Decompiled with CFR 0.152.
 */
package replay;

import components.input.ButtonInputProvider;
import components.input.FrameInputDevice;
import components.input.GBJoypad;
import replay.GBInputLog;
import replay.ParseException;
import replay.ParseExceptionHandler;

public class GBReplayJoypad
extends GBJoypad
implements FrameInputDevice {
    private static final int P1_UP = 0;
    private static final int P1_DOWN = 1;
    private static final int P1_LEFT = 2;
    private static final int P1_RIGHT = 3;
    private static final int P1_START = 4;
    private static final int P1_SELECT = 5;
    private static final int P1_B = 6;
    private static final int P1_A = 7;
    private static final int P1_POWER = 8;
    private static final int NUM_BUTTONS = 9;
    private final boolean[] buttons = new boolean[9];
    private final GBInputLog inputLog;
    private final ParseExceptionHandler parseExceptionHandler;
    private boolean done;

    public GBReplayJoypad(GBInputLog gBInputLog, ButtonInputProvider buttonInputProvider, int n, ParseExceptionHandler parseExceptionHandler) {
        super(buttonInputProvider, n, true);
        this.inputLog = gBInputLog;
        this.parseExceptionHandler = parseExceptionHandler;
    }

    @Override
    public int getKeyStates(int n, int n2) {
        if (this.done) {
            return super.getKeyStates(n, n2);
        }
        if (((n |= 0xCF) & 0x20) == 0) {
            if (this.buttons[7]) {
                n &= 0xFFFFFFFE;
            }
            if (this.buttons[6]) {
                n &= 0xFFFFFFFD;
            }
            if (this.buttons[5]) {
                n &= 0xFFFFFFFB;
            }
            if (this.buttons[4]) {
                n &= 0xFFFFFFF7;
            }
        }
        if ((n & 0x10) == 0) {
            if (this.buttons[3]) {
                n &= 0xFFFFFFFE;
            }
            if (this.buttons[2]) {
                n &= 0xFFFFFFFD;
            }
            if (this.buttons[0]) {
                n &= 0xFFFFFFFB;
            }
            if (this.buttons[1]) {
                n &= 0xFFFFFFF7;
            }
        }
        return n;
    }

    @Override
    public int readData(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void frameFinished() {
        if (!this.done) {
            if (this.inputLog.hasNext()) {
                try {
                    this.inputLog.getNextInput(this.buttons);
                }
                catch (ParseException parseException) {
                    this.parseExceptionHandler.handleParseException(parseException);
                    this.done = true;
                }
            } else {
                this.done = true;
            }
        }
    }
}

