/*
 * Decompiled with CFR 0.152.
 */
package util.string;

import util.string.SubCharSequence;

class ConcatenatedCharSequence
implements CharSequence {
    private final CharSequence sequence1;
    private final CharSequence sequence2;
    private final int length1;
    private final int totalLength;
    private String string;

    ConcatenatedCharSequence(CharSequence charSequence, CharSequence charSequence2) {
        this.sequence1 = charSequence;
        this.sequence2 = charSequence2;
        this.length1 = charSequence.length();
        this.totalLength = this.length1 + charSequence2.length();
    }

    @Override
    public char charAt(int n) {
        if (this.string != null) {
            return this.string.charAt(n);
        }
        if (n >= this.length1) {
            return this.sequence2.charAt(n - this.length1);
        }
        return this.sequence1.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        int n3 = this.length1;
        if (n >= n3 && n2 >= n3) {
            return this.sequence2.subSequence(n - n3, n2 - n3);
        }
        if (n < n3 && n2 < n3) {
            return this.sequence1.subSequence(n, n2);
        }
        return new SubCharSequence(this.toString(), n, n2);
    }

    private char[] buildString(char[] cArray, int n) {
        int n2;
        CharSequence charSequence = this.sequence1;
        CharSequence charSequence2 = this.sequence2;
        if (charSequence instanceof ConcatenatedCharSequence) {
            ((ConcatenatedCharSequence)charSequence).buildString(cArray, n);
            n += this.length1;
        } else {
            n2 = this.length1;
            int n3 = 0;
            while (n3 < n2) {
                cArray[n++] = charSequence.charAt(n3);
                ++n3;
            }
        }
        if (charSequence2 instanceof ConcatenatedCharSequence) {
            ((ConcatenatedCharSequence)charSequence2).buildString(cArray, n);
        } else {
            n2 = 0;
            while (n2 < charSequence2.length()) {
                cArray[n++] = charSequence2.charAt(n2);
                ++n2;
            }
        }
        return cArray;
    }

    @Override
    public int length() {
        return this.totalLength;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = new String(this.buildString(new char[this.length()], 0));
        }
        return this.string;
    }
}

