#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <allegro.h>
#include <malloc.h>
#include <assert.h>
#include <time.h>
#include "mz80.h"

DATAFILE *audio;
int game = 1;
int fps = 60;

static struct mz80context mz80;
static UINT8 bInvadersPlayer = 0x00;
static UINT8 bInvadersDipswitch = 0x00;

// Invaders global variables

static UINT32 iInvadersShiftData1, iInvadersShiftData2 , iInvadersShiftAmount;
static UINT8 flip = 1;

static void InvadersOut(UINT32 addr, UINT8 data, struct MemoryWriteByte *pMemWrite);
static void NothingWrite(UINT32 addr, UINT8 data, struct MemoryWriteByte *pMemWrite);
static UINT16 InvadersShiftDataRead(UINT16 port, struct z80PortRead *pPR);
static UINT16 InvadersPlayerRead(UINT16 port, struct z80PortRead *pPR);
static UINT16 InvadersDipswitchRead(UINT16 port, struct z80PortRead *pPR);
static void InvadersShiftAmountWrite(UINT16 port, UINT8 data, struct z80PortWrite *pPW);
static void InvadersShiftDataWrite(UINT16 port, UINT8 data, struct z80PortWrite *pPW);
static void InvadersSoundPort3Write(UINT16 port, UINT8 data, struct z80PortWrite *pPW);
static void InvadersSoundPort5Write(UINT16 port, UINT8 data, struct z80PortWrite *pPW);

//function added by Zan for user friendly ness :)..

void message (void);
void reset_all(void);

// Invaders read/write structures

struct MemoryWriteByte sInvadersWrite[] =
{
	{0x0000, 0x1FFF, NothingWrite},
   	{0x2400, 0x3FFF, InvadersOut},
	{0x4000, 0x57ff, NothingWrite},
	{-1, 	 -1, 	 NULL}
};

struct MemoryReadByte sInvadersRead[] =
{
	{-1, -1, NULL}
};

struct z80PortRead sInvadersPortRead[] =
{
	{ 0x0000, 0x0002, InvadersPlayerRead, NULL },
	{ 0x0002, 0x0002, InvadersDipswitchRead, NULL },
	{ 0x0003, 0x0003, InvadersShiftDataRead, NULL },
	{-1,	  -1,	  NULL}
};

struct z80PortWrite sInvadersPortWrite[] =
{
	{ 0x02, 0x02, InvadersShiftAmountWrite },
   	{ 0x03, 0x03, InvadersSoundPort3Write },
	{ 0x04, 0x04, InvadersShiftDataWrite },
   	{ 0x05, 0x05, InvadersSoundPort5Write },
	{-1,	-1,	NULL}
};

static void InvadersInterrupt(void)
{
	if (flip)
		mz80int(0);
	else
		mz80nmi();
	flip ^= 1;
}

static void NothingWrite(UINT32 addr, UINT8 data, struct MemoryWriteByte *pMemWrite)
{
	// Do nothing! The region is write protected!
}

static void InvadersOut(UINT32 addr, UINT8 data, struct MemoryWriteByte *pMemWrite)
{
	// Video RAM write

	int b,c,x,y;

	// A new update of screen RAM goes here!
		
        mz80.z80Base[addr] = data;
	x=(addr-0x2400)>>5;
	y=(addr-0x2400)&0x1F;
	c=15;
	if(y<8) c=2;
	if(y>23 && y<28) c=4;

	for (b=0;b<8;b++)
	{
		if(data&0x01) putpixel(screen,x,256-((y<<3)+b),c); else putpixel(screen,x,256-((y<<3)+b),0); data=data>>1;
	}
}

UINT16 InvadersShiftDataRead(UINT16 port, struct z80PortRead *pPR)
{
	return ((((iInvadersShiftData1 << 8) | iInvadersShiftData2) 
		<< iInvadersShiftAmount) >> 8) & 0xFF;
}


UINT16 InvadersPlayerRead(UINT16 port, struct z80PortRead *pPR)
{
	if (0 == port)
	{

		return(0xf4);

        }
        if (1 == port)
        {
                bInvadersPlayer=0x81;
                poll_joystick();
		if(key[KEY_1]) bInvadersPlayer|=0x04;
                if(key[KEY_2]) bInvadersPlayer|=0x02;
                if(key[KEY_3]) bInvadersPlayer&=~0x01;
                if(key[KEY_LEFT]) bInvadersPlayer|=0x20;
                if(key[KEY_RIGHT]) bInvadersPlayer|=0x40;
                if(key[KEY_CONTROL]) bInvadersPlayer|=0x10;
		if(joy_left) bInvadersPlayer|=0x20;
		if(joy_right) bInvadersPlayer|=0x40;
		if(joy_b1) bInvadersPlayer|=0x10;
                return(bInvadersPlayer);
        }
        if (2 == port)
        {
                bInvadersPlayer=0x00;
		poll_joystick();
		if(key[KEY_LEFT]) bInvadersPlayer|=0x20;
                if(key[KEY_RIGHT]) bInvadersPlayer|=0x40;
                if(key[KEY_CONTROL]) bInvadersPlayer|=0x10;
		if(joy_left) bInvadersPlayer|=0x20;
		if(joy_right) bInvadersPlayer|=0x40;
		if(joy_b1) bInvadersPlayer|=0x10;
                return(bInvadersPlayer);
        }
	else
		return(bInvadersPlayer);

}

UINT16 InvadersDipswitchRead(UINT16 port, struct z80PortRead *pPR)
{
	return bInvadersDipswitch;
}

static void InvadersShiftAmountWrite(UINT16 port, UINT8 data, struct z80PortWrite *pPW)
{
	iInvadersShiftAmount = data & 0x07;
}

static void InvadersShiftDataWrite(UINT16 port, UINT8 data, struct z80PortWrite *pPW)
{
	iInvadersShiftData2 = iInvadersShiftData1;
	iInvadersShiftData1 = data;
}

static void InvadersSoundPort3Write(UINT16 port, UINT8 data, struct z80PortWrite *pPW)
{
	static UINT8 bSound = 0;

      if(data&0x01 && ~bSound&0x01) play_sample(audio[0].dat,128,128,1000,1);
      if(~data&0x01 && bSound&0x01) stop_sample(audio[0].dat);
      if(data&0x02 && ~bSound&0x02) play_sample(audio[1].dat,100,128,1000,0);
      if(~data&0x02 && bSound&0x02) stop_sample(audio[1].dat);
      if(data&0x04 && ~bSound&0x04) play_sample(audio[2].dat,128,128,1000,0);
      if(~data&0x04 && bSound&0x04) stop_sample(audio[2].dat);
      if(data&0x08 && ~bSound&0x08) play_sample(audio[3].dat,100,128,1000,0);
      if(~data&0x08 && bSound&0x08) stop_sample(audio[3].dat);

	bSound = data;
}

static void InvadersSoundPort5Write(UINT16 port, UINT8 data, struct z80PortWrite *pPW)
{
	static UINT8 bSound = 0;

      if(data&0x01 && ~bSound&0x01) play_sample(audio[4].dat,255,128,1000,0);
      if(data&0x02 && ~bSound&0x02) play_sample(audio[5].dat,255,128,1000,0);
      if(data&0x04 && ~bSound&0x04) play_sample(audio[6].dat,255,128,1000,0);
      if(data&0x08 && ~bSound&0x08) play_sample(audio[7].dat,255,128,1000,0);
      if(data&0x10 && ~bSound&0x10) play_sample(audio[8].dat,128,128,1000,0);
      if(~data&0x10 && bSound&0x10) stop_sample(audio[8].dat);

	bSound = data;
}

void CheckCmdLine(int argc, char **argv)
{
	if (argc < 2) 
	{
    		printf("Usage : invmz [GAME NAME] [OPTIONS]\n");
		printf("i.e : invmz invaders fast\n\n");

    		printf("supported games are :\n\n");
    		printf("GAME NAME\t\tREAL NAME\t\t\tROM DIR\n");
    		printf("invaders\t\tSpace Invaders\t\t\troms\\Invaders\n");
    		printf("invadpt2\t\tSpace Invaders Part 2\t\troms\\Invadpt2\n");
    		printf("spaceatt\t\tSpace Attack II\t\t\troms\\spaceatt\n");
    		printf("desterth\t\tDestination Earth\t\troms\\desterth\n");
    		printf("galxwars\t\tGalaxy Wars\t\t\troms\\galxwars\n");
   		printf("lrescue\t\t\tLunar Rescue\t\t\troms\\lrescue\n");
		printf("grescue\t\t\tGalaxy Rescue\t\t\troms\\lrescue\n");

    		printf("\npartially working games are :\n\n");
    		printf("invrvnge\t\tInvaders Revenge\t\troms\\invrvnge\n");
    		printf("lupin3\t\t\tLupin III\t\t\troms\\lupin3\n");
   		printf("schaser\t\t\tSpace Chaser\t\t\troms\\schaser\n");
  		printf("ozmawars\t\tOzma Wars\t\t\troms\\Ozma Wars\n");

		printf("\nOPTION\t\t\tFUNCTION\n");
    		printf("fast\t\t\tGameplay 1.5x faster\n");
		exit(0);
  	}

  	if(!strcmp((char*)strlwr(argv[1]), "invaders")) 	{ game=1; }
  	else if(!strcmp((char*)strlwr(argv[1]), "invadpt2")) 	{ game=2; }
  	else if(!strcmp((char*)strlwr(argv[1]), "spaceatt")) 	{ game=3; }
  	else if(!strcmp((char*)strlwr(argv[1]), "desterth")) 	{ game=4; }
  	else if(!strcmp((char*)strlwr(argv[1]), "galxwars")) 	{ game=5; }
	else if(!strcmp((char*)strlwr(argv[1]), "invrvnge")) 	{ game=6; }
	else if(!strcmp((char*)strlwr(argv[1]), "lrescue")) 	{ game=7; }
	else if(!strcmp((char*)strlwr(argv[1]), "lupin3")) 	{ game=8; }
	else if(!strcmp((char*)strlwr(argv[1]), "schaser")) 	{ game=9; }
	else if(!strcmp((char*)strlwr(argv[1]), "ozmawars")) 	{ game=10; }
	else if(!strcmp((char*)strlwr(argv[1]), "grescue")) 	{ game=11; }
	else
	{
    		printf("Unsupported game\n\n");
    		printf("please run invmz.exe on its own for command line options\n");
    		exit(0);
	}

	if(!strcmp((char*)strlwr(argv[2]), "fast")) { fps = 90; }
}

void message(void)
{
 	int bKey = 0;
	clrscr();
	textcolor(WHITE);
  	clrscr();
  	clreol(); printf("\n");
  	clreol(); printf("                    Thankyou to the AMOAD project and Neil Bradley\n");
  	clreol(); printf("                         Without them, this wouldnt exist\n\n");
  	textcolor(RED);
  	clreol(); printf("                           SPACE INVADERS (C) 1979 TAITO\n\n");
  	textcolor(LIGHTGREEN);
  	clreol(); printf("                                     \n");
  	clreol(); printf("                               \n");
  	clreol(); printf("                               \n");
  	clreol(); printf("                                     \n");
  	clreol(); printf("                             \n");
  	clreol(); printf("                                             \n");
  	clreol(); printf("                                         \n");
  	clreol(); printf("                                             \n\n\n");
  	textcolor(WHITE);
  	clreol(); printf("  Please do not distribute the source code, executable, or diskette image with\n");
  	clreol(); printf("   ROM images. Doing so may harm further emulator development and may lead to\n");
  	clreol(); printf("   legal action being taken by the lawful copyright holder of the ROM images.\n\n");
  	clreol(); printf("             If you do not agree with these conditions press ESC now.\n\n");
  	textcolor(LIGHTGREEN);
  	clreol(); printf("                         Press any other key to continue\n");
  	bKey=getch();
  	if (bKey==27) {textcolor(LIGHTGRAY); clrscr(); exit(1);}

}

void reset_all(void)
{
	// Reset the virtual processor and load in defaults

	mz80reset();

	// WARNING: mz80Reset wipes out the interrupt addresses to the defaults!

	mz80GetContext(&mz80);
	mz80.z80intAddr = 0x08;		// Interrupt address
	mz80.z80nmiAddr = 0x10;		// NMI Address
	mz80SetContext(&mz80);

}

void LoadRom(char *Filename, short Offset, short Size)
{
	FILE *fp = NULL;
	
	fp = fopen(Filename, "rb");
	assert(fp);		// Make sure the ROM load was good
	fread(mz80.z80Base + Offset, Size, 1, fp);
	fclose(fp);

}

int main(int argc, char *argv[])
{
	UINT32 dwResult = 0;
	UINT32 dwDisplayInterval = 0;
	UINT32 dwIntTotal = 0;
	UINT32 dwFrames = 0;

        uclock_t time_start=0,curr=0;
        float elapsed_time=0;

	CheckCmdLine(argc, argv);
	
	//message();

	// Always best to start out with 0's
	
	memset(&mz80, 0, sizeof(struct mz80context));

	// Set up interrupt addresses

	mz80.z80MemRead = sInvadersRead;
	mz80.z80MemWrite = sInvadersWrite;
	mz80.z80IoRead = sInvadersPortRead;
	mz80.z80IoWrite = sInvadersPortWrite;
	
	mz80.z80Base = malloc(65536);	// Our virtual 64K
	mz80SetContext(&mz80);

	// Load in our ROM images here (sub directory ROMS)...

	switch (game)
	{
	case 1:
	{
		LoadRom("roms\\invaders\\invaders.h", 0x0000, 2048);
		LoadRom("roms\\invaders\\invaders.g", 0x0800, 2048);
		LoadRom("roms\\invaders\\invaders.f", 0x1000, 2048);
		LoadRom("roms\\invaders\\invaders.e", 0x1800, 2048);
		break;
	}
	case 2:
	{
		LoadRom("roms\\invadpt2\\pv.01", 0x0000, 2048);
		LoadRom("roms\\invadpt2\\pv.02", 0x0800, 2048);
		LoadRom("roms\\invadpt2\\pv.03", 0x1000, 2048);
		LoadRom("roms\\invadpt2\\pv.04", 0x1800, 2048);
		LoadRom("roms\\invadpt2\\pv.05", 0x4000, 2048);
		break;
	}
	case 3:
	{
		LoadRom("roms\\spaceatt\\spaceatt.h", 0x0000, 2048);
		LoadRom("roms\\spaceatt\\spaceatt.g", 0x0800, 2048);
		LoadRom("roms\\spaceatt\\spaceatt.f", 0x1000, 2048);
		LoadRom("roms\\spaceatt\\spaceatt.e", 0x1800, 2048);
		break;
	}
	case 4:
	{
		LoadRom("roms\\desterth\\36_h.bin", 0x0000, 2048);
		LoadRom("roms\\desterth\\35_g.bin", 0x0800, 2048);
		LoadRom("roms\\desterth\\34_f.bin", 0x1000, 2048);
		LoadRom("roms\\desterth\\33_e.bin", 0x1800, 2048);
		LoadRom("roms\\desterth\\32_d.bin", 0x4000, 2048);
		LoadRom("roms\\desterth\\31_c.bin", 0x4800, 2048);
		LoadRom("roms\\desterth\\42_b.bin", 0x5000, 2048);
		break;
	}
	case 5:
	{
		LoadRom("roms\\galxwars\\galxwars.0", 0x0000, 1024);
		LoadRom("roms\\galxwars\\galxwars.1", 0x0400, 1024);
		LoadRom("roms\\galxwars\\galxwars.2", 0x0800, 1024);
		LoadRom("roms\\galxwars\\galxwars.3", 0x0c00, 1024);
		LoadRom("roms\\galxwars\\galxwars.4", 0x4000, 1024);
		LoadRom("roms\\galxwars\\galxwars.5", 0x4400, 1024);
		break;
	}
	case 6:
	{
		LoadRom("roms\\invrvnge\\invrvnge.h", 0x0000, 2048);
		LoadRom("roms\\invrvnge\\invrvnge.g", 0x0800, 2048);
		LoadRom("roms\\invrvnge\\invrvnge.f", 0x1000, 2048);
		LoadRom("roms\\invrvnge\\invrvnge.e", 0x1800, 2048);
		break;
	}
	case 7:
	{
		LoadRom("roms\\lrescue\\lrescue.1", 0x0000, 2048);
		LoadRom("roms\\lrescue\\lrescue.2", 0x0800, 2048);
		LoadRom("roms\\lrescue\\lrescue.3", 0x1000, 2048);
		LoadRom("roms\\lrescue\\lrescue.4", 0x1800, 2048);
		LoadRom("roms\\lrescue\\lrescue.5", 0x4000, 2048);
		LoadRom("roms\\lrescue\\lrescue.6", 0x4800, 2048);
		break;
	}
	case 8:
	{
		LoadRom("roms\\lupin3\\lp12.bin", 0x0000, 2048);
		LoadRom("roms\\lupin3\\lp13.bin", 0x0800, 2048);
		LoadRom("roms\\lupin3\\lp14.bin", 0x1000, 2048);
		LoadRom("roms\\lupin3\\lp15.bin", 0x1800, 2048);
		LoadRom("roms\\lupin3\\lp16.bin", 0x4000, 2048);
		LoadRom("roms\\lupin3\\lp17.bin", 0x4800, 2048);
		LoadRom("roms\\lupin3\\lp18.bin", 0x5000, 2048);
		break;
	}
	case 9:
	{
		LoadRom("roms\\schaser\\rt13.bin", 0x0000, 1024);
		LoadRom("roms\\schaser\\rt14.bin", 0x0400, 1024);
		LoadRom("roms\\schaser\\rt15.bin", 0x0800, 1024);
		LoadRom("roms\\schaser\\rt16.bin", 0x0c00, 1024);
		LoadRom("roms\\schaser\\rt17.bin", 0x1000, 1024);
		LoadRom("roms\\schaser\\rt18.bin", 0x1400, 1024);
		LoadRom("roms\\schaser\\rt19.bin", 0x1800, 1024);
		LoadRom("roms\\schaser\\rt20.bin", 0x1c00, 1024);
		LoadRom("roms\\schaser\\rt21.bin", 0x4000, 1024);
		LoadRom("roms\\schaser\\rt22.bin", 0x4400, 1024);
		break;
	}
	case 10:
	{
		LoadRom("roms\\ozmawars\\mw01.   ", 0x0000, 2048);
		LoadRom("roms\\ozmawars\\mw02.   ", 0x0800, 2048);
		LoadRom("roms\\ozmawars\\mw03.   ", 0x1000, 2048);
		LoadRom("roms\\ozmawars\\mw04.   ", 0x1800, 2048);
		LoadRom("roms\\ozmawars\\mw05.   ", 0x4000, 2048);
		LoadRom("roms\\ozmawars\\mw06.   ", 0x4800, 2048);
		break;
	}
	case 11:
	{
		LoadRom("roms\\lrescue\\lrescue.1", 0x0000, 2048);
		LoadRom("roms\\lrescue\\lrescue.2", 0x0800, 2048);
		LoadRom("roms\\lrescue\\lrescue.3", 0x1000, 2048);
		LoadRom("roms\\lrescue\\grescue.4", 0x1800, 2048);
		LoadRom("roms\\lrescue\\grescue.5", 0x4000, 2048);
		LoadRom("roms\\lrescue\\lrescue.6", 0x4800, 2048);
		break;
	}
	}
	// initialise allegro

	allegro_init();
	install_keyboard();
	set_gfx_mode(GFX_MODEX,256,256,0,0);
	//initialise_joystick();
	install_joystick(JOY_TYPE_AUTODETECT);
	
	install_sound(DIGI_AUTODETECT,MIDI_NONE,0);
	audio=load_datafile("invaders.sam");
	
	reset_all();

	// Time to execute!


	while (key[KEY_ESC]==0)
	{

	        if (key[KEY_F3]) reset_all();

		dwResult = mz80exec(8000);	// Execute roughly 8000 cycles

		// 0x80000000 Is a "good" execution

		if (dwResult != 0x80000000)
		{
			//printf("Hit invalid instruction @ address %.4xh\n", dwResult);
			exit(1);
		}
	
		dwIntTotal += mz80GetElapsedTicks(0);	// How much emulated time passed?
		dwDisplayInterval += mz80GetElapsedTicks(1);	// Reset our internal counter


		if (dwDisplayInterval >= 34133)	// Roughly 60 times a second at 2MHZ
		{
			// Throttle speed here for screen update..
			
                        do
                        {
                        curr=uclock();
                        }
                        while (curr-time_start<(UCLOCKS_PER_SEC/fps));
                        time_start=uclock();
			elapsed_time=(float)uclock()/UCLOCKS_PER_SEC;

			++dwFrames;

			dwDisplayInterval -= 34133;
		}



		if (dwIntTotal > 17067)
		{
			// We toggle between an NMI and an Interrupt

			dwIntTotal -= 17067;
			InvadersInterrupt();
		}

        }
	fade_out(4);
	allegro_exit();
	printf("Displayed %ld Frames Total\n", dwFrames);
        printf("Elapsed Time is %5.2f seconds\n",elapsed_time);
        printf("Average Frames Per second is %5.2f\n",(float)dwFrames/elapsed_time);
	return(0);
}