VERSION 5.00
Begin VB.Form Arcade 
   BackColor       =   &H00C0C0C0&
   Caption         =   "PCSloMo Arcade Emulator"
   ClientHeight    =   3735
   ClientLeft      =   165
   ClientTop       =   465
   ClientWidth     =   3780
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   3735
   ScaleWidth      =   3780
   StartUpPosition =   2  'CenterScreen
   Begin VB.PictureBox ArcadeScreen 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      Height          =   3735
      Left            =   0
      ScaleHeight     =   245
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   247
      TabIndex        =   0
      Top             =   0
      Width           =   3765
   End
   Begin VB.Menu mnuMain 
      Caption         =   "&Main"
      Begin VB.Menu mnuMainGames 
         Caption         =   "&Games"
         Begin VB.Menu mnuMainGamesAstro 
            Caption         =   "Astro Fighter(Set 1)"
         End
         Begin VB.Menu mnuGamesAstroF2 
            Caption         =   "Astro Fighter(Set 2)"
         End
         Begin VB.Menu mnuMainGamesCenti 
            Caption         =   "Centipede"
         End
         Begin VB.Menu mnuGamesCircus 
            Caption         =   "Circus"
         End
         Begin VB.Menu mnuMainGamesMilli 
            Caption         =   "Millipede"
         End
         Begin VB.Menu mnuGamesVanG 
            Caption         =   "Vanguard"
         End
      End
      Begin VB.Menu mnuExit 
         Caption         =   "&Exit"
      End
   End
   Begin VB.Menu mnuEmu 
      Caption         =   "&Emulation"
      Begin VB.Menu mnuFileFrameSkip 
         Caption         =   "&FrameSkip"
         Begin VB.Menu mnuFileFS1 
            Caption         =   "&1"
         End
         Begin VB.Menu mnuFileFS2 
            Caption         =   "&2"
         End
         Begin VB.Menu mnuFileFS3 
            Caption         =   "&3"
         End
         Begin VB.Menu mnuFileFS4 
            Caption         =   "&4"
         End
      End
      Begin VB.Menu mnuEmuReset 
         Caption         =   "&Reset"
      End
      Begin VB.Menu mnuEmuStop 
         Caption         =   "&Stop"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuAbout 
         Caption         =   "&About"
      End
   End
End
Attribute VB_Name = "Arcade"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub ArcadeScreen_KeyDown(KeyCode As Integer, Shift As Integer)
Form_KeyDown KeyCode, Shift
End Sub

Private Sub ArcadeScreen_KeyUp(KeyCode As Integer, Shift As Integer)
Form_KeyUp KeyCode, Shift
End Sub

Private Sub Form_Unload(Cancel As Integer)
    End
End Sub

Private Sub mnuAbout_Click()
    frmAbout.Show
End Sub

Private Sub mnuEmuReset_Click()
reset6502
mnuReset_Click
End Sub

Private Sub mnuEmuStop_Click()
CPURunning = 0
MsgBox "Exit Address:$" & Hex$(PC)
End Sub

Private Sub mnuExit_Click()
  End
End Sub

Private Sub mnuReset_Click()
  Dim FrameTime As Double
  Dim TotalTime As Double
  Dim NumberOfFrames As Integer
  ArcadeScreen.Cls
  init6502
  reset6502
  NumberOfFrames = 0
  Do While KEY_ESC = 0
  If CPURunning = 0 Then Exit Sub
  If CPUPaused = 1 Then Exit Sub
    FrameTime = Timer
  If game = "centipede" Then
    For test = 1 To 4000
      exec6502
    Next test
    If Frames = FramesToSkip Then
        RedrawScreen
        Frames = 1
    Else
        Frames = Frames + 1
        DoEvents
    End If
    DoEvents
    TotalTime = TotalTime + (Timer - FrameTime)
    NumberOfFrames = NumberOfFrames + 1
  ElseIf game = "circus" Then
    For test = 1 To 4000
        exec6502
    Next test
    DoEvents
    RedrawCircus
    DoEvents
  ElseIf game = "warlord" Then
    For test = 1 To 4000
      exec6502
    Next test
    If Frames = FramesToSkip Then
        warRedrawScreen
        Frames = 1
    Else
        Frames = Frames + 1
        DoEvents
    End If
    DoEvents
    TotalTime = TotalTime + (Timer - FrameTime)
    NumberOfFrames = NumberOfFrames + 1
  ElseIf game = "vang" Then
    For test = 1 To 4000
        exec6502
    Next test
    If Frames = FramesToSkip Then
        Frames = 1
        RedrawRockScreen
    Else
        Frames = Frames + 1
        DoEvents
    End If
    TotalTime = TotalTime + (Timer - FrameTime)
    NumberOfFrames = NumberOfFrames + 1
   ElseIf game = "matmania" Then
    For i = 1 To 16606
        exec6502
    Next i
    DoEvents
    TotalTime = TotalTime + (Timer - FrameTime)
    NumberOfFrames = NumberOfFrames + 1
  ElseIf game = "astrof" Then
    For test = 1 To 16606
        exec6502
    Next test
    DoEvents
  Else
    For test = 1 To 4000
        exec6502
    Next test
    If Frames = FramesToSkip Then
        If VBlank > 0 Then
            MilliRedraw
        Else
            VBlank = VBlank + 1
        End If
    Else
        Frames = Frames + 1
        DoEvents
    End If
    DoEvents
    TotalTime = TotalTime + (Timer - FrameTime)
    NumberOfFrames = NumberOfFrames + 1
  End If
  Loop
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
If game = "astrof" And KeyCode = vbKey3 Then
    nmi6502
End If
    aKeyboard(KeyCode) = 1
End Sub

Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)
    aKeyboard(KeyCode) = 0
End Sub

Private Sub Form_Load()
  Arcade.Show
  Arcade.ScaleHeight = 3825
  Arcade.ArcadeScreen.Height = Arcade.ScaleHeight
  ChDir App.Path
  mnuFileFS4_Click
End Sub

Private Sub mnuFileFS1_Click()
FramesToSkip = 1
mnuFileFS1.Checked = True
mnuFileFS2.Checked = False
mnuFileFS3.Checked = False
mnuFileFS4.Checked = False
End Sub

Private Sub mnuFileFS2_Click()
FramesToSkip = 2
mnuFileFS2.Checked = True
mnuFileFS1.Checked = False
mnuFileFS3.Checked = False
mnuFileFS4.Checked = False
End Sub

Private Sub mnuFileFS3_Click()
FramesToSkip = 3
mnuFileFS3.Checked = True
mnuFileFS1.Checked = False
mnuFileFS2.Checked = False
mnuFileFS4.Checked = False
End Sub

Private Sub mnuFileFS4_Click()
FramesToSkip = 4
mnuFileFS4.Checked = True
mnuFileFS1.Checked = False
mnuFileFS2.Checked = False
mnuFileFS3.Checked = False
End Sub

Private Sub mnuGamesAstroF2_Click()
AstroF2Main
Caption = "PCSloMo v0.23br2-[Astro Fighter]"
CPURunning = 1
mnuReset_Click
End Sub

Private Sub mnuGamesCircus_Click()
CircusMain
Caption = "PCSloMo v0.23br2-[Circus]"
CPURunning = 1
mnuReset_Click
End Sub


Private Sub mnuGamesVanG_Click()
VanguardMain
Caption = "PCSloMo v0.23br2-[Vanguard]"
CPURunning = 1
mnuReset_Click
End Sub

Private Sub mnuMainGamesAstro_Click()
AstroMain
Caption = "PCSloMo v0.23br2-[Astro Fighter]"
CPURunning = 1
mnuReset_Click
End Sub

Private Sub mnuMainGamesCenti_Click()
Main
Caption = "PCSloMo v0.23br2-[Centipede]"
CPURunning = 1
mnuReset_Click
End Sub

Private Sub mnuMainGamesMilli_Click()
MilliMain
Caption = "PCSloMo v0.23br2-[Millipede]"
CPURunning = 1
mnuReset_Click
End Sub
