Attribute VB_Name = "RockOla"
'================================='
' Nibbler, Fantasy, Vangaurd      '
' RockOla.bas                     '
' Adds 3 classic games to SloMo   '
' By Don Jarrett, 1998            '
' Refrence: MAME                  '
'================================='
Public SCREEN_MEM2 As Long
Public WarpCharSet2(0 To 32768) As Byte
Public Sub VanguardMain()
' Emulates the Vangaurd Arcade Hardware
game = "vang"
SCREEN_MEM = &H400
SCREEN_MEM2 = &H800
SPRITE_XPOS = &H3200
SPRITE_YPOS = &H3300
AddressMask = &HFFFF&
Close #2
Erase gameImage
Erase VirtualScreen
' Load VROM
loadchar "c:\centi\sk5_ic50.bin", &H0&
loadchar "c:\centi\sk5_ic51.bin", &H800&
' Load ROMs
loadrom "c:\centi\sk4_ic07.bin", &H4000&
loadrom "c:\centi\sk4_ic08.bin", &H5000&
loadrom "c:\centi\sk4_ic09.bin", &H6000&
loadrom "c:\centi\sk4_ic10.bin", &H7000&
loadrom "c:\centi\sk4_ic13.bin", &H8000&
loadrom "c:\centi\sk4_ic13.bin", &HF000&
loadrom "c:\centi\sk4_ic14.bin", &H9000&
loadrom "c:\centi\sk4_ic15.bin", &HA000&
loadrom "c:\centi\sk4_ic16.bin ", &HB000&
' Set DipSwitches
gameImage(&H3106) = &H0
Pal(0) = QBColor(0)
Pal(1) = QBColor(1)
Pal(2) = QBColor(2)
Pal(3) = QBColor(3)
Pal(4) = QBColor(4)
Pal(5) = QBColor(5)
Pal(6) = QBColor(6)
Pal(7) = QBColor(7)
'0x00,0x2F,0xF4,0xFF,0xEF,0xF8,0xFF,0x07
' Get screen colors
WarpChars
' Init 6502
init6502
End Sub
Sub DumpCharGen()
Dim i As Integer
Dim xxx As String
Open "d:\chargen.txt" For Output As #1
For i = &H1000 To &H1FFF
xxx = xxx & Str(gameImage(i))
Next i
Print #1, xxx
Close #1
End Sub
Public Sub FantasyMain()
game = "fantasy"
SCREEN_MEM = &H800
SCREEN_MEM2 = &H400
AddressMask = &HFFFF&
' Clear Arrays
Erase VirtualScreen
Erase gameImage
' Load vRom
loadchar "ic50", 0
loadchar "ic51", &H1000
' Load ROMs
loadrom "ic12", &H3000
loadrom "ic07", &H4000
loadrom "ic08", &H5000
loadrom "ic09", &H6000
loadrom "ic10", &H7000
loadrom "ic14", 32768
loadrom "ic14", 61440
loadrom "ic15", 36864
loadrom "ic16", 40960
loadrom "ic17", 45056
' Init graphics
WarpChars
' init 6502 cpu
init6502
' done!
End Sub
Public Sub NibblerMain()
game = "nibbler"
SCREEN_MEM = &H400
AddressMask = &HFFFF&
' Load characters
loadchar "ic50", &H0
loadchar "ic51", &H1000
' Load CPU space
loadrom "ic12", &H3000
loadrom "ic07", &H4000
loadrom "ic08", &H5000
loadrom "ic09", &H6000
loadrom "ic10", &H7000
loadrom "ic14", &H8000&
loadrom "ic14", &HF000&
loadrom "ic15", 36864
loadrom "ic16", 40976
loadrom "ic17", 45056
' DipSwitches
gameImage(&H2106) = 0
' WarpChars
WarpChars
Pal(0) = 0
Pal(1) = QBColor(1)
Pal(2) = QBColor(2)
Pal(3) = QBColor(3)
Pal(4) = QBColor(4)
Pal(5) = QBColor(5)
Pal(6) = QBColor(6)
Pal(7) = QBColor(7)
init6502
WarpChars
End Sub
Public Function RedrawRockScreen()
  Dim x As Integer, y As Integer, count As Integer
  Dim xpos As Integer
  Dim ypos As Integer
  Dim offset As Integer
  Dim tid As Double
  Dim sluttid As Double
  Dim cx As Integer
  Dim cy As Integer
  Dim start As Long
  Dim hdc As Integer
  Dim x1 As Integer
  Dim y1 As Integer
  Dim col As Long
  Dim charcode As Integer
  Dim sx As Integer, sy As Integer
  tid = Timer
  Dim virx As Integer, viry As Integer
  Dim char As Byte
  Dim add As Byte
  count = 0
  'Draw chars
  If CPURunning = 1 Then
  For x = 0 To 29
    For y = 31 To 0 Step -1
        DrawSingleChar &H400 + count, x, y, 0
        count = count + 1
    Next y
  Next x
  
  'Draw sprites
  If Not game = "warlord" Or Not game = "vang" Or Not game = "eggs" Then
  For x = 0 To 15
    xpos = gameImage(SPRITE_XPOS + x)
    ypos = gameImage(SPRITE_YPOS + x)
    offset = gameImage(SPRITE_OFFSET + x)
    
    If (ypos < &HF8) Then
      drawsprite offset, xpos, ypos
    End If
  Next x
  End If
    If viewpic = 0 Then
    For virx = 0 To 256
      For viry = 0 To 256
        If VirtualScreen(0, virx, viry) = VirtualScreen(1, virx, viry) Then
        Else
          Arcade.ArcadeScreen.PSet (virx, viry), Pal(VirtualScreen(1, virx, viry))
          VirtualScreen(1, virx, viry) = VirtualScreen(0, virx, viry)
        End If
      Next viry
    Next virx
  End If
  If viewpic = 1 Then
    For virx = 0 To 256
      For viry = 0 To 256
        If VirtualScreen(0, virx, viry) = VirtualScreen(1, virx, viry) Then
        Else
          Arcade.ArcadeScreen.PSet (virx, viry), Pal(VirtualScreen(viewpic, virx, viry))
          VirtualScreen(0, virx, viry) = VirtualScreen(1, virx, viry)
       End If
      Next viry
    Next virx
  End If
  
  Arcade.ArcadeScreen.Refresh
  If viewpic = 0 Then
    viewpic = 1
  Else
    viewpic = 0
  End If
  End If
End Function
Public Function VanWr(addr As Long, value As Byte)
    'If addr = &H3200 Or addr = &H3300 Then Debug.Print addr, value
    gameImage(addr) = value And &HFF
End Function
Public Function VanRd(addr As Long) As Byte
    VanRd = gameImage(addr And AddressMask) And &HFF
End Function
