/*
 * Decompiled with CFR 0.152.
 */
import com.vladium.utils.timing.ITimer;
import com.vladium.utils.timing.TimerFactory;

class Animator
extends Thread {
    private CrtPanel crtPanel;
    private Control control;
    private SwitchPanel switchPanel;
    private final double speed = 1.44;
    private boolean keepAnimating = false;

    public Animator(CrtPanel aCrtPanel, Control aControl, SwitchPanel aSwitchPanel) {
        this.crtPanel = aCrtPanel;
        this.control = aControl;
        this.switchPanel = aSwitchPanel;
        this.setDaemon(true);
    }

    public synchronized void setKeepAnimating(boolean value) {
        this.keepAnimating = value;
    }

    public synchronized boolean getKeepAnimating() {
        return this.keepAnimating;
    }

    public void run() {
        this.setPriority(this.getPriority() + 1);
        this.setKeepAnimating(true);
        ITimer timer = TimerFactory.newTimer();
        for (int i = 0; i < 1000; ++i) {
            timer.start();
            timer.stop();
            timer.getDuration();
            timer.reset();
        }
        double elapse = 0.0;
        while (this.getKeepAnimating()) {
            timer.reset();
            timer.start();
            if (this.control.getStopFlag()) {
                this.setKeepAnimating(false);
            } else {
                for (int x = 0; x < this.control.getInstructionsPerRefresh() && !this.control.getStopFlag(); ++x) {
                    if (this.switchPanel.getManAuto()) {
                        this.control.executeAutomatic();
                        continue;
                    }
                    this.control.executeManual();
                }
                this.crtPanel.render();
                this.crtPanel.efficientRepaint();
                this.control.incCycleCount();
            }
            timer.stop();
            timer.reset();
            for (elapse = timer.getDuration(); elapse < 10.0; elapse += timer.getDuration()) {
                timer.start();
                for (int n = 0; n < 1000; ++n) {
                }
                timer.stop();
                timer.reset();
            }
        }
        Baby.running = false;
    }
}

