/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Timer;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class Baby
extends JApplet
implements ActionListener {
    File fileChooserDirectory;
    static String currentDir;
    private final boolean threadedAnimation = true;
    private static final double realCyclesPerSecond = 700.0;
    private double elapsedTime = 0.0;
    private Store store;
    private Control control;
    public SwitchPanel switchPanel;
    private Disassembler disassembler;
    CrtPanel crtPanel;
    private Animator animator;
    protected JButton stepButton = new JButton("Step");
    protected JButton runButton = new JButton("Run");
    protected JButton stopButton = new JButton("Stop");
    private JButton fpsLabel;
    private Color backgroundColor = SwitchPanel.backgroundColor;
    private javax.swing.Timer animateTimer;
    public static boolean running;
    public static TexturedJPanel mainPanel;
    public static JPanel globalPanel;
    JFrame aboutExamples = new JFrame();
    JTextPane viewer;
    private javax.swing.Timer fpsTimer;
    private Timer clockTimer;
    public JButton stopLamp;
    ImageIcon onIcon;
    ImageIcon offIcon;
    public static AudioClip gong;
    boolean firstLoad = true;

    public Baby() {
        try {
            currentDir = System.getProperty("user.home");
            System.out.println(currentDir);
        }
        catch (SecurityException e) {
            System.out.println("user.dir not accessible from applet");
            System.out.println(e.getMessage());
        }
        this.stepButton.addActionListener(this);
        this.runButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.store = new Store();
        this.control = new Control(this.store);
        this.store.setControl(this.control);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel toolPanel = new JPanel();
        toolPanel.setBackground(this.backgroundColor);
        toolPanel.add(this.stepButton);
        toolPanel.add(this.runButton);
        toolPanel.add(this.stopButton);
        JPanel infoPanel = new JPanel();
        infoPanel.setBackground(this.backgroundColor);
        this.fpsLabel = new JButton("Speed and elapsed time info.");
        this.fpsLabel.addActionListener(new FpsLabelPushed());
        infoPanel.add(this.fpsLabel);
        this.crtPanel = new CrtPanel(this.store, this.control);
        this.crtPanel.setOpaque(false);
        this.stopLamp = new JButton(this.offIcon);
        this.stopLamp.setFocusPainted(false);
        this.stopLamp.setBorderPainted(false);
        this.stopLamp.setContentAreaFilled(false);
        Insets marginSpace = new Insets(3, 3, 3, 3);
        this.stopLamp.setMargin(marginSpace);
        JPanel modernControls = new JPanel();
        modernControls.setBackground(this.backgroundColor);
        modernControls.add(infoPanel);
        modernControls.add(toolPanel);
        mainPanel = new TexturedJPanel("main.png");
        mainPanel.setLayout(new BorderLayout());
        globalPanel = new JPanel();
        globalPanel.setLayout(new BorderLayout());
        this.viewer = new JTextPane();
        this.viewer.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.viewer);
        this.aboutExamples.add(scrollPane);
        this.aboutExamples.setSize(450, 500);
        this.aboutExamples.setVisible(false);
        this.aboutExamples.setAlwaysOnTop(true);
        this.aboutExamples.setLocation(730, 250);
        this.crtPanel.setPreferredSize(new Dimension(400, 400));
        mainPanel.add((Component)this.crtPanel, "North");
        this.switchPanel = new SwitchPanel(this.store, this.control, this.crtPanel, this);
        this.switchPanel.setOpaque(false);
        this.control.setSwitchPanel(this.switchPanel);
        this.crtPanel.setPreferredSize(new Dimension(400, 386));
        mainPanel.add(this.switchPanel);
        mainPanel.setSize(690, 905);
        contentPane.add((Component)mainPanel, "Center");
        this.disassembler = new Disassembler(this.store, this.control, this.crtPanel);
        this.animateTimer = new javax.swing.Timer(0, this);
        this.animateTimer.setInitialDelay(0);
        this.animateTimer.setCoalesce(true);
        this.fpsTimer = new javax.swing.Timer(1000, this);
        this.fpsTimer.setInitialDelay(0);
        JMenuBar menuBar = new JMenuBar();
        this.menuSetup(menuBar);
        this.setJMenuBar(menuBar);
        this.store.reset();
        this.control.reset();
        try {
            this.store.loadLocalModernAssembly("diffeqt.asm");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getContentPane(), "Default program not loaded. " + e.getMessage(), "Error", 0);
        }
        this.crtPanel.render();
        this.crtPanel.repaint();
        this.stepButton.setToolTipText("Execute the next instruction.");
        this.runButton.setToolTipText("Start executing the instructions in the store.");
        this.stopButton.setToolTipText("Stop executing instructions.");
        this.fpsLabel.setToolTipText("Displays the speed of the simulation.");
        this.crtPanel.setToolTipText("The monitor.");
        this.stopLamp.setToolTipText("Lamp lit when the STP instruction is executed.");
        this.crtPanel.render();
        this.setVisible(true);
    }

    public void init() {
        try {
            File aud = new File("horn.wav");
            gong = this.getAudioClip(aud.toURI().toURL());
        }
        catch (MalformedURLException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (NullPointerException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        Baby baby = new Baby();
        baby.init();
        Frame mainFrame = new Frame();
        mainFrame.setSize(700, 950);
        mainFrame.setTitle("Baby");
        mainFrame.add(baby);
        mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        mainFrame.setVisible(true);
        mainFrame.setResizable(false);
    }

    private ImageIcon loadImage(String image) {
        int MAX_IMAGE_SIZE = 2400;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(this.getClass().getResourceAsStream(image));
        if (imgStream != null) {
            byte[] buf = new byte[MAX_IMAGE_SIZE];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Couldn't read stream from file: " + image);
                return null;
            }
            if (count <= 0) {
                System.err.println("Empty file: " + image);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
        }
        System.err.println("Couldn't find file: " + image);
        return null;
    }

    public void menuSetup(JMenuBar m) {
        JMenu fileMenu = new JMenu("File");
        JMenu viewMenu = new JMenu("View");
        JMenu exampleMenu = new JMenu("Examples");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem loadSnapshotAssembly = new JMenuItem("Load snapshot/assembly");
        JMenuItem saveSnapshot = new JMenuItem("Save snapshot");
        JMenuItem saveAssembly = new JMenuItem("Save assembly");
        JMenuItem close = new JMenuItem("Close");
        JMenuItem refManual = new JMenuItem("Reference Manual");
        JMenuItem diffeqt = new JMenuItem("diffeqt.asm");
        JMenuItem baby9 = new JMenuItem("Baby9.snp");
        JMenuItem primegen = new JMenuItem("primegen.asm");
        JMenuItem virpet = new JMenuItem("virpet.asm");
        JMenuItem noodleTimer = new JMenuItem("noodletimer.snp");
        JMenuItem viewStore = new JMenuItem("Store");
        JMenuItem viewControl = new JMenuItem("Control");
        JMenuItem viewAccumulator = new JMenuItem("Accumulator");
        JMenuItem viewDisassembler = new JMenuItem("Disassembler");
        JMenuItem aboutsim = new JMenuItem("About the simulator");
        JMenuItem aboutex = new JMenuItem("About the examples");
        loadSnapshotAssembly.addActionListener(new LoadSnapshotAssembly());
        saveSnapshot.addActionListener(new SaveSnapshot());
        saveAssembly.addActionListener(new SaveAssembly());
        diffeqt.addActionListener(new LoadExample("diffeqt.asm"));
        baby9.addActionListener(new LoadExample("Baby9.snp"));
        primegen.addActionListener(new LoadExample("primegen.asm"));
        virpet.addActionListener(new LoadExample("virpet.asm"));
        noodleTimer.addActionListener(new LoadExample("noodletimer.snp"));
        aboutex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Baby.this.aboutExamples.setVisible(true);
                try {
                    Baby.this.viewer.setPage(Baby.class.getResource("aboutexamples.html"));
                }
                catch (IOException err) {
                    Baby.this.viewer.setContentType("text/html");
                    Baby.this.viewer.setText("<html>Could not load example info </html>");
                }
                catch (NullPointerException err) {
                    Baby.this.viewer.setContentType("text/html");
                    Baby.this.viewer.setText("<html>Could not load example info </html>");
                }
            }
        });
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        viewStore.addActionListener(new ViewStore(this.crtPanel));
        viewControl.addActionListener(new ViewControl(this.crtPanel));
        viewAccumulator.addActionListener(new ViewAccumulator(this.crtPanel));
        viewDisassembler.addActionListener(new ViewDisassembler(this.disassembler));
        aboutsim.addActionListener(new About());
        loadSnapshotAssembly.setMnemonic(76);
        fileMenu.add(loadSnapshotAssembly);
        fileMenu.add(saveSnapshot);
        fileMenu.add(saveAssembly);
        fileMenu.add(close);
        viewMenu.add(viewStore);
        viewMenu.add(viewControl);
        viewMenu.add(viewAccumulator);
        viewMenu.add(viewDisassembler);
        exampleMenu.add(diffeqt);
        exampleMenu.add(baby9);
        exampleMenu.add(primegen);
        exampleMenu.add(virpet);
        exampleMenu.add(noodleTimer);
        helpMenu.add(aboutex);
        helpMenu.add(aboutsim);
        m.add(fileMenu);
        m.add(viewMenu);
        m.add(exampleMenu);
        m.add(helpMenu);
    }

    public synchronized void startAnimation() {
        if (!running) {
            this.animator = new Animator(this.crtPanel, this.control, this.switchPanel);
            this.animator.start();
        }
        this.fpsTimer.start();
        this.control.setCycleCount(0);
        running = true;
    }

    public void stopAnimation() {
        if (running) {
            this.animator.setKeepAnimating(false);
            running = false;
        }
        this.switchPanel.updateActionLine();
        this.crtPanel.render();
        this.crtPanel.repaint();
        this.fpsTimer.stop();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.animateTimer) {
            if (this.control.getStopFlag()) {
                this.stopAnimation();
            } else {
                for (int x = 0; x < this.control.getInstructionsPerRefresh() && !this.control.getStopFlag(); ++x) {
                    if (this.switchPanel.getManAuto()) {
                        this.control.executeAutomatic();
                        continue;
                    }
                    this.control.executeManual();
                }
                this.crtPanel.render();
                this.crtPanel.efficientRepaint();
                this.control.incCycleCount();
            }
        } else if (e.getSource() == this.fpsTimer) {
            this.updateFpsLabel();
            int actualFpsValue = this.control.getCycleCount() * this.control.getInstructionsPerRefresh();
            if (actualFpsValue > 730) {
                int newValue = this.control.getInstructionsPerRefresh();
                if (--newValue < 1) {
                    newValue = 1;
                }
                this.control.setInstructionsPerRefresh(newValue);
            } else if (actualFpsValue < 670) {
                int newValue = this.control.getInstructionsPerRefresh();
                if (++newValue > 20) {
                    newValue = 20;
                }
                this.control.setInstructionsPerRefresh(newValue);
            }
            this.control.setCycleCount(0);
            if (!running) {
                this.fpsTimer.stop();
            }
        } else if (e.getSource() == this.stepButton) {
            this.switchPanel.setManAuto(true);
            this.switchPanel.setEraseWrite(true);
            for (int lStatSwitch = 0; lStatSwitch < 5; ++lStatSwitch) {
                this.switchPanel.lineSwitch[lStatSwitch].setSelected(true);
            }
            for (int fStatSwitch = 0; fStatSwitch < 3; ++fStatSwitch) {
                this.switchPanel.functionSwitch[fStatSwitch].setSelected(true);
            }
            this.switchPanel.kspSwitch.doClick();
        } else if (e.getSource() == this.runButton) {
            this.switchPanel.setManAuto(true);
            this.switchPanel.setEraseWrite(true);
            for (int lStatSwitch = 0; lStatSwitch < 5; ++lStatSwitch) {
                this.switchPanel.lineSwitch[lStatSwitch].setSelected(true);
            }
            for (int fStatSwitch = 0; fStatSwitch < 3; ++fStatSwitch) {
                this.switchPanel.functionSwitch[fStatSwitch].setSelected(true);
            }
            if (!this.switchPanel.getPrePulse()) {
                this.switchPanel.prePulse.doClick();
            }
        } else if (e.getSource() == this.stopButton && this.switchPanel.getPrePulse()) {
            this.switchPanel.prePulse.doClick();
        }
    }

    private void updateFpsLabel() {
        String elapsedTimeS;
        this.elapsedTime += (double)(this.control.getCycleCount() * this.control.getInstructionsPerRefresh()) / 700.0;
        String percentage = "" + (double)(this.control.getCycleCount() * this.control.getInstructionsPerRefresh()) / 700.0 * 100.0;
        int pointPos = percentage.indexOf(46);
        if (pointPos != -1) {
            percentage = percentage.substring(0, pointPos + 2);
        }
        if ((pointPos = (elapsedTimeS = "" + this.elapsedTime).indexOf(46)) != -1) {
            elapsedTimeS = elapsedTimeS.substring(0, pointPos + 2);
        }
        this.fpsLabel.setText("" + this.control.getCycleCount() * this.control.getInstructionsPerRefresh() + " fps " + percentage + "% " + elapsedTimeS + "s");
    }

    public void updateStopLamp() {
        if (this.control.getStopFlag()) {
            mainPanel.changeTexture("mainon.png");
            mainPanel.repaint();
            try {
                gong = this.getAudioClip(this.getCodeBase(), "TestSnd.wav");
                gong.play();
            }
            catch (Exception e) {
                System.out.println("sound: " + e.getMessage());
            }
        } else {
            mainPanel.changeTexture("main.png");
            mainPanel.repaint();
        }
    }

    static {
        running = false;
    }

    class LoadExample
    implements ActionListener {
        String fileName;

        public LoadExample(String name) {
            this.fileName = name;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.fileName.equals("noodletimer.snp") || this.fileName.equals("Baby9.snp")) {
                    Baby.this.store.loadLocalSnapshot(this.fileName);
                } else {
                    Baby.this.store.loadLocalModernAssembly(this.fileName);
                }
                mainPanel.changeTexture("main.png");
                mainPanel.repaint();
                Baby.this.crtPanel.render();
                Baby.this.crtPanel.repaint();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Baby.this.getContentPane(), ex.getMessage(), "Error", 0);
            }
        }
    }

    class About
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Baby.this.getContentPane(), "Manchester Small Scale Experimental Machine ('The Baby') Simulator\n\nOriginal codebase: David Sharp, 2001.\n\nHistorical and technical consultant: Chris Burton.\n\nInterface design and implementation, based on photographs of the rebuilt\nBaby, now at Manchester Museum of Science and Industry (MOSI):\nGulzaman Khan, 2008.", "Baby", 1);
        }
    }

    class FpsLabelPushed
    implements ActionListener {
        FpsLabelPushed() {
        }

        public void actionPerformed(ActionEvent e) {
            Baby.this.elapsedTime = 0.0;
            Baby.this.control.setCycleCount(0);
            Baby.this.updateFpsLabel();
        }
    }

    class ViewDisassembler
    implements ActionListener {
        Disassembler disassembler;

        public ViewDisassembler(Disassembler aDisassembler) {
            this.disassembler = aDisassembler;
        }

        public void actionPerformed(ActionEvent e) {
            this.disassembler.updateTextArea();
            this.disassembler.setVisible(true);
        }
    }

    class ViewSwitchPanel
    implements ActionListener {
        SwitchPanel switchPanel;

        public ViewSwitchPanel(SwitchPanel aSwitchPanel) {
            this.switchPanel = aSwitchPanel;
        }

        public void actionPerformed(ActionEvent e) {
            this.switchPanel.setVisible(true);
        }
    }

    class ViewAccumulator
    implements ActionListener {
        CrtPanel crtPanel;

        public ViewAccumulator(CrtPanel aCrtPanel) {
            this.crtPanel = aCrtPanel;
        }

        public void actionPerformed(ActionEvent e) {
            this.crtPanel.setCrtDisplay(2);
            Baby.this.switchPanel.accSelect.setSelected(true);
        }
    }

    class ViewControl
    implements ActionListener {
        CrtPanel crtPanel;

        public ViewControl(CrtPanel aCrtPanel) {
            this.crtPanel = aCrtPanel;
        }

        public void actionPerformed(ActionEvent e) {
            this.crtPanel.setCrtDisplay(1);
            Baby.this.switchPanel.crSelect.setSelected(true);
        }
    }

    class ViewStore
    implements ActionListener {
        CrtPanel crtPanel;

        public ViewStore(CrtPanel aCrtPanel) {
            this.crtPanel = aCrtPanel;
        }

        public void actionPerformed(ActionEvent e) {
            this.crtPanel.setCrtDisplay(0);
            Baby.this.switchPanel.storeSelect.setSelected(true);
        }
    }

    class SaveAssembly
    implements ActionListener {
        SaveAssembly() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(currentDir);
            fc.setDialogTitle("Save assembly as...");
            int returnVal = fc.showSaveDialog(Baby.this.getContentPane());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                try {
                    Baby.this.store.saveAssembly(file.toString());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Baby.this.getContentPane(), ex.getMessage(), "Error", 0);
                }
            }
            Baby.this.getContentPane().repaint();
        }
    }

    class SaveSnapshot
    implements ActionListener {
        SaveSnapshot() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(currentDir);
            fc.setDialogTitle("Save snapshot as...");
            int returnVal = fc.showSaveDialog(Baby.this.getContentPane());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                try {
                    Baby.this.store.saveSnapshot(file.toString());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Baby.this.getContentPane(), ex.getMessage(), "Error", 0);
                }
            }
            Baby.this.getContentPane().repaint();
        }
    }

    class LoadSnapshotAssembly
    implements ActionListener {
        LoadSnapshotAssembly() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = Baby.this.firstLoad ? new JFileChooser(currentDir) : new JFileChooser(Baby.this.fileChooserDirectory);
            Baby.this.firstLoad = false;
            fc.setDialogTitle("Load snapshot or assembly...");
            int returnVal = fc.showOpenDialog(Baby.this.getContentPane());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                Baby.this.fileChooserDirectory = file.getParentFile();
                String currentFile = file.toString();
                try {
                    Baby.this.control.setInstructionsPerRefresh(4);
                    switch (Baby.this.store.getFileType(currentFile)) {
                        case 0: {
                            JOptionPane.showMessageDialog(Baby.this.getContentPane(), "Unrecognised file type", "Error", 0);
                            break;
                        }
                        case 1: {
                            Baby.this.store.loadSnapshot(currentFile);
                            break;
                        }
                        case 2: {
                            Baby.this.store.loadModernAssembly(currentFile);
                            break;
                        }
                        default: {
                            JOptionPane.showMessageDialog(Baby.this.getContentPane(), "Unrecognised file type", "Error", 0);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Baby.this.getContentPane(), ex.getMessage(), "Error", 0);
                    System.out.println("fnf");
                }
            }
            Baby.this.crtPanel.render();
            Baby.this.getContentPane().repaint();
        }
    }
}

