/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class Disassembler
extends JFrame {
    Store store;
    Control control;
    CrtPanel crtPanel;
    JTextArea textArea;

    public Disassembler(Store aStore, Control aControl, CrtPanel aCrtPanel) {
        this.store = aStore;
        this.control = aControl;
        this.crtPanel = aCrtPanel;
        this.setTitle("Disassembler");
        this.setSize(300, 500);
        Container contentPane = this.getContentPane();
        JPanel backPanel = new JPanel(new BorderLayout());
        JButton loadFromStore = new JButton("Load from store");
        JButton saveToStore = new JButton("Save to store");
        this.textArea = new JTextArea();
        this.textArea.setEditable(true);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        loadFromStore.addActionListener(new UpdateTextArea());
        saveToStore.addActionListener(new UpdateStore());
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setPreferredSize(new Dimension(100, 100));
        JPanel controlsPanel = new JPanel();
        controlsPanel.add(loadFromStore);
        controlsPanel.add(saveToStore);
        backPanel.add((Component)controlsPanel, "North");
        backPanel.add((Component)scrollPane, "Center");
        contentPane.add(backPanel);
    }

    public void updateTextArea() {
        String output = "";
        output = output + "; CI: " + this.control.getControlInstruction() + "\n";
        output = output + "; PI: " + Store.disassembleModern(this.control.getPresentInstruction()) + "\n";
        output = output + "; ACC: " + this.control.getAccumulator() + "\n\n";
        for (int lineNumber = 0; lineNumber < 32; ++lineNumber) {
            String lineNumberS = "" + lineNumber;
            while (lineNumberS.length() < 2) {
                lineNumberS = "0" + lineNumberS;
            }
            output = output + lineNumberS + "  " + Store.disassembleModern(this.store.getLine(lineNumber)) + "\n";
        }
        this.textArea.setText(output);
    }

    class UpdateStore
    implements ActionListener {
        UpdateStore() {
        }

        public void actionPerformed(ActionEvent e) {
            String fullText = Disassembler.this.textArea.getText();
            StringTokenizer tokenizer = new StringTokenizer(fullText, "\n");
            try {
                int tokenCounter = 0;
                while (tokenizer.hasMoreElements()) {
                    Disassembler.this.store.assembleModernToStore(tokenizer.nextToken(), ++tokenCounter);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Disassembler.this.getContentPane(), ex.getMessage(), "Error", 0);
            }
            Disassembler.this.crtPanel.render();
            Disassembler.this.crtPanel.repaint();
        }
    }

    class UpdateTextArea
    implements ActionListener {
        UpdateTextArea() {
        }

        public void actionPerformed(ActionEvent e) {
            Disassembler.this.updateTextArea();
        }
    }
}

