/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;

class InterlockingPushButton
extends JRadioButton {
    public InterlockingPushButton(String textValue, int verticalPosition) {
        ImageIcon inIcon = this.loadImage("ibuttonin.gif");
        ImageIcon outIcon = this.loadImage("ibuttonout.gif");
        this.setIcon(outIcon);
        this.setSelectedIcon(inIcon);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        Insets marginSpace = new Insets(3, 3, 3, 3);
        this.setMargin(marginSpace);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(verticalPosition);
        this.setText(textValue);
    }

    private ImageIcon loadImage(String image) {
        int MAX_IMAGE_SIZE = 2400;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(this.getClass().getResourceAsStream(image));
        if (imgStream != null) {
            byte[] buf = new byte[MAX_IMAGE_SIZE];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Couldn't read stream from file: " + image);
                return null;
            }
            if (count <= 0) {
                System.err.println("Empty file: " + image);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
        }
        System.err.println("Couldn't find file: " + image);
        return null;
    }
}

