/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

class KeySwitch
extends JButton {
    public KeySwitch(String textValue, String downIconFileName, String upIconFileName) {
        ImageIcon upIcon = this.loadImage(upIconFileName);
        ImageIcon downIcon = this.loadImage(downIconFileName);
        this.setIcon(upIcon);
        this.setPressedIcon(downIcon);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        Insets marginSpace = new Insets(3, 3, 3, 3);
        this.setMargin(marginSpace);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(1);
        this.setText(textValue);
    }

    private ImageIcon loadImage(String image) {
        int MAX_IMAGE_SIZE = 2400;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(this.getClass().getResourceAsStream(image));
        if (imgStream != null) {
            byte[] buf = new byte[MAX_IMAGE_SIZE];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Couldn't read stream from file: " + image);
                return null;
            }
            if (count <= 0) {
                System.err.println("Empty file: " + image);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
        }
        System.err.println("Couldn't find file: " + image);
        return null;
    }
}

