/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;

class PushButton
extends JButton {
    private ImageIcon inIcon = this.loadImage("pushin.gif");
    private ImageIcon outIcon = this.loadImage("pushout.gif");

    public PushButton(String textValue, int verticalPosition) {
        this.setIcon(this.outIcon);
        this.setPressedIcon(this.inIcon);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(verticalPosition);
        this.setText(textValue);
    }

    public Image getImage(String fileName) {
        URL imageURL = this.getClass().getClassLoader().getResource(fileName);
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL).getImage();
    }

    protected ImageIcon loadImage(String image) {
        int MAX_IMAGE_SIZE = 2400;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(this.getClass().getResourceAsStream(image));
        if (imgStream != null) {
            byte[] buf = new byte[MAX_IMAGE_SIZE];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Couldn't read stream from file: " + image);
                return null;
            }
            if (count <= 0) {
                System.err.println("Empty file: " + image);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
        }
        System.err.println("Couldn't find file: " + image);
        return null;
    }
}

