/*
 * Decompiled with CFR 0.152.
 */
class Control {
    private Store store;
    private int accumulator;
    private int controlInstruction;
    private int presentInstruction;
    private int oldPresentInstruction = 0;
    private boolean stopFlag = false;
    private int cycleCount = 0;
    private int instructionsPerRefresh = 2;
    public SwitchPanel switchPanel;
    private boolean keyPressed = false;
    private int keyNumberPressed;
    private boolean kscPressed = false;
    private boolean kccPressed = false;
    private boolean klcPressed = false;
    private boolean kacPressed = false;
    private boolean setToErase = false;

    public Control(Store aStore) {
        this.store = aStore;
    }

    public void reset() {
        this.setStopFlag(false);
        this.controlInstruction = 0;
        this.presentInstruction = 0;
        this.accumulator = 0;
    }

    public void setSwitchPanel(SwitchPanel aSwitchPanel) {
        this.switchPanel = aSwitchPanel;
    }

    public int getControlInstruction() {
        return this.controlInstruction;
    }

    public void setControlInstruction(int value) {
        this.controlInstruction = value;
    }

    public synchronized int getCycleCount() {
        return this.cycleCount;
    }

    public synchronized void setCycleCount(int value) {
        this.cycleCount = value;
    }

    public synchronized void incCycleCount() {
        ++this.cycleCount;
    }

    public synchronized int getInstructionsPerRefresh() {
        return this.instructionsPerRefresh;
    }

    public synchronized void setInstructionsPerRefresh(int value) {
        this.instructionsPerRefresh = value;
    }

    public void incrementControlInstruction() {
        ++this.controlInstruction;
    }

    public int getPresentInstruction() {
        return this.presentInstruction;
    }

    public void setPresentInstruction(int value) {
        this.presentInstruction = value;
    }

    public int getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(int value) {
        this.accumulator = value;
    }

    public synchronized boolean getStopFlag() {
        return this.stopFlag;
    }

    public void setStopFlag(boolean value) {
        this.stopFlag = value;
        this.switchPanel.baby.updateStopLamp();
    }

    public int averageStoreChanges() {
        boolean localStopFlag = this.getStopFlag();
        int localControlInstruction = this.getControlInstruction();
        int localAccumulator = this.getAccumulator();
        int[] localStore = new int[32];
        for (int line = 0; line < 32; ++line) {
            localStore[line] = this.store.getLine(line);
        }
        int storeChanges = 0;
        block10: for (int instructionCount = 0; instructionCount < 700; ++instructionCount) {
            int localPresentInstruction = localStore[this.getLineNumber(++localControlInstruction)];
            switch (this.getFunctionNumber(localPresentInstruction)) {
                case 0: {
                    localControlInstruction = localStore[this.getLineNumber(localPresentInstruction)];
                    continue block10;
                }
                case 1: {
                    localControlInstruction += localStore[this.getLineNumber(localPresentInstruction)];
                    continue block10;
                }
                case 2: {
                    localAccumulator = -localStore[this.getLineNumber(localPresentInstruction)];
                    continue block10;
                }
                case 3: {
                    localStore[this.getLineNumber((int)localPresentInstruction)] = localAccumulator;
                    ++storeChanges;
                    continue block10;
                }
                case 4: 
                case 5: {
                    localAccumulator -= localStore[this.getLineNumber(localPresentInstruction)];
                    continue block10;
                }
                case 6: {
                    if (localAccumulator >= 0) continue block10;
                    ++localControlInstruction;
                    continue block10;
                }
                case 7: {
                    localStopFlag = true;
                }
            }
        }
        if (localStopFlag) {
            storeChanges = 0;
        }
        return storeChanges;
    }

    public synchronized void executeAutomatic() {
        this.oldPresentInstruction = this.presentInstruction;
        this.incrementControlInstruction();
        int switchValue = this.switchPanel.getLineAndFunctionValue();
        int controlInstructionValue = this.getControlInstruction() & switchValue;
        this.presentInstruction = this.store.getLine(this.getLineNumber(controlInstructionValue));
        if (this.keyPressed) {
            int actionLine;
            if (this.switchPanel.getEraseWrite()) {
                this.presentInstruction |= 1 << this.keyNumberPressed;
                actionLine = this.getLineNumber(this.presentInstruction);
                this.store.setLine(actionLine, this.store.getLine(actionLine) | 1 << this.keyNumberPressed);
            } else {
                this.presentInstruction &= ~(1 << this.keyNumberPressed);
                actionLine = this.getLineNumber(this.presentInstruction);
                this.store.setLine(actionLine, this.store.getLine(actionLine) & ~(1 << this.keyNumberPressed));
            }
        }
        if (this.klcPressed) {
            this.presentInstruction = 0;
            this.store.setLine(0, 0);
        }
        if (this.kacPressed) {
            this.setAccumulator(0);
        }
        if (this.kacPressed) {
            this.setAccumulator(0);
        }
        if (this.kscPressed) {
            this.store.reset();
        }
        if (this.kccPressed) {
            this.setControlInstruction(0);
            this.setPresentInstruction(0);
            this.setAccumulator(0);
        }
        if (this.getFunctionNumber(controlInstructionValue) != 0 && this.getFunctionNumber(controlInstructionValue) == 1) {
            this.presentInstruction += this.oldPresentInstruction;
        }
        int presentInstructionValue = this.presentInstruction & switchValue;
        this.performInstruction(presentInstructionValue);
    }

    public void executeManual() {
        int instructionValue = this.switchPanel.getLineAndFunctionValue();
        if (this.kacPressed) {
            this.setAccumulator(0);
        }
        if (this.kscPressed) {
            this.store.reset();
        }
        if (this.klcPressed) {
            this.store.setLine(this.switchPanel.getLineValue(), 0);
        }
        if (this.kccPressed) {
            this.setControlInstruction(0);
            this.setPresentInstruction(0);
            this.setAccumulator(0);
        }
        if (this.keyPressed) {
            if (this.switchPanel.getEraseWrite()) {
                int actionLine = this.getLineNumber(instructionValue);
                this.store.setLine(actionLine, this.store.getLine(actionLine) | 1 << this.keyNumberPressed);
            } else {
                int actionLine = this.getLineNumber(instructionValue);
                this.store.setLine(actionLine, this.store.getLine(actionLine) & ~(1 << this.keyNumberPressed));
            }
        }
        this.performInstruction(instructionValue);
        this.setPresentInstruction(this.store.getLine(this.getControlInstruction()));
    }

    public synchronized void performInstruction(int instructionValue) {
        switch (this.getFunctionNumber(instructionValue)) {
            case 0: {
                this.controlInstruction = this.store.getLine(this.getLineNumber(instructionValue));
                break;
            }
            case 1: {
                this.controlInstruction += this.store.getLine(this.getLineNumber(instructionValue));
                break;
            }
            case 2: {
                this.accumulator = -this.store.getLine(this.getLineNumber(instructionValue));
                break;
            }
            case 3: {
                this.store.setLine(this.getLineNumber(instructionValue), this.accumulator);
                break;
            }
            case 4: 
            case 5: {
                this.accumulator -= this.store.getLine(this.getLineNumber(instructionValue));
                break;
            }
            case 6: {
                if (this.accumulator >= 0) break;
                this.incrementControlInstruction();
                break;
            }
            case 7: {
                this.setStopFlag(true);
            }
        }
    }

    public boolean makesUseOfActionLine(int instructionValue) {
        boolean result = false;
        switch (this.getFunctionNumber(instructionValue)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                result = true;
                break;
            }
            case 6: 
            case 7: {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public String toString() {
        String output = "";
        output = output + "Control Instruction: " + this.controlInstruction + "\n";
        output = output + "Present Instruction: " + this.presentInstruction + "\n";
        output = output + "Accumulator: " + this.accumulator + "\n";
        output = output + "Stopped: ";
        output = this.getStopFlag() ? output + "true" : output + "false";
        return output;
    }

    public void setKeyPressed(boolean set, int keyNumber) {
        this.keyPressed = set;
        this.keyNumberPressed = keyNumber;
    }

    public void setKlcPressed(boolean value) {
        this.klcPressed = value;
    }

    public void setKacPressed(boolean value) {
        this.kacPressed = value;
    }

    public void setKscPressed(boolean value) {
        this.kscPressed = value;
    }

    public void setKccPressed(boolean value) {
        this.kccPressed = value;
    }

    public int getLineNumber(int value) {
        return value & 0x1F;
    }

    private int getFunctionNumber(int value) {
        return value >> 13 & 7;
    }
}

