/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.swing.JPanel;

class CrtPanel
extends JPanel {
    public static final int STORE = 0;
    public static final int CONTROL = 1;
    public static final int ACCUMULATOR = 2;
    public static final int crtWidth = 400;
    public static final int crtHeight = 290;
    public static final int rasterOffsetx = 200;
    public static final int rasterOffsety = 95;
    public static final int bitLength = 6;
    public static final int spacing = 3;
    private int currentDisplay = 0;
    private boolean renderAccurately = true;
    static String bitOneFileName = "bit1.gif";
    static String bitZeroFileName = "bit0.gif";
    static String bitOneBrightFileName = "bit1bright.gif";
    static String bitZeroBrightFileName = "bit0bright.gif";
    private Store store;
    private Control control;
    private int actionLine = 0;
    private Image bit1;
    private Image bit0;
    private Image bit1bright;
    private Image bit0bright;
    private BufferedImage bi = new BufferedImage(400, 290, 2);
    private Color backgroundFill = SwitchPanel.backgroundColor;

    public CrtPanel(Store aStore, Control aControl) {
        this.store = aStore;
        this.control = aControl;
        this.bit1 = this.loadImage(bitOneFileName);
        this.bit0 = this.loadImage(bitZeroFileName);
        this.bit1bright = this.loadImage(bitOneBrightFileName);
        this.bit0bright = this.loadImage(bitZeroBrightFileName);
        this.render();
        this.repaint();
    }

    private Image loadImage(String image) {
        int MAX_IMAGE_SIZE = 2400;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(this.getClass().getResourceAsStream(image));
        if (imgStream != null) {
            byte[] buf = new byte[MAX_IMAGE_SIZE];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Couldn't read stream from file: " + image);
                return null;
            }
            if (count <= 0) {
                System.err.println("Empty file: " + image);
                return null;
            }
            return Toolkit.getDefaultToolkit().createImage(buf);
        }
        System.err.println("Couldn't find file: " + image);
        return null;
    }

    public void setCrtDisplay(int display) {
        int beforeDisplay = this.currentDisplay;
        for (int x = 0; x < 32; ++x) {
            this.store.lineAltered[x] = true;
        }
        switch (display) {
            case 0: 
            case 1: 
            case 2: {
                this.currentDisplay = display;
                break;
            }
            default: {
                this.currentDisplay = 0;
            }
        }
        if (this.currentDisplay != beforeDisplay) {
            for (int lineNumber = 0; lineNumber < 32; ++lineNumber) {
                this.store.lineAltered[lineNumber] = true;
            }
            this.render();
            this.repaint();
        }
    }

    public int getCrtDisplay() {
        return this.currentDisplay;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.update(g);
    }

    public synchronized void efficientRepaint() {
        switch (this.currentDisplay) {
            case 0: {
                for (int lineNumber = 0; lineNumber < 31; ++lineNumber) {
                    if (!this.store.lineAltered[lineNumber]) continue;
                    this.repaint(0, 3 + lineNumber * 6, 400, 3 + (lineNumber + 1) * 6);
                    this.store.lineAltered[lineNumber] = false;
                }
                break;
            }
            case 2: {
                if (this.renderAccurately) {
                    this.repaint();
                    break;
                }
                this.repaint(0, 0, 400, 9);
                break;
            }
            case 1: {
                if (this.renderAccurately) {
                    this.repaint();
                    break;
                }
                this.repaint(0, 0, 400, 15);
                break;
            }
            default: {
                this.repaint();
            }
        }
    }

    public void update(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)this.bi, 0, 0, this);
    }

    public void setActionLine(int newActionLine) {
        if (newActionLine < 0) {
            if (this.actionLine > 0 && this.actionLine < 32) {
                this.store.lineAltered[this.actionLine] = true;
            }
            this.actionLine = newActionLine;
        } else if (this.actionLine != newActionLine) {
            if (this.actionLine > 0 && this.actionLine < 32) {
                this.store.lineAltered[this.actionLine] = true;
            }
            this.actionLine = newActionLine;
            this.store.lineAltered[this.actionLine] = true;
            this.render();
            this.repaint();
        }
    }

    public synchronized void render() {
        switch (this.currentDisplay) {
            case 0: {
                this.renderStore();
                break;
            }
            case 2: {
                this.renderAccumulator();
                break;
            }
            case 1: {
                this.renderControl();
                break;
            }
            default: {
                this.renderStore();
            }
        }
    }

    private void initialRender() {
        Graphics2D big = this.bi.createGraphics();
        big.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        big.setColor(Color.black);
        big.fillOval(0, 0, 400, 290);
    }

    private void renderStore() {
        Graphics2D big = this.bi.createGraphics();
        for (int lineNumber = 0; lineNumber < 32; ++lineNumber) {
            if (!this.store.lineAltered[lineNumber]) continue;
            if (this.actionLine == lineNumber) {
                this.drawActionDataAtLine(this.store.getLine(lineNumber), lineNumber, big);
                continue;
            }
            this.drawDataAtLine(this.store.getLine(lineNumber), lineNumber, big);
        }
    }

    public void renderControl() {
        Graphics2D big = this.bi.createGraphics();
        if (this.renderAccurately) {
            if (Baby.running) {
                for (int line = 0; line < 32; line += 2) {
                    this.drawDataAtLine(this.control.getControlInstruction(), line, big);
                    this.drawDataAtLine(this.control.getPresentInstruction(), line + 1, big);
                }
            } else {
                for (int line = 0; line < 32; ++line) {
                    this.drawDataAtLine(this.control.getControlInstruction(), line, big);
                }
            }
        } else {
            this.drawDataAtLine(this.control.getControlInstruction(), 0, big);
            this.drawDataAtLine(this.control.getPresentInstruction(), 1, big);
        }
    }

    public void renderAccumulator() {
        Graphics2D big = this.bi.createGraphics();
        this.drawDataAtLine(this.control.getAccumulator(), 0, big);
        if (this.renderAccurately) {
            for (int line = 1; line < 32; ++line) {
                this.drawDataAtLine(this.control.getAccumulator(), line, big);
            }
        }
    }

    private void drawDataAtLine(int data, int line, Graphics2D graphicsContext) {
        for (int bitNumber = 31; bitNumber >= 0; --bitNumber) {
            if ((data >> bitNumber & 1) == 1) {
                graphicsContext.drawImage(this.bit1, 203 + bitNumber * 6, 98 + line * 6, null);
                continue;
            }
            graphicsContext.drawImage(this.bit0, 203 + bitNumber * 6, 98 + line * 6, null);
        }
    }

    private void drawActionDataAtLine(int data, int line, Graphics2D graphicsContext) {
        for (int bitNumber = 31; bitNumber >= 0; --bitNumber) {
            if ((data >> bitNumber & 1) == 1) {
                graphicsContext.drawImage(this.bit1bright, 203 + bitNumber * 6, 98 + line * 6, null);
                continue;
            }
            graphicsContext.drawImage(this.bit0bright, 203 + bitNumber * 6, 98 + line * 6, null);
        }
    }
}

