/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;

class Store {
    private int[] line = new int[32];
    private Control control;
    public boolean[] lineAltered = new boolean[32];
    public static final int UNACCEPTABLE = 0;
    public static final int SNAPSHOT = 1;
    public static final int ASSEMBLY = 2;

    public Store() {
        for (int x = 0; x < 32; ++x) {
            this.lineAltered[x] = true;
        }
    }

    public void setControl(Control aControl) {
        this.control = aControl;
    }

    public void setLine(int lineNumber, int value) {
        this.line[lineNumber] = value;
        this.lineAltered[lineNumber] = true;
    }

    public int getLine(int lineNumber) {
        return this.line[lineNumber];
    }

    public int getBit(int lineNumber, int bitNumber) {
        return this.line[lineNumber] >> bitNumber & 1;
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.line[i] = 0;
            this.lineAltered[i] = true;
        }
    }

    public String toString() {
        String output = "";
        for (int lineNum = 0; lineNum < 32; ++lineNum) {
            String lineOutput = Store.getBinaryString(this.getLine(lineNum));
            lineOutput = Store.reverseString(lineOutput);
            output = output + lineOutput + "  " + Store.disassembleModern(this.getLine(lineNum)) + "\n";
        }
        return output;
    }

    public void saveSnapshot(String fileName) throws IOException {
        int line;
        File snapshotFile = new File(fileName);
        FileWriter snapshotWriter = new FileWriter(snapshotFile);
        BufferedWriter out = new BufferedWriter(snapshotWriter);
        int numLines = 0;
        for (line = 0; line < 32; ++line) {
            if (this.getLine(line) == 0) continue;
            ++numLines;
        }
        out.write("" + numLines);
        out.newLine();
        for (line = 0; line < 32; ++line) {
            if (this.getLine(line) == 0) continue;
            out.write("00");
            if (line < 10) {
                out.write("0");
            }
            out.write("" + line + ":");
            out.write(Store.reverseString(Store.getBinaryString(this.getLine(line))));
            if (line >= 31) continue;
            out.newLine();
        }
        out.close();
    }

    public void saveAssembly(String fileName) throws IOException {
        File snapshotFile = new File(fileName);
        FileWriter snapshotWriter = new FileWriter(snapshotFile);
        BufferedWriter out = new BufferedWriter(snapshotWriter);
        int numLines = 0;
        for (int line = 0; line < 32; ++line) {
            if (this.getLine(line) == 0) continue;
            ++numLines;
        }
        out.write("" + numLines);
        out.newLine();
        for (int lineNumber = 0; lineNumber < 32; ++lineNumber) {
            if (this.getLine(lineNumber) == 0) continue;
            String lineNumberS = "" + lineNumber;
            out.write(lineNumberS + "  " + Store.disassembleModern(this.getLine(lineNumber)) + "\n");
        }
        out.close();
    }

    public int getFileType(String fileName) throws IOException, SnapshotException {
        FileReader snapshotReader;
        File snapshotFile = new File(fileName);
        try {
            snapshotReader = new FileReader(snapshotFile);
        }
        catch (FileNotFoundException e) {
            throw new SnapshotException(e.getMessage());
        }
        BufferedReader in = new BufferedReader(snapshotReader);
        int numberOfLines = -1;
        while (in.ready() && numberOfLines == -1) {
            String numberOfLinesS = in.readLine().trim();
            if (numberOfLinesS.equals("") || numberOfLinesS.charAt(0) == ';') continue;
            try {
                numberOfLines = Integer.parseInt(numberOfLinesS);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        if (numberOfLines == -1) {
            return 0;
        }
        String nextLine = in.readLine();
        if (nextLine.indexOf(58) == -1) {
            return 2;
        }
        return 1;
    }

    public void loadLocalSnapshot(String fileName) throws SnapshotException, IOException {
        InputStream snapshotReader;
        try {
            snapshotReader = this.openFile(fileName);
        }
        catch (FileNotFoundException e) {
            throw new SnapshotException(e.getMessage());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(snapshotReader));
        String numberOfLinesS = in.readLine().trim();
        try {
            int numberOfLines = Integer.parseInt(numberOfLinesS);
        }
        catch (NumberFormatException e) {
            throw new SnapshotException("File " + fileName + " is of an unrecognised format");
        }
        this.reset();
        this.control.reset();
        int lineCounter = 0;
        while (in.ready()) {
            int lineData;
            int lineNumber;
            ++lineCounter;
            String fileLine = in.readLine().trim();
            if (fileLine.equals("")) continue;
            StringTokenizer tokenizer = new StringTokenizer(fileLine, ":");
            if (tokenizer.hasMoreElements()) {
                String lineNumberS = tokenizer.nextToken();
                try {
                    lineNumber = Integer.parseInt(lineNumberS);
                }
                catch (NumberFormatException e) {
                    throw new SnapshotException("File " + fileName + " has a bad store line number at line " + lineCounter + " in the file");
                }
            } else {
                throw new SnapshotException("File " + fileName + " is of an unrecognised format at line " + lineCounter + " in the file");
            }
            if (tokenizer.hasMoreElements()) {
                String lineDataS = tokenizer.nextToken();
                lineDataS = Store.reverseString(lineDataS);
                try {
                    lineData = Store.parseBinaryString(lineDataS);
                }
                catch (NumberFormatException e) {
                    throw new SnapshotException("File " + fileName + " has bad store line data at line " + lineCounter + " in the file");
                }
            } else {
                throw new SnapshotException("File " + fileName + " is of an unrecognised format at line " + lineCounter + " in the file");
            }
            this.setLine(lineNumber, lineData);
        }
    }

    public void loadSnapshot(String fileName) throws SnapshotException, IOException {
        FileReader snapshotReader;
        File snapshotFile = new File(fileName);
        try {
            snapshotReader = new FileReader(snapshotFile);
        }
        catch (FileNotFoundException e) {
            throw new SnapshotException(e.getMessage());
        }
        BufferedReader in = new BufferedReader(snapshotReader);
        String numberOfLinesS = in.readLine().trim();
        try {
            int numberOfLines = Integer.parseInt(numberOfLinesS);
        }
        catch (NumberFormatException e) {
            throw new SnapshotException("File " + fileName + " is of an unrecognised format");
        }
        this.reset();
        this.control.reset();
        int lineCounter = 0;
        while (in.ready()) {
            int lineData;
            int lineNumber;
            ++lineCounter;
            String fileLine = in.readLine().trim();
            if (fileLine.equals("")) continue;
            StringTokenizer tokenizer = new StringTokenizer(fileLine, ":");
            if (tokenizer.hasMoreElements()) {
                String lineNumberS = tokenizer.nextToken();
                try {
                    lineNumber = Integer.parseInt(lineNumberS);
                }
                catch (NumberFormatException e) {
                    throw new SnapshotException("File " + fileName + " has a bad store line number at line " + lineCounter + " in the file");
                }
            } else {
                throw new SnapshotException("File " + fileName + " is of an unrecognised format at line " + lineCounter + " in the file");
            }
            if (tokenizer.hasMoreElements()) {
                String lineDataS = tokenizer.nextToken();
                lineDataS = Store.reverseString(lineDataS);
                try {
                    lineData = Store.parseBinaryString(lineDataS);
                }
                catch (NumberFormatException e) {
                    throw new SnapshotException("File " + fileName + " has bad store line data at line " + lineCounter + " in the file");
                }
            } else {
                throw new SnapshotException("File " + fileName + " is of an unrecognised format at line " + lineCounter + " in the file");
            }
            this.setLine(lineNumber, lineData);
        }
    }

    public InputStream openFile(String fileName) throws IOException {
        URL url = this.getClass().getClassLoader().getResource(fileName);
        if (url == null) {
            throw new IOException("File not found: " + fileName);
        }
        return url.openStream();
    }

    public void loadModernAssembly(String fileName) throws AssemblyException, IOException {
        FileReader assemblyReader;
        File assemblyFile = new File(fileName);
        try {
            assemblyReader = new FileReader(assemblyFile);
        }
        catch (FileNotFoundException e) {
            throw new AssemblyException(e.getMessage());
        }
        BufferedReader in = new BufferedReader(assemblyReader);
        int numberOfLines = -1;
        while (in.ready() && numberOfLines == -1) {
            String numberOfLinesS = in.readLine().trim();
            if (numberOfLinesS.equals("") || numberOfLinesS.charAt(0) == ';') continue;
            try {
                numberOfLines = Integer.parseInt(numberOfLinesS);
            }
            catch (NumberFormatException e) {
                throw new AssemblyException("File " + fileName + " is of an unrecognised format");
            }
        }
        this.reset();
        this.control.reset();
        int lineCounter = 1;
        while (in.ready()) {
            String fileLine = in.readLine().trim();
            this.assembleModernToStore(fileLine, ++lineCounter);
        }
    }

    public void loadLocalModernAssembly(String fileName) throws AssemblyException, IOException {
        InputStream assemblyReader;
        try {
            assemblyReader = this.openFile(fileName);
        }
        catch (FileNotFoundException e) {
            throw new AssemblyException(e.getMessage());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(assemblyReader));
        int numberOfLines = -1;
        while (in.ready() && numberOfLines == -1) {
            String numberOfLinesS = in.readLine().trim();
            if (numberOfLinesS.equals("") || numberOfLinesS.charAt(0) == ';') continue;
            try {
                numberOfLines = Integer.parseInt(numberOfLinesS);
            }
            catch (NumberFormatException e) {
                throw new AssemblyException("File " + fileName + " is of an unrecognised format");
            }
        }
        this.reset();
        this.control.reset();
        int lineCounter = 1;
        while (in.ready()) {
            String fileLine = in.readLine().trim();
            this.assembleModernToStore(fileLine, ++lineCounter);
        }
    }

    public void assembleModernToStore(String fileLine, int lineCounter) throws AssemblyException {
        int lineNumber = 0;
        if (!fileLine.equals("") && fileLine.charAt(0) != ';') {
            StringTokenizer tokenizer = new StringTokenizer(fileLine, " ");
            if (tokenizer.hasMoreElements()) {
                String lineNumberS = tokenizer.nextToken();
                try {
                    lineNumber = Integer.parseInt(lineNumberS);
                }
                catch (NumberFormatException e) {
                    throw new AssemblyException("Bad store line number at line " + lineCounter);
                }
            } else {
                throw new AssemblyException("Unrecognised format at line " + lineCounter);
            }
            boolean recognised = false;
            boolean operand = false;
            int functionNumber = 0;
            int operandValue = 0;
            if (tokenizer.hasMoreElements()) {
                String lineMnemonic = tokenizer.nextToken();
                lineMnemonic.toUpperCase();
                if (lineMnemonic.equals("JMP")) {
                    recognised = true;
                    operand = true;
                    functionNumber = 0;
                }
                if (lineMnemonic.equals("JRP")) {
                    recognised = true;
                    operand = true;
                    functionNumber = 1;
                }
                if (lineMnemonic.equals("LDN")) {
                    recognised = true;
                    operand = true;
                    functionNumber = 2;
                }
                if (lineMnemonic.equals("STO")) {
                    recognised = true;
                    operand = true;
                    functionNumber = 3;
                }
                if (lineMnemonic.equals("SUB")) {
                    recognised = true;
                    operand = true;
                    functionNumber = 4;
                }
                if (lineMnemonic.equals("CMP")) {
                    recognised = true;
                    operand = false;
                    functionNumber = 6;
                }
                if (lineMnemonic.equals("STP")) {
                    recognised = true;
                    operand = false;
                    functionNumber = 7;
                }
                if (lineMnemonic.equals("NUM")) {
                    recognised = true;
                    operand = true;
                    functionNumber = 8;
                }
                if (operand) {
                    if (tokenizer.hasMoreElements()) {
                        String operandValueS = tokenizer.nextToken();
                        try {
                            operandValue = Integer.parseInt(operandValueS);
                        }
                        catch (NumberFormatException e) {
                            throw new AssemblyException("Bad operand at line " + lineCounter);
                        }
                    } else {
                        throw new AssemblyException("Unrecognised format at line " + lineCounter);
                    }
                }
                int lineData = 0;
                if (functionNumber == 8) {
                    lineData = operandValue;
                } else {
                    if (operandValue > 31) {
                        throw new AssemblyException("Bad store line number at line " + lineCounter);
                    }
                    lineData = operandValue;
                    lineData |= functionNumber << 13;
                }
                this.setLine(lineNumber, lineData);
            } else {
                throw new AssemblyException("Unrecognised format at line " + lineCounter);
            }
        }
    }

    public static String disassembleModern(int line) {
        String output = "";
        String lineValue = Integer.toString(line);
        output = (line & 0xFFFF1FE0) != 0 ? "NUM " + lineValue : Store.disassembleModernMnemonic(line);
        while (output.length() < 20) {
            output = output + " ";
        }
        output = output + "; ";
        output = (line & 0xFFFF1FE0) != 0 ? output + Store.disassembleModernMnemonic(line) : output + lineValue;
        return output;
    }

    public static String disassembleModernMnemonic(int line) {
        String functionName = "";
        switch (line >> 13 & 7) {
            case 0: {
                functionName = "JMP";
                break;
            }
            case 1: {
                functionName = "JRP";
                break;
            }
            case 2: {
                functionName = "LDN";
                break;
            }
            case 3: {
                functionName = "STO";
                break;
            }
            case 4: {
                functionName = "SUB";
                break;
            }
            case 5: {
                functionName = "SUB";
                break;
            }
            case 6: {
                functionName = "CMP";
                break;
            }
            case 7: {
                functionName = "STP";
            }
        }
        String actionLine = Integer.toString(line & 0x1F);
        String output = functionName + " ";
        if (!functionName.equals("CMP") && !functionName.equals("STP")) {
            output = output + actionLine;
        }
        return output;
    }

    public static String reverseString(String str) {
        StringBuffer strBuffer = new StringBuffer(str);
        strBuffer.reverse();
        return strBuffer.toString();
    }

    public static String getBinaryString(int value) {
        String output = "";
        for (int bit = 31; bit >= 0; --bit) {
            output = output + "" + (value >> bit & 1);
        }
        return output;
    }

    private static int parseBinaryString(String s) throws NumberFormatException {
        int result = 0;
        if (s.length() > 32) {
            throw new NumberFormatException("Binary string longer than 32 bits");
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            char bitChar = s.charAt(i);
            if (bitChar == '1') {
                int bitValue = 1 << s.length() - 1 - i;
                if (i == 0) {
                    result -= bitValue;
                    continue;
                }
                result += bitValue;
                continue;
            }
            if (bitChar == '0') continue;
            throw new NumberFormatException("Non-binary digit in string");
        }
        return result;
    }
}

