/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

class SwitchPanel
extends JPanel
implements ActionListener {
    private Store store;
    private Control control;
    public CrtPanel crtPanel;
    public Baby baby;
    public PushButton[] numberKey;
    public ToggleSwitch[] lineSwitch;
    public ToggleSwitch[] functionSwitch;
    ToggleSwitch manAuto;
    ToggleSwitch prePulse;
    InterlockingPushButton crSelect;
    InterlockingPushButton accSelect;
    InterlockingPushButton storeSelect;
    ButtonGroup monitorSelectGroup;
    KeySwitch klcSwitch;
    KeySwitch kscSwitch;
    KeySwitch kacSwitch;
    KeySwitch kccSwitch;
    KeySwitch kspSwitch;
    ToggleSwitch eraseWrite;
    public static Color backgroundColor = new Color(206, 205, 201);

    public SwitchPanel(Store aStore, Control aControl, CrtPanel aCrtPanel, Baby aBaby) {
        int x;
        int keyNumber;
        this.store = aStore;
        this.control = aControl;
        this.crtPanel = aCrtPanel;
        this.baby = aBaby;
        this.setLayout(new BoxLayout(this, 1));
        JPanel typeWriter = new JPanel();
        typeWriter.setOpaque(false);
        typeWriter.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 10;
        this.numberKey = new PushButton[40];
        for (int keyNumber2 = 0; keyNumber2 < 40; ++keyNumber2) {
            this.numberKey[keyNumber2] = new PushButton("", 0);
            if (keyNumber2 >= 32) continue;
            this.numberKey[keyNumber2].addMouseListener(new TypeWriterPushed(keyNumber2, this.control, this.store, this));
        }
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 40; j += 5) {
                gbc.gridx = j / 5;
                gbc.gridy = i;
                typeWriter.add((Component)this.numberKey[i + j], gbc);
            }
            gbc.anchor = 22;
        }
        typeWriter.setPreferredSize(new Dimension(0, 270));
        JPanel staticisor = new JPanel();
        staticisor.setOpaque(false);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        staticisor.setPreferredSize(new Dimension(300, 135));
        staticisor.setLayout(gb);
        c.gridx = 0;
        c.gridy = 0;
        ToggleSwitch dud = new ToggleSwitch("", 0, 1);
        staticisor.add(dud);
        JPanel linePanel = new JPanel();
        linePanel.setOpaque(false);
        this.lineSwitch = new ToggleSwitch[13];
        LineSwitchActionListener lineSwitchActionListener = new LineSwitchActionListener();
        for (int switchNumber = 0; switchNumber < 13; ++switchNumber) {
            if (switchNumber > 6 && switchNumber < 12) {
                this.lineSwitch[switchNumber] = new ToggleSwitch("", 0, 1);
                this.lineSwitch[switchNumber].setEnabled(false);
            } else {
                this.lineSwitch[switchNumber] = new ToggleSwitch("", 0, 1);
            }
            c.gridx = switchNumber + 1;
            staticisor.add((Component)this.lineSwitch[switchNumber], c);
            this.lineSwitch[switchNumber].addActionListener(lineSwitchActionListener);
        }
        c.anchor = 22;
        c.gridy = 1;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel functionPanel = new JPanel();
        functionPanel.setOpaque(false);
        this.functionSwitch = new ToggleSwitch[8];
        for (int switchNumber = 0; switchNumber < 7; ++switchNumber) {
            if (switchNumber > 3) {
                this.functionSwitch[switchNumber] = new ToggleSwitch("", 0, 1);
                this.functionSwitch[switchNumber].setEnabled(false);
            } else {
                this.functionSwitch[switchNumber] = new ToggleSwitch("", 0, 1);
            }
            c.gridx = 3 + switchNumber;
            c.anchor = 10;
            staticisor.add((Component)this.functionSwitch[switchNumber], c);
        }
        this.manAuto = new ToggleSwitch("", 0, 1);
        this.manAuto.addActionListener(new ManAutoPressed());
        c.gridx = 10;
        staticisor.add((Component)this.manAuto, c);
        JPanel displayControls = new JPanel();
        displayControls.setOpaque(false);
        displayControls.setPreferredSize(new Dimension(0, 110));
        displayControls.setLayout(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        JPanel csSwitchPanel = new JPanel();
        csSwitchPanel.setOpaque(false);
        this.prePulse = new ToggleSwitch("", 2, 1);
        this.prePulse.addActionListener(new PrePulsePushed());
        csSwitchPanel.add(this.prePulse);
        JPanel monitorSelector = new JPanel();
        monitorSelector.setOpaque(false);
        this.crSelect = new InterlockingPushButton("", 1);
        this.accSelect = new InterlockingPushButton("", 1);
        this.storeSelect = new InterlockingPushButton("", 1);
        this.monitorSelectGroup = new ButtonGroup();
        this.monitorSelectGroup.add(this.crSelect);
        this.monitorSelectGroup.add(this.accSelect);
        this.monitorSelectGroup.add(this.storeSelect);
        monitorSelector.add(this.crSelect);
        monitorSelector.add(this.accSelect);
        monitorSelector.add(this.storeSelect);
        this.crSelect.addActionListener(new DisplaySelectPressed(1));
        this.accSelect.addActionListener(new DisplaySelectPressed(2));
        this.storeSelect.addActionListener(new DisplaySelectPressed(0));
        JPanel storageClearingKeys = new JPanel();
        storageClearingKeys.setOpaque(false);
        storageClearingKeys.setLayout(new GridBagLayout());
        this.kspSwitch = new KeySwitch("", "greydown.png", "greyup.png");
        this.kspSwitch.addActionListener(new KspPushed());
        this.klcSwitch = new KeySwitch("", "whitedown.png", "whiteup.png");
        this.klcSwitch.addMouseListener(new KlcPressed());
        this.kscSwitch = new KeySwitch("", "whitedown.png", "whiteup.png");
        this.kscSwitch.addMouseListener(new KscPushed());
        this.kacSwitch = new KeySwitch("", "whitedown.png", "whiteup.png");
        this.kacSwitch.addMouseListener(new KacPushed());
        this.kccSwitch = new KeySwitch("", "greydown.png", "greyup.png");
        this.kccSwitch.addMouseListener(new KccPushed());
        KeySwitch kbcSwitch = new KeySwitch("", "greydown.png", "greyup.png");
        KeySwitch kecSwitch = new KeySwitch("", "greydown.png", "greyup.png");
        KeySwitch kmcSwitch = new KeySwitch("", "greydown.png", "greyup.png");
        GridBagConstraints sc = new GridBagConstraints();
        sc.anchor = 17;
        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 42, 0, 223);
        storageClearingKeys.add((Component)this.kspSwitch, sc);
        sc.insets = new Insets(0, 115, 0, 0);
        storageClearingKeys.add((Component)this.klcSwitch, sc);
        sc.insets = new Insets(0, 152, 0, 0);
        storageClearingKeys.add((Component)this.kscSwitch, sc);
        sc.insets = new Insets(0, 187, 0, 0);
        storageClearingKeys.add((Component)this.kacSwitch, sc);
        sc.insets = new Insets(0, 226, 0, 0);
        storageClearingKeys.add((Component)kbcSwitch, sc);
        sc.insets = new Insets(0, 263, 0, 0);
        storageClearingKeys.add((Component)this.kccSwitch, sc);
        sc.insets = new Insets(0, 296, 0, 0);
        storageClearingKeys.add((Component)kecSwitch, sc);
        sc.insets = new Insets(0, 334, 0, 0);
        storageClearingKeys.add((Component)kmcSwitch, sc);
        JPanel eraseWritePanel = new JPanel();
        eraseWritePanel.setOpaque(false);
        this.eraseWrite = new ToggleSwitch("", 0, 1);
        eraseWritePanel.add((Component)this.eraseWrite, "Center");
        con.fill = 19;
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.insets = new Insets(15, 0, 0, 0);
        displayControls.add((Component)this.crSelect, con);
        con.insets = new Insets(15, 50, 0, 0);
        displayControls.add((Component)this.accSelect, con);
        con.insets = new Insets(15, 100, 0, 0);
        displayControls.add((Component)this.storeSelect, con);
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 2;
        con.insets = new Insets(0, 75, 0, 0);
        displayControls.add((Component)this.prePulse, con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 6;
        con.gridheight = 2;
        con.insets = new Insets(0, 0, 0, 0);
        storageClearingKeys.setPreferredSize(new Dimension(430, 50));
        displayControls.add((Component)storageClearingKeys, con);
        con.gridx = 8;
        con.gridy = 0;
        con.insets = new Insets(0, 15, 30, 0);
        displayControls.add((Component)eraseWritePanel, con);
        this.add(typeWriter);
        this.add(staticisor);
        this.add(displayControls);
        dud.setToolTipText("Left unconnected.");
        for (keyNumber = 0; keyNumber < 32; ++keyNumber) {
            this.numberKey[keyNumber].setToolTipText("Typewriter adjusts bit " + keyNumber + " of the action line.");
        }
        for (keyNumber = 32; keyNumber < 40; ++keyNumber) {
            this.numberKey[keyNumber].setToolTipText("Left unconnected.");
        }
        for (x = 0; x < 5; ++x) {
            this.lineSwitch[x].setToolTipText("Selects the action line to be adjusted or executed.");
        }
        this.lineSwitch[5].setToolTipText("Left unconnected.");
        this.lineSwitch[6].setToolTipText("Left unconnected.");
        this.lineSwitch[12].setToolTipText("Left unconnected.");
        for (x = 0; x < 3; ++x) {
            this.functionSwitch[x].setToolTipText("Selects the function number to be manually executed.");
        }
        this.functionSwitch[3].setToolTipText("Left unconnected.");
        this.manAuto.setToolTipText("Select whether to execute the store or the manual instruction.");
        this.prePulse.setToolTipText("If switched down then continually executes instructions.");
        this.klcSwitch.setToolTipText("Clears the current action line of the store.");
        this.kscSwitch.setToolTipText("Clears the entire store.");
        this.kccSwitch.setToolTipText("Clears the CI, PI and Accumulator.");
        this.kspSwitch.setToolTipText("Executes a single instruction.");
        this.eraseWrite.setToolTipText("Selects whether typewriter erases or writes bits.");
        this.accSelect.setToolTipText("Displays the accumulator on the monitor.");
        this.crSelect.setToolTipText("Displays the control on the monitor");
        this.storeSelect.setToolTipText("Displays the store on the monitor.");
        this.kacSwitch.setToolTipText("Clears the accumulator");
        kbcSwitch.setToolTipText("Not connected");
        kecSwitch.setToolTipText("Not connected");
        kmcSwitch.setToolTipText("Not connected");
        this.storeSelect.setSelected(true);
        this.eraseWrite.setSelected(false);
        this.setManAuto(true);
        for (int lStatSwitch = 0; lStatSwitch < 5; ++lStatSwitch) {
            this.lineSwitch[lStatSwitch].setSelected(true);
        }
        for (int fStatSwitch = 0; fStatSwitch < 3; ++fStatSwitch) {
            this.functionSwitch[fStatSwitch].setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public int getLineValue() {
        int result = 0;
        for (int switchNumber = 0; switchNumber < 5; ++switchNumber) {
            if (!this.lineSwitch[switchNumber].isSelected()) continue;
            result += 1 << switchNumber;
        }
        return result;
    }

    public int getFunctionValue() {
        int result = 0;
        for (int switchNumber = 0; switchNumber < 3; ++switchNumber) {
            if (!this.functionSwitch[switchNumber].isSelected()) continue;
            result += 1 << switchNumber;
        }
        return result;
    }

    public synchronized int getLineAndFunctionValue() {
        int value = this.getLineValue() | this.getFunctionValue() << 13;
        return value;
    }

    public void setEraseWrite(boolean value) {
        this.eraseWrite.setSelected(value);
    }

    public boolean getEraseWrite() {
        return !this.eraseWrite.isSelected();
    }

    public boolean getPrePulse() {
        return this.prePulse.isSelected();
    }

    public void setPrePulse(boolean value) {
        this.prePulse.setSelected(value);
    }

    public boolean getManAuto() {
        return this.manAuto.isSelected();
    }

    public void setManAuto(boolean value) {
        this.manAuto.setSelected(value);
    }

    public void redrawCrtPanel() {
        this.crtPanel.render();
        this.crtPanel.repaint();
    }

    public void updateActionLine() {
        if (this.getManAuto()) {
            this.crtPanel.setActionLine(this.control.getLineNumber(this.control.getControlInstruction()));
        } else {
            this.crtPanel.setActionLine(this.getLineValue());
        }
    }

    class ManAutoPressed
    implements ActionListener {
        ManAutoPressed() {
        }

        public void actionPerformed(ActionEvent e) {
            SwitchPanel.this.updateActionLine();
        }
    }

    class LineSwitchActionListener
    implements ActionListener {
        LineSwitchActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SwitchPanel.this.updateActionLine();
        }
    }

    class KacPushed
    implements MouseListener {
        KacPushed() {
        }

        public void mousePressed(MouseEvent e) {
            if (!Baby.running) {
                SwitchPanel.this.control.setAccumulator(0);
                SwitchPanel.this.crtPanel.render();
                SwitchPanel.this.crtPanel.repaint();
            } else {
                SwitchPanel.this.control.setKacPressed(true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            SwitchPanel.this.control.setKacPressed(false);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class KlcPressed
    implements MouseListener {
        KlcPressed() {
        }

        public void mousePressed(MouseEvent e) {
            if (Baby.running) {
                SwitchPanel.this.control.setKlcPressed(true);
            } else {
                SwitchPanel.this.store.setLine(SwitchPanel.this.getLineValue(), 0);
                SwitchPanel.this.crtPanel.render();
                SwitchPanel.this.crtPanel.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            SwitchPanel.this.control.setKlcPressed(false);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class TypeWriterPushed
    implements MouseListener {
        private int keyNumber;
        private Control control;
        private SwitchPanel switchPanel;
        private Store store;

        public TypeWriterPushed(int aKeyNumber, Control aControl, Store aStore, SwitchPanel aSwitchPanel) {
            this.keyNumber = aKeyNumber;
            this.control = aControl;
            this.switchPanel = aSwitchPanel;
            this.store = aStore;
        }

        public void mousePressed(MouseEvent e) {
            if (Baby.running) {
                this.control.setKeyPressed(true, this.keyNumber);
            } else {
                int lineNumber = this.switchPanel.getLineValue();
                if (this.switchPanel.getEraseWrite()) {
                    this.store.setLine(lineNumber, this.store.getLine(lineNumber) | 1 << this.keyNumber);
                } else {
                    this.store.setLine(lineNumber, this.store.getLine(lineNumber) & ~(1 << this.keyNumber));
                }
                this.switchPanel.redrawCrtPanel();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.control.setKeyPressed(false, this.keyNumber);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class KspPushed
    implements ActionListener {
        KspPushed() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SwitchPanel.this.control.getStopFlag()) {
                SwitchPanel.this.control.setStopFlag(false);
            }
            if (SwitchPanel.this.getManAuto()) {
                SwitchPanel.this.control.executeAutomatic();
                SwitchPanel.this.updateActionLine();
                SwitchPanel.this.crtPanel.render();
                SwitchPanel.this.crtPanel.repaint();
            } else {
                SwitchPanel.this.control.executeManual();
                SwitchPanel.this.updateActionLine();
                SwitchPanel.this.crtPanel.render();
                SwitchPanel.this.crtPanel.repaint();
            }
        }
    }

    class KccPushed
    implements MouseListener {
        KccPushed() {
        }

        public void mousePressed(MouseEvent e) {
            if (Baby.running) {
                SwitchPanel.this.control.setKccPressed(true);
            } else {
                SwitchPanel.this.control.setControlInstruction(0);
                SwitchPanel.this.control.setPresentInstruction(0);
                SwitchPanel.this.control.setAccumulator(0);
                SwitchPanel.this.updateActionLine();
                SwitchPanel.this.redrawCrtPanel();
            }
        }

        public void mouseReleased(MouseEvent e) {
            SwitchPanel.this.control.setKccPressed(false);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class KscPushed
    implements MouseListener {
        KscPushed() {
        }

        public void mousePressed(MouseEvent e) {
            if (Baby.running) {
                SwitchPanel.this.control.setKscPressed(true);
            } else {
                SwitchPanel.this.store.reset();
                SwitchPanel.this.redrawCrtPanel();
            }
        }

        public void mouseReleased(MouseEvent e) {
            SwitchPanel.this.control.setKscPressed(false);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class DisplaySelectPressed
    implements ActionListener {
        int displayValue;

        public DisplaySelectPressed(int value) {
            this.displayValue = value;
        }

        public void actionPerformed(ActionEvent e) {
            SwitchPanel.this.crtPanel.setCrtDisplay(this.displayValue);
        }
    }

    class PrePulsePushed
    implements ActionListener {
        PrePulsePushed() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SwitchPanel.this.getPrePulse()) {
                SwitchPanel.this.crtPanel.setActionLine(-1);
                SwitchPanel.this.baby.startAnimation();
            } else {
                SwitchPanel.this.baby.stopAnimation();
                SwitchPanel.this.updateActionLine();
            }
        }
    }
}

