/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class TexturedJPanel
extends JPanel {
    File filetexture;
    BufferedImage mImage;

    public TexturedJPanel(String fileName) {
        this.mImage = this.convert(this.loadImage(fileName).getImage());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (g2 == null) {
            System.out.println("error");
            return;
        }
        Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        TexturePaint tp = new TexturePaint(this.mImage, tr);
        g2.setPaint(tp);
        Rectangle r = this.getBounds();
        g2.fill(r);
    }

    public void changeTexture(String fileName) {
        this.mImage = this.convert(this.loadImage(fileName).getImage());
    }

    private ImageIcon loadImage(String image) {
        int MAX_IMAGE_SIZE = 800000;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(this.getClass().getResourceAsStream(image));
        if (imgStream != null) {
            byte[] buf = new byte[MAX_IMAGE_SIZE];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Couldn't read stream from file: " + image);
                return null;
            }
            if (count <= 0) {
                System.err.println("Empty file: " + image);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
        }
        System.err.println("Couldn't find file: " + image);
        return null;
    }

    public BufferedImage convert(Image im) {
        BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 2);
        Graphics bg = bi.getGraphics();
        bg.drawImage(im, 0, 0, null);
        bg.dispose();
        return bi;
    }
}

