/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

class ToggleSwitch
extends JCheckBox {
    public ToggleSwitch(String textValue, int horizontalPos, int verticalPos) {
        ImageIcon downIcon = this.loadImage("toggle_switch_down.png");
        ImageIcon upIcon = this.loadImage("toggle_switch_up.png");
        ImageIcon holeIcon = this.loadImage("hole.gif");
        this.setIcon(upIcon);
        this.setSelectedIcon(downIcon);
        this.setDisabledIcon(holeIcon);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setSelected(false);
        this.setHorizontalTextPosition(horizontalPos);
        this.setVerticalTextPosition(verticalPos);
        this.setText(textValue);
    }

    protected ImageIcon loadImage(String image) {
        int MAX_IMAGE_SIZE = 12400;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(this.getClass().getResourceAsStream(image));
        if (imgStream != null) {
            byte[] buf = new byte[MAX_IMAGE_SIZE];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Couldn't read stream from file: " + image);
                return null;
            }
            if (count <= 0) {
                System.err.println("Empty file: " + image);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
        }
        System.err.println("Couldn't find file: " + image);
        return null;
    }
}

