/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.utils.timing;

import com.vladium.utils.timing.ITimer;
import com.vladium.utils.timing.ITimerConstants;

final class JavaSystemTimer
implements ITimer,
ITimerConstants {
    private int m_state;
    private long m_data;

    JavaSystemTimer() {
    }

    public void start() {
        if (this.m_state != 0) {
            throw new IllegalStateException(this + ": start() must be called from READY state, current state is " + STATE_NAMES[this.m_state]);
        }
        this.m_state = 1;
        this.m_data = System.currentTimeMillis();
    }

    public void stop() {
        long data = System.currentTimeMillis();
        if (this.m_state != 1) {
            throw new IllegalStateException(this + ": stop() must be called from STARTED state, current state is " + STATE_NAMES[this.m_state]);
        }
        this.m_data = data - this.m_data;
        this.m_state = 2;
    }

    public double getDuration() {
        if (this.m_state != 2) {
            throw new IllegalStateException(this + ": getDuration() must be called from STOPPED state, current state is " + STATE_NAMES[this.m_state]);
        }
        return this.m_data;
    }

    public void reset() {
        this.m_state = 0;
    }
}

