
#include	<stdio.h>
#include	<windows.h>
#include	<signal.h>

#define		USE_DUMP_BLI_FILE
#define		ENABLE_VXDCALL_LOG
#define		ENABLE_MSCDEX_LOG
#define		ENABLE_DIRECTX_LOG

//******************************************************************************

// VxDCall requests:
#define		VMM_PageReserve					0x00010000
#define		VMM_PageCommit					0x00010001
#define		VMM_PageFree					0x0001000A
#define		VMM_PageModifyPermissions		0x0001000D
#define		VMM_GetDemandPageInfo			0x0001001E
#define		VWin32_Get_Version				0x002A0000
#define		VWin32_Int21Dispatch			0x002A0010
#define		VWin32_Int31Dispatch			0x002A0029
#define		VWin32_Int41Dispatch			0x002A002A

// Int20 (VxDCall service) requests:
#define		VMMCall_CopyPageTable			0x00010061
#define		VMMCall_PageCommitPhys			0x00010128
#define		VMMCall_PageModifyPermissions	0x00010133
#define		VMMCall_Get_DDB					0x00010146

// Int21 (DOS service) requests:
#define		DOS_ResetDrive					0x710D

// Int31 (DPMI service) requests:
#define		DPMI_AllocateLDTDescriptors		0x0000
#define		DPMI_FreeLDTDescriptors			0x0001
#define		DPMI_SimulateRealModeInterrupt	0x0300

// Int41 (MS Windows debugging kernel) requests:
#define		D386_DebuggerInstallationCheck	0x004F

// dwIoControlCode values for vwin32's DeviceIOControl Interface:
#define		VWIN32_DIOC_DOS_IOCTL			0x0001

//******************************************************************************

typedef struct VxDCall_Regs {
	DWORD	reg_EAX;
	DWORD	reg_EBX;
	DWORD	reg_ECX;
	DWORD	reg_EDX;
	DWORD	reg_EDI;
	DWORD	reg_ESI;
	DWORD	reg_EBP;
	DWORD	reg_ESP;
	DWORD	reg_Flags;
	DWORD	ret_address;
	DWORD	vxd_service;
} VXDCALL_REGS;

// DPMI interrupt registers:
typedef struct {
	DWORD	RealMode_EDI;
	DWORD	RealMode_ESI;
	DWORD	RealMode_EBP;
	DWORD	RealMode_res0;
	DWORD	RealMode_EBX;
	DWORD	RealMode_EDX;
	DWORD	RealMode_ECX;
	DWORD	RealMode_EAX;
	WORD	RealMode_Flags;
	WORD	RealMode_ES;
	WORD	RealMode_DS;
	WORD	RealMode_FS;
	WORD	RealMode_GS;
	WORD	RealMode_IP;
	WORD	RealMode_CS;
	WORD	RealMode_SP;
	WORD	RealMode_SS;
} REAL_MODE_CALL_REGS;

// Data structure for _GetDemandPageInfo:
typedef struct DemandInfoStruc {
    ULONG	DILin_Total_Count;	// # pages in linear address space
    ULONG	DIPhys_Count; 		// Count of phys pages
    ULONG	DIFree_Count; 		// Count of free phys pages
    ULONG	DIUnlock_Count;		// Count of unlocked Phys Pages
    ULONG	DILinear_Base_Addr;	// Base of pageable address space
    ULONG	DILin_Total_Free;	// Total Count of free linear pages
    ULONG	DIPage_Faults;		// total page faults
    ULONG	DIPage_Ins;			// calls to pagers to page in a page
    ULONG	DIPage_Outs;		// calls to pagers to page out a page
    ULONG	DIPage_Discards;	// pages discarded w/o calling pager
    ULONG	DIInstance_Faults;	// instance page faults
    ULONG	DIPagingFileMax;	// maximum # of pages that could be in paging file
    ULONG	DIPagingFileInUse;	// # of pages of paging file currently in use
    ULONG	DICommit_Count;		// Total committed memory, in pages
    ULONG	DIReserved[2];		// Reserved for expansion
} DEMANDINFOSTRUC;

// Structure with i386 registers for making VWIN32_DIOC_DOS_IOCTL:
typedef struct DIOCRegs {
	DWORD	reg_EBX;
	DWORD	reg_EDX;
	DWORD	reg_ECX;
	DWORD	reg_EAX;
	DWORD	reg_EDI;
	DWORD	reg_ESI;
	DWORD	reg_Flags;
} DIOC_REGISTERS;

// Structure for LDT segment descriptor:
typedef union {
	// LDT & CODE/DATA segment descriptor:
	struct {
		WORD	limit_low;
		WORD	base_low;
		BYTE	base_mid;
		BYTE	ar;
		BYTE	ar2;
		BYTE	base_high;
	} ldt, code_seg, data_seg;
	// CALL GATE descriptor:
	struct {
		WORD	offset_low;
		WORD	selector;
		BYTE	dword_cnt;
		BYTE	ar;
		WORD	offset_high;
	} call_gate;
} LDT_DESCR;

// Possible values of 'ar' bits for descriptors:
#define	DESCR_ar_LDT(ar)			(((ar) & 0x1f) == 0x02)	// 00010
#define	DESCR_ar_LDT_286_TSS(ar)	(((ar) & 0x15) == 0x01)	// 0?0?1
#define	DESCR_ar_LDT_CALL_GATE(ar)	(((ar) & 0x17) == 0x04)	// 0?100
#define	DESCR_ar_LDT_TASK_GATE(ar)	(((ar) & 0x17) == 0x05)	// 0?101
#define	DESCR_ar_LDT_INT_GATE(ar)	(((ar) & 0x17) == 0x06)	// 0?110
#define	DESCR_ar_LDT_TRAP_GATE(ar)	(((ar) & 0x17) == 0x07)	// 0?111
#define	DESCR_ar_LDT_DATA_SEG(ar)	(((ar) & 0x18) == 0x10)	// 10???
#define	DESCR_ar_LDT_CODE_SEG(ar)	(((ar) & 0x18) == 0x18)	// 11???

//******************************************************************************

// IA32 registers
enum reg8	{ AL=0, CL=1, DL=2, BL=3, AH=4, CH=5, DH=6, BH=7 };
enum reg16	{ AX=0, CX=1, DX=2, BX=3, SP=4, BP=5, SI=6, DI=7 };
enum reg32	{ EAX=0,ECX=1,EDX=2,EBX=3,ESP=4,EBP=5,ESI=6,EDI=7 };
enum sreg	{ ES=0, CS=1, SS=2, DS=3, FS=4, GS=5, NO_SEG=-1 };
// IA32 flags bits
enum flags	{ CF=0x01, PF=0x04, AF=0x10, ZF=0x40, SF=0x80, TF=0x100, IF=0x200, DF=0x400, OF=0x800, IOPL=0x3000, NT=0x4000, RF=0x10000, VM=0x20000 };

typedef union {
	struct {
		BYTE mem_op:3;	// bits 0-2 = Memory operand address
		BYTE reg_op:3;	// bits 3-5 = Register operand address
		BYTE adr_op:2;	// bits 6-7 = Memory addressing mode
	};
	BYTE	byte;
} OPCODE;

typedef struct EA_ADDR {
	EA_ADDR(DWORD addr, sreg seg) { this->addr = addr; this->seg = seg; }
	DWORD	addr;
	sreg	seg;
} EA_ADDR;

#define	LDT_SEG		0		// segment used for mapping LDT r/w access
#define	PAGE_SIZE	0x1000

extern BOOL		AllocLDTDescriptor(DWORD *ldt_addr);
extern BOOL		FreeLDTDescriptor(DWORD ldt_addr);
extern BOOL		TrackX86Opcode(LPCONTEXT context);
extern void		ExecX86ContextTrap(void (WINAPI *trap_fn)(LPCONTEXT context));

//******************************************************************************

extern HANDLE	hInstance;				// instance of the DLL
extern HANDLE	hProcessHeap;			// process heap (for HeapAlloc() / HeapFree())
extern OSVERSIONINFO	os_version;
extern BOOL		nt_dos_translate_adr;
extern CRITICAL_SECTION	vxdcall_crtsec;

// imports from kernel32.dll (used only under Win9x OS)
extern LPVOID	VxDCall, QT_Thunk, MapLS, SMapLS, UnMapLS,
				LoadLibrary16, FreeLibrary16, GetProcAddress16;

#ifdef	USE_DUMP_BLI_FILE
extern HANDLE	dump_bli_file;
#endif//USE_DUMP_BLI_FILE

//******************************************************************************

extern void WINAPI	MSCDEXRequest(REAL_MODE_CALL_REGS *regs);
extern void	cdrom_init(void);
extern void	cdrom_free(void);
extern int	cdrom_get_drive_type(int drive_unit);

#ifdef	_DEBUG
#define	W9xIMPORT(name)	w9x_##name
// debug hooks for kernel32.dll (used with Win9x OS only)
extern void		w9x_VxDCall(), w9x_QT_Thunk(), w9x_MapLS(), w9x_SMapLS(), w9x_UnMapLS(),
				w9x_LoadLibrary16(), w9x_FreeLibrary16(), w9x_GetProcAddress16();

extern void		Log(const char *fmt, ...);
extern void WINAPI	Log_VxDCall(VXDCALL_REGS *regs, DWORD args[], REAL_MODE_CALL_REGS *dpmi_regs);

#else //_DEBUG
#define	W9xIMPORT(name)	name
#endif//_DEBUG

//******************************************************************************

