
#include	"bleem_nt.h"
// MSCDEX interface
#include	"mscdex.h"

#ifdef	_DEBUG

//******************************************************************************

//__declspec(naked) void w9x_VxDCall() { __asm jmp dword ptr [VxDCall] }
__declspec(naked) void w9x_QT_Thunk() { __asm jmp dword ptr [QT_Thunk] }
__declspec(naked) void w9x_MapLS() { __asm jmp dword ptr [MapLS] }
__declspec(naked) void w9x_SMapLS() { __asm jmp dword ptr [SMapLS] }
__declspec(naked) void w9x_UnMapLS() { __asm jmp dword ptr [UnMapLS] }
__declspec(naked) void w9x_LoadLibrary16() { __asm jmp dword ptr [LoadLibrary16] }
__declspec(naked) void w9x_FreeLibrary16() { __asm jmp dword ptr [FreeLibrary16] }
__declspec(naked) void w9x_GetProcAddress16() { __asm jmp dword ptr [GetProcAddress16] }

//******************************************************************************

#ifdef	USE_DUMP_BLI_FILE
static BOOL WINAPI w9x_MSCDEXRequest(REAL_MODE_CALL_REGS *regs)
{
	DEVICE_REQUEST	*device_request;
	CONTROL_BLOCK	*control_block, tmp_cb;
	DWORD	nBytesRead;
	BYTE	*p;

	if (dump_bli_file == INVALID_HANDLE_VALUE)
		return FALSE;
	if (regs->RealMode_EAX != (0x1500 | API_SEND_DEVICE_REQUEST))
		return FALSE;
	device_request = (DEVICE_REQUEST *)((nt_dos_translate_adr) ?
		(regs->RealMode_ES << 16) + regs->RealMode_EBX :
		(regs->RealMode_ES << 4) + regs->RealMode_EBX);
	switch (device_request->header.cmd) {
	case DEV_IOCTL_INPUT:
		control_block = (CONTROL_BLOCK *)((nt_dos_translate_adr) ?
			(regs->RealMode_ES << 16) + ((device_request->ioctl_input.addr >> 12) & 0xFFF0) + (device_request->ioctl_input.addr & 0x0F) :
			((device_request->ioctl_input.addr >> 12) & 0x000FFFF0) + (device_request->ioctl_input.addr & 0x0F));
		if (!ReadFile(dump_bli_file, &tmp_cb, 0x07, &nBytesRead, NULL) || nBytesRead != 0x07 ||
			tmp_cb.header.cmd != control_block->header.cmd) {
			CloseHandle(dump_bli_file);
			dump_bli_file = INVALID_HANDLE_VALUE;
			Log("DEV_IOCTL_INPUT: closed 'dump.bli' file");
			return FALSE;
		}
		memcpy(control_block, &tmp_cb, 0x07);
		break;
	case DEV_READ_LONG:
		p = (BYTE *)((nt_dos_translate_adr) ?
			(regs->RealMode_ES << 16) + ((device_request->read_long.addr >> 12) & 0xFFF0) + (device_request->read_long.addr & 0x0F) :
			((device_request->read_long.addr >> 12) & 0x000FFFF0) + (device_request->read_long.addr & 0x0F));
		if (!ReadFile(dump_bli_file, p, 0x0800, &nBytesRead, NULL) || nBytesRead != 0x0800) {
			CloseHandle(dump_bli_file);
			dump_bli_file = INVALID_HANDLE_VALUE;
			Log("DEV_READ_LONG: closed 'dump.bli' file");
			return FALSE;
		}
//		if (device_request->read_long.loc >= 28010 &&
//			device_request->read_long.loc <= 265051) {
//			HANDLE	hIsoFile = CreateFile("track07.bin", GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE,
//				NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
//			if (hIsoFile != INVALID_HANDLE_VALUE) {
//				SetFilePointer(hIsoFile, (device_request->read_long.loc - 28010) * 2048, NULL, FILE_BEGIN);
//				WriteFile(hIsoFile, p, 0x0800, &nBytesRead, NULL);
//				CloseHandle(hIsoFile);
//			}
//		}
//		if (device_request->read_long.loc == 0x007530)
//			__asm int 3
		break;
	default:
		return FALSE;
	}
	*(WORD *)&device_request->header.status = 0x0100;	// done
	regs->RealMode_Flags &= ~0x0001;	// reset carry flag (no error)
	return TRUE;
}
#endif//USE_DUMP_BLI_FILE


#define	SAVE_REGS(regs) \
	__asm mov	regs.reg_EAX,eax \
	__asm mov	regs.reg_EBX,ebx \
	__asm mov	regs.reg_ECX,ecx \
	__asm mov	regs.reg_EDX,edx \
	__asm mov	regs.reg_EDI,edi \
	__asm mov	regs.reg_ESI,esi \
	__asm mov	regs.reg_EBP,ebp \
	__asm mov	regs.reg_ESP,esp \
	__asm pushfd				 \
	__asm pop	regs.reg_Flags \
	__asm cld
#define	LOAD_REGS(regs) \
	__asm mov	eax,regs.reg_EAX \
	__asm mov	ebx,regs.reg_EBX \
	__asm mov	ecx,regs.reg_ECX \
	__asm mov	edx,regs.reg_EDX \
	__asm mov	edi,regs.reg_EDI \
	__asm mov	esi,regs.reg_ESI \
	__asm mov	ebp,regs.reg_EBP \
	__asm mov	esp,regs.reg_ESP \
	__asm push	regs.reg_Flags	 \
	__asm popfd

__declspec(naked) void w9x_VxDCall() {
	static	VXDCALL_REGS	regs;
	static	DWORD	args[5];
	static	REAL_MODE_CALL_REGS	dpmi_regs;

	// enter VxDCall() critical section to avoid multithreading behaviours
	__asm pushfd
	__asm pushad
	EnterCriticalSection(&vxdcall_crtsec);
	__asm popad
	__asm popfd

	// save caller return address & input registers
	__asm pop	regs.ret_address
	SAVE_REGS(regs)

	// save input data from the stack (service, args[])
	regs.vxd_service = *(DWORD *)(regs.reg_ESP);
	memcpy(args, (LPVOID)(regs.reg_ESP + 4), sizeof(args));
	if (regs.vxd_service == VWin32_Int31Dispatch &&
		args[0] == DPMI_SimulateRealModeInterrupt) {
		// save input DPMI registers
		memcpy(&dpmi_regs, (LPVOID)regs.reg_EDI, sizeof(dpmi_regs));
#ifdef	USE_DUMP_BLI_FILE
		if ((regs.reg_EBX & 0xFF) == 0x2F &&
			w9x_MSCDEXRequest((REAL_MODE_CALL_REGS *)regs.reg_EDI)) {
			regs.reg_EAX = 0;
			regs.reg_ESP += 12;	// vxd_service + 2 args
			goto out_from_vxdcall;
		}
#endif//USE_DUMP_BLI_FILE
	}

	// restore input registers, execute the REAL VxDCall(), and save output registers
	LOAD_REGS(regs)
	__asm call	dword ptr [VxDCall]
	SAVE_REGS(regs)

#ifdef	USE_DUMP_BLI_FILE
out_from_vxdcall:
#endif//USE_DUMP_BLI_FILE
	Log_VxDCall(&regs, args, &dpmi_regs);

	// restore output registers & caller return address
	LOAD_REGS(regs)
	__asm push	regs.ret_address

	// leave VxDCall() critical section
	__asm pushfd
	__asm pushad
	LeaveCriticalSection(&vxdcall_crtsec);
	__asm popad
	__asm popfd
	// ret to caller return address
	__asm ret
}

#undef	SAVE_REGS
#undef	LOAD_REGS

//******************************************************************************

#endif//_DEBUG
