
//******************************************************************************

#include "d3d.h"
#include "ddraw.h"
#include "dinput.h"
#include "dsound.h"

#ifdef	_DEBUG
#ifdef	BLEEM_NT
#include "bleem_nt.h"
#ifdef	ENABLE_DIRECTX_LOG
#define	DXWRAP_LOG			// if defined, enable log file writing(debug version only)
#endif//ENABLE_DIRECTX_LOG
#endif//BLEEM_NT
#endif//_DEBUG

//******************************************************************************

//IID_IDirect3D:
class myIDirect3D: public IDirect3D
{
public:
	myIDirect3D(LPDIRECT3D p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3D getBaseInterface(LPDIRECT3D p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3D *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3D methods ***/
    STDMETHOD(Initialize)(THIS_ REFCLSID);
    STDMETHOD(EnumDevices)(THIS_ LPD3DENUMDEVICESCALLBACK,LPVOID);
    STDMETHOD(CreateLight)(THIS_ LPDIRECT3DLIGHT*,IUnknown*);
    STDMETHOD(CreateMaterial)(THIS_ LPDIRECT3DMATERIAL*,IUnknown*);
    STDMETHOD(CreateViewport)(THIS_ LPDIRECT3DVIEWPORT*,IUnknown*);
    STDMETHOD(FindDevice)(THIS_ LPD3DFINDDEVICESEARCH,LPD3DFINDDEVICERESULT);
private:
	LPDIRECT3D	p;
	DWORD	ownerThread;
};

//IID_IDirect3D2:
class myIDirect3D2: public IDirect3D2
{
public:
	myIDirect3D2(LPDIRECT3D2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3D2 getBaseInterface(LPDIRECT3D2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3D2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3D2 methods ***/
    STDMETHOD(EnumDevices)(THIS_ LPD3DENUMDEVICESCALLBACK,LPVOID);
    STDMETHOD(CreateLight)(THIS_ LPDIRECT3DLIGHT*,IUnknown*);
    STDMETHOD(CreateMaterial)(THIS_ LPDIRECT3DMATERIAL2*,IUnknown*);
    STDMETHOD(CreateViewport)(THIS_ LPDIRECT3DVIEWPORT2*,IUnknown*);
    STDMETHOD(FindDevice)(THIS_ LPD3DFINDDEVICESEARCH,LPD3DFINDDEVICERESULT);
    STDMETHOD(CreateDevice)(THIS_ REFCLSID,LPDIRECTDRAWSURFACE,LPDIRECT3DDEVICE2*);
private:
	LPDIRECT3D2	p;
	DWORD	ownerThread;
};

//IID_IDirect3D3:
class myIDirect3D3: public IDirect3D3
{
public:
	myIDirect3D3(LPDIRECT3D3 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3D3 getBaseInterface(LPDIRECT3D3 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3D3 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3D3 methods ***/
    STDMETHOD(EnumDevices)(THIS_ LPD3DENUMDEVICESCALLBACK,LPVOID);
    STDMETHOD(CreateLight)(THIS_ LPDIRECT3DLIGHT*,LPUNKNOWN);
    STDMETHOD(CreateMaterial)(THIS_ LPDIRECT3DMATERIAL3*,LPUNKNOWN);
    STDMETHOD(CreateViewport)(THIS_ LPDIRECT3DVIEWPORT3*,LPUNKNOWN);
    STDMETHOD(FindDevice)(THIS_ LPD3DFINDDEVICESEARCH,LPD3DFINDDEVICERESULT);
    STDMETHOD(CreateDevice)(THIS_ REFCLSID,LPDIRECTDRAWSURFACE4,LPDIRECT3DDEVICE3*,LPUNKNOWN);
    STDMETHOD(CreateVertexBuffer)(THIS_ LPD3DVERTEXBUFFERDESC,LPDIRECT3DVERTEXBUFFER*,DWORD,LPUNKNOWN);
    STDMETHOD(EnumZBufferFormats)(THIS_ REFCLSID,LPD3DENUMPIXELFORMATSCALLBACK,LPVOID);
    STDMETHOD(EvictManagedTextures)(THIS);
private:
	LPDIRECT3D3	p;
	DWORD	ownerThread;
};

//IID_IDirect3DDevice:
class myIDirect3DDevice: public IDirect3DDevice
{
public:
	myIDirect3DDevice(LPDIRECT3DDEVICE p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DDEVICE getBaseInterface(LPDIRECT3DDEVICE p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DDevice *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DDevice methods ***/
    STDMETHOD(Initialize)(THIS_ LPDIRECT3D,LPGUID,LPD3DDEVICEDESC);
    STDMETHOD(GetCaps)(THIS_ LPD3DDEVICEDESC,LPD3DDEVICEDESC);
    STDMETHOD(SwapTextureHandles)(THIS_ LPDIRECT3DTEXTURE,LPDIRECT3DTEXTURE);
    STDMETHOD(CreateExecuteBuffer)(THIS_ LPD3DEXECUTEBUFFERDESC,LPDIRECT3DEXECUTEBUFFER*,IUnknown*);
    STDMETHOD(GetStats)(THIS_ LPD3DSTATS);
    STDMETHOD(Execute)(THIS_ LPDIRECT3DEXECUTEBUFFER,LPDIRECT3DVIEWPORT,DWORD);
    STDMETHOD(AddViewport)(THIS_ LPDIRECT3DVIEWPORT);
    STDMETHOD(DeleteViewport)(THIS_ LPDIRECT3DVIEWPORT);
    STDMETHOD(NextViewport)(THIS_ LPDIRECT3DVIEWPORT,LPDIRECT3DVIEWPORT*,DWORD);
    STDMETHOD(Pick)(THIS_ LPDIRECT3DEXECUTEBUFFER,LPDIRECT3DVIEWPORT,DWORD,LPD3DRECT);
    STDMETHOD(GetPickRecords)(THIS_ LPDWORD,LPD3DPICKRECORD);
    STDMETHOD(EnumTextureFormats)(THIS_ LPD3DENUMTEXTUREFORMATSCALLBACK,LPVOID);
    STDMETHOD(CreateMatrix)(THIS_ LPD3DMATRIXHANDLE);
    STDMETHOD(SetMatrix)(THIS_ D3DMATRIXHANDLE,const LPD3DMATRIX);
    STDMETHOD(GetMatrix)(THIS_ D3DMATRIXHANDLE,LPD3DMATRIX);
    STDMETHOD(DeleteMatrix)(THIS_ D3DMATRIXHANDLE);
    STDMETHOD(BeginScene)(THIS);
    STDMETHOD(EndScene)(THIS);
    STDMETHOD(GetDirect3D)(THIS_ LPDIRECT3D*);
private:
	LPDIRECT3DDEVICE	p;
	DWORD	ownerThread;
};

//IID_IDirect3DDevice2:
class myIDirect3DDevice2: public IDirect3DDevice2
{
public:
	myIDirect3DDevice2(LPDIRECT3DDEVICE2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DDEVICE2 getBaseInterface(LPDIRECT3DDEVICE2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DDevice2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DDevice2 methods ***/
    STDMETHOD(GetCaps)(THIS_ LPD3DDEVICEDESC,LPD3DDEVICEDESC);
    STDMETHOD(SwapTextureHandles)(THIS_ LPDIRECT3DTEXTURE2,LPDIRECT3DTEXTURE2);
    STDMETHOD(GetStats)(THIS_ LPD3DSTATS);
    STDMETHOD(AddViewport)(THIS_ LPDIRECT3DVIEWPORT2);
    STDMETHOD(DeleteViewport)(THIS_ LPDIRECT3DVIEWPORT2);
    STDMETHOD(NextViewport)(THIS_ LPDIRECT3DVIEWPORT2,LPDIRECT3DVIEWPORT2*,DWORD);
    STDMETHOD(EnumTextureFormats)(THIS_ LPD3DENUMTEXTUREFORMATSCALLBACK,LPVOID);
    STDMETHOD(BeginScene)(THIS);
    STDMETHOD(EndScene)(THIS);
    STDMETHOD(GetDirect3D)(THIS_ LPDIRECT3D2*);
    STDMETHOD(SetCurrentViewport)(THIS_ LPDIRECT3DVIEWPORT2);
    STDMETHOD(GetCurrentViewport)(THIS_ LPDIRECT3DVIEWPORT2 *);
    STDMETHOD(SetRenderTarget)(THIS_ LPDIRECTDRAWSURFACE,DWORD);
    STDMETHOD(GetRenderTarget)(THIS_ LPDIRECTDRAWSURFACE *);
    STDMETHOD(Begin)(THIS_ D3DPRIMITIVETYPE,D3DVERTEXTYPE,DWORD);
    STDMETHOD(BeginIndexed)(THIS_ D3DPRIMITIVETYPE,D3DVERTEXTYPE,LPVOID,DWORD,DWORD);
    STDMETHOD(Vertex)(THIS_ LPVOID);
    STDMETHOD(Index)(THIS_ WORD);
    STDMETHOD(End)(THIS_ DWORD);
    STDMETHOD(GetRenderState)(THIS_ D3DRENDERSTATETYPE,LPDWORD);
    STDMETHOD(SetRenderState)(THIS_ D3DRENDERSTATETYPE,DWORD);
    STDMETHOD(GetLightState)(THIS_ D3DLIGHTSTATETYPE,LPDWORD);
    STDMETHOD(SetLightState)(THIS_ D3DLIGHTSTATETYPE,DWORD);
    STDMETHOD(SetTransform)(THIS_ D3DTRANSFORMSTATETYPE,LPD3DMATRIX);
    STDMETHOD(GetTransform)(THIS_ D3DTRANSFORMSTATETYPE,LPD3DMATRIX);
    STDMETHOD(MultiplyTransform)(THIS_ D3DTRANSFORMSTATETYPE,LPD3DMATRIX);
    STDMETHOD(DrawPrimitive)(THIS_ D3DPRIMITIVETYPE,D3DVERTEXTYPE,LPVOID,DWORD,DWORD);
    STDMETHOD(DrawIndexedPrimitive)(THIS_ D3DPRIMITIVETYPE,D3DVERTEXTYPE,LPVOID,DWORD,LPWORD,DWORD,DWORD);
    STDMETHOD(SetClipStatus)(THIS_ LPD3DCLIPSTATUS);
    STDMETHOD(GetClipStatus)(THIS_ LPD3DCLIPSTATUS);
private:
	LPDIRECT3DDEVICE2	p;
	DWORD	ownerThread;
};

//IID_IDirect3DDevice3:
class myIDirect3DDevice3: public IDirect3DDevice3
{
public:
	myIDirect3DDevice3(LPDIRECT3DDEVICE3 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DDEVICE3 getBaseInterface(LPDIRECT3DDEVICE3 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DDevice3 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DDevice3 methods ***/
    STDMETHOD(GetCaps)(THIS_ LPD3DDEVICEDESC,LPD3DDEVICEDESC);
    STDMETHOD(GetStats)(THIS_ LPD3DSTATS);
    STDMETHOD(AddViewport)(THIS_ LPDIRECT3DVIEWPORT3);
    STDMETHOD(DeleteViewport)(THIS_ LPDIRECT3DVIEWPORT3);
    STDMETHOD(NextViewport)(THIS_ LPDIRECT3DVIEWPORT3,LPDIRECT3DVIEWPORT3*,DWORD);
    STDMETHOD(EnumTextureFormats)(THIS_ LPD3DENUMPIXELFORMATSCALLBACK,LPVOID);
    STDMETHOD(BeginScene)(THIS);
    STDMETHOD(EndScene)(THIS);
    STDMETHOD(GetDirect3D)(THIS_ LPDIRECT3D3*);
    STDMETHOD(SetCurrentViewport)(THIS_ LPDIRECT3DVIEWPORT3);
    STDMETHOD(GetCurrentViewport)(THIS_ LPDIRECT3DVIEWPORT3 *);
    STDMETHOD(SetRenderTarget)(THIS_ LPDIRECTDRAWSURFACE4,DWORD);
    STDMETHOD(GetRenderTarget)(THIS_ LPDIRECTDRAWSURFACE4 *);
    STDMETHOD(Begin)(THIS_ D3DPRIMITIVETYPE,DWORD,DWORD);
    STDMETHOD(BeginIndexed)(THIS_ D3DPRIMITIVETYPE,DWORD,LPVOID,DWORD,DWORD);
    STDMETHOD(Vertex)(THIS_ LPVOID);
    STDMETHOD(Index)(THIS_ WORD);
    STDMETHOD(End)(THIS_ DWORD);
    STDMETHOD(GetRenderState)(THIS_ D3DRENDERSTATETYPE,LPDWORD);
    STDMETHOD(SetRenderState)(THIS_ D3DRENDERSTATETYPE,DWORD);
    STDMETHOD(GetLightState)(THIS_ D3DLIGHTSTATETYPE,LPDWORD);
    STDMETHOD(SetLightState)(THIS_ D3DLIGHTSTATETYPE,DWORD);
    STDMETHOD(SetTransform)(THIS_ D3DTRANSFORMSTATETYPE,LPD3DMATRIX);
    STDMETHOD(GetTransform)(THIS_ D3DTRANSFORMSTATETYPE,LPD3DMATRIX);
    STDMETHOD(MultiplyTransform)(THIS_ D3DTRANSFORMSTATETYPE,LPD3DMATRIX);
    STDMETHOD(DrawPrimitive)(THIS_ D3DPRIMITIVETYPE,DWORD,LPVOID,DWORD,DWORD);
    STDMETHOD(DrawIndexedPrimitive)(THIS_ D3DPRIMITIVETYPE,DWORD,LPVOID,DWORD,LPWORD,DWORD,DWORD);
    STDMETHOD(SetClipStatus)(THIS_ LPD3DCLIPSTATUS);
    STDMETHOD(GetClipStatus)(THIS_ LPD3DCLIPSTATUS);
    STDMETHOD(DrawPrimitiveStrided)(THIS_ D3DPRIMITIVETYPE,DWORD,LPD3DDRAWPRIMITIVESTRIDEDDATA,DWORD,DWORD);
    STDMETHOD(DrawIndexedPrimitiveStrided)(THIS_ D3DPRIMITIVETYPE,DWORD,LPD3DDRAWPRIMITIVESTRIDEDDATA,DWORD,LPWORD,DWORD,DWORD);
    STDMETHOD(DrawPrimitiveVB)(THIS_ D3DPRIMITIVETYPE,LPDIRECT3DVERTEXBUFFER,DWORD,DWORD,DWORD);
    STDMETHOD(DrawIndexedPrimitiveVB)(THIS_ D3DPRIMITIVETYPE,LPDIRECT3DVERTEXBUFFER,LPWORD,DWORD,DWORD);
    STDMETHOD(ComputeSphereVisibility)(THIS_ LPD3DVECTOR,LPD3DVALUE,DWORD,DWORD,LPDWORD);
    STDMETHOD(GetTexture)(THIS_ DWORD,LPDIRECT3DTEXTURE2 *);
    STDMETHOD(SetTexture)(THIS_ DWORD,LPDIRECT3DTEXTURE2);
    STDMETHOD(GetTextureStageState)(THIS_ DWORD,D3DTEXTURESTAGESTATETYPE,LPDWORD);
    STDMETHOD(SetTextureStageState)(THIS_ DWORD,D3DTEXTURESTAGESTATETYPE,DWORD);
    STDMETHOD(ValidateDevice)(THIS_ LPDWORD);
private:
	LPDIRECT3DDEVICE3	p;
	DWORD	ownerThread;
};

//IID_IDirect3DExecuteBuffer:
class myIDirect3DExecuteBuffer: public IDirect3DExecuteBuffer
{
public:
	myIDirect3DExecuteBuffer(LPDIRECT3DEXECUTEBUFFER p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DEXECUTEBUFFER getBaseInterface(LPDIRECT3DEXECUTEBUFFER p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DExecuteBuffer *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DExecuteBuffer methods ***/
    STDMETHOD(Initialize)(THIS_ LPDIRECT3DDEVICE,LPD3DEXECUTEBUFFERDESC);
    STDMETHOD(Lock)(THIS_ LPD3DEXECUTEBUFFERDESC);
    STDMETHOD(Unlock)(THIS);
    STDMETHOD(SetExecuteData)(THIS_ LPD3DEXECUTEDATA);
    STDMETHOD(GetExecuteData)(THIS_ LPD3DEXECUTEDATA);
    STDMETHOD(Validate)(THIS_ LPDWORD,LPD3DVALIDATECALLBACK,LPVOID,DWORD);
    STDMETHOD(Optimize)(THIS_ DWORD);
private:
	LPDIRECT3DEXECUTEBUFFER	p;
	DWORD	ownerThread;
};

//IID_IDirect3DLight:
class myIDirect3DLight: public IDirect3DLight
{
public:
	myIDirect3DLight(LPDIRECT3DLIGHT p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DLIGHT getBaseInterface(LPDIRECT3DLIGHT p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DLight *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DLight methods ***/
    STDMETHOD(Initialize)(THIS_ LPDIRECT3D);
    STDMETHOD(SetLight)(THIS_ LPD3DLIGHT);
    STDMETHOD(GetLight)(THIS_ LPD3DLIGHT);
private:
	LPDIRECT3DLIGHT	p;
	DWORD	ownerThread;
};

//IID_IDirect3DMaterial:
class myIDirect3DMaterial: public IDirect3DMaterial
{
public:
	myIDirect3DMaterial(LPDIRECT3DMATERIAL p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DMATERIAL getBaseInterface(LPDIRECT3DMATERIAL p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DMaterial *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DMaterial methods ***/
    STDMETHOD(Initialize)(THIS_ LPDIRECT3D);
    STDMETHOD(SetMaterial)(THIS_ LPD3DMATERIAL);
    STDMETHOD(GetMaterial)(THIS_ LPD3DMATERIAL);
    STDMETHOD(GetHandle)(THIS_ LPDIRECT3DDEVICE,LPD3DMATERIALHANDLE);
    STDMETHOD(Reserve)(THIS);
    STDMETHOD(Unreserve)(THIS);
private:
	LPDIRECT3DMATERIAL	p;
	DWORD	ownerThread;
};

//IID_IDirect3DMaterial2:
class myIDirect3DMaterial2: public IDirect3DMaterial2
{
public:
	myIDirect3DMaterial2(LPDIRECT3DMATERIAL2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DMATERIAL2 getBaseInterface(LPDIRECT3DMATERIAL2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DMaterial2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DMaterial2 methods ***/
    STDMETHOD(SetMaterial)(THIS_ LPD3DMATERIAL);
    STDMETHOD(GetMaterial)(THIS_ LPD3DMATERIAL);
    STDMETHOD(GetHandle)(THIS_ LPDIRECT3DDEVICE2,LPD3DMATERIALHANDLE);
private:
	LPDIRECT3DMATERIAL2	p;
	DWORD	ownerThread;
};

//IID_IDirect3DMaterial3:
class myIDirect3DMaterial3: public IDirect3DMaterial3
{
public:
	myIDirect3DMaterial3(LPDIRECT3DMATERIAL3 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DMATERIAL3 getBaseInterface(LPDIRECT3DMATERIAL3 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DMaterial3 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DMaterial3 methods ***/
    STDMETHOD(SetMaterial)(THIS_ LPD3DMATERIAL);
    STDMETHOD(GetMaterial)(THIS_ LPD3DMATERIAL);
    STDMETHOD(GetHandle)(THIS_ LPDIRECT3DDEVICE3,LPD3DMATERIALHANDLE);
private:
	LPDIRECT3DMATERIAL3	p;
	DWORD	ownerThread;
};

//IID_IDirect3DTexture:
class myIDirect3DTexture: public IDirect3DTexture
{
public:
	myIDirect3DTexture(LPDIRECT3DTEXTURE p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DTEXTURE getBaseInterface(LPDIRECT3DTEXTURE p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DTexture *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DTexture methods ***/
    STDMETHOD(Initialize)(THIS_ LPDIRECT3DDEVICE,LPDIRECTDRAWSURFACE);
    STDMETHOD(GetHandle)(THIS_ LPDIRECT3DDEVICE,LPD3DTEXTUREHANDLE);
    STDMETHOD(PaletteChanged)(THIS_ DWORD,DWORD);
    STDMETHOD(Load)(THIS_ LPDIRECT3DTEXTURE);
    STDMETHOD(Unload)(THIS);
private:
	LPDIRECT3DTEXTURE	p;
	DWORD	ownerThread;
};

//IID_IDirect3DTexture2:
class myIDirect3DTexture2: public IDirect3DTexture2
{
public:
	myIDirect3DTexture2(LPDIRECT3DTEXTURE2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DTEXTURE2 getBaseInterface(LPDIRECT3DTEXTURE2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DTexture2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DTexture2 methods ***/
    STDMETHOD(GetHandle)(THIS_ LPDIRECT3DDEVICE2,LPD3DTEXTUREHANDLE);
    STDMETHOD(PaletteChanged)(THIS_ DWORD,DWORD);
    STDMETHOD(Load)(THIS_ LPDIRECT3DTEXTURE2);
private:
	LPDIRECT3DTEXTURE2	p;
	DWORD	ownerThread;
};

//IID_IDirect3DVertexBuffer:
class myIDirect3DVertexBuffer: public IDirect3DVertexBuffer
{
public:
	myIDirect3DVertexBuffer(LPDIRECT3DVERTEXBUFFER p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DVERTEXBUFFER getBaseInterface(LPDIRECT3DVERTEXBUFFER p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DVertexBuffer *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DVertexBuffer methods ***/
    STDMETHOD(Lock)(THIS_ DWORD,LPVOID*,LPDWORD);
    STDMETHOD(Unlock)(THIS);
    STDMETHOD(ProcessVertices)(THIS_ DWORD,DWORD,DWORD,LPDIRECT3DVERTEXBUFFER,DWORD,LPDIRECT3DDEVICE3,DWORD);
    STDMETHOD(GetVertexBufferDesc)(THIS_ LPD3DVERTEXBUFFERDESC);
    STDMETHOD(Optimize)(THIS_ LPDIRECT3DDEVICE3,DWORD);
private:
	LPDIRECT3DVERTEXBUFFER	p;
	DWORD	ownerThread;
};

//IID_IDirect3DViewport:
class myIDirect3DViewport: public IDirect3DViewport
{
public:
	myIDirect3DViewport(LPDIRECT3DVIEWPORT p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DVIEWPORT getBaseInterface(LPDIRECT3DVIEWPORT p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DViewport *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DViewport methods ***/
    STDMETHOD(Initialize)(THIS_ LPDIRECT3D);
    STDMETHOD(GetViewport)(THIS_ LPD3DVIEWPORT);
    STDMETHOD(SetViewport)(THIS_ LPD3DVIEWPORT);
    STDMETHOD(TransformVertices)(THIS_ DWORD,LPD3DTRANSFORMDATA,DWORD,LPDWORD);
    STDMETHOD(LightElements)(THIS_ DWORD,LPD3DLIGHTDATA);
    STDMETHOD(SetBackground)(THIS_ D3DMATERIALHANDLE);
    STDMETHOD(GetBackground)(THIS_ LPD3DMATERIALHANDLE,LPBOOL);
    STDMETHOD(SetBackgroundDepth)(THIS_ LPDIRECTDRAWSURFACE);
    STDMETHOD(GetBackgroundDepth)(THIS_ LPDIRECTDRAWSURFACE*,LPBOOL);
    STDMETHOD(Clear)(THIS_ DWORD,LPD3DRECT,DWORD);
    STDMETHOD(AddLight)(THIS_ LPDIRECT3DLIGHT);
    STDMETHOD(DeleteLight)(THIS_ LPDIRECT3DLIGHT);
    STDMETHOD(NextLight)(THIS_ LPDIRECT3DLIGHT,LPDIRECT3DLIGHT*,DWORD);
private:
	LPDIRECT3DVIEWPORT	p;
	DWORD	ownerThread;
};

//IID_IDirect3DViewport2:
class myIDirect3DViewport2: public IDirect3DViewport2
{
public:
	myIDirect3DViewport2(LPDIRECT3DVIEWPORT2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DVIEWPORT2 getBaseInterface(LPDIRECT3DVIEWPORT2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DViewport2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DViewport2 methods ***/
    STDMETHOD(Initialize)(THIS_ LPDIRECT3D);
    STDMETHOD(GetViewport)(THIS_ LPD3DVIEWPORT);
    STDMETHOD(SetViewport)(THIS_ LPD3DVIEWPORT);
    STDMETHOD(TransformVertices)(THIS_ DWORD,LPD3DTRANSFORMDATA,DWORD,LPDWORD);
    STDMETHOD(LightElements)(THIS_ DWORD,LPD3DLIGHTDATA);
    STDMETHOD(SetBackground)(THIS_ D3DMATERIALHANDLE);
    STDMETHOD(GetBackground)(THIS_ LPD3DMATERIALHANDLE,LPBOOL);
    STDMETHOD(SetBackgroundDepth)(THIS_ LPDIRECTDRAWSURFACE);
    STDMETHOD(GetBackgroundDepth)(THIS_ LPDIRECTDRAWSURFACE*,LPBOOL);
    STDMETHOD(Clear)(THIS_ DWORD,LPD3DRECT,DWORD);
    STDMETHOD(AddLight)(THIS_ LPDIRECT3DLIGHT);
    STDMETHOD(DeleteLight)(THIS_ LPDIRECT3DLIGHT);
    STDMETHOD(NextLight)(THIS_ LPDIRECT3DLIGHT,LPDIRECT3DLIGHT*,DWORD);
    STDMETHOD(GetViewport2)(THIS_ LPD3DVIEWPORT2);
    STDMETHOD(SetViewport2)(THIS_ LPD3DVIEWPORT2);
private:
	LPDIRECT3DVIEWPORT2	p;
	DWORD	ownerThread;
};

//IID_IDirect3DViewport3:
class myIDirect3DViewport3: public IDirect3DViewport3
{
public:
	myIDirect3DViewport3(LPDIRECT3DVIEWPORT3 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECT3DVIEWPORT3 getBaseInterface(LPDIRECT3DVIEWPORT3 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirect3DViewport3 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirect3DViewport3 methods ***/
    STDMETHOD(Initialize)(THIS_ LPDIRECT3D);
    STDMETHOD(GetViewport)(THIS_ LPD3DVIEWPORT);
    STDMETHOD(SetViewport)(THIS_ LPD3DVIEWPORT);
    STDMETHOD(TransformVertices)(THIS_ DWORD,LPD3DTRANSFORMDATA,DWORD,LPDWORD);
    STDMETHOD(LightElements)(THIS_ DWORD,LPD3DLIGHTDATA);
    STDMETHOD(SetBackground)(THIS_ D3DMATERIALHANDLE);
    STDMETHOD(GetBackground)(THIS_ LPD3DMATERIALHANDLE,LPBOOL);
    STDMETHOD(SetBackgroundDepth)(THIS_ LPDIRECTDRAWSURFACE);
    STDMETHOD(GetBackgroundDepth)(THIS_ LPDIRECTDRAWSURFACE*,LPBOOL);
    STDMETHOD(Clear)(THIS_ DWORD,LPD3DRECT,DWORD);
    STDMETHOD(AddLight)(THIS_ LPDIRECT3DLIGHT);
    STDMETHOD(DeleteLight)(THIS_ LPDIRECT3DLIGHT);
    STDMETHOD(NextLight)(THIS_ LPDIRECT3DLIGHT,LPDIRECT3DLIGHT*,DWORD);
    STDMETHOD(GetViewport2)(THIS_ LPD3DVIEWPORT2);
    STDMETHOD(SetViewport2)(THIS_ LPD3DVIEWPORT2);
    STDMETHOD(SetBackgroundDepth2)(THIS_ LPDIRECTDRAWSURFACE4);
    STDMETHOD(GetBackgroundDepth2)(THIS_ LPDIRECTDRAWSURFACE4*,LPBOOL);
    STDMETHOD(Clear2)(THIS_ DWORD,LPD3DRECT,DWORD,D3DCOLOR,D3DVALUE,DWORD);
private:
	LPDIRECT3DVIEWPORT3	p;
	DWORD	ownerThread;
};

//******************************************************************************

//IID_IDirectDraw:
class myIDirectDraw: public IDirectDraw
{
public:
	myIDirectDraw(LPDIRECTDRAW p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAW getBaseInterface(LPDIRECTDRAW p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDraw *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDraw methods ***/
    STDMETHOD(Compact)(THIS);
    STDMETHOD(CreateClipper)(THIS_ DWORD, LPDIRECTDRAWCLIPPER FAR*, IUnknown FAR * );
    STDMETHOD(CreatePalette)(THIS_ DWORD, LPPALETTEENTRY, LPDIRECTDRAWPALETTE FAR*, IUnknown FAR * );
    STDMETHOD(CreateSurface)(THIS_ LPDDSURFACEDESC, LPDIRECTDRAWSURFACE FAR *, IUnknown FAR *);
    STDMETHOD(DuplicateSurface)(THIS_ LPDIRECTDRAWSURFACE, LPDIRECTDRAWSURFACE FAR * );
    STDMETHOD(EnumDisplayModes)(THIS_ DWORD, LPDDSURFACEDESC, LPVOID, LPDDENUMMODESCALLBACK );
    STDMETHOD(EnumSurfaces)(THIS_ DWORD, LPDDSURFACEDESC, LPVOID,LPDDENUMSURFACESCALLBACK );
    STDMETHOD(FlipToGDISurface)(THIS);
    STDMETHOD(GetCaps)(THIS_ LPDDCAPS, LPDDCAPS);
    STDMETHOD(GetDisplayMode)(THIS_ LPDDSURFACEDESC);
    STDMETHOD(GetFourCCCodes)(THIS_ LPDWORD, LPDWORD );
    STDMETHOD(GetGDISurface)(THIS_ LPDIRECTDRAWSURFACE FAR *);
    STDMETHOD(GetMonitorFrequency)(THIS_ LPDWORD);
    STDMETHOD(GetScanLine)(THIS_ LPDWORD);
    STDMETHOD(GetVerticalBlankStatus)(THIS_ LPBOOL );
    STDMETHOD(Initialize)(THIS_ GUID FAR *);
    STDMETHOD(RestoreDisplayMode)(THIS);
    STDMETHOD(SetCooperativeLevel)(THIS_ HWND, DWORD);
    STDMETHOD(SetDisplayMode)(THIS_ DWORD, DWORD,DWORD);
    STDMETHOD(WaitForVerticalBlank)(THIS_ DWORD, HANDLE );
private:
	LPDIRECTDRAW	p;
	DWORD	ownerThread;
};

//IID_IDirectDraw2:
class myIDirectDraw2: public IDirectDraw2
{
public:
	myIDirectDraw2(LPDIRECTDRAW2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAW2 getBaseInterface(LPDIRECTDRAW2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDraw2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDraw methods ***/
    STDMETHOD(Compact)(THIS);
    STDMETHOD(CreateClipper)(THIS_ DWORD, LPDIRECTDRAWCLIPPER FAR*, IUnknown FAR * );
    STDMETHOD(CreatePalette)(THIS_ DWORD, LPPALETTEENTRY, LPDIRECTDRAWPALETTE FAR*, IUnknown FAR * );
    STDMETHOD(CreateSurface)(THIS_ LPDDSURFACEDESC, LPDIRECTDRAWSURFACE FAR *, IUnknown FAR *);
    STDMETHOD(DuplicateSurface)(THIS_ LPDIRECTDRAWSURFACE, LPDIRECTDRAWSURFACE FAR * );
    STDMETHOD(EnumDisplayModes)(THIS_ DWORD, LPDDSURFACEDESC, LPVOID, LPDDENUMMODESCALLBACK );
    STDMETHOD(EnumSurfaces)(THIS_ DWORD, LPDDSURFACEDESC, LPVOID,LPDDENUMSURFACESCALLBACK );
    STDMETHOD(FlipToGDISurface)(THIS);
    STDMETHOD(GetCaps)(THIS_ LPDDCAPS, LPDDCAPS);
    STDMETHOD(GetDisplayMode)(THIS_ LPDDSURFACEDESC);
    STDMETHOD(GetFourCCCodes)(THIS_ LPDWORD, LPDWORD );
    STDMETHOD(GetGDISurface)(THIS_ LPDIRECTDRAWSURFACE FAR *);
    STDMETHOD(GetMonitorFrequency)(THIS_ LPDWORD);
    STDMETHOD(GetScanLine)(THIS_ LPDWORD);
    STDMETHOD(GetVerticalBlankStatus)(THIS_ LPBOOL );
    STDMETHOD(Initialize)(THIS_ GUID FAR *);
    STDMETHOD(RestoreDisplayMode)(THIS);
    STDMETHOD(SetCooperativeLevel)(THIS_ HWND, DWORD);
    STDMETHOD(SetDisplayMode)(THIS_ DWORD, DWORD,DWORD, DWORD, DWORD);
    STDMETHOD(WaitForVerticalBlank)(THIS_ DWORD, HANDLE );
    /*** Added in the v2 interface ***/
    STDMETHOD(GetAvailableVidMem)(THIS_ LPDDSCAPS, LPDWORD, LPDWORD);
private:
	LPDIRECTDRAW2	p;
	DWORD	ownerThread;
};

//IID_IDirectDraw4:
class myIDirectDraw4: public IDirectDraw4
{
public:
	myIDirectDraw4(LPDIRECTDRAW4 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAW4 getBaseInterface(LPDIRECTDRAW4 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDraw4 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDraw methods ***/
    STDMETHOD(Compact)(THIS);
    STDMETHOD(CreateClipper)(THIS_ DWORD, LPDIRECTDRAWCLIPPER FAR*, IUnknown FAR * );
    STDMETHOD(CreatePalette)(THIS_ DWORD, LPPALETTEENTRY, LPDIRECTDRAWPALETTE FAR*, IUnknown FAR * );
    STDMETHOD(CreateSurface)(THIS_ LPDDSURFACEDESC2, LPDIRECTDRAWSURFACE4 FAR *, IUnknown FAR *);
    STDMETHOD(DuplicateSurface)(THIS_ LPDIRECTDRAWSURFACE4, LPDIRECTDRAWSURFACE4 FAR * );
    STDMETHOD(EnumDisplayModes)(THIS_ DWORD, LPDDSURFACEDESC2, LPVOID, LPDDENUMMODESCALLBACK2 );
    STDMETHOD(EnumSurfaces)(THIS_ DWORD, LPDDSURFACEDESC2, LPVOID,LPDDENUMSURFACESCALLBACK2 );
    STDMETHOD(FlipToGDISurface)(THIS);
    STDMETHOD(GetCaps)(THIS_ LPDDCAPS, LPDDCAPS);
    STDMETHOD(GetDisplayMode)(THIS_ LPDDSURFACEDESC2);
    STDMETHOD(GetFourCCCodes)(THIS_ LPDWORD, LPDWORD );
    STDMETHOD(GetGDISurface)(THIS_ LPDIRECTDRAWSURFACE4 FAR *);
    STDMETHOD(GetMonitorFrequency)(THIS_ LPDWORD);
    STDMETHOD(GetScanLine)(THIS_ LPDWORD);
    STDMETHOD(GetVerticalBlankStatus)(THIS_ LPBOOL );
    STDMETHOD(Initialize)(THIS_ GUID FAR *);
    STDMETHOD(RestoreDisplayMode)(THIS);
    STDMETHOD(SetCooperativeLevel)(THIS_ HWND, DWORD);
    STDMETHOD(SetDisplayMode)(THIS_ DWORD, DWORD,DWORD, DWORD, DWORD);
    STDMETHOD(WaitForVerticalBlank)(THIS_ DWORD, HANDLE );
    /*** Added in the v2 interface ***/
    STDMETHOD(GetAvailableVidMem)(THIS_ LPDDSCAPS2, LPDWORD, LPDWORD);
    /*** Added in the V4 Interface ***/
    STDMETHOD(GetSurfaceFromDC)(THIS_ HDC, LPDIRECTDRAWSURFACE4 *);
    STDMETHOD(RestoreAllSurfaces)(THIS);
    STDMETHOD(TestCooperativeLevel)(THIS);
    STDMETHOD(GetDeviceIdentifier)(THIS_ LPDDDEVICEIDENTIFIER, DWORD );
private:
	LPDIRECTDRAW4	p;
	DWORD	ownerThread;
#ifdef	BLEEM_NT
	HWND	ddscl_hWnd;
	DWORD	ddscl_dwFlags;
#endif//BLEEM_NT
};

//IID_IDirectDrawClipper:
class myIDirectDrawClipper: public IDirectDrawClipper
{
public:
	myIDirectDrawClipper(LPDIRECTDRAWCLIPPER p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAWCLIPPER getBaseInterface(LPDIRECTDRAWCLIPPER p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDrawClipper *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDrawClipper methods ***/
    STDMETHOD(GetClipList)(THIS_ LPRECT, LPRGNDATA, LPDWORD);
    STDMETHOD(GetHWnd)(THIS_ HWND FAR *);
    STDMETHOD(Initialize)(THIS_ LPDIRECTDRAW, DWORD);
    STDMETHOD(IsClipListChanged)(THIS_ BOOL FAR *);
    STDMETHOD(SetClipList)(THIS_ LPRGNDATA,DWORD);
    STDMETHOD(SetHWnd)(THIS_ DWORD, HWND );
private:
	LPDIRECTDRAWCLIPPER	p;
	DWORD	ownerThread;
};

//IID_IDirectDrawColorControl:
class myIDirectDrawColorControl: public IDirectDrawColorControl
{
public:
	myIDirectDrawColorControl(LPDIRECTDRAWCOLORCONTROL p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAWCOLORCONTROL getBaseInterface(LPDIRECTDRAWCOLORCONTROL p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDrawColorControl *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDrawColorControl methods ***/
    STDMETHOD(GetColorControls)(THIS_ LPDDCOLORCONTROL);
    STDMETHOD(SetColorControls)(THIS_ LPDDCOLORCONTROL);
private:
	LPDIRECTDRAWCOLORCONTROL	p;
	DWORD	ownerThread;
};

//IID_IDirectDrawGammaControl:
class myIDirectDrawGammaControl: public IDirectDrawGammaControl
{
public:
	myIDirectDrawGammaControl(LPDIRECTDRAWGAMMACONTROL p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAWGAMMACONTROL getBaseInterface(LPDIRECTDRAWGAMMACONTROL p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDrawGammaControl *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDrawGammaControl methods ***/
    STDMETHOD(GetGammaRamp)(THIS_ DWORD, LPDDGAMMARAMP);
    STDMETHOD(SetGammaRamp)(THIS_ DWORD, LPDDGAMMARAMP);
private:
	LPDIRECTDRAWGAMMACONTROL	p;
	DWORD	ownerThread;
};

//IID_IDirectDrawPalette:
class myIDirectDrawPalette: public IDirectDrawPalette
{
public:
	myIDirectDrawPalette(LPDIRECTDRAWPALETTE p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAWPALETTE getBaseInterface(LPDIRECTDRAWPALETTE p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDrawPalette *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDrawPalette methods ***/
    STDMETHOD(GetCaps)(THIS_ LPDWORD);
    STDMETHOD(GetEntries)(THIS_ DWORD,DWORD,DWORD,LPPALETTEENTRY);
    STDMETHOD(Initialize)(THIS_ LPDIRECTDRAW, DWORD, LPPALETTEENTRY);
    STDMETHOD(SetEntries)(THIS_ DWORD,DWORD,DWORD,LPPALETTEENTRY);
private:
	LPDIRECTDRAWPALETTE	p;
	DWORD	ownerThread;
};

//IID_IDirectDrawSurface:
class myIDirectDrawSurface: public IDirectDrawSurface
{
public:
	myIDirectDrawSurface(LPDIRECTDRAWSURFACE p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAWSURFACE getBaseInterface(LPDIRECTDRAWSURFACE p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDrawSurface *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDrawSurface methods ***/
    STDMETHOD(AddAttachedSurface)(THIS_ LPDIRECTDRAWSURFACE);
    STDMETHOD(AddOverlayDirtyRect)(THIS_ LPRECT);
    STDMETHOD(Blt)(THIS_ LPRECT,LPDIRECTDRAWSURFACE, LPRECT,DWORD, LPDDBLTFX);
    STDMETHOD(BltBatch)(THIS_ LPDDBLTBATCH, DWORD, DWORD );
    STDMETHOD(BltFast)(THIS_ DWORD,DWORD,LPDIRECTDRAWSURFACE, LPRECT,DWORD);
    STDMETHOD(DeleteAttachedSurface)(THIS_ DWORD,LPDIRECTDRAWSURFACE);
    STDMETHOD(EnumAttachedSurfaces)(THIS_ LPVOID,LPDDENUMSURFACESCALLBACK);
    STDMETHOD(EnumOverlayZOrders)(THIS_ DWORD,LPVOID,LPDDENUMSURFACESCALLBACK);
    STDMETHOD(Flip)(THIS_ LPDIRECTDRAWSURFACE, DWORD);
    STDMETHOD(GetAttachedSurface)(THIS_ LPDDSCAPS, LPDIRECTDRAWSURFACE FAR *);
    STDMETHOD(GetBltStatus)(THIS_ DWORD);
    STDMETHOD(GetCaps)(THIS_ LPDDSCAPS);
    STDMETHOD(GetClipper)(THIS_ LPDIRECTDRAWCLIPPER FAR*);
    STDMETHOD(GetColorKey)(THIS_ DWORD, LPDDCOLORKEY);
    STDMETHOD(GetDC)(THIS_ HDC FAR *);
    STDMETHOD(GetFlipStatus)(THIS_ DWORD);
    STDMETHOD(GetOverlayPosition)(THIS_ LPLONG, LPLONG );
    STDMETHOD(GetPalette)(THIS_ LPDIRECTDRAWPALETTE FAR*);
    STDMETHOD(GetPixelFormat)(THIS_ LPDDPIXELFORMAT);
    STDMETHOD(GetSurfaceDesc)(THIS_ LPDDSURFACEDESC);
    STDMETHOD(Initialize)(THIS_ LPDIRECTDRAW, LPDDSURFACEDESC);
    STDMETHOD(IsLost)(THIS);
    STDMETHOD(Lock)(THIS_ LPRECT,LPDDSURFACEDESC,DWORD,HANDLE);
    STDMETHOD(ReleaseDC)(THIS_ HDC);
    STDMETHOD(Restore)(THIS);
    STDMETHOD(SetClipper)(THIS_ LPDIRECTDRAWCLIPPER);
    STDMETHOD(SetColorKey)(THIS_ DWORD, LPDDCOLORKEY);
    STDMETHOD(SetOverlayPosition)(THIS_ LONG, LONG );
    STDMETHOD(SetPalette)(THIS_ LPDIRECTDRAWPALETTE);
    STDMETHOD(Unlock)(THIS_ LPVOID);
    STDMETHOD(UpdateOverlay)(THIS_ LPRECT, LPDIRECTDRAWSURFACE,LPRECT,DWORD, LPDDOVERLAYFX);
    STDMETHOD(UpdateOverlayDisplay)(THIS_ DWORD);
    STDMETHOD(UpdateOverlayZOrder)(THIS_ DWORD, LPDIRECTDRAWSURFACE);
private:
	LPDIRECTDRAWSURFACE	p;
	DWORD	ownerThread;
};

//IID_IDirectDrawSurface2:
class myIDirectDrawSurface2: public IDirectDrawSurface2
{
public:
	myIDirectDrawSurface2(LPDIRECTDRAWSURFACE2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAWSURFACE2 getBaseInterface(LPDIRECTDRAWSURFACE2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDrawSurface2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDrawSurface methods ***/
    STDMETHOD(AddAttachedSurface)(THIS_ LPDIRECTDRAWSURFACE2);
    STDMETHOD(AddOverlayDirtyRect)(THIS_ LPRECT);
    STDMETHOD(Blt)(THIS_ LPRECT,LPDIRECTDRAWSURFACE2, LPRECT,DWORD, LPDDBLTFX);
    STDMETHOD(BltBatch)(THIS_ LPDDBLTBATCH, DWORD, DWORD );
    STDMETHOD(BltFast)(THIS_ DWORD,DWORD,LPDIRECTDRAWSURFACE2, LPRECT,DWORD);
    STDMETHOD(DeleteAttachedSurface)(THIS_ DWORD,LPDIRECTDRAWSURFACE2);
    STDMETHOD(EnumAttachedSurfaces)(THIS_ LPVOID,LPDDENUMSURFACESCALLBACK);
    STDMETHOD(EnumOverlayZOrders)(THIS_ DWORD,LPVOID,LPDDENUMSURFACESCALLBACK);
    STDMETHOD(Flip)(THIS_ LPDIRECTDRAWSURFACE2, DWORD);
    STDMETHOD(GetAttachedSurface)(THIS_ LPDDSCAPS, LPDIRECTDRAWSURFACE2 FAR *);
    STDMETHOD(GetBltStatus)(THIS_ DWORD);
    STDMETHOD(GetCaps)(THIS_ LPDDSCAPS);
    STDMETHOD(GetClipper)(THIS_ LPDIRECTDRAWCLIPPER FAR*);
    STDMETHOD(GetColorKey)(THIS_ DWORD, LPDDCOLORKEY);
    STDMETHOD(GetDC)(THIS_ HDC FAR *);
    STDMETHOD(GetFlipStatus)(THIS_ DWORD);
    STDMETHOD(GetOverlayPosition)(THIS_ LPLONG, LPLONG );
    STDMETHOD(GetPalette)(THIS_ LPDIRECTDRAWPALETTE FAR*);
    STDMETHOD(GetPixelFormat)(THIS_ LPDDPIXELFORMAT);
    STDMETHOD(GetSurfaceDesc)(THIS_ LPDDSURFACEDESC);
    STDMETHOD(Initialize)(THIS_ LPDIRECTDRAW, LPDDSURFACEDESC);
    STDMETHOD(IsLost)(THIS);
    STDMETHOD(Lock)(THIS_ LPRECT,LPDDSURFACEDESC,DWORD,HANDLE);
    STDMETHOD(ReleaseDC)(THIS_ HDC);
    STDMETHOD(Restore)(THIS);
    STDMETHOD(SetClipper)(THIS_ LPDIRECTDRAWCLIPPER);
    STDMETHOD(SetColorKey)(THIS_ DWORD, LPDDCOLORKEY);
    STDMETHOD(SetOverlayPosition)(THIS_ LONG, LONG );
    STDMETHOD(SetPalette)(THIS_ LPDIRECTDRAWPALETTE);
    STDMETHOD(Unlock)(THIS_ LPVOID);
    STDMETHOD(UpdateOverlay)(THIS_ LPRECT, LPDIRECTDRAWSURFACE2,LPRECT,DWORD, LPDDOVERLAYFX);
    STDMETHOD(UpdateOverlayDisplay)(THIS_ DWORD);
    STDMETHOD(UpdateOverlayZOrder)(THIS_ DWORD, LPDIRECTDRAWSURFACE2);
    /*** Added in the v2 interface ***/
    STDMETHOD(GetDDInterface)(THIS_ LPVOID FAR *);
    STDMETHOD(PageLock)(THIS_ DWORD);
    STDMETHOD(PageUnlock)(THIS_ DWORD);
private:
	LPDIRECTDRAWSURFACE2	p;
	DWORD	ownerThread;
};

//IID_IDirectDrawSurface4:
class myIDirectDrawSurface4: public IDirectDrawSurface4
{
public:
	myIDirectDrawSurface4(LPDIRECTDRAWSURFACE4 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTDRAWSURFACE4 getBaseInterface(LPDIRECTDRAWSURFACE4 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectDrawSurface4 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR * ppvObj);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    /*** IDirectDrawSurface methods ***/
    STDMETHOD(AddAttachedSurface)(THIS_ LPDIRECTDRAWSURFACE4);
    STDMETHOD(AddOverlayDirtyRect)(THIS_ LPRECT);
    STDMETHOD(Blt)(THIS_ LPRECT,LPDIRECTDRAWSURFACE4, LPRECT,DWORD, LPDDBLTFX);
    STDMETHOD(BltBatch)(THIS_ LPDDBLTBATCH, DWORD, DWORD );
    STDMETHOD(BltFast)(THIS_ DWORD,DWORD,LPDIRECTDRAWSURFACE4, LPRECT,DWORD);
    STDMETHOD(DeleteAttachedSurface)(THIS_ DWORD,LPDIRECTDRAWSURFACE4);
    STDMETHOD(EnumAttachedSurfaces)(THIS_ LPVOID,LPDDENUMSURFACESCALLBACK2);
    STDMETHOD(EnumOverlayZOrders)(THIS_ DWORD,LPVOID,LPDDENUMSURFACESCALLBACK2);
    STDMETHOD(Flip)(THIS_ LPDIRECTDRAWSURFACE4, DWORD);
    STDMETHOD(GetAttachedSurface)(THIS_ LPDDSCAPS2, LPDIRECTDRAWSURFACE4 FAR *);
    STDMETHOD(GetBltStatus)(THIS_ DWORD);
    STDMETHOD(GetCaps)(THIS_ LPDDSCAPS2);
    STDMETHOD(GetClipper)(THIS_ LPDIRECTDRAWCLIPPER FAR*);
    STDMETHOD(GetColorKey)(THIS_ DWORD, LPDDCOLORKEY);
    STDMETHOD(GetDC)(THIS_ HDC FAR *);
    STDMETHOD(GetFlipStatus)(THIS_ DWORD);
    STDMETHOD(GetOverlayPosition)(THIS_ LPLONG, LPLONG );
    STDMETHOD(GetPalette)(THIS_ LPDIRECTDRAWPALETTE FAR*);
    STDMETHOD(GetPixelFormat)(THIS_ LPDDPIXELFORMAT);
    STDMETHOD(GetSurfaceDesc)(THIS_ LPDDSURFACEDESC2);
    STDMETHOD(Initialize)(THIS_ LPDIRECTDRAW, LPDDSURFACEDESC2);
    STDMETHOD(IsLost)(THIS);
    STDMETHOD(Lock)(THIS_ LPRECT,LPDDSURFACEDESC2,DWORD,HANDLE);
    STDMETHOD(ReleaseDC)(THIS_ HDC);
    STDMETHOD(Restore)(THIS);
    STDMETHOD(SetClipper)(THIS_ LPDIRECTDRAWCLIPPER);
    STDMETHOD(SetColorKey)(THIS_ DWORD, LPDDCOLORKEY);
    STDMETHOD(SetOverlayPosition)(THIS_ LONG, LONG );
    STDMETHOD(SetPalette)(THIS_ LPDIRECTDRAWPALETTE);
    STDMETHOD(Unlock)(THIS_ LPRECT);
    STDMETHOD(UpdateOverlay)(THIS_ LPRECT, LPDIRECTDRAWSURFACE4,LPRECT,DWORD, LPDDOVERLAYFX);
    STDMETHOD(UpdateOverlayDisplay)(THIS_ DWORD);
    STDMETHOD(UpdateOverlayZOrder)(THIS_ DWORD, LPDIRECTDRAWSURFACE4);
    /*** Added in the v2 interface ***/
    STDMETHOD(GetDDInterface)(THIS_ LPVOID FAR *);
    STDMETHOD(PageLock)(THIS_ DWORD);
    STDMETHOD(PageUnlock)(THIS_ DWORD);
    /*** Added in the v3 interface ***/
    STDMETHOD(SetSurfaceDesc)(THIS_ LPDDSURFACEDESC2, DWORD);
    /*** Added in the v4 interface ***/
    STDMETHOD(SetPrivateData)(THIS_ REFGUID, LPVOID, DWORD, DWORD);
    STDMETHOD(GetPrivateData)(THIS_ REFGUID, LPVOID, LPDWORD);
    STDMETHOD(FreePrivateData)(THIS_ REFGUID);
    STDMETHOD(GetUniquenessValue)(THIS_ LPDWORD);
    STDMETHOD(ChangeUniquenessValue)(THIS);
private:
	LPDIRECTDRAWSURFACE4	p;
	DWORD	ownerThread;
#ifdef	BLEEM_NT
	DDSURFACEDESC2 locked_DDSurfaceDesc;
#endif//BLEEM_NT
};

//******************************************************************************

//IID_IDirectInput:
class myIDirectInput: public IDirectInput
{
public:
	myIDirectInput(LPDIRECTINPUT p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTINPUT getBaseInterface(LPDIRECTINPUT p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectInput *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectInput methods
    STDMETHOD(CreateDevice)(THIS_ REFGUID,LPDIRECTINPUTDEVICE *,LPUNKNOWN);
    STDMETHOD(EnumDevices)(THIS_ DWORD,LPDIENUMDEVICESCALLBACK,LPVOID,DWORD);
    STDMETHOD(GetDeviceStatus)(THIS_ REFGUID);
    STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD);
    STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD);
private:
	LPDIRECTINPUT	p;
	DWORD	ownerThread;
};

//IID_IDirectInput2:
class myIDirectInput2: public IDirectInput2
{
public:
	myIDirectInput2(LPDIRECTINPUT2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTINPUT2 getBaseInterface(LPDIRECTINPUT2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectInput2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectInput methods
    STDMETHOD(CreateDevice)(THIS_ REFGUID,LPDIRECTINPUTDEVICE *,LPUNKNOWN);
    STDMETHOD(EnumDevices)(THIS_ DWORD,LPDIENUMDEVICESCALLBACK,LPVOID,DWORD);
    STDMETHOD(GetDeviceStatus)(THIS_ REFGUID);
    STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD);
    STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD);
    // IDirectInput2 methods
    STDMETHOD(FindDevice)(THIS_ REFGUID,LPCSTR,LPGUID);
private:
	LPDIRECTINPUT2	p;
	DWORD	ownerThread;
};

//IID_IDirectInputDevice:
class myIDirectInputDevice: public IDirectInputDevice
{
public:
	myIDirectInputDevice(LPDIRECTINPUTDEVICE p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTINPUTDEVICE getBaseInterface(LPDIRECTINPUTDEVICE p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectInputDevice *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectInputDevice methods
    STDMETHOD(GetCapabilities)(THIS_ LPDIDEVCAPS);
    STDMETHOD(EnumObjects)(THIS_ LPDIENUMDEVICEOBJECTSCALLBACK,LPVOID,DWORD);
    STDMETHOD(GetProperty)(THIS_ REFGUID,LPDIPROPHEADER);
    STDMETHOD(SetProperty)(THIS_ REFGUID,LPCDIPROPHEADER);
    STDMETHOD(Acquire)(THIS);
    STDMETHOD(Unacquire)(THIS);
    STDMETHOD(GetDeviceState)(THIS_ DWORD,LPVOID);
    STDMETHOD(GetDeviceData)(THIS_ DWORD,LPDIDEVICEOBJECTDATA,LPDWORD,DWORD);
    STDMETHOD(SetDataFormat)(THIS_ LPCDIDATAFORMAT);
    STDMETHOD(SetEventNotification)(THIS_ HANDLE);
    STDMETHOD(SetCooperativeLevel)(THIS_ HWND,DWORD);
    STDMETHOD(GetObjectInfo)(THIS_ LPDIDEVICEOBJECTINSTANCE,DWORD,DWORD);
    STDMETHOD(GetDeviceInfo)(THIS_ LPDIDEVICEINSTANCE);
    STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD);
    STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD,REFGUID);
private:
	LPDIRECTINPUTDEVICE	p;
	DWORD	ownerThread;
};

//IID_IDirectInputDevice2:
class myIDirectInputDevice2: public IDirectInputDevice2
{
public:
	myIDirectInputDevice2(LPDIRECTINPUTDEVICE2 p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTINPUTDEVICE2 getBaseInterface(LPDIRECTINPUTDEVICE2 p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectInputDevice2 *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectInputDevice methods
    STDMETHOD(GetCapabilities)(THIS_ LPDIDEVCAPS);
    STDMETHOD(EnumObjects)(THIS_ LPDIENUMDEVICEOBJECTSCALLBACK,LPVOID,DWORD);
    STDMETHOD(GetProperty)(THIS_ REFGUID,LPDIPROPHEADER);
    STDMETHOD(SetProperty)(THIS_ REFGUID,LPCDIPROPHEADER);
    STDMETHOD(Acquire)(THIS);
    STDMETHOD(Unacquire)(THIS);
    STDMETHOD(GetDeviceState)(THIS_ DWORD,LPVOID);
    STDMETHOD(GetDeviceData)(THIS_ DWORD,LPDIDEVICEOBJECTDATA,LPDWORD,DWORD);
    STDMETHOD(SetDataFormat)(THIS_ LPCDIDATAFORMAT);
    STDMETHOD(SetEventNotification)(THIS_ HANDLE);
    STDMETHOD(SetCooperativeLevel)(THIS_ HWND,DWORD);
    STDMETHOD(GetObjectInfo)(THIS_ LPDIDEVICEOBJECTINSTANCE,DWORD,DWORD);
    STDMETHOD(GetDeviceInfo)(THIS_ LPDIDEVICEINSTANCE);
    STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD);
    STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD,REFGUID);
    // IDirectInputDevice2 methods
    STDMETHOD(CreateEffect)(THIS_ REFGUID,LPCDIEFFECT,LPDIRECTINPUTEFFECT *,LPUNKNOWN);
    STDMETHOD(EnumEffects)(THIS_ LPDIENUMEFFECTSCALLBACK,LPVOID,DWORD);
    STDMETHOD(GetEffectInfo)(THIS_ LPDIEFFECTINFO,REFGUID);
    STDMETHOD(GetForceFeedbackState)(THIS_ LPDWORD);
    STDMETHOD(SendForceFeedbackCommand)(THIS_ DWORD);
    STDMETHOD(EnumCreatedEffectObjects)(THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK,LPVOID,DWORD);
    STDMETHOD(Escape)(THIS_ LPDIEFFESCAPE);
    STDMETHOD(Poll)(THIS);
    STDMETHOD(SendDeviceData)(THIS_ DWORD,LPCDIDEVICEOBJECTDATA,LPDWORD,DWORD);
private:
	LPDIRECTINPUTDEVICE2	p;
	DWORD	ownerThread;
};

//IID_IDirectInputEffect:
class myIDirectInputEffect: public IDirectInputEffect
{
public:
	myIDirectInputEffect(LPDIRECTINPUTEFFECT p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTINPUTEFFECT getBaseInterface(LPDIRECTINPUTEFFECT p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectInputEffect *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectInputEffect methods
    STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD,REFGUID);
    STDMETHOD(GetEffectGuid)(THIS_ LPGUID);
    STDMETHOD(GetParameters)(THIS_ LPDIEFFECT,DWORD);
    STDMETHOD(SetParameters)(THIS_ LPCDIEFFECT,DWORD);
    STDMETHOD(Start)(THIS_ DWORD,DWORD);
    STDMETHOD(Stop)(THIS);
    STDMETHOD(GetEffectStatus)(THIS_ LPDWORD);
    STDMETHOD(Download)(THIS);
    STDMETHOD(Unload)(THIS);
    STDMETHOD(Escape)(THIS_ LPDIEFFESCAPE);
private:
	LPDIRECTINPUTEFFECT	p;
	DWORD	ownerThread;
};

//******************************************************************************

//IID_IDirectSound:
class myIDirectSound: public IDirectSound
{
public:
	myIDirectSound(LPDIRECTSOUND p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTSOUND getBaseInterface(LPDIRECTSOUND p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectSound *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectSound methods
    STDMETHOD(CreateSoundBuffer)(THIS_ LPCDSBUFFERDESC, LPDIRECTSOUNDBUFFER *, LPUNKNOWN);
    STDMETHOD(GetCaps)(THIS_ LPDSCAPS);
    STDMETHOD(DuplicateSoundBuffer)(THIS_ LPDIRECTSOUNDBUFFER, LPDIRECTSOUNDBUFFER *);
    STDMETHOD(SetCooperativeLevel)(THIS_ HWND, DWORD);
    STDMETHOD(Compact)(THIS);
    STDMETHOD(GetSpeakerConfig)(THIS_ LPDWORD);
    STDMETHOD(SetSpeakerConfig)(THIS_ DWORD);
    STDMETHOD(Initialize)(THIS_ LPCGUID);
private:
	LPDIRECTSOUND	p;
	DWORD	ownerThread;
};

//IID_IDirectSound3DBuffer:
class myIDirectSound3DBuffer: public IDirectSound3DBuffer
{
public:
	myIDirectSound3DBuffer(LPDIRECTSOUND3DBUFFER p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTSOUND3DBUFFER getBaseInterface(LPDIRECTSOUND3DBUFFER p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectSound3DBuffer *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectSound3DBuffer methods
    STDMETHOD(GetAllParameters)(THIS_ LPDS3DBUFFER);
    STDMETHOD(GetConeAngles)(THIS_ LPDWORD, LPDWORD);
    STDMETHOD(GetConeOrientation)(THIS_ LPD3DVECTOR);
    STDMETHOD(GetConeOutsideVolume)(THIS_ LPLONG);
    STDMETHOD(GetMaxDistance)(THIS_ LPD3DVALUE);
    STDMETHOD(GetMinDistance)(THIS_ LPD3DVALUE);
    STDMETHOD(GetMode)(THIS_ LPDWORD);
    STDMETHOD(GetPosition)(THIS_ LPD3DVECTOR);
    STDMETHOD(GetVelocity)(THIS_ LPD3DVECTOR);
    STDMETHOD(SetAllParameters)(THIS_ LPCDS3DBUFFER, DWORD);
    STDMETHOD(SetConeAngles)(THIS_ DWORD, DWORD, DWORD);
    STDMETHOD(SetConeOrientation)(THIS_ D3DVALUE, D3DVALUE, D3DVALUE, DWORD);
    STDMETHOD(SetConeOutsideVolume)(THIS_ LONG, DWORD);
    STDMETHOD(SetMaxDistance)(THIS_ D3DVALUE, DWORD);
    STDMETHOD(SetMinDistance)(THIS_ D3DVALUE, DWORD);
    STDMETHOD(SetMode)(THIS_ DWORD, DWORD);
    STDMETHOD(SetPosition)(THIS_ D3DVALUE, D3DVALUE, D3DVALUE, DWORD);
    STDMETHOD(SetVelocity)(THIS_ D3DVALUE, D3DVALUE, D3DVALUE, DWORD);
private:
	LPDIRECTSOUND3DBUFFER	p;
	DWORD	ownerThread;
};

//IID_IDirectSound3DListener:
class myIDirectSound3DListener: public IDirectSound3DListener
{
public:
	myIDirectSound3DListener(LPDIRECTSOUND3DLISTENER p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTSOUND3DLISTENER getBaseInterface(LPDIRECTSOUND3DLISTENER p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectSound3DListener *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectSound3DListener methods
    STDMETHOD(GetAllParameters)(THIS_ LPDS3DLISTENER);
    STDMETHOD(GetDistanceFactor)(THIS_ LPD3DVALUE);
    STDMETHOD(GetDopplerFactor)(THIS_ LPD3DVALUE);
    STDMETHOD(GetOrientation)(THIS_ LPD3DVECTOR, LPD3DVECTOR);
    STDMETHOD(GetPosition)(THIS_ LPD3DVECTOR);
    STDMETHOD(GetRolloffFactor)(THIS_ LPD3DVALUE);
    STDMETHOD(GetVelocity)(THIS_ LPD3DVECTOR);
    STDMETHOD(SetAllParameters)(THIS_ LPCDS3DLISTENER, DWORD);
    STDMETHOD(SetDistanceFactor)(THIS_ D3DVALUE, DWORD);
    STDMETHOD(SetDopplerFactor)(THIS_ D3DVALUE, DWORD);
    STDMETHOD(SetOrientation)(THIS_ D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, D3DVALUE, DWORD);
    STDMETHOD(SetPosition)(THIS_ D3DVALUE, D3DVALUE, D3DVALUE, DWORD);
    STDMETHOD(SetRolloffFactor)(THIS_ D3DVALUE, DWORD);
    STDMETHOD(SetVelocity)(THIS_ D3DVALUE, D3DVALUE, D3DVALUE, DWORD);
    STDMETHOD(CommitDeferredSettings)(THIS);
private:
	LPDIRECTSOUND3DLISTENER	p;
	DWORD	ownerThread;
};

//IID_IDirectSoundBuffer:
class myIDirectSoundBuffer: public IDirectSoundBuffer
{
public:
	myIDirectSoundBuffer(LPDIRECTSOUNDBUFFER p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTSOUNDBUFFER getBaseInterface(LPDIRECTSOUNDBUFFER p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectSoundBuffer *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectSoundBuffer methods
    STDMETHOD(GetCaps)(THIS_ LPDSBCAPS);
    STDMETHOD(GetCurrentPosition)(THIS_ LPDWORD, LPDWORD);
    STDMETHOD(GetFormat)(THIS_ LPWAVEFORMATEX, DWORD, LPDWORD);
    STDMETHOD(GetVolume)(THIS_ LPLONG);
    STDMETHOD(GetPan)(THIS_ LPLONG);
    STDMETHOD(GetFrequency)(THIS_ LPDWORD);
    STDMETHOD(GetStatus)(THIS_ LPDWORD);
    STDMETHOD(Initialize)(THIS_ LPDIRECTSOUND, LPCDSBUFFERDESC);
    STDMETHOD(Lock)(THIS_ DWORD, DWORD, LPVOID *, LPDWORD, LPVOID *, LPDWORD, DWORD);
    STDMETHOD(Play)(THIS_ DWORD, DWORD, DWORD);
    STDMETHOD(SetCurrentPosition)(THIS_ DWORD);
    STDMETHOD(SetFormat)(THIS_ LPCWAVEFORMATEX);
    STDMETHOD(SetVolume)(THIS_ LONG);
    STDMETHOD(SetPan)(THIS_ LONG);
    STDMETHOD(SetFrequency)(THIS_ DWORD);
    STDMETHOD(Stop)(THIS);
    STDMETHOD(Unlock)(THIS_ LPVOID, DWORD, LPVOID, DWORD);
    STDMETHOD(Restore)(THIS);
private:
	LPDIRECTSOUNDBUFFER	p;
	DWORD	ownerThread;
};

//IID_IDirectSoundCapture:
class myIDirectSoundCapture: public IDirectSoundCapture
{
public:
	myIDirectSoundCapture(LPDIRECTSOUNDCAPTURE p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTSOUNDCAPTURE getBaseInterface(LPDIRECTSOUNDCAPTURE p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectSoundCapture *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectSoundCapture methods
    STDMETHOD(CreateCaptureBuffer)(THIS_ LPCDSCBUFFERDESC, LPDIRECTSOUNDCAPTUREBUFFER *, LPUNKNOWN);
    STDMETHOD(GetCaps)(THIS_ LPDSCCAPS );
    STDMETHOD(Initialize)(THIS_ LPCGUID);
private:
	LPDIRECTSOUNDCAPTURE	p;
	DWORD	ownerThread;
};

//IID_IDirectSoundCaptureBuffer:
class myIDirectSoundCaptureBuffer: public IDirectSoundCaptureBuffer
{
public:
	myIDirectSoundCaptureBuffer(LPDIRECTSOUNDCAPTUREBUFFER p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTSOUNDCAPTUREBUFFER getBaseInterface(LPDIRECTSOUNDCAPTUREBUFFER p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectSoundCaptureBuffer *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectSoundCaptureBuffer methods
    STDMETHOD(GetCaps)(THIS_ LPDSCBCAPS );
    STDMETHOD(GetCurrentPosition)(THIS_ LPDWORD, LPDWORD );
    STDMETHOD(GetFormat)(THIS_ LPWAVEFORMATEX, DWORD, LPDWORD );
    STDMETHOD(GetStatus)(THIS_ LPDWORD );
    STDMETHOD(Initialize)(THIS_ LPDIRECTSOUNDCAPTURE, LPCDSCBUFFERDESC);
    STDMETHOD(Lock)(THIS_ DWORD, DWORD, LPVOID *, LPDWORD, LPVOID *, LPDWORD, DWORD);
    STDMETHOD(Start)(THIS_ DWORD);
    STDMETHOD(Stop)(THIS);
    STDMETHOD(Unlock)(THIS_ LPVOID, DWORD, LPVOID, DWORD);
private:
	LPDIRECTSOUNDCAPTUREBUFFER	p;
	DWORD	ownerThread;
};

//IID_IDirectSoundNotify:
class myIDirectSoundNotify: public IDirectSoundNotify
{
public:
	myIDirectSoundNotify(LPDIRECTSOUNDNOTIFY p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPDIRECTSOUNDNOTIFY getBaseInterface(LPDIRECTSOUNDNOTIFY p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIDirectSoundNotify *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IDirectSoundNotify methods
    STDMETHOD(SetNotificationPositions)(THIS_ DWORD, LPCDSBPOSITIONNOTIFY);
private:
	LPDIRECTSOUNDNOTIFY	p;
	DWORD	ownerThread;
};

//IID_IKsPropertySet:
class myIKsPropertySet: public IKsPropertySet
{
public:
	myIKsPropertySet(LPKSPROPERTYSET p) { this->p = p; this->ownerThread = GetCurrentThreadId(); }
	static LPKSPROPERTYSET getBaseInterface(LPKSPROPERTYSET p) { if (p == NULL || p->QueryInterface != QueryInterface) { return p; } else { return ((myIKsPropertySet *)p)->p; } }
    /*** IUnknown methods ***/
    STDMETHOD(QueryInterface)(THIS_ REFIID, LPVOID *);
    STDMETHOD_(ULONG,AddRef)(THIS);
    STDMETHOD_(ULONG,Release)(THIS);
    // IKsPropertySet methods
    STDMETHOD(Get)(THIS_ REFGUID, ULONG, LPVOID, ULONG, LPVOID, ULONG, PULONG);
    STDMETHOD(Set)(THIS_ REFGUID, ULONG, LPVOID, ULONG, LPVOID, ULONG);
    STDMETHOD(QuerySupport)(THIS_ REFGUID, ULONG, PULONG);
private:
	LPKSPROPERTYSET	p;
	DWORD	ownerThread;
};

//******************************************************************************

// DirectX Callbacks
class myCallbackClass
{
public:
	myCallbackClass(LPVOID lpCallback, LPVOID lpContext) { this->lpCallback = lpCallback; this->lpContext = lpContext; }

	// Direct3D callbacks:
	static HRESULT CALLBACK myD3DEnumDevicesCallback(GUID FAR* lpGuid, LPSTR lpDeviceDescription, LPSTR lpDeviceName, LPD3DDEVICEDESC lpD3DHWDeviceDesc, LPD3DDEVICEDESC lpD3DHELDeviceDesc, LPVOID lpContext);
	static HRESULT CALLBACK myD3DEnumPixelFormatsCallback(LPDDPIXELFORMAT lpDDPixFmt, LPVOID lpContext);
	// DirectDraw callbacks:
	static BOOL CALLBACK myDDEnumCallback(GUID FAR *lpGUID, LPSTR lpDriverDescription, LPSTR lpDriverName, LPVOID lpContext);
	static BOOL CALLBACK myDDEnumCallbackEx(GUID FAR *lpGUID, LPSTR lpDriverDescription, LPSTR lpDriverName, LPVOID lpContext, HMONITOR hm);
	static HRESULT CALLBACK myEnumModesCallback(LPDDSURFACEDESC lpDDSurfaceDesc, LPVOID lpContext);
	static HRESULT CALLBACK myEnumModesCallback2(LPDDSURFACEDESC2 lpDDSurfaceDesc, LPVOID lpContext);
	static HRESULT CALLBACK myEnumSurfacesCallback(LPDIRECTDRAWSURFACE lpDDSurface, LPDDSURFACEDESC lpDDSurfaceDesc, LPVOID lpContext);
	static HRESULT CALLBACK myEnumSurfacesCallback2(LPDIRECTDRAWSURFACE4 lpDDSurface, LPDDSURFACEDESC2 lpDDSurfaceDesc, LPVOID lpContext);
	// DirectInput callbacks:
	static BOOL CALLBACK myDIEnumCreatedEffectObjectsCallback(LPDIRECTINPUTEFFECT peff, LPVOID lpContext);
	static BOOL CALLBACK myDIEnumDeviceObjectsCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID lpContext);
	static BOOL CALLBACK myDIEnumDevicesCallback(LPCDIDEVICEINSTANCE lpddi, LPVOID lpContext);
	static BOOL CALLBACK myDIEnumEffectsCallback(LPCDIEFFECTINFO pdei, LPVOID lpContext);
	//static BOOL CALLBACK myDIEnumEffectsInFileCallback(LPCDIFILEEFFECT lpDiFileEf, LPVOID lpContext);
	// DirectSound callbacks:
	static BOOL CALLBACK myDSEnumCallback(GUID FAR *lpGUID, LPCSTR lpDriverDescription, LPCSTR lpDriverName, LPVOID lpContext);
private:
	LPVOID	lpCallback;
	LPVOID	lpContext;
};

//******************************************************************************

#ifdef __cplusplus
extern "C" {
#endif
HRESULT WINAPI myDirectDrawCreate(GUID FAR *lpGUID, LPDIRECTDRAW FAR *lplpDD, IUnknown FAR *pUnkOuter);
HRESULT WINAPI myDirectDrawCreateClipper(DWORD dwFlags, LPDIRECTDRAWCLIPPER FAR *lplpDDClipper, IUnknown FAR *pUnkOuter);
HRESULT WINAPI myDirectDrawEnumerateA(LPDDENUMCALLBACKA lpCallback, LPVOID lpContext);
HRESULT WINAPI myDirectDrawEnumerateExA(LPDDENUMCALLBACKEXA lpCallback, LPVOID lpContext, DWORD dwFlags);
HRESULT WINAPI myDirectInputCreateA(HINSTANCE hinst, DWORD dwVersion, LPDIRECTINPUTA *ppDI, LPUNKNOWN pUnkOuter);
HRESULT WINAPI myDirectInputCreateEx(HINSTANCE hinst, DWORD dwVersion, REFIID riidltf, LPVOID *ppvOut, LPUNKNOWN pUnkOuter);
HRESULT WINAPI myDirectSoundCreate(GUID FAR *lpGUID, LPDIRECTSOUND *ppDS, IUnknown FAR *pUnkOuter);
HRESULT WINAPI myDirectSoundEnumerateA(LPDSENUMCALLBACKA lpCallback, LPVOID lpContext);
#ifdef __cplusplus
};
#endif

//******************************************************************************

void myRedirectNewInterface(REFIID riid, LPVOID FAR *ppvObj);

#ifdef	DXWRAP_LOG
void Log(const char *fmt, ...);
LPCSTR Str(LPCSTR lpStr);
LPCSTR DwtoStr(DWORD dw);
LPCSTR LpDwtoStr(LPDWORD lpDw);
LPCSTR BOOLtoStr(BOOL b);
LPCSTR LPDDSURFACEDESC2toStr(LPDDSURFACEDESC2 lpSD2);
LPCSTR GUIDtoStr(const GUID *lpGUID);
LPCSTR D3D_HREStoStr(HRESULT res);
LPCSTR D3D_HRESCallbacktoStr(HRESULT res);
LPCSTR DD_HREStoStr(HRESULT res);
LPCSTR DD_HRESCallbacktoStr(HRESULT res);
LPCSTR DI_HREStoStr(HRESULT res);
LPCSTR DS_HREStoStr(HRESULT res);
#endif//DXWRAP_LOG

void dxwrap_GetProcAddressHook(LPCSTR lpProcName, FARPROC *lpProcAddr);

//******************************************************************************
