#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DDevice::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DDevice_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DDevice::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DDevice_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DDevice::Release(THIS)
{
	ULONG res;
	res = IDirect3DDevice_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DDevice::Initialize(THIS_ LPDIRECT3D lpd3d, LPGUID lpGUID, LPD3DDEVICEDESC lpd3ddvdesc)
{
	HRESULT res;
	lpd3d = myIDirect3D::getBaseInterface(lpd3d);
	res = IDirect3DDevice_Initialize(p, lpd3d, lpGUID, lpd3ddvdesc);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_Initialize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::GetCaps(THIS_ LPD3DDEVICEDESC lpD3DHWDevDesc, LPD3DDEVICEDESC lpD3DHELDevDesc)
{
	HRESULT res;
	res = IDirect3DDevice_GetCaps(p, lpD3DHWDevDesc, lpD3DHELDevDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_GetCaps(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::SwapTextureHandles(THIS_ LPDIRECT3DTEXTURE lpD3DTex1, LPDIRECT3DTEXTURE lpD3DTex2)
{
	HRESULT res;
	lpD3DTex1 = myIDirect3DTexture::getBaseInterface(lpD3DTex1);
	lpD3DTex2 = myIDirect3DTexture::getBaseInterface(lpD3DTex2);
	res = IDirect3DDevice_SwapTextureHandles(p, lpD3DTex1, lpD3DTex2);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_SwapTextureHandles(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::CreateExecuteBuffer(THIS_ LPD3DEXECUTEBUFFERDESC lpDesc, LPDIRECT3DEXECUTEBUFFER *lplpDirect3DExecuteBuffer, IUnknown *pUnkOuter)
{
	HRESULT res;
	res = IDirect3DDevice_CreateExecuteBuffer(p, lpDesc, lplpDirect3DExecuteBuffer, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_CreateExecuteBuffer(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DExecuteBuffer, (LPVOID *)lplpDirect3DExecuteBuffer);
	return res;
}
HRESULT WINAPI myIDirect3DDevice::GetStats(THIS_ LPD3DSTATS lpD3DStats)
{
	HRESULT res;
	res = IDirect3DDevice_GetStats(p, lpD3DStats);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_GetStats(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::Execute(THIS_ LPDIRECT3DEXECUTEBUFFER lpDirect3DExecuteBuffer, LPDIRECT3DVIEWPORT lpDirect3DViewport, DWORD dwFlags)
{
	HRESULT res;
	lpDirect3DExecuteBuffer = myIDirect3DExecuteBuffer::getBaseInterface(lpDirect3DExecuteBuffer);
	lpDirect3DViewport = myIDirect3DViewport::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice_Execute(p, lpDirect3DExecuteBuffer, lpDirect3DViewport, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_Execute(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::AddViewport(THIS_ LPDIRECT3DVIEWPORT lpDirect3DViewport)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice_AddViewport(p, lpDirect3DViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_AddViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::DeleteViewport(THIS_ LPDIRECT3DVIEWPORT lpDirect3DViewport)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice_DeleteViewport(p, lpDirect3DViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_DeleteViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::NextViewport(THIS_ LPDIRECT3DVIEWPORT lpDirect3DViewport, LPDIRECT3DVIEWPORT *lplpAnotherViewport, DWORD dwFlags)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice_NextViewport(p, lpDirect3DViewport, lplpAnotherViewport, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_NextViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DViewport, (LPVOID *)lplpAnotherViewport);
	return res;
}
HRESULT WINAPI myIDirect3DDevice::Pick(THIS_ LPDIRECT3DEXECUTEBUFFER lpDirect3DExecuteBuffer, LPDIRECT3DVIEWPORT lpDirect3DViewport, DWORD dwFlags, LPD3DRECT lpRect)
{
	HRESULT res;
	lpDirect3DExecuteBuffer = myIDirect3DExecuteBuffer::getBaseInterface(lpDirect3DExecuteBuffer);
	lpDirect3DViewport = myIDirect3DViewport::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice_Pick(p, lpDirect3DExecuteBuffer, lpDirect3DViewport, dwFlags, lpRect);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_Pick(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::GetPickRecords(THIS_ LPDWORD lpCount, LPD3DPICKRECORD lpD3DPickRec)
{
	HRESULT res;
	res = IDirect3DDevice_GetPickRecords(p, lpCount, lpD3DPickRec);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_GetPickRecords(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::EnumTextureFormats(THIS_ LPD3DENUMTEXTUREFORMATSCALLBACK lpd3dEnumTextureProc, LPVOID lpArg)
{
	HRESULT res;
	res = IDirect3DDevice_EnumTextureFormats(p, lpd3dEnumTextureProc, lpArg);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_EnumTextureFormats(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::CreateMatrix(THIS_ LPD3DMATRIXHANDLE lpD3DMatHandle)
{
	HRESULT res;
	res = IDirect3DDevice_CreateMatrix(p, lpD3DMatHandle);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_CreateMatrix(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::SetMatrix(THIS_ D3DMATRIXHANDLE d3dMatHandle, const LPD3DMATRIX lpD3DMatrix)
{
	HRESULT res;
	res = IDirect3DDevice_SetMatrix(p, d3dMatHandle, lpD3DMatrix);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_SetMatrix(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::GetMatrix(THIS_ D3DMATRIXHANDLE D3DMatHandle, LPD3DMATRIX lpD3DMatrix)
{
	HRESULT res;
	res = IDirect3DDevice_GetMatrix(p, D3DMatHandle, lpD3DMatrix);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_GetMatrix(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::DeleteMatrix(THIS_ D3DMATRIXHANDLE d3dMatHandle)
{
	HRESULT res;
	res = IDirect3DDevice_DeleteMatrix(p, d3dMatHandle);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_DeleteMatrix(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::BeginScene(THIS)
{
	HRESULT res;
	res = IDirect3DDevice_BeginScene(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_BeginScene(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::EndScene(THIS)
{
	HRESULT res;
	res = IDirect3DDevice_EndScene(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_EndScene(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice::GetDirect3D(THIS_ LPDIRECT3D *lplpD3D)
{
	HRESULT res;
	res = IDirect3DDevice_GetDirect3D(p, lplpD3D);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice_GetDirect3D(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3D, (LPVOID *)lplpD3D);
	return res;
}
