#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DMaterial::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DMaterial_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("Direct3DMaterial_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DMaterial::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DMaterial_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("Direct3DMaterial_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DMaterial::Release(THIS)
{
	ULONG res;
	res = IDirect3DMaterial_Release(p);
#ifdef	DXWRAP_LOG
	::Log("Direct3DMaterial_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DMaterial::Initialize(THIS_ LPDIRECT3D lpd3d)
{
	HRESULT res;
	lpd3d = myIDirect3D::getBaseInterface(lpd3d);
	res = IDirect3DMaterial_Initialize(p, lpd3d);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial_Initialize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DMaterial::SetMaterial(THIS_ LPD3DMATERIAL lpMat)
{
	HRESULT res;
	res = IDirect3DMaterial_SetMaterial(p, lpMat);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial_SetMaterial(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DMaterial::GetMaterial(THIS_ LPD3DMATERIAL lpMat)
{
	HRESULT res;
	res = IDirect3DMaterial_GetMaterial(p, lpMat);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial_GetMaterial(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DMaterial::GetHandle(THIS_ LPDIRECT3DDEVICE lpD3DDevice, LPD3DMATERIALHANDLE lpHandle)
{
	HRESULT res;
	lpD3DDevice = myIDirect3DDevice::getBaseInterface(lpD3DDevice);
	res = IDirect3DMaterial_GetHandle(p, lpD3DDevice, lpHandle);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial_GetHandle(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DMaterial::Reserve(THIS)
{
	HRESULT res;
	res = IDirect3DMaterial_Reserve(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial_Reserve(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DMaterial::Unreserve(THIS)
{
	HRESULT res;
	res = IDirect3DMaterial_Unreserve(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial_Unreserve(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
