#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DTexture::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DTexture_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DTexture::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DTexture_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DTexture::Release(THIS)
{
	ULONG res;
	res = IDirect3DTexture_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DTexture::Initialize(THIS_ LPDIRECT3DDEVICE lpD3DDevice, LPDIRECTDRAWSURFACE lpDDSurface)
{
	HRESULT res;
	lpD3DDevice = myIDirect3DDevice::getBaseInterface(lpD3DDevice);
	lpDDSurface = myIDirectDrawSurface::getBaseInterface(lpDDSurface);
	res = IDirect3DTexture_Initialize(p, lpD3DDevice, lpDDSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture_Initialize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DTexture::GetHandle(THIS_ LPDIRECT3DDEVICE lpD3DDevice, LPD3DTEXTUREHANDLE lpHandle)
{
	HRESULT res;
	lpD3DDevice = myIDirect3DDevice::getBaseInterface(lpD3DDevice);
	res = IDirect3DTexture_GetHandle(p, lpD3DDevice, lpHandle);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture_GetHandle(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DTexture::PaletteChanged(THIS_ DWORD dwStart, DWORD dwCount)
{
	HRESULT res;
	res = IDirect3DTexture_PaletteChanged(p, dwStart, dwCount);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture_PaletteChanged(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DTexture::Load(THIS_ LPDIRECT3DTEXTURE lpD3DTexture)
{
	HRESULT res;
	lpD3DTexture = myIDirect3DTexture::getBaseInterface(lpD3DTexture);
	res = IDirect3DTexture_Load(p, lpD3DTexture);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture_Load(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DTexture::Unload(THIS)
{
	HRESULT res;
	res = IDirect3DTexture_Unload(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture_Unload(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
