#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DVertexBuffer::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DVertexBuffer_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DVertexBuffer_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DVertexBuffer::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DVertexBuffer_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DVertexBuffer_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DVertexBuffer::Release(THIS)
{
	ULONG res;
	res = IDirect3DVertexBuffer_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DVertexBuffer_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DVertexBuffer::Lock(THIS_ DWORD dwFlags, LPVOID *lplpData, LPDWORD lpdwSize)
{
	HRESULT res;
	res = IDirect3DVertexBuffer_Lock(p, dwFlags, lplpData, lpdwSize);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DVertexBuffer_Lock(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DVertexBuffer::Unlock(THIS)
{
	HRESULT res;
	res = IDirect3DVertexBuffer_Unlock(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DVertexBuffer_Unlock(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DVertexBuffer::ProcessVertices(THIS_ DWORD dwVertexOp, DWORD dwDestIndex, DWORD dwCount, LPDIRECT3DVERTEXBUFFER lpSrcBuffer, DWORD dwSrcIndex, LPDIRECT3DDEVICE3 lpD3DDevice, DWORD dwFlags)
{
	HRESULT res;
	lpSrcBuffer = myIDirect3DVertexBuffer::getBaseInterface(lpSrcBuffer);
	lpD3DDevice = myIDirect3DDevice3::getBaseInterface(lpD3DDevice);
	res = IDirect3DVertexBuffer_ProcessVertices(p, dwVertexOp, dwDestIndex, dwCount, lpSrcBuffer, dwSrcIndex, lpD3DDevice, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DVertexBuffer_ProcessVertices(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DVertexBuffer::GetVertexBufferDesc(THIS_ LPD3DVERTEXBUFFERDESC lpVBDesc)
{
	HRESULT res;
	res = IDirect3DVertexBuffer_GetVertexBufferDesc(p, lpVBDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DVertexBuffer_GetVertexBufferDesc(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DVertexBuffer::Optimize(THIS_ LPDIRECT3DDEVICE3 lpD3DDevice, DWORD dwFlags)
{
	HRESULT res;
	lpD3DDevice = myIDirect3DDevice3::getBaseInterface(lpD3DDevice);
	res = IDirect3DVertexBuffer_Optimize(p, lpD3DDevice, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DVertexBuffer_Optimize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
