#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DViewport::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DViewport_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DViewport::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DViewport_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DViewport::Release(THIS)
{
	ULONG res;
	res = IDirect3DViewport_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DViewport::Initialize(THIS_ LPDIRECT3D lpDirect3D)
{
	HRESULT res;
	lpDirect3D = myIDirect3D::getBaseInterface(lpDirect3D);
	res = IDirect3DViewport_Initialize(p, lpDirect3D);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_Initialize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::GetViewport(THIS_ LPD3DVIEWPORT lpData)
{
	HRESULT res;
	res = IDirect3DViewport_GetViewport(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_GetViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::SetViewport(THIS_ LPD3DVIEWPORT lpData)
{
	HRESULT res;
	res = IDirect3DViewport_SetViewport(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_SetViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::TransformVertices(THIS_ DWORD dwVertexCount, LPD3DTRANSFORMDATA lpData, DWORD dwFlags, LPDWORD lpOffscreen)
{
	HRESULT res;
	res = IDirect3DViewport_TransformVertices(p, dwVertexCount, lpData, dwFlags, lpOffscreen);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_TransformVertices(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::LightElements(THIS_ DWORD dwElementCount, LPD3DLIGHTDATA lpData)
{
	HRESULT res;
	res = IDirect3DViewport_LightElements(p, dwElementCount, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_LightElements(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::SetBackground(THIS_ D3DMATERIALHANDLE hMat)
{
	HRESULT res;
	res = IDirect3DViewport_SetBackground(p, hMat);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_SetBackground(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::GetBackground(THIS_ LPD3DMATERIALHANDLE lphMat, LPBOOL lpValid)
{
	HRESULT res;
	res = IDirect3DViewport_GetBackground(p, lphMat, lpValid);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_GetBackground(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::SetBackgroundDepth(THIS_ LPDIRECTDRAWSURFACE lpDDSurface)
{
	HRESULT res;
	lpDDSurface = myIDirectDrawSurface::getBaseInterface(lpDDSurface);
	res = IDirect3DViewport_SetBackgroundDepth(p, lpDDSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_SetBackgroundDepth(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::GetBackgroundDepth(THIS_ LPDIRECTDRAWSURFACE *lplpDDSurface, LPBOOL lpValid)
{
	HRESULT res;
	res = IDirect3DViewport_GetBackgroundDepth(p, lplpDDSurface, lpValid);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_GetBackgroundDepth(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface, (LPVOID *)lplpDDSurface);
	return res;
}
HRESULT WINAPI myIDirect3DViewport::Clear(THIS_ DWORD dwCount, LPD3DRECT lpRects, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DViewport_Clear(p, dwCount, lpRects, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_Clear(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::AddLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport_AddLight(p, lpDirect3DLight);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_AddLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::DeleteLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport_DeleteLight(p, lpDirect3DLight);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_DeleteLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport::NextLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight, LPDIRECT3DLIGHT *lplpDirect3DLight, DWORD dwFlags)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport_NextLight(p, lpDirect3DLight, lplpDirect3DLight, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport_NextLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DLight, (LPVOID *)lplpDirect3DLight);
	return res;
}
