#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DViewport2::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DViewport2_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DViewport2::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DViewport2_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DViewport2::Release(THIS)
{
	ULONG res;
	res = IDirect3DViewport2_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::Initialize(THIS_ LPDIRECT3D lpDirect3D)
{
	HRESULT res;
	lpDirect3D = myIDirect3D::getBaseInterface(lpDirect3D);
	res = IDirect3DViewport2_Initialize(p, lpDirect3D);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_Initialize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::GetViewport(THIS_ LPD3DVIEWPORT lpData)
{
	HRESULT res;
	res = IDirect3DViewport2_GetViewport(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_GetViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::SetViewport(THIS_ LPD3DVIEWPORT lpData)
{
	HRESULT res;
	res = IDirect3DViewport2_SetViewport(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_SetViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::TransformVertices(THIS_ DWORD dwVertexCount, LPD3DTRANSFORMDATA lpData, DWORD dwFlags, LPDWORD lpOffscreen)
{
	HRESULT res;
	res = IDirect3DViewport2_TransformVertices(p, dwVertexCount, lpData, dwFlags, lpOffscreen);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_TransformVertices(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::LightElements(THIS_ DWORD dwElementCount, LPD3DLIGHTDATA lpData)
{
	HRESULT res;
	res = IDirect3DViewport2_LightElements(p, dwElementCount, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_LightElements(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::SetBackground(THIS_ D3DMATERIALHANDLE hMat)
{
	HRESULT res;
	res = IDirect3DViewport2_SetBackground(p, hMat);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_SetBackground(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::GetBackground(THIS_ LPD3DMATERIALHANDLE lphMat, LPBOOL lpValid)
{
	HRESULT res;
	res = IDirect3DViewport2_GetBackground(p, lphMat, lpValid);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_GetBackground(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::SetBackgroundDepth(THIS_ LPDIRECTDRAWSURFACE lpDDSurface)
{
	HRESULT res;
	lpDDSurface = myIDirectDrawSurface::getBaseInterface(lpDDSurface);
	res = IDirect3DViewport2_SetBackgroundDepth(p, lpDDSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_SetBackgroundDepth(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::GetBackgroundDepth(THIS_ LPDIRECTDRAWSURFACE *lplpDDSurface, LPBOOL lpValid)
{
	HRESULT res;
	res = IDirect3DViewport2_GetBackgroundDepth(p, lplpDDSurface, lpValid);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_GetBackgroundDepth(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface, (LPVOID *)lplpDDSurface);
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::Clear(THIS_ DWORD dwCount, LPD3DRECT lpRects, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DViewport2_Clear(p, dwCount, lpRects, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_Clear(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::AddLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport2_AddLight(p, lpDirect3DLight);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_AddLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::DeleteLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport2_DeleteLight(p, lpDirect3DLight);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_DeleteLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::NextLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight, LPDIRECT3DLIGHT *lplpDirect3DLight, DWORD dwFlags)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport2_NextLight(p, lpDirect3DLight, lplpDirect3DLight, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_NextLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DLight, (LPVOID *)lplpDirect3DLight);
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::GetViewport2(THIS_ LPD3DVIEWPORT2 lpData)
{
	HRESULT res;
	res = IDirect3DViewport2_GetViewport2(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_GetViewport2(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport2::SetViewport2(THIS_ LPD3DVIEWPORT2 lpData)
{
	HRESULT res;
	res = IDirect3DViewport2_SetViewport2(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport2_SetViewport2(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
