#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDraw2::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDraw2_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDraw2::AddRef(THIS)
{
	ULONG res;
	res = IDirectDraw2_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDraw2::Release(THIS)
{
	ULONG res;
	res = IDirectDraw2_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectDraw2::Compact(THIS)
{
	HRESULT res;
	res = IDirectDraw2_Compact(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_Compact(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::CreateClipper(THIS_ DWORD dwFlags, LPDIRECTDRAWCLIPPER FAR *lplpDDClipper, IUnknown FAR *pUnkOuter)
{
	HRESULT res;
	res = IDirectDraw2_CreateClipper(p, dwFlags, lplpDDClipper, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_CreateClipper(this=%08x, dwFlags=%08x, *lplpDDClipper=%08x, pUnkOuter=%08x) = %s",
		p, dwFlags, *lplpDDClipper, pUnkOuter, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawClipper, (LPVOID *)lplpDDClipper);
	return res;
}
HRESULT WINAPI myIDirectDraw2::CreatePalette(THIS_ DWORD dwFlags, LPPALETTEENTRY lpDDColorArray, LPDIRECTDRAWPALETTE FAR *lplpDDPalette, IUnknown FAR *pUnkOuter)
{
	HRESULT res;
	res = IDirectDraw2_CreatePalette(p, dwFlags, lpDDColorArray, lplpDDPalette, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_CreatePalette(this=%08x, dwFlags=%08x, lpDDColorArray=%08x, *lplpDDPalette=%08x, pUnkOuter=%08x) = %s",
		p, dwFlags, lpDDColorArray, *lplpDDPalette, pUnkOuter, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawPalette, (LPVOID *)lplpDDPalette);
	return res;
}
HRESULT WINAPI myIDirectDraw2::CreateSurface(THIS_ LPDDSURFACEDESC lpDDSurfaceDesc, LPDIRECTDRAWSURFACE FAR *lplpDDSurface, IUnknown FAR *pUnkOuter)
{
	HRESULT res;
	res = IDirectDraw2_CreateSurface(p, lpDDSurfaceDesc, lplpDDSurface, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_CreateSurface(this=%08x, lpDDSurfaceDesc=%08x, *lplpDDSurface=%08x, pUnkOuter=%08x) = %s",
		p, lpDDSurfaceDesc, *lplpDDSurface, pUnkOuter, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface, (LPVOID *)lplpDDSurface);
	return res;
}
HRESULT WINAPI myIDirectDraw2::DuplicateSurface(THIS_ LPDIRECTDRAWSURFACE lpDDSurface, LPDIRECTDRAWSURFACE FAR *lplpDupDDSurface)
{
	HRESULT res;
	lpDDSurface = myIDirectDrawSurface::getBaseInterface(lpDDSurface);
	res = IDirectDraw2_DuplicateSurface(p, lpDDSurface, lplpDupDDSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_DuplicateSurface(this=%08x, lpDDSurface=%08x, *lplpDupDDSurface=%08x) = %s",
		p, lpDDSurface, *lplpDupDDSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface, (LPVOID *)lplpDupDDSurface);
	return res;
}
HRESULT WINAPI myIDirectDraw2::EnumDisplayModes(THIS_ DWORD dwFlags, LPDDSURFACEDESC lpDDSurfaceDesc, LPVOID lpContext, LPDDENUMMODESCALLBACK lpEnumModesCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumModesCallback, lpContext);
	res = IDirectDraw2_EnumDisplayModes(p, dwFlags, lpDDSurfaceDesc, ctx, myCallbackClass::myEnumModesCallback);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_EnumDisplayModes(this=%08x, dwFlags=%08x, lpDDSurfaceDesc=%08x, lpContext=%08x, lpEnumModesCallback=%08x) = %s",
		p, dwFlags, lpDDSurfaceDesc, lpContext, lpEnumModesCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::EnumSurfaces(THIS_ DWORD dwFlags, LPDDSURFACEDESC lpDDSD, LPVOID lpContext, LPDDENUMSURFACESCALLBACK lpEnumSurfacesCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumSurfacesCallback, lpContext);
	res = IDirectDraw2_EnumSurfaces(p, dwFlags, lpDDSD, ctx, myCallbackClass::myEnumSurfacesCallback);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_EnumSurfaces(this=%08x, dwFlags=%08x, lpDDSD=%08x, lpContext=%08x, lpEnumSurfacesCallback=%08x) = %s",
		p, dwFlags, lpDDSD, lpContext, lpEnumSurfacesCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::FlipToGDISurface(THIS)
{
	HRESULT res;
	res = IDirectDraw2_FlipToGDISurface(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_FlipToGDISurface(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::GetCaps(THIS_ LPDDCAPS lpDDDriverCaps, LPDDCAPS lpDDHELCaps)
{
	HRESULT res;
	res = IDirectDraw2_GetCaps(p, lpDDDriverCaps, lpDDHELCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_GetCaps(this=%08x, lpDDDriverCaps=%08x, lpDDHELCaps=%08x) = %s",
		p, lpDDDriverCaps, lpDDHELCaps, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::GetDisplayMode(THIS_ LPDDSURFACEDESC lpDDSurfaceDesc)
{
	HRESULT res;
	res = IDirectDraw2_GetDisplayMode(p, lpDDSurfaceDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_GetDisplayMode(this=%08x, lpDDSurfaceDesc=%08x) = %s",
		p, lpDDSurfaceDesc, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::GetFourCCCodes(THIS_ LPDWORD lpNumCodes, LPDWORD lpCodes)
{
	HRESULT res;
	res = IDirectDraw2_GetFourCCCodes(p, lpNumCodes, lpCodes);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_GetFourCCCodes(this=%08x, *lpNumCodes=%08x, *lpCodes=%s) = %s",
		p, lpNumCodes, LpDwtoStr(lpCodes), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::GetGDISurface(THIS_ LPDIRECTDRAWSURFACE FAR *lplpGDIDDSSurface)
{
	HRESULT res;
	res = IDirectDraw2_GetGDISurface(p, lplpGDIDDSSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_GetGDISurface(this=%08x, *lplpGDIDDSSurface=%08x) = %s",
		p, *lplpGDIDDSSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface, (LPVOID *)lplpGDIDDSSurface);
	return res;
}
HRESULT WINAPI myIDirectDraw2::GetMonitorFrequency(THIS_ LPDWORD lpdwFrequency)
{
	HRESULT res;
	res = IDirectDraw2_GetMonitorFrequency(p, lpdwFrequency);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_GetMonitorFrequency(this=%08x, *lpdwFrequency=%08x) = %s",
		p, *lpdwFrequency, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::GetScanLine(THIS_ LPDWORD lpdwScanLine)
{
	HRESULT res;
	res = IDirectDraw2_GetScanLine(p, lpdwScanLine);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_GetScanLine(this=%08x, *lpdwScanLine=%08x) = %s",
		p, *lpdwScanLine, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::GetVerticalBlankStatus(THIS_ LPBOOL lpbIsInVB)
{
	HRESULT res;
	res = IDirectDraw2_GetVerticalBlankStatus(p, lpbIsInVB);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_GetVerticalBlankStatus(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::Initialize(THIS_ GUID FAR *lpGUID)
{
	HRESULT res;
	res = IDirectDraw2_Initialize(p, lpGUID);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_Initialize(this=%08x, lpGUID=%s) = %s",
		p, GUIDtoStr(lpGUID), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::RestoreDisplayMode(THIS)
{
	HRESULT res;
	res = IDirectDraw2_RestoreDisplayMode(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_RestoreDisplayMode(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::SetCooperativeLevel(THIS_ HWND hWnd, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDraw2_SetCooperativeLevel(p, hWnd, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_SetCooperativeLevel(this=%08x, hWnd=%08x, dwFlags=%08x) = %s",
		p, hWnd, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::SetDisplayMode(THIS_ DWORD dwWidth, DWORD dwHeight, DWORD dwBPP, DWORD dwRefreshRate, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDraw2_SetDisplayMode(p, dwWidth, dwHeight, dwBPP, dwRefreshRate, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_SetDisplayMode(this=%08x, dwWidth=%08x, dwHeight=%08x, dwBPP=%08x, dwRefreshRate=%08x, dwFlags=%08x) = %s",
		p, dwWidth, dwHeight, dwBPP, dwRefreshRate, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::WaitForVerticalBlank(THIS_ DWORD dwFlags, HANDLE hEvent)
{
	HRESULT res;
	res = IDirectDraw2_WaitForVerticalBlank(p, dwFlags, hEvent);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_WaitForVerticalBlank(this=%08x, dwFlags=%08x, hEvent=%08x) = %s",
		p, dwFlags, hEvent, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw2::GetAvailableVidMem(THIS_ LPDDSCAPS lpDDSCaps, LPDWORD lpdwTotal, LPDWORD lpdwFree)
{
	HRESULT res;
	res = IDirectDraw2_GetAvailableVidMem(p, lpDDSCaps, lpdwTotal, lpdwFree);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw2_GetAvailableVidMem(this=%08x, lpDDSCaps=%08x, *lpdwTotal=%s, *lpdwFree=%s) = %s",
		p, lpDDSCaps, LpDwtoStr(lpdwTotal), LpDwtoStr(lpdwFree), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
