#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDraw4::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDraw4_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDraw4::AddRef(THIS)
{
	ULONG res;
	res = IDirectDraw4_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDraw4::Release(THIS)
{
	ULONG res;
	res = IDirectDraw4_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectDraw4::Compact(THIS)
{
	HRESULT res;
	res = IDirectDraw4_Compact(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_Compact(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::CreateClipper(THIS_ DWORD dwFlags, LPDIRECTDRAWCLIPPER FAR *lplpDDClipper, IUnknown FAR *pUnkOuter)
{
	HRESULT res;
	res = IDirectDraw4_CreateClipper(p, dwFlags, lplpDDClipper, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_CreateClipper(this=%08x, dwFlags=%08x, *lplpDDClipper=%08x, pUnkOuter=%08x) = %s",
		p, dwFlags, *lplpDDClipper, pUnkOuter, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawClipper, (LPVOID *)lplpDDClipper);
	return res;
}
HRESULT WINAPI myIDirectDraw4::CreatePalette(THIS_ DWORD dwFlags, LPPALETTEENTRY lpDDColorArray, LPDIRECTDRAWPALETTE FAR *lplpDDPalette, IUnknown FAR *pUnkOuter)
{
	HRESULT res;
	res = IDirectDraw4_CreatePalette(p, dwFlags, lpDDColorArray, lplpDDPalette, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_CreatePalette(this=%08x, dwFlags=%08x, lpDDColorArray=%08x, *lplpDDPalette=%08x, pUnkOuter=%08x) = %s",
		p, dwFlags, lpDDColorArray, *lplpDDPalette, pUnkOuter, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawPalette, (LPVOID *)lplpDDPalette);
	return res;
}
HRESULT WINAPI myIDirectDraw4::CreateSurface(THIS_ LPDDSURFACEDESC2 lpDDSurfaceDesc2, LPDIRECTDRAWSURFACE4 FAR *lplpDDSurface, IUnknown FAR *pUnkOuter)
{
	HRESULT res;
	res = IDirectDraw4_CreateSurface(p, lpDDSurfaceDesc2, lplpDDSurface, pUnkOuter);
#ifdef	BLEEM_NT
	if (res == DDERR_INVALIDOBJECT && ownerThread != GetCurrentThreadId()) {
		LPDIRECTDRAW	tmp_dd = NULL;
		LPDIRECTDRAW4	tmp_dd4 = NULL;
		res = DirectDrawCreate(NULL, &tmp_dd, NULL);
		res = IDirectDraw_QueryInterface(tmp_dd, IID_IDirectDraw4, (LPVOID *)&tmp_dd4);
		// reuse saved values from last 'SetCooperativeLevel()' call:
		res = IDirectDraw4_SetCooperativeLevel(tmp_dd4, ddscl_hWnd, ddscl_dwFlags);
		res = IDirectDraw4_CreateSurface(tmp_dd4, lpDDSurfaceDesc2, lplpDDSurface, pUnkOuter);
		IDirectDraw4_Release(tmp_dd4);
		IDirectDraw_Release(tmp_dd);
	}
#endif//BLEEM_NT
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_CreateSurface(this=%08x, lpDDSurfaceDesc2=%08x, *lplpDDSurface=%08x, pUnkOuter=%08x) = %s",
		p, lpDDSurfaceDesc2, *lplpDDSurface, pUnkOuter, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface4, (LPVOID *)lplpDDSurface);
	return res;
}
HRESULT WINAPI myIDirectDraw4::DuplicateSurface(THIS_ LPDIRECTDRAWSURFACE4 lpDDSurface, LPDIRECTDRAWSURFACE4 FAR *lplpDupDDSurface)
{
	HRESULT res;
	lpDDSurface = myIDirectDrawSurface4::getBaseInterface(lpDDSurface);
	res = IDirectDraw4_DuplicateSurface(p, lpDDSurface, lplpDupDDSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_DuplicateSurface(this=%08x, lpDDSurface=%08x, *lplpDupDDSurface=%08x) = %s",
		p, lpDDSurface, *lplpDupDDSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface4, (LPVOID *)lplpDupDDSurface);
	return res;
}
HRESULT WINAPI myIDirectDraw4::EnumDisplayModes(THIS_ DWORD dwFlags, LPDDSURFACEDESC2 lpDDSurfaceDesc2, LPVOID lpContext, LPDDENUMMODESCALLBACK2 lpEnumModesCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumModesCallback, lpContext);
	res = IDirectDraw4_EnumDisplayModes(p, dwFlags, lpDDSurfaceDesc2, ctx, myCallbackClass::myEnumModesCallback2);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_EnumDisplayModes(this=%08x, dwFlags=%08x, lpDDSurfaceDesc2=%08x, lpContext=%08x, lpEnumModesCallback=%08x) = %s",
		p, dwFlags, lpDDSurfaceDesc2, lpContext, lpEnumModesCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::EnumSurfaces(THIS_ DWORD dwFlags, LPDDSURFACEDESC2 lpDDSD2, LPVOID lpContext, LPDDENUMSURFACESCALLBACK2 lpEnumSurfacesCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumSurfacesCallback, lpContext);
	res = IDirectDraw4_EnumSurfaces(p, dwFlags, lpDDSD2, ctx, myCallbackClass::myEnumSurfacesCallback2);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_EnumSurfaces(this=%08x, dwFlags=%08x, lpDDSD2=%08x, lpContext=%08x, lpEnumSurfacesCallback=%08x) = %s",
		p, dwFlags, lpDDSD2, lpContext, lpEnumSurfacesCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::FlipToGDISurface(THIS)
{
	HRESULT res;
	res = IDirectDraw4_FlipToGDISurface(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_FlipToGDISurface(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetCaps(THIS_ LPDDCAPS lpDDDriverCaps, LPDDCAPS lpDDHELCaps)
{
	HRESULT res;
	res = IDirectDraw4_GetCaps(p, lpDDDriverCaps, lpDDHELCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetCaps(this=%08x, lpDDDriverCaps=%08x, lpDDHELCaps=%08x) = %s",
		p, lpDDDriverCaps, lpDDHELCaps, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetDisplayMode(THIS_ LPDDSURFACEDESC2 lpDDSurfaceDesc2)
{
	HRESULT res;
	res = IDirectDraw4_GetDisplayMode(p, lpDDSurfaceDesc2);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetDisplayMode(this=%08x, lpDDSurfaceDesc2=%08x) = %s",
		p, lpDDSurfaceDesc2, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetFourCCCodes(THIS_ LPDWORD lpNumCodes, LPDWORD lpCodes)
{
	HRESULT res;
	res = IDirectDraw4_GetFourCCCodes(p, lpNumCodes, lpCodes);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetFourCCCodes(this=%08x, *lpNumCodes=%08x, *lpCodes=%s) = %s",
		p, lpNumCodes, LpDwtoStr(lpCodes), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetGDISurface(THIS_ LPDIRECTDRAWSURFACE4 FAR *lplpGDIDDSSurface4)
{
	HRESULT res;
	res = IDirectDraw4_GetGDISurface(p, lplpGDIDDSSurface4);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetGDISurface(this=%08x, *lplpGDIDDSSurface4=%08x) = %s",
		p, *lplpGDIDDSSurface4, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface4, (LPVOID *)lplpGDIDDSSurface4);
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetMonitorFrequency(THIS_ LPDWORD lpdwFrequency)
{
	HRESULT res;
	res = IDirectDraw4_GetMonitorFrequency(p, lpdwFrequency);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetMonitorFrequency(this=%08x, *lpdwFrequency=%08x) = %s",
		p, *lpdwFrequency, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetScanLine(THIS_ LPDWORD lpdwScanLine)
{
	HRESULT res;
	res = IDirectDraw4_GetScanLine(p, lpdwScanLine);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetScanLine(this=%08x, *lpdwScanLine=%08x) = %s",
		p, *lpdwScanLine, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetVerticalBlankStatus(THIS_ LPBOOL lpbIsInVB)
{
	HRESULT res;
	res = IDirectDraw4_GetVerticalBlankStatus(p, lpbIsInVB);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetVerticalBlankStatus(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::Initialize(THIS_ GUID FAR *lpGUID)
{
	HRESULT res;
	res = IDirectDraw4_Initialize(p, lpGUID);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_Initialize(this=%08x, lpGUID=%s) = %s",
		p, GUIDtoStr(lpGUID), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::RestoreDisplayMode(THIS)
{
	HRESULT res;
	res = IDirectDraw4_RestoreDisplayMode(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_RestoreDisplayMode(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::SetCooperativeLevel(THIS_ HWND hWnd, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDraw4_SetCooperativeLevel(p, hWnd, dwFlags);
#ifdef	BLEEM_NT
	// save last used values for 'CreateSurface()' function patch:
	ddscl_hWnd = hWnd;
	ddscl_dwFlags = dwFlags;
#endif//BLEEM_NT
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_SetCooperativeLevel(this=%08x, hWnd=%08x, dwFlags=%08x) = %s",
		p, hWnd, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::SetDisplayMode(THIS_ DWORD dwWidth, DWORD dwHeight, DWORD dwBPP, DWORD dwRefreshRate, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDraw4_SetDisplayMode(p, dwWidth, dwHeight, dwBPP, dwRefreshRate, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_SetDisplayMode(this=%08x, dwWidth=%08x, dwHeight=%08x, dwBPP=%08x, dwRefreshRate=%08x, dwFlags=%08x) = %s",
		p, dwWidth, dwHeight, dwBPP, dwRefreshRate, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::WaitForVerticalBlank(THIS_ DWORD dwFlags, HANDLE hEvent)
{
	HRESULT res;
	res = IDirectDraw4_WaitForVerticalBlank(p, dwFlags, hEvent);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_WaitForVerticalBlank(this=%08x, dwFlags=%08x, hEvent=%08x) = %s",
		p, dwFlags, hEvent, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetAvailableVidMem(THIS_ LPDDSCAPS2 lpDDSCaps2, LPDWORD lpdwTotal, LPDWORD lpdwFree)
{
	HRESULT res;
	res = IDirectDraw4_GetAvailableVidMem(p, lpDDSCaps2, lpdwTotal, lpdwFree);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetAvailableVidMem(this=%08x, lpDDSCaps2=%08x, *lpdwTotal=%s, *lpdwFree=%s) = %s",
		p, lpDDSCaps2, LpDwtoStr(lpdwTotal), LpDwtoStr(lpdwFree), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetSurfaceFromDC (THIS_ HDC hdc, LPDIRECTDRAWSURFACE4 *lpDDS4)
{
	HRESULT res;
	res = IDirectDraw4_GetSurfaceFromDC(p, hdc, lpDDS4);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetSurfaceFromDC(this=%08x, hdc=%08x, *lpDDS4=%08x) = %s",
		p, hdc, *lpDDS4, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface4, (LPVOID *)lpDDS4);
	return res;
}
HRESULT WINAPI myIDirectDraw4::RestoreAllSurfaces(THIS)
{
	HRESULT res;
	res = IDirectDraw4_RestoreAllSurfaces(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_RestoreAllSurfaces(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::TestCooperativeLevel(THIS)
{
	HRESULT res;
	res = IDirectDraw4_TestCooperativeLevel(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_TestCooperativeLevel(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDraw4::GetDeviceIdentifier(THIS_ LPDDDEVICEIDENTIFIER lpdddi, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDraw4_GetDeviceIdentifier(p, lpdddi, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDraw4_GetDeviceIdentifier(this=%08x, lpdddi=%08x, dwFlags=%08x) = %s",
		p, lpdddi, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
