#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDrawPalette::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDrawPalette_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawPalette_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDrawPalette::AddRef(THIS)
{
	ULONG res;
	res = IDirectDrawPalette_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawPalette_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDrawPalette::Release(THIS)
{
	ULONG res;
	res = IDirectDrawPalette_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawPalette_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectDrawPalette::GetCaps(THIS_ LPDWORD lpdwCaps)
{
	ULONG res;
	res = IDirectDrawPalette_GetCaps(p, lpdwCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawPalette_GetCaps(this=%08x, lpdwCaps=%s) = %s",
		p, LpDwtoStr(lpdwCaps), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawPalette::GetEntries(THIS_ DWORD dwFlags, DWORD dwBase, DWORD dwNumEntries, LPPALETTEENTRY lpEntries)
{
	ULONG res;
	res = IDirectDrawPalette_GetEntries(p, dwFlags, dwBase, dwNumEntries, lpEntries);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawPalette_GetEntries(this=%08x, dwFlags=%08x, dwBase=%08x, dwNumEntries=%08x, lpEntries=%08x) = %s",
		p, dwFlags, dwBase, dwNumEntries, lpEntries, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawPalette::Initialize(THIS_ LPDIRECTDRAW lpDD, DWORD dwFlags, LPPALETTEENTRY lpDDColorTable)
{
	ULONG res;
	lpDD = myIDirectDraw::getBaseInterface(lpDD);
	res = IDirectDrawPalette_Initialize(p, lpDD, dwFlags, lpDDColorTable);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawPalette_Initialize(this=%08x, lpDD=%08x, dwFlags=%08x, lpDDColorTable=%08x) = %s",
		p, lpDD, dwFlags, lpDDColorTable, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawPalette::SetEntries(THIS_ DWORD dwFlags, DWORD dwStartingEntry, DWORD dwCount, LPPALETTEENTRY lpEntries)
{
	ULONG res;
	res = IDirectDrawPalette_SetEntries(p, dwFlags, dwStartingEntry, dwCount, lpEntries);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawPalette_SetEntries(this=%08x, dwFlags=%08x, dwStartingEntry=%08x, dwCount=%08x, lpEntries=%08x) = %s",
		p, dwFlags, dwStartingEntry, dwCount, lpEntries, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
