#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDrawSurface::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDrawSurface_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDrawSurface::AddRef(THIS)
{
	ULONG res;
	res = IDirectDrawSurface_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDrawSurface::Release(THIS)
{
	ULONG res;
	res = IDirectDrawSurface_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::AddAttachedSurface(THIS_ LPDIRECTDRAWSURFACE lpDDSAttachedSurface)
{
	HRESULT res;
	lpDDSAttachedSurface = myIDirectDrawSurface::getBaseInterface(lpDDSAttachedSurface);
	res = IDirectDrawSurface_AddAttachedSurface(p, lpDDSAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_AddAttachedSurface(this=%08x, lpDDSAttachedSurface=%08x) = %s",
		p, lpDDSAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::AddOverlayDirtyRect(THIS_ LPRECT lpRect)
{
	HRESULT res;
	res = IDirectDrawSurface_AddOverlayDirtyRect(p, lpRect);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_AddOverlayDirtyRect(this=%08x, lpRect=%08x) = %s",
		p, lpRect, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::Blt(THIS_ LPRECT lpDestRect, LPDIRECTDRAWSURFACE lpDDSrcSurface, LPRECT lpSrcRect, DWORD dwFlags, LPDDBLTFX lpDDBltFx)
{
	HRESULT res;
	lpDDSrcSurface = myIDirectDrawSurface::getBaseInterface(lpDDSrcSurface);
	res = IDirectDrawSurface_Blt(p, lpDestRect, lpDDSrcSurface, lpSrcRect, dwFlags, lpDDBltFx);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_Blt(this=%08x, lpDestRect=%08x, lpDDSrcSurface=%08x, lpSrcRect=%08x, dwFlags=%08x, lpDDBltFx=%08x) = %s",
		p, lpDestRect, lpDDSrcSurface, lpSrcRect, dwFlags, lpDDBltFx, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::BltBatch(THIS_ LPDDBLTBATCH lpDDBltBatch, DWORD dwCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface_BltBatch(p, lpDDBltBatch, dwCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_BltBatch(this=%08x, lpDDBltBatch=%08x, dwCount=%08x, dwFlags=%08x) = %s",
		p, lpDDBltBatch, dwCount, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::BltFast(THIS_ DWORD dwX, DWORD dwY, LPDIRECTDRAWSURFACE lpDDSrcSurface, LPRECT lpSrcRect, DWORD dwTrans)
{
	HRESULT res;
	lpDDSrcSurface = myIDirectDrawSurface::getBaseInterface(lpDDSrcSurface);
	res = IDirectDrawSurface_BltFast(p, dwX, dwY, lpDDSrcSurface, lpSrcRect, dwTrans);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_BltFast(this=%08x, dwX=%08x, dwY=%08x, lpDDSrcSurface=%08x, lpSrcRect=%08x, dwTrans=%08x) = %s",
		p, dwX, dwY, lpDDSrcSurface, lpSrcRect, dwTrans, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::DeleteAttachedSurface(THIS_ DWORD dwFlags, LPDIRECTDRAWSURFACE lpDDSAttachedSurface)
{
	HRESULT res;
	lpDDSAttachedSurface = myIDirectDrawSurface::getBaseInterface(lpDDSAttachedSurface);
	res = IDirectDrawSurface_DeleteAttachedSurface(p, dwFlags, lpDDSAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_DeleteAttachedSurface(this=%08x, dwFlags=%08x, lpDDSAttachedSurface=%08x) = %s",
		p, dwFlags, lpDDSAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::EnumAttachedSurfaces(THIS_ LPVOID lpContext, LPDDENUMSURFACESCALLBACK lpEnumSurfacesCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumSurfacesCallback, lpContext);
	res = IDirectDrawSurface_EnumAttachedSurfaces(p, ctx, myCallbackClass::myEnumSurfacesCallback);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_EnumAttachedSurfaces(this=%08x, lpContext=%08x, lpEnumSurfacesCallback=%08x) = %s",
		p, lpContext, lpEnumSurfacesCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::EnumOverlayZOrders(THIS_ DWORD dwFlags, LPVOID lpContext, LPDDENUMSURFACESCALLBACK lpfnCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpfnCallback, lpContext);
	res = IDirectDrawSurface_EnumOverlayZOrders(p, dwFlags, ctx, myCallbackClass::myEnumSurfacesCallback);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_EnumOverlayZOrders(this=%08x, dwFlags=%08x, lpContext=%08x, lpfnCallback=%08x) = %s",
		p, dwFlags, lpContext, lpfnCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::Flip(THIS_ LPDIRECTDRAWSURFACE lpDDSurfaceTargetOverride, DWORD dwFlags)
{
	HRESULT res;
	lpDDSurfaceTargetOverride = myIDirectDrawSurface::getBaseInterface(lpDDSurfaceTargetOverride);
	res = IDirectDrawSurface_Flip(p, lpDDSurfaceTargetOverride, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_Flip(this=%08x, lpDDSurfaceTargetOverride=%08x, dwFlags=%08x) = %s",
		p, lpDDSurfaceTargetOverride, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetAttachedSurface(THIS_ LPDDSCAPS lpDDSCaps, LPDIRECTDRAWSURFACE FAR *lplpDDAttachedSurface)
{
	HRESULT res;
	res = IDirectDrawSurface_GetAttachedSurface(p, lpDDSCaps, lplpDDAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetAttachedSurface(this=%08x, lpDDSCaps=%08x, *lplpDDAttachedSurface=%08x) = %s",
		p, lpDDSCaps, *lplpDDAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface, (LPVOID *)lplpDDAttachedSurface);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetBltStatus(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface_GetBltStatus(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetBltStatus(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetCaps(THIS_ LPDDSCAPS lpDDSCaps)
{
	HRESULT res;
	res = IDirectDrawSurface_GetCaps(p, lpDDSCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetCaps(this=%08x, lpDDSCaps=%08x) = %s",
		p, lpDDSCaps, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetClipper(THIS_ LPDIRECTDRAWCLIPPER FAR *lplpDDClipper)
{
	HRESULT res;
	res = IDirectDrawSurface_GetClipper(p, lplpDDClipper);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetClipper(this=%08x, *lplpDDClipper=%08x) = %s",
		p, *lplpDDClipper, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawClipper, (LPVOID *)lplpDDClipper);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetColorKey(THIS_ DWORD dwFlags, LPDDCOLORKEY lpDDColorKey)
{
	HRESULT res;
	res = IDirectDrawSurface_GetColorKey(p, dwFlags, lpDDColorKey);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetColorKey(this=%08x, dwFlags=%08x, lpDDColorKey=%08x) = %s",
		p, dwFlags, lpDDColorKey, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetDC(THIS_ HDC FAR *lphDC)
{
	HRESULT res;
	res = IDirectDrawSurface_GetDC(p, lphDC);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetDC(this=%08x, *lphDC=%08x) = %s",
		p, *lphDC, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetFlipStatus(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface_GetFlipStatus(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetFlipStatus(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetOverlayPosition(THIS_ LPLONG lplX, LPLONG lplY)
{
	HRESULT res;
	res = IDirectDrawSurface_GetOverlayPosition(p, lplX, lplY);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetOverlayPosition(this=%08x, *lplX=%s, lplY=%s) = %s",
		p, LpDwtoStr((LPDWORD)lplX), LpDwtoStr((LPDWORD)lplY), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetPalette(THIS_ LPDIRECTDRAWPALETTE FAR *lplpDDPalette)
{
	HRESULT res;
	res = IDirectDrawSurface_GetPalette(p, lplpDDPalette);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetPalette(this=%08x, *lplpDDPalette=%08x) = %s",
		p, *lplpDDPalette, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawPalette, (LPVOID *)lplpDDPalette);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetPixelFormat(THIS_ LPDDPIXELFORMAT lpDDPixelFormat)
{
	HRESULT res;
	res = IDirectDrawSurface_GetPixelFormat(p, lpDDPixelFormat);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetPixelFormat(this=%08x, lpDDPixelFormat=%08x) = %s",
		p, lpDDPixelFormat, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::GetSurfaceDesc(THIS_ LPDDSURFACEDESC lpDDSurfaceDesc)
{
	HRESULT res;
	res = IDirectDrawSurface_GetSurfaceDesc(p, lpDDSurfaceDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_GetSurfaceDesc(this=%08x, lpDDSurfaceDesc=%08x) = %s",
		p, lpDDSurfaceDesc, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::Initialize(THIS_ LPDIRECTDRAW lpDD, LPDDSURFACEDESC lpDDSurfaceDesc)
{
	HRESULT res;
	lpDD = myIDirectDraw::getBaseInterface(lpDD);
	res = IDirectDrawSurface_Initialize(p, lpDD, lpDDSurfaceDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_Initialize(this=%08x, lpDD=%08x, lpDDSurfaceDesc=%08x) = %s",
		p, lpDD, lpDDSurfaceDesc, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::IsLost(void)
{
	HRESULT res;
	res = IDirectDrawSurface_IsLost(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_IsLost(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::Lock(THIS_ LPRECT lpDestRect, LPDDSURFACEDESC lpDDSurfaceDesc, DWORD dwFlags, HANDLE hEvent)
{
	HRESULT res;
	res = IDirectDrawSurface_Lock(p, lpDestRect, lpDDSurfaceDesc, dwFlags, hEvent);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_Lock(this=%08x, lpDestRect=%08x, lpDDSurfaceDesc=%08x, dwFlags=%08x, hEvent=%08x) = %s",
		p, lpDestRect, lpDDSurfaceDesc, dwFlags, hEvent, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::ReleaseDC(THIS_ HDC hDC)
{
	HRESULT res;
	res = IDirectDrawSurface_ReleaseDC(p, hDC);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_ReleaseDC(this=%08x, hDC=%08x) = %s",
		p, hDC, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::Restore(THIS)
{
	HRESULT res;
	res = IDirectDrawSurface_Restore(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_Restore(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::SetClipper(THIS_ LPDIRECTDRAWCLIPPER lpDDClipper)
{
	HRESULT res;
	lpDDClipper = myIDirectDrawClipper::getBaseInterface(lpDDClipper);
	res = IDirectDrawSurface_SetClipper(p, lpDDClipper);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_SetClipper(this=%08x, lpDDClipper=%08x) = %s",
		p, lpDDClipper, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::SetColorKey(THIS_ DWORD dwFlags, LPDDCOLORKEY lpDDColorKey)
{
	HRESULT res;
	res = IDirectDrawSurface_SetColorKey(p, dwFlags, lpDDColorKey);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_SetColorKey(this=%08x, dwFlags=%08x, lpDDColorKey=%08x) = %s",
		p, dwFlags, lpDDColorKey, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::SetOverlayPosition(THIS_ LONG lX, LONG lY)
{
	HRESULT res;
	res = IDirectDrawSurface_SetOverlayPosition(p, lX, lY);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_SetOverlayPosition(this=%08x, lX=%08x, lY=%08x) = %s",
		p, lX, lY, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::SetPalette(THIS_ LPDIRECTDRAWPALETTE lpDDPalette)
{
	HRESULT res;
	lpDDPalette = myIDirectDrawPalette::getBaseInterface(lpDDPalette);
	res = IDirectDrawSurface_SetPalette(p, lpDDPalette);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_SetPalette(this=%08x, lpDDPalette=%08x) = %s",
		p, lpDDPalette, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::Unlock(THIS_ LPVOID lpSurfaceData)
{
	HRESULT res;
	res = IDirectDrawSurface_Unlock(p, lpSurfaceData);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_Unlock(this=%08x, lpSurfaceData=%08x) = %s",
		p, lpSurfaceData, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::UpdateOverlay(THIS_ LPRECT lpSrcRect, LPDIRECTDRAWSURFACE lpDDDestSurface, LPRECT lpDestRect, DWORD dwFlags, LPDDOVERLAYFX lpDDOverlayFx)
{
	HRESULT res;
	lpDDDestSurface = myIDirectDrawSurface::getBaseInterface(lpDDDestSurface);
	res = IDirectDrawSurface_UpdateOverlay(p, lpSrcRect, lpDDDestSurface, lpDestRect, dwFlags, lpDDOverlayFx);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_UpdateOverlay(this=%08x, lpSrcRect=%08x, lpDDDestSurface=%08x, lpDestRect=%08x, dwFlags=%08x, lpDDOverlayFx=%08x) = %s",
		p, lpSrcRect, lpDDDestSurface, lpDestRect, dwFlags, lpDDOverlayFx, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::UpdateOverlayDisplay(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface_UpdateOverlayDisplay(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_UpdateOverlayDisplay(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface::UpdateOverlayZOrder(THIS_ DWORD dwFlags, LPDIRECTDRAWSURFACE lpDDSReference)
{
	HRESULT res;
	lpDDSReference = myIDirectDrawSurface::getBaseInterface(lpDDSReference);
	res = IDirectDrawSurface_UpdateOverlayZOrder(p, dwFlags, lpDDSReference);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface_UpdateOverlayZOrder(this=%08x, dwFlags=%08x, lpDDSReference=%08x) = %s",
		p, dwFlags, lpDDSReference, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
