#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectInput::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectInput_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DI_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectInput::AddRef(THIS)
{
	ULONG res;
	res = IDirectInput_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectInput::Release(THIS)
{
	ULONG res;
	res = IDirectInput_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectInput::CreateDevice(THIS_ REFGUID rguid, LPDIRECTINPUTDEVICE *lplpDirectInputDevice, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirectInput_CreateDevice(p, rguid, lplpDirectInputDevice, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput_CreateDevice(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DI_OK) ::myRedirectNewInterface(IID_IDirectInputDevice, (LPVOID *)lplpDirectInputDevice);
	return res;
}
HRESULT WINAPI myIDirectInput::EnumDevices(THIS_ DWORD dwDevType, LPDIENUMDEVICESCALLBACK lpCallback, LPVOID lpContext, DWORD dwFlags)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = IDirectInput_EnumDevices(p, dwDevType, myCallbackClass::myDIEnumDevicesCallback, ctx, dwFlags);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectInput_EnumDevices(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInput::GetDeviceStatus(THIS_ REFGUID rguidInstance)
{
	HRESULT res;
	res = IDirectInput_GetDeviceStatus(p, rguidInstance);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput_GetDeviceStatus(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInput::RunControlPanel(THIS_ HWND hwndOwner, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInput_RunControlPanel(p, hwndOwner, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput_RunControlPanel(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInput::Initialize(THIS_ HINSTANCE hinst, DWORD dwVersion)
{
	HRESULT res;
	res = IDirectInput_Initialize(p, hinst, dwVersion);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput_Initialize(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
