#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectInput2::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectInput2_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DI_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectInput2::AddRef(THIS)
{
	ULONG res;
	res = IDirectInput2_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectInput2::Release(THIS)
{
	ULONG res;
	res = IDirectInput2_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectInput2::CreateDevice(THIS_ REFGUID rguid, LPDIRECTINPUTDEVICE *lplpDirectInputDevice, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirectInput2_CreateDevice(p, rguid, lplpDirectInputDevice, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_CreateDevice(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DI_OK) ::myRedirectNewInterface(IID_IDirectInputDevice, (LPVOID *)lplpDirectInputDevice);
	return res;
}
HRESULT WINAPI myIDirectInput2::EnumDevices(THIS_ DWORD dwDevType, LPDIENUMDEVICESCALLBACK lpCallback, LPVOID lpContext, DWORD dwFlags)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = IDirectInput2_EnumDevices(p, dwDevType, myCallbackClass::myDIEnumDevicesCallback, ctx, dwFlags);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_EnumDevices(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInput2::GetDeviceStatus(THIS_ REFGUID rguidInstance)
{
	HRESULT res;
	res = IDirectInput2_GetDeviceStatus(p, rguidInstance);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_GetDeviceStatus(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInput2::RunControlPanel(THIS_ HWND hwndOwner, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInput2_RunControlPanel(p, hwndOwner, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_RunControlPanel(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInput2::Initialize(THIS_ HINSTANCE hinst, DWORD dwVersion)
{
	HRESULT res;
	res = IDirectInput2_Initialize(p, hinst, dwVersion);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_Initialize(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInput2::FindDevice(THIS_ REFGUID rguidClass, LPCSTR ptszName, LPGUID pguidInstance)
{
	HRESULT res;
	res = IDirectInput2_FindDevice(p, rguidClass, ptszName, pguidInstance);
#ifdef	DXWRAP_LOG
	::Log("IDirectInput2_FindDevice(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
