#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectInputDevice::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectInputDevice_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DI_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectInputDevice::AddRef(THIS)
{
	ULONG res;
	res = IDirectInputDevice_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectInputDevice::Release(THIS)
{
	ULONG res;
	res = IDirectInputDevice_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectInputDevice::GetCapabilities(THIS_ LPDIDEVCAPS lpDIDevCaps)
{
	HRESULT res;
	res = IDirectInputDevice_GetCapabilities(p, lpDIDevCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_GetCapabilities(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::EnumObjects(THIS_ LPDIENUMDEVICEOBJECTSCALLBACK lpCallback, LPVOID lpContext, DWORD dwFlags)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = IDirectInputDevice_EnumObjects(p, myCallbackClass::myDIEnumDeviceObjectsCallback, ctx, dwFlags);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_EnumObjects(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::GetProperty(THIS_ REFGUID rguidProp, LPDIPROPHEADER pdiph)
{
	HRESULT res;
	res = IDirectInputDevice_GetProperty(p, rguidProp, pdiph);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_GetProperty(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::SetProperty(THIS_ REFGUID rguidProp, LPCDIPROPHEADER pdiph)
{
	HRESULT res;
	res = IDirectInputDevice_SetProperty(p, rguidProp, pdiph);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_SetProperty(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::Acquire(THIS)
{
	HRESULT res;
	res = IDirectInputDevice_Acquire(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_Acquire(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::Unacquire(THIS)
{
	HRESULT res;
	res = IDirectInputDevice_Unacquire(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_Unacquire(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::GetDeviceState(THIS_ DWORD cbData, LPVOID lpvData)
{
	HRESULT res;
	res = IDirectInputDevice_GetDeviceState(p, cbData, lpvData);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_GetDeviceState(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::GetDeviceData(THIS_ DWORD cbObjectData, LPDIDEVICEOBJECTDATA rgdod, LPDWORD pdwInOut, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputDevice_GetDeviceData(p, cbObjectData, rgdod, pdwInOut, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_GetDeviceData(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::SetDataFormat(THIS_ LPCDIDATAFORMAT lpdf)
{
	HRESULT res;
	res = IDirectInputDevice_SetDataFormat(p, lpdf);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_SetDataFormat(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::SetEventNotification(THIS_ HANDLE hEvent)
{
	HRESULT res;
	res = IDirectInputDevice_SetEventNotification(p, hEvent);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_SetEventNotification(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::SetCooperativeLevel(THIS_ HWND hwnd, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputDevice_SetCooperativeLevel(p, hwnd, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_SetCooperativeLevel(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::GetObjectInfo(THIS_ LPDIDEVICEOBJECTINSTANCE pdidoi, DWORD dwObj, DWORD dwHow)
{
	HRESULT res;
	res = IDirectInputDevice_GetObjectInfo(p, pdidoi, dwObj, dwHow);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_GetObjectInfo(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::GetDeviceInfo(THIS_ LPDIDEVICEINSTANCE pdidi)
{
	HRESULT res;
	res = IDirectInputDevice_GetDeviceInfo(p, pdidi);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_GetDeviceInfo(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::RunControlPanel(THIS_ HWND hwndOwner, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputDevice_RunControlPanel(p, hwndOwner, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_RunControlPanel(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice::Initialize(THIS_ HINSTANCE hinst, DWORD dwVersion, REFGUID rguid)
{
	HRESULT res;
	res = IDirectInputDevice_Initialize(p, hinst, dwVersion, rguid);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice_Initialize(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
