#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectInputDevice2::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectInputDevice2_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DI_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectInputDevice2::AddRef(THIS)
{
	ULONG res;
	res = IDirectInputDevice2_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectInputDevice2::Release(THIS)
{
	ULONG res;
	res = IDirectInputDevice2_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::GetCapabilities(THIS_ LPDIDEVCAPS lpDIDevCaps)
{
	HRESULT res;
	res = IDirectInputDevice2_GetCapabilities(p, lpDIDevCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_GetCapabilities(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::EnumObjects(THIS_ LPDIENUMDEVICEOBJECTSCALLBACK lpCallback, LPVOID lpContext, DWORD dwFlags)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = IDirectInputDevice2_EnumObjects(p, myCallbackClass::myDIEnumDeviceObjectsCallback, ctx, dwFlags);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_EnumObjects(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::GetProperty(THIS_ REFGUID rguidProp, LPDIPROPHEADER pdiph)
{
	HRESULT res;
	res = IDirectInputDevice2_GetProperty(p, rguidProp, pdiph);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_GetProperty(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::SetProperty(THIS_ REFGUID rguidProp, LPCDIPROPHEADER pdiph)
{
	HRESULT res;
	res = IDirectInputDevice2_SetProperty(p, rguidProp, pdiph);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_SetProperty(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::Acquire(THIS)
{
	HRESULT res;
	res = IDirectInputDevice2_Acquire(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_Acquire(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::Unacquire(THIS)
{
	HRESULT res;
	res = IDirectInputDevice2_Unacquire(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_Unacquire(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::GetDeviceState(THIS_ DWORD cbData, LPVOID lpvData)
{
	HRESULT res;
	res = IDirectInputDevice2_GetDeviceState(p, cbData, lpvData);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_GetDeviceState(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::GetDeviceData(THIS_ DWORD cbObjectData, LPDIDEVICEOBJECTDATA rgdod, LPDWORD pdwInOut, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputDevice2_GetDeviceData(p, cbObjectData, rgdod, pdwInOut, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_GetDeviceData(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::SetDataFormat(THIS_ LPCDIDATAFORMAT lpdf)
{
	HRESULT res;
	res = IDirectInputDevice2_SetDataFormat(p, lpdf);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_SetDataFormat(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::SetEventNotification(THIS_ HANDLE hEvent)
{
	HRESULT res;
	res = IDirectInputDevice2_SetEventNotification(p, hEvent);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_SetEventNotification(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::SetCooperativeLevel(THIS_ HWND hwnd, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputDevice2_SetCooperativeLevel(p, hwnd, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_SetCooperativeLevel(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::GetObjectInfo(THIS_ LPDIDEVICEOBJECTINSTANCE pdidoi, DWORD dwObj, DWORD dwHow)
{
	HRESULT res;
	res = IDirectInputDevice2_GetObjectInfo(p, pdidoi, dwObj, dwHow);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_GetObjectInfo(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::GetDeviceInfo(THIS_ LPDIDEVICEINSTANCE pdidi)
{
	HRESULT res;
	res = IDirectInputDevice2_GetDeviceInfo(p, pdidi);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_GetDeviceInfo(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::RunControlPanel(THIS_ HWND hwndOwner, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputDevice2_RunControlPanel(p, hwndOwner, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_RunControlPanel(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::Initialize(THIS_ HINSTANCE hinst, DWORD dwVersion, REFGUID rguid)
{
	HRESULT res;
	res = IDirectInputDevice2_Initialize(p, hinst, dwVersion, rguid);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_Initialize(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::CreateEffect(THIS_ REFGUID rguid, LPCDIEFFECT lpeff, LPDIRECTINPUTEFFECT *ppdeff, LPUNKNOWN punkOuter)
{
	HRESULT res;
	res = IDirectInputDevice2_CreateEffect(p, rguid, lpeff, ppdeff, punkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_CreateEffect(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DI_OK) ::myRedirectNewInterface(IID_IDirectInputEffect, (LPVOID *)ppdeff);
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::EnumEffects(THIS_ LPDIENUMEFFECTSCALLBACK lpCallback, LPVOID lpContext, DWORD dwEffType)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = IDirectInputDevice2_EnumEffects(p, myCallbackClass::myDIEnumEffectsCallback, ctx, dwEffType);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_EnumEffects(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::GetEffectInfo(THIS_ LPDIEFFECTINFO pdei, REFGUID rguid)
{
	HRESULT res;
	res = IDirectInputDevice2_GetEffectInfo(p, pdei, rguid);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_GetEffectInfo(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::GetForceFeedbackState(THIS_ LPDWORD pdwOut)
{
	HRESULT res;
	res = IDirectInputDevice2_GetForceFeedbackState(p, pdwOut);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_GetForceFeedbackState(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::SendForceFeedbackCommand(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputDevice2_SendForceFeedbackCommand(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_SendForceFeedbackCommand(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::EnumCreatedEffectObjects(THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK lpCallback, LPVOID lpContext, DWORD fl)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = IDirectInputDevice2_EnumCreatedEffectObjects(p, myCallbackClass::myDIEnumCreatedEffectObjectsCallback, ctx, fl);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_EnumCreatedEffectObjects(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::Escape(THIS_ LPDIEFFESCAPE pesc)
{
	HRESULT res;
	res = IDirectInputDevice2_Escape(p, pesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_Escape(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::Poll(THIS)
{
	HRESULT res;
	res = IDirectInputDevice2_Poll(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_Poll(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputDevice2::SendDeviceData(THIS_ DWORD cbObjectData, LPCDIDEVICEOBJECTDATA rgdod, LPDWORD pdwInOut, DWORD fl)
{
	HRESULT res;
	res = IDirectInputDevice2_SendDeviceData(p, cbObjectData, rgdod, pdwInOut, fl);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputDevice2_SendDeviceData(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
