#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectInputEffect::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectInputEffect_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DI_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectInputEffect::AddRef(THIS)
{
	ULONG res;
	res = IDirectInputEffect_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectInputEffect::Release(THIS)
{
	ULONG res;
	res = IDirectInputEffect_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectInputEffect::Initialize(THIS_ HINSTANCE hinst, DWORD dwVersion, REFGUID rguid)
{
	HRESULT res;
	res = IDirectInputEffect_Initialize(p, hinst, dwVersion, rguid);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_Initialize(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::GetEffectGuid(THIS_ LPGUID pguid)
{
	HRESULT res;
	res = IDirectInputEffect_GetEffectGuid(p, pguid);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_GetEffectGuid(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::GetParameters(THIS_ LPDIEFFECT peff, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputEffect_GetParameters(p, peff, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_GetParameters(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::SetParameters(THIS_ LPCDIEFFECT peff, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputEffect_SetParameters(p, peff, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_SetParameters(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::Start(THIS_ DWORD dwIterations, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectInputEffect_Start(p, dwIterations, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_Start(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::Stop(THIS)
{
	HRESULT res;
	res = IDirectInputEffect_Stop(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_Stop(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::GetEffectStatus(THIS_ LPDWORD pdwFlags)
{
	HRESULT res;
	res = IDirectInputEffect_GetEffectStatus(p, pdwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_GetEffectStatus(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::Download(THIS)
{
	HRESULT res;
	res = IDirectInputEffect_Download(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_Download(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::Unload(THIS)
{
	HRESULT res;
	res = IDirectInputEffect_Unload(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_Unload(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectInputEffect::Escape(THIS_ LPDIEFFESCAPE pesc)
{
	HRESULT res;
	res = IDirectInputEffect_Escape(p, pesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectInputEffect_Escape(this=%08x) = %s",
		p, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
