#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectSound3DBuffer::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectSound3DBuffer_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectSound3DBuffer::AddRef(THIS)
{
	ULONG res;
	res = IDirectSound3DBuffer_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectSound3DBuffer::Release(THIS)
{
	ULONG res;
	res = IDirectSound3DBuffer_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetAllParameters(THIS_ LPDS3DBUFFER lpDs3dBuffer)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetAllParameters(p, lpDs3dBuffer);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetAllParameters(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetConeAngles(THIS_ LPDWORD lpdwInsideConeAngle, LPDWORD lpdwOutsideConeAngle)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetConeAngles(p, lpdwInsideConeAngle, lpdwOutsideConeAngle);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetConeAngles(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetConeOrientation(THIS_ LPD3DVECTOR lpvOrientation)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetConeOrientation(p, lpvOrientation);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetConeOrientation(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetConeOutsideVolume(THIS_ LPLONG lplConeOutsideVolume)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetConeOutsideVolume(p, lplConeOutsideVolume);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetConeOutsideVolume(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetMaxDistance(THIS_ LPD3DVALUE lpflMaxDistance)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetMaxDistance(p, lpflMaxDistance);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetMaxDistance(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetMinDistance(THIS_ LPD3DVALUE lpflMinDistance)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetMinDistance(p, lpflMinDistance);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetMinDistance(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetMode(THIS_ LPDWORD lpdwMode)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetMode(p, lpdwMode);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetMode(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetPosition(THIS_ LPD3DVECTOR lpvPosition)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetPosition(p, lpvPosition);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetPosition(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::GetVelocity(THIS_ LPD3DVECTOR lpvVelocity)
{
	HRESULT res;
	res = IDirectSound3DBuffer_GetVelocity(p, lpvVelocity);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_GetVelocity(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetAllParameters(THIS_ LPCDS3DBUFFER lpcDs3dBuffer, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetAllParameters(p, lpcDs3dBuffer, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetAllParameters(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetConeAngles(THIS_ DWORD dwInsideConeAngle, DWORD dwOutsideConeAngle, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetConeAngles(p, dwInsideConeAngle, dwOutsideConeAngle, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetConeAngles(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetConeOrientation(THIS_ D3DVALUE x, D3DVALUE y, D3DVALUE z, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetConeOrientation(p, x, y, z, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetConeOrientation(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetConeOutsideVolume(THIS_ LONG lConeOutsideVolume, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetConeOutsideVolume(p, lConeOutsideVolume, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetConeOutsideVolume(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetMaxDistance(THIS_ D3DVALUE flMaxDistance, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetMaxDistance(p, flMaxDistance, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetMaxDistance(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetMinDistance(THIS_ D3DVALUE flMinDistance, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetMinDistance(p, flMinDistance, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetMinDistance(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetMode(THIS_ DWORD dwMode, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetMode(p, dwMode, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetMode(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetPosition(THIS_ D3DVALUE x, D3DVALUE y, D3DVALUE z, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetPosition(p, x, y, z, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetPosition(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DBuffer::SetVelocity(THIS_ D3DVALUE x, D3DVALUE y, D3DVALUE z, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DBuffer_SetVelocity(p, x, y, z, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DBuffer_SetVelocity(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
